/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.authn.LoginFailureCause;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelService;
import com.tridium.tunnel.TunnelConst;
import com.tridium.tunnel.TunnelInputStream;
import com.tridium.tunnel.TunnelOutputStream;
import com.tridium.tunnel.TunnelUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.net.ssl.SSLSocket;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="established", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="userName", type="String", defaultValue="", flags=3), @NiagaraProperty(name="remoteHost", type="String", defaultValue="", flags=3), @NiagaraProperty(name="protocolVersion", type="int", defaultValue="1", flags=3), @NiagaraProperty(name="lastRead", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="lastWrite", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3)})
@NiagaraAction(name="disconnect")
public class BTunnelConnection
extends BComponent
implements Context,
TunnelConst,
NiagaraSession {
    @Generated
    public static final Property established = BTunnelConnection.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property userName = BTunnelConnection.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property remoteHost = BTunnelConnection.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property protocolVersion = BTunnelConnection.newProperty((int)3, (int)1, null);
    @Generated
    public static final Property lastRead = BTunnelConnection.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastWrite = BTunnelConnection.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Action disconnect = BTunnelConnection.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTunnelConnection.class);
    private static final BIcon icon = BIcon.std((String)"connection.png");
    private boolean connected = true;
    private DataInputStream in;
    private DataOutputStream out;
    private ByteBuffer readBuffer = new ByteBuffer();
    private BTunnelService service;
    private Socket socket;
    private String string;
    private BTunnel tunnel;
    private BUser user;
    private Object writeMutex = new Object();
    private String id;
    private String superId;
    private final long creationTime;

    @Generated
    public BAbsTime getEstablished() {
        return (BAbsTime)this.get(established);
    }

    @Generated
    public void setEstablished(BAbsTime v) {
        this.set(established, (BValue)v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public String getRemoteHost() {
        return this.getString(remoteHost);
    }

    @Generated
    public void setRemoteHost(String v) {
        this.setString(remoteHost, v, null);
    }

    @Generated
    public int getProtocolVersion() {
        return this.getInt(protocolVersion);
    }

    @Generated
    public void setProtocolVersion(int v) {
        this.setInt(protocolVersion, v, null);
    }

    @Generated
    public BAbsTime getLastRead() {
        return (BAbsTime)this.get(lastRead);
    }

    @Generated
    public void setLastRead(BAbsTime v) {
        this.set(lastRead, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastWrite() {
        return (BAbsTime)this.get(lastWrite);
    }

    @Generated
    public void setLastWrite(BAbsTime v) {
        this.set(lastWrite, (BValue)v, null);
    }

    @Generated
    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTunnelConnection() {
        this.creationTime = System.currentTimeMillis();
    }

    BTunnelConnection(BUser user, DataInputStream in, DataOutputStream out, Socket socket, BTunnel tunnel, BTunnelService service) {
        this.user = user;
        this.in = in;
        this.out = out;
        this.socket = socket;
        this.tunnel = tunnel;
        this.service = service;
        this.creationTime = System.currentTimeMillis();
        this.id = SessionManager.generateSessionId(BTunnelConnection.class, (int)25);
    }

    public int bytesAvailable() throws IOException {
        if (!this.connected) {
            return -1;
        }
        return this.readBuffer.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDisconnect() {
        if (!this.connected) {
            return;
        }
        Object object = this.writeMutex;
        synchronized (object) {
            try {
                this.out.write(MAGIC);
                this.out.write(23);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hardDisconnect();
    }

    public Context getBase() {
        return null;
    }

    public BObject getFacet(String name) {
        return null;
    }

    public BFacets getFacets() {
        return BFacets.DEFAULT;
    }

    public BIcon getIcon() {
        return icon;
    }

    public String getLanguage() {
        return this.getUser().getLanguage();
    }

    public InputStream getInputStream() {
        return new TunnelInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new TunnelOutputStream(this);
    }

    public BTunnelService getService() {
        return this.service;
    }

    public BTunnel getTunnel() {
        return this.tunnel;
    }

    public BUser getUser() {
        return this.user;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isParentLegal(BComponent c) {
        return c instanceof BTunnel;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        while (this.connected && this.readBuffer.available() == 0) {
            this.readMsg();
        }
        if (this.readBuffer.available() > 0) {
            int ret = this.readBuffer.read(buf, off, len);
            if (this.readBuffer.available() == 0) {
                this.readBuffer.reset();
            }
            return ret;
        }
        return -1;
    }

    public String toString(Context cx) {
        if (this.string == null) {
            this.string = this.getEstablished().toString();
        }
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected.");
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Object object = this.writeMutex;
        synchronized (object) {
            this.out.write(MAGIC);
            this.out.write(11);
            this.out.writeInt(len);
            this.out.write(buf, off, len);
            this.out.flush();
            this.setLastWrite(Clock.time());
        }
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void hardDisconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.service.removeConnection(this);
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tunnel.removeConnection(this);
        this.tunnel.sessionClosed(this);
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPing() {
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(MAGIC);
                this.out.write(19);
                this.setLastWrite(Clock.time());
                this.out.flush();
            }
        }
        catch (IOException x) {
            TunnelUtils.log.log(Level.SEVERE, this.toString() + " sending ping.", x);
            this.disconnect();
        }
    }

    private void readMsg() {
        block8: {
            try {
                if (this.in.read() != MAGIC[0] || this.in.read() != MAGIC[1] || this.in.read() != MAGIC[2] || this.in.read() != MAGIC[3]) {
                    TunnelUtils.log.severe(this.toString() + " invalid magic.");
                    this.disconnect();
                    return;
                }
                int msgType = this.in.read();
                this.setLastRead(Clock.time());
                switch (msgType) {
                    case 11: {
                        TunnelUtils.log.fine(this.toString() + " recv data.");
                        int len = this.in.readInt();
                        this.readBuffer.readFrom((InputStream)this.in, len);
                        break;
                    }
                    case 19: {
                        TunnelUtils.log.fine(this.toString() + " recv ping.");
                        break;
                    }
                    case 23: {
                        TunnelUtils.log.fine(this.toString() + " recv disconnect.");
                        this.disconnect();
                        break;
                    }
                    default: {
                        TunnelUtils.log.severe(this.toString() + " unexpected message: " + msgType);
                        this.disconnect();
                        break;
                    }
                }
            }
            catch (Exception x) {
                if (!this.connected) break block8;
                TunnelUtils.log.log(Level.SEVERE, this.toString(), x);
                this.disconnect();
            }
        }
    }

    public Map<String, String> getSessionInfo() {
        return new HashMap<String, String>();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public String getSuperId() {
        return this.superId;
    }

    public void setSuperId(String superId) {
        NiagaraBasicPermission initPermission = new NiagaraBasicPermission("MODIFY_SESSION_IDS");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)initPermission);
        }
        this.superId = superId;
    }

    public void doSetAuthenticated(BUser user) {
    }

    public void invalidate() {
        this.invalidate(null);
    }

    public void invalidate(LoginFailureCause cause) {
        SessionManager.removeSession((NiagaraSession)this);
    }

    public String getAuditTarget() {
        return this.tunnel.toPathString();
    }

    public boolean isSecure() {
        return this.socket instanceof SSLSocket;
    }
}

