/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.util;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
public class BObixThreadPool
extends BThreadPoolWorker {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixThreadPool.class);
    private ThreadPoolWorker worker;
    private CoalesceQueue queue;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue();
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    public boolean post(Runnable request) {
        if (this.queue == null) {
            throw new IllegalStateException("Obix: Null queue, please report this.");
        }
        if (!this.isRunning()) {
            return false;
        }
        return this.queue.enqueue((Object)request);
    }

    public void started() throws Exception {
        super.started();
        this.getWorker().start("Obix Worker");
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.worker != null) {
            this.worker.stop();
        }
    }

    protected String getWorkerThreadName() {
        return "Obix Worker";
    }
}

