/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.export;

import com.tridium.obix.server.BObixOp;
import com.tridium.obix.server.BObixStatusAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="point", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="priority", type="BPriorityLevel", defaultValue="BPriorityLevel.level_10"), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultReason", type="String", defaultValue="BString.make(\"\")", flags=1), @NiagaraProperty(name="writePoint", type="BComponent", defaultValue="new BObixOp(\"write\",\"obix:WritePointIn\",\"obix:Point\")", flags=1)})
@NiagaraAction(name="configure", flags=24)
public class BObixExport
extends BComponent
implements BIObixEncodable,
BIObixInvocable,
BIStatus {
    @Generated
    public static final Property point = BObixExport.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property priority = BObixExport.newProperty((int)0, (BValue)BPriorityLevel.level_10, null);
    @Generated
    public static final Property facets = BObixExport.newProperty((int)0, (BValue)BFacets.NULL, null);
    @Generated
    public static final Property status = BObixExport.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultReason = BObixExport.newProperty((int)1, (BValue)BString.make((String)""), null);
    @Generated
    public static final Property writePoint = BObixExport.newProperty((int)1, (BValue)new BObixOp("write", "obix:WritePointIn", "obix:Point"), null);
    @Generated
    public static final Action configure = BObixExport.newAction((int)24, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixExport.class);
    public static final BEnumRange DISALLOWED_PRIORITIES = BEnumRange.make((int[])new int[]{0}, (String[])new String[]{BPriorityLevel.none.getTag()});
    private static final String OUT = "out";
    private static final String FIN = "feedback";
    public static final BINavNode[] EMPTY_NAV_NODES = new BINavNode[0];

    @Generated
    public BOrd getPoint() {
        return (BOrd)this.get(point);
    }

    @Generated
    public void setPoint(BOrd v) {
        this.set(point, (BValue)v, null);
    }

    @Generated
    public BPriorityLevel getPriority() {
        return (BPriorityLevel)this.get(priority);
    }

    @Generated
    public void setPriority(BPriorityLevel v) {
        this.set(priority, (BValue)v, null);
    }

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultReason() {
        return this.getString(faultReason);
    }

    @Generated
    public void setFaultReason(String v) {
        this.setString(faultReason, v, null);
    }

    @Generated
    public BComponent getWritePoint() {
        return (BComponent)this.get(writePoint);
    }

    @Generated
    public void setWritePoint(BComponent v) {
        this.set(writePoint, (BValue)v, null);
    }

    @Generated
    public void configure() {
        this.invoke(configure, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context c) {
        super.changed(p, c);
        if (!this.isRunning()) {
            return;
        }
        if ((p == point || p == priority) && c != Context.decoding) {
            this.configure();
        }
    }

    public void doConfigure(Context cx) {
        try {
            BObject o;
            Property feedback;
            Property out = this.getProperty(OUT);
            if (out != null) {
                Knob[] nobs = this.getKnobs((Slot)out);
                if (nobs != null) {
                    for (Knob nob : nobs) {
                        nob.getTargetComponent().remove((BComplex)nob.getLink());
                    }
                }
                this.remove(out, cx);
            }
            if ((feedback = this.getProperty(FIN)) != null) {
                BLink[] links = this.getLinks((Slot)feedback);
                if (links != null) {
                    for (BLink link : links) {
                        this.remove((BComplex)link);
                    }
                }
                this.remove(feedback, cx);
            }
            if (!((o = this.getPoint().resolve((BObject)Sys.getStation(), cx).get()) instanceof BIWritablePoint) || !(o instanceof BControlPoint)) {
                this.setFaultReason(this.getPoint().toString(cx) + " is not a writable point.");
                this.setStatus(BStatus.fault);
                return;
            }
            BStatusValue cpInVal = null;
            BControlPoint cp = (BControlPoint)o;
            String opIn = this.writeOp().getOpIn();
            if (cp instanceof BBooleanWritable) {
                cpInVal = this.getInVal((BIWritablePoint)((BBooleanWritable)cp));
                this.writeOp().setOpIn("/obix/def/baja:StatusBoolean " + opIn);
            } else if (cp instanceof BNumericWritable) {
                cpInVal = this.getInVal((BIWritablePoint)((BNumericWritable)cp));
                this.writeOp().setOpIn("/obix/def/baja:StatusNumeric " + opIn);
            } else if (cp instanceof BEnumWritable) {
                cpInVal = this.getInVal((BIWritablePoint)((BEnumWritable)cp));
                this.writeOp().setOpIn("/obix/def/baja:StatusEnum " + opIn);
            } else if (cp instanceof BStringWritable) {
                cpInVal = this.getInVal((BIWritablePoint)((BStringWritable)cp));
                this.writeOp().setOpIn("/obix/def/baja:StatusString " + opIn);
            } else {
                this.setFaultReason("Unexpected point type: " + cp.getClass().getName());
                this.setStatus(BStatus.fault);
                return;
            }
            Property cpInProp = cpInVal.getPropertyInParent();
            if (cp.isLinkTarget((Slot)cpInProp)) {
                this.setFaultReason(this.getPoint().toString(cx) + " is already linked in priority " + this.getPriority().getDisplayTag(cx));
                this.setStatus(BStatus.fault);
                return;
            }
            this.add(OUT, cpInVal.newCopy(true), cx);
            cp.add("obixLink?", (BValue)cp.makeLink((BComponent)this, (Slot)this.getProperty(OUT), (Slot)cpInProp, cx));
            this.add(FIN, cpInVal.newCopy(true), cx);
            this.add("obixLink?", (BValue)this.makeLink((BComponent)cp, (Slot)cp.getOutProperty(), (Slot)this.getProperty(FIN), cx));
            this.setFacets(cp.getFacets());
            this.setFaultReason("");
            this.setStatus(BStatus.ok);
        }
        catch (Exception x) {
            this.setFaultReason(x.toString());
            this.setStatus(BStatus.fault);
        }
    }

    private BStatusValue getInVal(BIWritablePoint wp) {
        BPriorityLevel lvl = this.getPriority();
        if (lvl == BPriorityLevel.fallback) {
            if (wp instanceof BBooleanWritable) {
                return ((BBooleanWritable)wp).getFallback();
            }
            if (wp instanceof BNumericWritable) {
                return ((BNumericWritable)wp).getFallback();
            }
            if (wp instanceof BEnumWritable) {
                return ((BEnumWritable)wp).getFallback();
            }
            return ((BStringWritable)wp).getFallback();
        }
        return wp.getInStatusValue(lvl);
    }

    public BINavNode[] getNavChildren() {
        return EMPTY_NAV_NODES;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        this.encode(out, cx, true);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)priority)) {
            return BFacets.make((String)"range", (BIDataValue)DISALLOWED_PRIORITIES, (String)"fieldEditor", (BIDataValue)BString.make((String)"obixDriver:LimitedFrozenEnumFE"));
        }
        return this.getFacets();
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        try {
            BStatusValue val = (BStatusValue)this.get(OUT);
            in.addFacets(this.getFacets());
            BValue wrPtIn = in.decode();
            if (wrPtIn == null) {
                val.setStatus(BStatus.nullStatus);
            } else if (wrPtIn instanceof BComplex) {
                BComplex writePointIn = (BComplex)wrPtIn;
                BValue value = writePointIn.get("value");
                if (value == null) {
                    val.setStatus(BStatus.nullStatus);
                } else {
                    if (val instanceof BStatusEnum) {
                        ((BStatusEnum)val).setValue((BEnum)value.newCopy(true));
                    } else {
                        val.setValueValue(value.newCopy(true));
                    }
                    if (val.getStatus().isNull()) {
                        val.setStatus(BStatus.ok);
                    }
                }
            } else {
                val.setStatusNull(false);
                if (wrPtIn instanceof BDouble) {
                    val.setValueValue(wrPtIn.newCopy(true));
                } else if (wrPtIn instanceof BBoolean) {
                    val.setValueValue(wrPtIn.newCopy(true));
                } else if (wrPtIn instanceof BString) {
                    val.setValueValue(wrPtIn.newCopy(true));
                }
            }
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
        out.setName(null);
        this.encode(out, in, false);
    }

    public void started() throws Exception {
        if (this.getProperty(OUT) == null) {
            this.configure();
        }
    }

    public String toString(Context cx) {
        Property toEncode = this.getProperty(FIN);
        if (toEncode != null && !this.isLinkTarget((Slot)toEncode)) {
            toEncode = null;
        }
        if (toEncode == null) {
            toEncode = this.getProperty(OUT);
        }
        if (toEncode == null) {
            return "Not configured";
        }
        return this.get(toEncode).toString(cx);
    }

    private void encode(ObixEncoder out, Context cx, boolean notOp) {
        try {
            Property toEncode = this.getProperty(FIN);
            if (toEncode != null && !this.isLinkTarget((Slot)toEncode)) {
                toEncode = null;
            }
            if (toEncode == null || !notOp) {
                toEncode = this.getProperty(OUT);
            }
            if (toEncode == null) {
                return;
            }
            String href = out.getHref();
            BStatusValue val = (BStatusValue)this.get(toEncode);
            Obj obj = new Obj();
            obj.setName(out.getName());
            obj.setHref(ObixUtils.makeSlotPathUri(out, ObixUtils.concat(this.toPathString(), toEncode.getName())));
            BOrd ord = BOrd.make((String)("slot:" + toEncode.getName()));
            ObixUtils.encode(out, obj, (BObject)val.getValueValue(), ord.resolve((BObject)this, cx));
            obj.setIs("obix:WritablePoint obix:Point");
            obj.setHref(href);
            obj.setStatus(BObixStatusAgent.getStatus((BIStatus)val.getStatus()));
            obj.setWritable(null);
            if (val.getStatus().isNull()) {
                obj.setNull(Boolean.TRUE);
            }
            if (out.isRef()) {
                obj.makeRef();
                obj.write(out, false);
            } else if (notOp) {
                obj.write(out, true);
                String elem = obj.getElement();
                BOrd ptOrd = this.getPoint();
                OrdQuery[] oq = ptOrd.parse();
                if (oq.length == 1 && oq[0] instanceof SlotPath) {
                    obj.initRef("target", ObixUtils.makeSlotPathUri(out, oq[0].getBody()));
                } else {
                    BComponent c = ptOrd.get((BObject)Sys.getStation()).asComponent();
                    obj.initRef("target", ObixUtils.makeSlotPathUri(out, c.getSlotPath().getBody()));
                }
                obj.write(out, false);
                String outN = out.getName();
                out.setName("writePoint");
                out.setHref(out.getChildHref(out.getHref(), "writePoint"));
                this.writeOp().encode(out, cx);
                obj.setElement(elem);
                obj.endElem(out);
                out.setName(outN);
            } else {
                obj.write(out, false);
            }
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    private BObixOp writeOp() {
        return (BObixOp)this.getWritePoint();
    }
}

