/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.util;

import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.ObixUtils;
import java.util.Map;
import java.util.Vector;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.xml.XWriter;

public class Obj
implements ObixConstants {
    String display;
    String displayName;
    String element;
    String href;
    String icon;
    String in;
    String is;
    String max;
    String min;
    String name;
    Boolean nil;
    String of;
    String out;
    String precision;
    String range;
    String status;
    String tz;
    String units;
    String val;
    Boolean writable;

    public Obj() {
        this.element = "obj";
    }

    public Obj(String element) {
        this.element = element;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Obj setDisplayName(String arg) {
        this.displayName = arg;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public Obj setDisplay(String arg) {
        this.display = arg;
        return this;
    }

    public String getElement() {
        return this.element;
    }

    public Obj setElement(String arg) {
        this.element = arg;
        return this;
    }

    public String getHref() {
        return this.href;
    }

    public Obj setHref(String arg) {
        this.href = arg;
        return this;
    }

    public String getIcon() {
        return this.icon;
    }

    public Obj setIcon(String arg) {
        this.icon = arg;
        return this;
    }

    public String getIn() {
        return this.in;
    }

    public Obj setIn(String arg) {
        this.in = arg;
        return this;
    }

    public String getIs() {
        return this.is;
    }

    public Obj setIs(String arg) {
        this.is = arg;
        return this;
    }

    public String getMax() {
        return this.max;
    }

    public Obj setMax(String arg) {
        this.max = arg;
        return this;
    }

    public String getMin() {
        return this.min;
    }

    public Obj setMin(String arg) {
        this.min = arg;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Obj setName(String arg) {
        this.name = arg;
        return this;
    }

    public Boolean getNull() {
        return this.nil;
    }

    public boolean isNull() {
        return this.nil != null && this.nil != false;
    }

    public Obj setNull(Boolean arg) {
        this.nil = arg;
        return this;
    }

    public String getOf() {
        return this.of;
    }

    public Obj setOf(String arg) {
        this.of = arg;
        return this;
    }

    public String getOut() {
        return this.out;
    }

    public Obj setOut(String arg) {
        this.out = arg;
        return this;
    }

    public String getPrecision() {
        return this.precision;
    }

    public Obj setPrecision(String arg) {
        this.precision = arg;
        return this;
    }

    public String getRange() {
        return this.range;
    }

    public Obj setRange(String arg) {
        this.range = arg;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Obj setStatus(String arg) {
        this.status = arg;
        return this;
    }

    public String getTz() {
        return this.tz;
    }

    public Obj setTz(String arg) {
        this.tz = arg;
        return this;
    }

    public String getUnits() {
        return this.units;
    }

    public Obj setUnits(String arg) {
        this.units = arg;
        return this;
    }

    public String getVal() {
        return this.val;
    }

    public Obj setVal(String arg) {
        this.val = arg;
        return this;
    }

    public Boolean getWritable() {
        return this.writable;
    }

    public Obj setWritable(Boolean arg) {
        this.writable = arg;
        return this;
    }

    public void addContract(String arg) {
        this.addContract(arg, false);
    }

    public void addPrimaryContract(String arg) {
        this.addContract(arg, true);
    }

    public Obj endElem(ObixEncoder enc) {
        XWriter w = enc.getWriter();
        w.indent(enc.outdent());
        w.w((Object)"</").w((Object)this.element).w((Object)">\n");
        return this;
    }

    public String[] getContracts() {
        return this.getContracts(this.is);
    }

    public Obj initAbstime(String name, BAbsTime val) {
        this.reset().setElement("abstime").setName(name);
        if (val == null || val.isNull()) {
            return this.setNull(Boolean.TRUE);
        }
        return this.setVal(ObixUtils.dateTime(val)).setTz(val.getTimeZone().getId());
    }

    public Obj initAbstime(String name, String val) {
        return this.reset().setElement("abstime").setName(name).setVal(val);
    }

    public Obj initBool(String name, boolean val) {
        this.reset().setElement("bool").setName(name);
        return this.setVal(val ? "true" : "false");
    }

    public Obj initEnum(String name, String val) {
        return this.reset().setElement("enum").setName(name).setVal(val);
    }

    public Obj initErr(String href, String display) {
        return this.reset().setElement("err").setHref(href).setDisplay(display);
    }

    public Obj initFeed(String name, String in, String of) {
        return this.reset().setElement("feed").setName(name).setIn(in).setOf(of);
    }

    public Obj initInt(String name, int val) {
        this.reset().setElement("int").setName(name);
        return this.setVal(String.valueOf(val));
    }

    public Obj initList(String name, String of) {
        return this.reset().setElement("list").setName(name).setOf(of);
    }

    public Obj initObj(String name) {
        return this.reset().setName(name);
    }

    public Obj initOp(String name, String in, String out) {
        this.reset().setElement("op").setName(name);
        return this.setIn(in).setOut(out);
    }

    public Obj initReal(String name, double val) {
        this.reset().setElement("real").setName(name);
        return this.setVal(String.valueOf(val));
    }

    public Obj initRef(String name, String href) {
        return this.reset().setElement("ref").setName(name).setHref(href);
    }

    public Obj initReltime(String name, String val) {
        return this.reset().setElement("reltime").setName(name).setVal(val);
    }

    public Obj initStr(String name, String val) {
        return this.reset().setElement("str").setName(name).setVal(val);
    }

    public Obj initUri(String name, String val) {
        return this.reset().setElement("uri").setName(name).setVal(val);
    }

    public Obj makeRef() {
        this.setIn(null);
        this.setMax(null);
        this.setMin(null);
        this.setOf(null);
        this.setOut(null);
        this.setPrecision(null);
        this.setRange(null);
        this.setStatus(null);
        this.setTz(null);
        this.setUnits(null);
        this.setVal(null);
        this.setElement("ref");
        return this;
    }

    public Obj newCopy() {
        Obj ret = new Obj();
        ret.display = this.display;
        ret.displayName = this.displayName;
        ret.element = this.element;
        ret.href = this.href;
        ret.icon = this.icon;
        ret.in = this.in;
        ret.is = this.is;
        ret.max = this.max;
        ret.min = this.min;
        ret.name = this.name;
        ret.nil = this.nil;
        ret.of = this.of;
        ret.out = this.out;
        ret.precision = this.precision;
        ret.range = this.range;
        ret.status = this.status;
        ret.tz = this.tz;
        ret.units = this.units;
        ret.val = this.val;
        ret.writable = this.writable;
        return ret;
    }

    public final Obj reset() {
        this.display = null;
        this.displayName = null;
        this.element = "obj";
        this.href = null;
        this.icon = null;
        this.in = null;
        this.is = null;
        this.max = null;
        this.min = null;
        this.name = null;
        this.nil = null;
        this.of = null;
        this.out = null;
        this.precision = null;
        this.range = null;
        this.status = null;
        this.tz = null;
        this.units = null;
        this.val = null;
        this.writable = null;
        return this;
    }

    public String toString() {
        int len;
        StringBuilder buf = new StringBuilder();
        if (this.href != null) {
            buf.append("href=").append(this.href).append(',');
        }
        if (this.name != null) {
            buf.append("name=").append(this.name).append(',');
        }
        if (this.is != null) {
            buf.append("is=").append(this.is).append(',');
        }
        if (this.val != null) {
            buf.append("val=").append(this.val).append(',');
        }
        if (this.element != null) {
            buf.append("element=").append(this.element).append(',');
        }
        if (this.displayName != null) {
            buf.append("displayName=").append(this.displayName).append(',');
        }
        if (this.display != null) {
            buf.append("display=").append(this.display).append(',');
        }
        if (this.icon != null) {
            buf.append("icon=").append(this.icon).append(',');
        }
        if (this.in != null) {
            buf.append("in=").append(this.in).append(',');
        }
        if (this.max != null) {
            buf.append("max=").append(this.max).append(',');
        }
        if (this.min != null) {
            buf.append("min=").append(this.min).append(',');
        }
        if (this.nil != null) {
            buf.append("null=").append(this.nil).append(',');
        }
        if (this.of != null) {
            buf.append("of=").append(this.of).append(',');
        }
        if (this.out != null) {
            buf.append("out=").append(this.out).append(',');
        }
        if (this.precision != null) {
            buf.append("precision=").append(this.precision).append(',');
        }
        if (this.range != null) {
            buf.append("range=").append(this.range).append(',');
        }
        if (this.status != null) {
            buf.append("status=").append(this.status).append(',');
        }
        if (this.tz != null) {
            buf.append("tz=").append(this.tz).append(',');
        }
        if (this.units != null) {
            buf.append("units=").append(this.units).append(',');
        }
        if (this.writable != null) {
            buf.append("writable=").append(this.writable);
        }
        if ((len = buf.length()) > 0 && buf.charAt(--len) == ',') {
            buf.setLength(len);
        }
        return buf.toString();
    }

    public void write(ObixEncoder enc, boolean hasChildren) {
        this.write(enc, hasChildren, null);
    }

    public void write(ObixEncoder enc, boolean hasChildren, BIObixAgent agent) {
        String _writable;
        String _displayName = this.displayName;
        String _display = this.display;
        String _href = this.href;
        String _icon = this.icon;
        String _in = this.in;
        String _is = this.is;
        String _max = this.max;
        String _min = this.min;
        String _name = this.name;
        String _nil = this.nil == null ? null : String.valueOf(this.nil);
        String _of = this.of;
        String _out = this.out;
        String _precision = this.precision;
        String _range = this.range;
        String _status = this.status;
        String _tz = this.tz;
        String _units = this.units;
        String _val = this.val;
        String string = _writable = this.writable == null ? null : String.valueOf(this.writable);
        if (agent != null) {
            if (!this.element.equals("ref")) {
                this.element = agent.processElem(this.element);
            }
            _displayName = agent.processAttr("displayName", _displayName);
            _display = agent.processAttr("display", _display);
            _href = agent.processAttr("href", _href);
            _icon = agent.processAttr("icon", _icon);
            _in = agent.processAttr("in", _in);
            _is = agent.processAttr("is", _is);
            _max = agent.processAttr("max", _max);
            _min = agent.processAttr("min", _min);
            _name = agent.processAttr("name", _name);
            _nil = agent.processAttr("null", _nil);
            _of = agent.processAttr("of", _of);
            _out = agent.processAttr("out", _out);
            _precision = agent.processAttr("precision", _precision);
            _range = agent.processAttr("range", _range);
            _status = agent.processAttr("status", _status);
            _tz = agent.processAttr("tz", this.tz);
            _units = agent.processAttr("unit", _units);
            _val = agent.processAttr("val", _val);
            _writable = agent.processAttr("writable", _writable);
        }
        XWriter w = enc.getWriter();
        if (_val != null && _display != null && _val.equals(_display)) {
            _display = null;
        }
        if (_name != null && _displayName != null && _name.equals(_displayName)) {
            _displayName = null;
        }
        if (this.element == null) {
            throw new IllegalStateException("Missing element name: " + this.toString());
        }
        w.indent(enc.getIndent());
        w.w('<').w((Object)this.element);
        if (_name != null) {
            w.w(' ').attr("name", _name);
        }
        if (_val != null) {
            w.w(' ').attr("val", _val);
        }
        if (_status != null) {
            w.w(' ').attr("status", _status);
        }
        if (_href != null) {
            w.w(' ').attr("href", _href);
        }
        if (_is != null && enc.getEncodeIs()) {
            if (enc.getIndent() == 0) {
                w.w(' ').attr("is", this.cleanContracts(_href, _is));
            } else {
                w.w(' ').attr("is", _is);
            }
        }
        if (_of != null) {
            w.w(' ').attr("of", _of);
        }
        if (_in != null) {
            w.w(' ').attr("in", _in);
        }
        if (_out != null) {
            w.w(' ').attr("out", _out);
        }
        if (_nil != null) {
            w.w(' ').attr("null", _nil);
        }
        if (enc.getEncodeFacets()) {
            if (_display != null) {
                w.w(' ').attr("display", _display);
            }
            if (_displayName != null) {
                w.w(' ').attr("displayName", _displayName);
            }
            if (_icon != null) {
                w.w(' ').attr("icon", _icon);
            }
            if (_max != null) {
                w.w(' ').attr("max", _max);
            }
            if (_min != null) {
                w.w(' ').attr("min", _min);
            }
            if (_precision != null) {
                w.w(' ').attr("precision", _precision);
            }
            if (_range != null) {
                w.w(' ').attr("range", _range);
            }
            if (_tz != null) {
                w.w(' ').attr("tz", _tz);
            }
            if (_units != null) {
                w.w(' ').attr("unit", _units);
            }
            if (_writable != null && _href != null) {
                w.w(' ').attr("writable", _writable);
            }
        }
        if (enc.getIndent() == 0) {
            enc.attributes().put("xmlns", "http://obix.org/ns/schema/1.0");
        }
        this.writeAttributes(enc);
        if (hasChildren) {
            w.w((Object)">\n");
            enc.indent();
        } else {
            w.w((Object)"/>\n");
        }
    }

    private void addContract(String arg, boolean primary) {
        if (arg == null) {
            return;
        }
        String[] contracts = this.getContracts();
        int i = contracts.length;
        while (--i >= 0) {
            if (!contracts[i].equals(arg)) continue;
            return;
        }
        this.is = this.is == null ? arg.trim() : (primary ? arg + " " + this.is : this.is + " " + arg);
    }

    private String cleanContracts(String uri, String contract) {
        if (uri == null) {
            return contract;
        }
        if (contract == null) {
            return contract;
        }
        String[] contracts = this.getContracts(contract);
        if (contracts == null) {
            return contract;
        }
        int len = contracts.length;
        boolean mod = false;
        for (int i = 0; i < len; ++i) {
            if (!this.match(uri, contracts[i])) continue;
            mod = true;
            contracts[i] = null;
            break;
        }
        if (mod) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (contracts[i] == null) continue;
                buf.append(contracts[i]).append(' ');
            }
            contract = buf.toString().trim();
        }
        return contract;
    }

    private String[] getContracts(String is) {
        if (is == null) {
            return new String[0];
        }
        int len = is.length();
        Vector<String> v = new Vector<String>();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = is.charAt(i);
            if (ch <= ' ') {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    private boolean match(String uri, String contract) {
        int i = uri.indexOf(contract);
        if (i < 0) {
            return false;
        }
        return i + contract.length() + 1 >= this.href.length();
    }

    private void writeAttributes(ObixEncoder enc) {
        Map<String, String> attrs = enc.attributes();
        if (attrs != null && attrs.size() > 0) {
            XWriter w = enc.getWriter();
            for (String str : attrs.keySet()) {
                w.w(' ').attr(str, attrs.get(str));
            }
            attrs.clear();
        }
    }
}

