/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.history.audit.BAuditRecord;
import com.tridium.obix.server.BObixStatusAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType(agent={@AgentOn(types={"history:HistoryRecord"}, requiredPermissions="r")})
public class BObixHistoryRecordAgent
extends BObixStatusAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixHistoryRecordAgent.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean encode(OrdTarget target, ObixEncoder out) throws Exception {
        BTimeZone tzf;
        BHistoryRecord rec = (BHistoryRecord)target.get();
        BFacets f = target.getFacets();
        BTimeZone tz = BTimeZone.getLocal();
        if (f != null && (tzf = (BTimeZone)f.getFacet("TimeZone")) != null) {
            tz = tzf;
        }
        Obj obj = new Obj();
        obj.setHref(out.getHref());
        if (out.getEncodeIs()) {
            obj.setIs("obix:HistoryRecord");
        }
        obj.write(out, true);
        obj.initAbstime("timestamp", BAbsTime.make((BAbsTime)rec.getTimestamp(), (BTimeZone)tz));
        boolean isContract = out.isContract();
        if (isContract) {
            obj.setVal(null);
        }
        obj.write(out, false);
        if (rec instanceof BTrendRecord) {
            BTrendRecord trec = (BTrendRecord)rec;
            BSimple val = trec.get(trec.getValueProperty()).asSimple();
            ObixUtils.encodeSimple(out, obj.reset(), val, (Context)target);
            obj.setName("value");
            if (isContract) {
                obj.setVal(null);
            }
            obj.write(out, false);
        } else if (rec instanceof BAuditRecord) {
            BAuditRecord arec = (BAuditRecord)rec;
            BObixHistoryRecordAgent.writeAuditRecordPart(obj, out, "operation", arec.getOperation(), isContract);
            BObixHistoryRecordAgent.writeAuditRecordRef(obj, out, "targetSlot", arec.getTarget() + '/' + arec.getSlotName(), isContract);
            BObixHistoryRecordAgent.writeAuditRecordPart(obj, out, "oldValue", arec.getOldValue(), isContract);
            BObixHistoryRecordAgent.writeAuditRecordPart(obj, out, "value", arec.getValue(), isContract);
            BObixHistoryRecordAgent.writeAuditRecordPart(obj, out, "userName", arec.getUserName(), isContract);
        } else {
            obj.initStr("value", rec.toString((Context)target));
            if (out.isContract()) {
                obj.setVal(null);
            }
            obj.write(out, false);
        }
        obj.reset().endElem(out);
        return false;
    }

    private static void writeAuditRecordRef(Obj obj, ObixEncoder out, String name, String val, boolean contract) {
        obj.initRef(name, "/obix/config" + val);
        if (contract) {
            obj.setHref(null);
        }
        obj.write(out, false);
    }

    private static void writeAuditRecordPart(Obj obj, ObixEncoder out, String name, String val, boolean contract) {
        obj.initStr(name, val);
        if (contract) {
            obj.setVal(null);
        }
        obj.write(out, false);
    }
}

