/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.samlEncryption;

import com.onelogin.saml2.util.Util;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLResponseException;
import com.tridium.saml.idp.BISamlXmlEncrypter;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.utils.SAMLUtils;
import java.security.AccessController;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NiagaraType
public class BSamlXmlEncrypter
extends BComponent
implements BISamlXmlEncrypter {
    @Generated
    public static final Type TYPE = Sys.loadType(BSamlXmlEncrypter.class);
    private static SecureRandom random;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType() == BSAMLIdPService.TYPE && ((BISamlXmlEncrypter[])parent.getChildren(BISamlXmlEncrypter.class)).length == 0;
    }

    public Document encryptResponse(Document unencryptedResponse, X509Certificate encryptingCertificate) throws SAMLException {
        Document encryptedResponse;
        try {
            encryptedResponse = SAMLUtils.copyDocument((Document)unencryptedResponse);
        }
        catch (ParserConfigurationException e) {
            throw new SAMLResponseException(e.getLocalizedMessage());
        }
        AccessController.doPrivileged(() -> {
            Init.init();
            return null;
        });
        PublicKey keyEncryptionKey = encryptingCertificate.getPublicKey();
        try {
            byte[] randomBytes = new byte[16];
            random.nextBytes(randomBytes);
            SecretKeySpec aesKey = new SecretKeySpec(randomBytes, "AES");
            XMLCipher cipher = XMLCipher.getProviderInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc", (String)SecurityInitializer.getInstance().getCryptoProvider().getProvider().getName());
            cipher.init(1, (Key)aesKey);
            NodeList assertionNodes = SAMLUtils.query((Document)encryptedResponse, (String)"/samlp:Response/saml:Assertion");
            Element assertion = (Element)assertionNodes.item(0);
            EncryptedData encryptedData = cipher.encryptData(encryptedResponse, assertion);
            cipher = XMLCipher.getProviderInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (String)SecurityInitializer.getInstance().getCryptoProvider().getProvider().getName());
            cipher.init(3, (Key)keyEncryptionKey);
            EncryptedKey encryptedKey = cipher.encryptKey(encryptedResponse, (Key)aesKey);
            KeyInfo keyInfo = new KeyInfo(encryptedResponse);
            keyInfo.add(encryptedKey);
            encryptedData.setKeyInfo(keyInfo);
            Element encryptedDataElement = cipher.martial(encryptedResponse, encryptedData);
            NodeList mgfElements = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "MGF");
            for (int i = 0; i < mgfElements.getLength(); ++i) {
                Node mgf = mgfElements.item(i);
                mgf.getParentNode().removeChild(mgf);
            }
            Element encryptedAssertion = encryptedResponse.createElement("saml:EncryptedAssertion");
            encryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:2.0:assertion");
            encryptedAssertion.appendChild(encryptedDataElement);
            assertion.getParentNode().replaceChild(encryptedAssertion, assertion);
        }
        catch (Exception e) {
            throw new SAMLResponseException(e.getMessage(), (Throwable)e);
        }
        return SAMLUtils.loadXML((String)AccessController.doPrivileged(() -> Util.convertDocumentToString((Document)encryptedResponse)));
    }

    static {
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            Logger.getLogger("samlEncryption").warning(e.getLocalizedMessage());
        }
    }
}

