/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public class BJobLogView
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BJobLogView.class);
    private JobLogModel model = new JobLogModel();
    public static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    public static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    public static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    public static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    public static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    public static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    public static final String lexStatus = UiLexicon.bajaui().getText("status");
    public static final String lexTimestamp = UiLexicon.bajaui().getText("timestamp");
    public static final String lexMessage = UiLexicon.bajaui().getText("message");
    public static final String lexDetails = UiLexicon.bajaui().getText("details");
    public static final String lexCancel = UiLexicon.bajaui().getText("cancel");
    public static final String lexDispose = UiLexicon.bajaui().getText("dispose");
    public static final String lexLog = UiLexicon.bajaui().getText("log");
    public static final String lexJobLog = UiLexicon.bajaui().getText("job.log");
    public static final String lexLogDetails = UiLexicon.bajaui().getText("log.details");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BJobLogView() {
        BTable table = new BTable((TableModel)this.model, (TableController)new JobLogController());
        this.setContent((BWidget)table);
    }

    public void doLoadValue(BObject object, Context cx) throws Exception {
        this.model.load(JobLog.decode((String)((BJob)object).readLog().toString()));
    }

    public static BImage stateToIcon(BJobState state) {
        switch (state.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    public static BImage itemToIcon(JobLogItem item) {
        switch (item.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    public class JobLogController
    extends TableController {
        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            JobLogItem item = ((JobLogModel)this.getModel()).log.getItem(row);
            BTextEditor text = new BTextEditor(item.toString(), false);
            BTextEditorPane pane = new BTextEditorPane(text, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lexLogDetails, (Object)pane, (int)1);
        }
    }

    public class JobLogModel
    extends TableModel {
        public int count;
        public JobLog log;
        public JobLogItem[] items;
        public String[] messages;
        public String[] details;

        public void load(JobLog log) {
            this.log = log;
            this.items = log.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage());
                this.details[i] = this.str(this.items[i].getDetails());
            }
            this.updateTable();
        }

        public String str(String s) {
            if (s == null) {
                return "";
            }
            int n = s.indexOf(10);
            if (n < 0) {
                return s;
            }
            return s.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.items[row].getIdString();
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.messages[row];
                }
                case 3: {
                    return this.details[row];
                }
            }
            return "???";
        }

        public Object getSubject(int row) {
            return this.items[row];
        }

        public BObject export(int row, int col) {
            switch (col) {
                case 0: {
                    return this.export(this.items[row].getIdString());
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[row].getMessage());
                }
                case 3: {
                    return this.export(this.items[row].getDetails());
                }
            }
            return BString.DEFAULT;
        }

        public BString export(String s) {
            if (s == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)s);
        }

        public BImage getRowIcon(int row) {
            return BJobLogView.itemToIcon(this.items[row]);
        }
    }
}

