/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.proxyExt.subscribers;

import com.tridium.mqttClientDriver.clients.INiagaraMessage;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BMqttEnumObjectSubscribeExt
extends BMqttClientAbstractSubscriberPoint {
    @Generated
    public static final Type TYPE = Sys.loadType(BMqttEnumObjectSubscribeExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveValueToPoint(INiagaraMessage message) {
        byte[] byteMsg = message.getMessagePayload();
        if (!this.isValidPayload(byteMsg)) {
            logger.warning("Invalid message.");
            return;
        }
        String msg = new String(message.getMessagePayload());
        boolean sendTag = "true".equals(this.getDevice().get("sendEnumAs").toString());
        BDynamicEnum enumValue = null;
        BEnumRange enumRange = null;
        int ordinal = 0;
        try {
            enumRange = (BEnumRange)this.getPointFacets().getFacet("range");
            if (sendTag) {
                if (!enumRange.isTag(msg)) throw new LocalizableRuntimeException("abstractMqttDriver", "invalidEnumData");
                ordinal = enumRange.tagToOrdinal(msg);
            } else {
                ordinal = Integer.parseInt(msg);
                if (!enumRange.isOrdinal(ordinal)) {
                    throw new LocalizableRuntimeException("abstractMqttDriver", "invalidEnumData");
                }
            }
            enumValue = BDynamicEnum.make((int)ordinal, (BEnumRange)enumRange);
            BStatusEnum val = new BStatusEnum((BEnum)enumValue);
            this.readOk((BStatusValue)val);
            return;
        }
        catch (LocalizableRuntimeException lre) {
            this.readFail(lre.getMessage());
            logger.fine(lre.getMessage());
            return;
        }
        catch (Exception e) {
            String exceptionMessage = this.lex.get("invalidEnumSubscriberFormat");
            this.readFail(exceptionMessage);
            logger.warning(exceptionMessage + e.getMessage());
            if (!logger.isLoggable(Level.FINE)) return;
            e.printStackTrace();
        }
    }
}

