/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotDeviceProperty;
import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.AWSIotTimeoutException;
import com.amazonaws.services.iot.client.AWSIotTopic;
import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceCommandAckListener;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceCommandManager;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceDeltaListener;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceReportMessage;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceSyncMessage;
import com.amazonaws.services.iot.client.shadow.AwsIotJsonDeserializer;
import com.amazonaws.services.iot.client.shadow.AwsIotJsonSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractAwsIotDevice {
    private static final Logger LOGGER = Logger.getLogger(AbstractAwsIotDevice.class.getName());
    protected final String thingName;
    protected long reportInterval = 3000L;
    protected boolean enableVersioning = false;
    protected AWSIotQos deviceReportQos = AWSIotQos.valueOf(0);
    protected AWSIotQos shadowUpdateQos = AWSIotQos.valueOf(0);
    protected AWSIotQos methodQos = AWSIotQos.valueOf(0);
    protected AWSIotQos methodAckQos = AWSIotQos.valueOf(0);
    private final Map<String, Field> reportedProperties;
    private final Map<String, Field> updatableProperties;
    private final AwsIotDeviceCommandManager commandManager;
    private final ConcurrentMap<String, Boolean> deviceSubscriptions;
    private final ObjectMapper jsonObjectMapper;
    private AbstractAwsIotClient client;
    private Future<?> syncTask;
    private AtomicLong localVersion;

    protected AbstractAwsIotDevice(String thingName) {
        this.thingName = thingName;
        this.reportedProperties = this.getDeviceProperties(true, false);
        this.updatableProperties = this.getDeviceProperties(false, true);
        this.commandManager = new AwsIotDeviceCommandManager(this);
        this.deviceSubscriptions = new ConcurrentHashMap<String, Boolean>();
        for (String topic : this.getDeviceTopics()) {
            this.deviceSubscriptions.put(topic, false);
        }
        this.jsonObjectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(AbstractAwsIotDevice.class, new AwsIotJsonSerializer());
        this.jsonObjectMapper.registerModule(module);
        this.localVersion = new AtomicLong(-1L);
    }

    protected AbstractAwsIotDevice getDevice() {
        return this;
    }

    protected String get() throws AWSIotException {
        AWSIotMessage message = new AWSIotMessage(null, this.methodQos);
        return this.commandManager.runCommandSync(AwsIotDeviceCommandManager.Command.GET, message);
    }

    protected String get(long timeout) throws AWSIotException, AWSIotTimeoutException {
        AWSIotMessage message = new AWSIotMessage(null, this.methodQos);
        return this.commandManager.runCommandSync(AwsIotDeviceCommandManager.Command.GET, message, timeout);
    }

    protected void get(AWSIotMessage message, long timeout) throws AWSIotException {
        this.commandManager.runCommand(AwsIotDeviceCommandManager.Command.GET, message, timeout);
    }

    protected void update(String jsonState) throws AWSIotException {
        AWSIotMessage message = new AWSIotMessage(null, this.methodQos, jsonState);
        this.commandManager.runCommandSync(AwsIotDeviceCommandManager.Command.UPDATE, message);
    }

    protected void update(String jsonState, long timeout) throws AWSIotException, AWSIotTimeoutException {
        AWSIotMessage message = new AWSIotMessage(null, this.methodQos, jsonState);
        this.commandManager.runCommandSync(AwsIotDeviceCommandManager.Command.UPDATE, message, timeout);
    }

    protected void update(AWSIotMessage message, long timeout) throws AWSIotException {
        this.commandManager.runCommand(AwsIotDeviceCommandManager.Command.UPDATE, message, timeout);
    }

    protected void delete() throws AWSIotException {
        AWSIotMessage message = new AWSIotMessage(null, this.methodQos);
        this.commandManager.runCommandSync(AwsIotDeviceCommandManager.Command.DELETE, message);
    }

    protected void delete(long timeout) throws AWSIotException, AWSIotTimeoutException {
        AWSIotMessage message = new AWSIotMessage(null, this.methodQos);
        this.commandManager.runCommandSync(AwsIotDeviceCommandManager.Command.DELETE, message, timeout);
    }

    protected void delete(AWSIotMessage message, long timeout) throws AWSIotException {
        this.commandManager.runCommand(AwsIotDeviceCommandManager.Command.DELETE, message, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onShadowUpdate(String jsonState) {
        AbstractAwsIotDevice abstractAwsIotDevice = this;
        synchronized (abstractAwsIotDevice) {
            try {
                AwsIotJsonDeserializer.deserialize(this, jsonState);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to update device", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String onDeviceReport() {
        AbstractAwsIotDevice abstractAwsIotDevice = this;
        synchronized (abstractAwsIotDevice) {
            try {
                return this.jsonObjectMapper.writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOGGER.log(Level.WARNING, "Failed to generate device report", e);
                return null;
            }
        }
    }

    public void activate() throws AWSIotException {
        this.stopSync();
        for (String topic : this.getDeviceTopics()) {
            AWSIotTopic awsIotTopic = this.commandManager.isDeltaTopic(topic) ? new AwsIotDeviceDeltaListener(topic, this.shadowUpdateQos, this) : new AwsIotDeviceCommandAckListener(topic, this.methodAckQos, this);
            this.client.subscribe(awsIotTopic, this.client.getServerAckTimeout());
        }
        this.startSync();
    }

    public void deactivate() throws AWSIotException {
        this.stopSync();
        this.commandManager.onDeactivate();
        for (String topic : this.getDeviceTopics()) {
            this.deviceSubscriptions.put(topic, false);
            AWSIotTopic awsIotTopic = new AWSIotTopic(topic);
            this.client.unsubscribe(awsIotTopic, (long)this.client.getServerAckTimeout());
        }
    }

    public boolean isTopicReady(String topic) {
        Boolean status = (Boolean)this.deviceSubscriptions.get(topic);
        return Boolean.TRUE.equals(status);
    }

    public boolean isCommandReady(AwsIotDeviceCommandManager.Command command) {
        Boolean accepted = (Boolean)this.deviceSubscriptions.get(this.commandManager.getTopic(command, AwsIotDeviceCommandManager.CommandAck.ACCEPTED));
        Boolean rejected = (Boolean)this.deviceSubscriptions.get(this.commandManager.getTopic(command, AwsIotDeviceCommandManager.CommandAck.REJECTED));
        return Boolean.TRUE.equals(accepted) && Boolean.TRUE.equals(rejected);
    }

    public void onSubscriptionAck(String topic, boolean success) {
        this.deviceSubscriptions.put(topic, success);
        this.commandManager.onSubscriptionAck(topic, success);
    }

    public void onCommandAck(AWSIotMessage message) {
        this.commandManager.onCommandAck(message);
    }

    protected void startSync() {
        if (this.reportedProperties.isEmpty() || this.reportInterval <= 0L) {
            return;
        }
        this.syncTask = this.client.scheduleRoutineTask(new Runnable(){

            @Override
            public void run() {
                if (!AbstractAwsIotDevice.this.isCommandReady(AwsIotDeviceCommandManager.Command.UPDATE)) {
                    LOGGER.fine("Device not ready for reporting");
                    return;
                }
                long reportVersion = AbstractAwsIotDevice.this.localVersion.get();
                if (AbstractAwsIotDevice.this.enableVersioning && reportVersion < 0L) {
                    LOGGER.fine("Starting version sync");
                    AbstractAwsIotDevice.this.startVersionSync();
                    return;
                }
                String jsonState = AbstractAwsIotDevice.this.onDeviceReport();
                if (jsonState != null) {
                    LOGGER.fine("Sending device report");
                    AbstractAwsIotDevice.this.sendDeviceReport(reportVersion, jsonState);
                }
            }
        }, 0L, this.reportInterval);
    }

    protected void stopSync() {
        if (this.syncTask != null) {
            this.syncTask.cancel(false);
            this.syncTask = null;
        }
        this.localVersion.set(-1L);
    }

    protected void startVersionSync() {
        this.localVersion.set(-1L);
        AwsIotDeviceSyncMessage message = new AwsIotDeviceSyncMessage(null, this.shadowUpdateQos, this);
        try {
            this.commandManager.runCommand(AwsIotDeviceCommandManager.Command.GET, message, this.client.getServerAckTimeout(), true);
        }
        catch (AWSIotTimeoutException aWSIotTimeoutException) {
        }
        catch (AWSIotException e) {
            LOGGER.log(Level.WARNING, "Failed to publish version update message", e);
        }
    }

    private void sendDeviceReport(long reportVersion, String jsonState) {
        StringBuilder payload = new StringBuilder("{");
        if (this.enableVersioning) {
            payload.append("\"version\":").append(reportVersion).append(",");
        }
        payload.append("\"state\":{\"reported\":").append(jsonState).append("}}");
        AwsIotDeviceReportMessage message = new AwsIotDeviceReportMessage(null, this.shadowUpdateQos, reportVersion, payload.toString(), this);
        if (this.enableVersioning && reportVersion != this.localVersion.get()) {
            LOGGER.warning("Local version number has changed, skip reporting for this round");
            return;
        }
        try {
            this.commandManager.runCommand(AwsIotDeviceCommandManager.Command.UPDATE, message, this.client.getServerAckTimeout(), true);
        }
        catch (AWSIotTimeoutException aWSIotTimeoutException) {
        }
        catch (AWSIotException e) {
            LOGGER.log(Level.WARNING, "Failed to publish device report message", e);
        }
    }

    private Map<String, Field> getDeviceProperties(boolean enableReport, boolean allowUpdate) {
        HashMap<String, Field> properties = new HashMap<String, Field>();
        for (Field field : this.getClass().getDeclaredFields()) {
            String propertyName;
            AWSIotDeviceProperty annotation = field.getAnnotation(AWSIotDeviceProperty.class);
            if (annotation == null) continue;
            String string = propertyName = annotation.name().length() > 0 ? annotation.name() : field.getName();
            if ((!enableReport || !annotation.enableReport()) && (!allowUpdate || !annotation.allowUpdate())) continue;
            properties.put(propertyName, field);
        }
        return properties;
    }

    private List<String> getDeviceTopics() {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.DELTA, null));
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.GET, AwsIotDeviceCommandManager.CommandAck.ACCEPTED));
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.GET, AwsIotDeviceCommandManager.CommandAck.REJECTED));
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.UPDATE, AwsIotDeviceCommandManager.CommandAck.ACCEPTED));
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.UPDATE, AwsIotDeviceCommandManager.CommandAck.REJECTED));
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.DELETE, AwsIotDeviceCommandManager.CommandAck.ACCEPTED));
        topics.add(this.commandManager.getTopic(AwsIotDeviceCommandManager.Command.DELETE, AwsIotDeviceCommandManager.CommandAck.REJECTED));
        return topics;
    }

    public String getThingName() {
        return this.thingName;
    }

    public long getReportInterval() {
        return this.reportInterval;
    }

    public boolean isEnableVersioning() {
        return this.enableVersioning;
    }

    public AWSIotQos getDeviceReportQos() {
        return this.deviceReportQos;
    }

    public AWSIotQos getShadowUpdateQos() {
        return this.shadowUpdateQos;
    }

    public AWSIotQos getMethodQos() {
        return this.methodQos;
    }

    public AWSIotQos getMethodAckQos() {
        return this.methodAckQos;
    }

    public Map<String, Field> getReportedProperties() {
        return this.reportedProperties;
    }

    public Map<String, Field> getUpdatableProperties() {
        return this.updatableProperties;
    }

    public AwsIotDeviceCommandManager getCommandManager() {
        return this.commandManager;
    }

    public ConcurrentMap<String, Boolean> getDeviceSubscriptions() {
        return this.deviceSubscriptions;
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonObjectMapper;
    }

    public AbstractAwsIotClient getClient() {
        return this.client;
    }

    public Future<?> getSyncTask() {
        return this.syncTask;
    }

    public AtomicLong getLocalVersion() {
        return this.localVersion;
    }

    public void setReportInterval(long reportInterval) {
        this.reportInterval = reportInterval;
    }

    public void setEnableVersioning(boolean enableVersioning) {
        this.enableVersioning = enableVersioning;
    }

    public void setDeviceReportQos(AWSIotQos deviceReportQos) {
        this.deviceReportQos = deviceReportQos;
    }

    public void setShadowUpdateQos(AWSIotQos shadowUpdateQos) {
        this.shadowUpdateQos = shadowUpdateQos;
    }

    public void setMethodQos(AWSIotQos methodQos) {
        this.methodQos = methodQos;
    }

    public void setMethodAckQos(AWSIotQos methodAckQos) {
        this.methodAckQos = methodAckQos;
    }

    public void setClient(AbstractAwsIotClient client) {
        this.client = client;
    }

    public void setSyncTask(Future<?> syncTask) {
        this.syncTask = syncTask;
    }

    public void setLocalVersion(AtomicLong localVersion) {
        this.localVersion = localVersion;
    }
}

