/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.ui;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.platcrypto.core.IExtCryptoManager;
import com.tridium.platcrypto.ui.BCertificateSelectFE;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.fieldeditors.BDefaultPasswordFE;
import com.tridium.workbench.shell.BGeneralOptions;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.wizard.BWizard;
import javax.baja.util.Lexicon;
import javax.baja.workbench.authn.BCredInputPane;

@NiagaraType
@NiagaraAction(name="changeUser", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public class BClientCertCredInputPane
extends BCredInputPane {
    @Generated
    public static final Action changeUser = BClientCertCredInputPane.newAction((int)0, (BValue)new BMouseEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BClientCertCredInputPane.class);
    private BTextField usernameFE = new BTextField();
    private BHyperlinkLabel changeUserHyperlink = new BHyperlinkLabel();
    protected BCheckBox saveCredentials;
    private BCertificateSelectFE certificateSelectFE;
    private String alias = "";
    private BDefaultPasswordFE passwordFE = new BDefaultPasswordFE();
    public static final Lexicon lexicon = Lexicon.make(BClientCertCredInputPane.class);
    private static final Logger LOG = Logger.getLogger("clientCertAuth");

    @Generated
    public void changeUser(BMouseEvent parameter) {
        this.invoke(changeUser, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BClientCertCredInputPane(BCertificateAliasCredential credentials, AuthenticationRealm realm, String realmPrefix) {
        BGridPane credPane = new BGridPane(2);
        credPane.setHalign(BHalign.left);
        credPane.setColumnGap(20.0);
        credPane.add(null, (BValue)new BLabel(lexicon.getText("clientCert.username")));
        credPane.add(null, (BValue)this.usernameFE);
        this.usernameFE.setText(credentials.getUsername());
        this.usernameFE.setEnabled(false);
        credPane.add(null, (BValue)new BLabel());
        credPane.add(null, (BValue)this.changeUserHyperlink);
        this.initChangeUserHyperlink();
        try {
            IExtCryptoManager cm = (IExtCryptoManager)CertManagerFactory.getInstance();
            this.certificateSelectFE = new BCertificateSelectFE(cm.getCoreCryptoManager(), BCertificateSelectFE.KeyStoreType.USER_KEYSTORE, KeyPurpose.CLIENT_CERT);
            this.certificateSelectFE.loadValue(null);
            credPane.add(null, (BValue)new BLabel(lexicon.getText("clientCert.certificate")));
            credPane.add(null, (BValue)this.certificateSelectFE);
            String alias = credentials.getCertificateAlias();
            if (alias != null && !alias.isEmpty()) {
                this.certificateSelectFE.setSelectedAlias(alias);
            } else {
                this.certificateSelectFE.setSelectedAlias(this.certificateSelectFE.getText());
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Unable to get instance of Certificate Manager Factory - ", ex);
        }
        credPane.add(null, (BValue)new BLabel(lexicon.getText("clientCert.certificatePassword")));
        credPane.add(null, (BValue)this.passwordFE);
        this.add(null, (BValue)credPane);
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        if (!allowCaching) {
            AuthUtil.saveCredentials = false;
        }
        this.saveCredentials = new BCheckBox(lexicon.get("clientCert.saveCredentials"), allowCaching && AuthUtil.hasSavedCredentials((String)(realmPrefix + realm.getAuthenticationRealmName())));
        this.saveCredentials.setEnabled(allowCaching);
        this.add(null, (BValue)this.saveCredentials);
    }

    protected BICredentials doGetCredentials() throws Exception {
        BCertificateAliasCredential credentials;
        block2: {
            credentials = new BCertificateAliasCredential();
            credentials.setUsername(this.usernameFE.getText());
            credentials.setCertificateAlias(this.certificateSelectFE.saveValue().toString());
            try {
                credentials.setCertificatePassword((BPassword)this.passwordFE.saveValue());
            }
            catch (Exception e) {
                if (this.passwordFE.saveValue() != null) break block2;
                throw new FoxAuthenticationException(lexicon.get("clientCert.certificatePassword.exception.reqPassword"), null);
            }
        }
        return credentials;
    }

    protected void doCleanCredentials() {
    }

    private void initChangeUserHyperlink() {
        BFont font = this.changeUserHyperlink.getFont();
        font = font.isNull() ? BFont.make((BFont)Theme.label().getTextFont((IStylable)this.changeUserHyperlink), (int)4) : BFont.make((BFont)font, (int)4);
        this.changeUserHyperlink.setForeground(BBrush.makeSolid((BColor)BColor.blue));
        this.changeUserHyperlink.setFont(font);
        this.changeUserHyperlink.setText(lexicon.getText("clientCert.changeUser"));
        this.changeUserHyperlink.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)3.0));
        this.linkTo((BComponent)this.changeUserHyperlink, (Slot)BWidget.mouseEvent, (Slot)changeUser);
    }

    public void doChangeUser(BMouseEvent event) {
        if (event.getId() == 502) {
            BClientCertCredInputPane parent = this;
            while (!((parent = parent.getParentWidget()) instanceof BOptionDialog) && !(parent instanceof BWizard) && parent != null) {
            }
            if (parent instanceof BOptionDialog) {
                ((BOptionDialog)parent).close(1000);
            } else if (parent instanceof BWizard) {
                ((BWizard)parent).getModel().back();
            }
        }
    }

    public boolean shouldSaveCredentials() {
        return this.saveCredentials.isSelected();
    }

    public boolean shouldDeleteCredentials() {
        return !this.saveCredentials.isSelected();
    }
}

