/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.smartTableHx.export.BExportFileWrapper;
import javax.baja.gx.BImage;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BIcon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class DownloadDialog
extends Dialog {
    protected BImage image = BImage.make((BIcon)BIcon.std((String)"download.png"));
    protected BExportFileWrapper wrapper;
    protected boolean refresh = false;

    public DownloadDialog(String title, Command handler) {
        super(title, handler);
    }

    public DownloadDialog(String title, Command handler, BExportFileWrapper wrapper, boolean refresh) {
        this(title, handler);
        this.wrapper = wrapper;
        this.refresh = refresh;
    }

    public void open(BExportFileWrapper currentWrapper, HxOp op) throws Exception {
        this.wrapper = currentWrapper;
        this.open(op);
        this.wrapper = null;
    }

    protected void writeContent(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table><tr><td>");
        HxUtil.makeImageJS((BImage)this.image, null, null, null, (HxOp)op);
        out.w((Object)"<td> ");
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        String text = Lexicon.make(DownloadDialog.class).getText("areYouSureDownload", new Object[]{this.wrapper.getFileName()});
        out.safe((Object)text);
        out.w((Object)"</tr></table>");
    }

    public Command[] getCommands() {
        return new Command[]{new Download(), new DownloadCancel()};
    }

    protected class DownloadCancel
    extends Dialog.Cancel {
        public DownloadCancel() {
            super((Dialog)DownloadDialog.this);
        }

        public String getInvokeCode(HxOp op) {
            if (DownloadDialog.this.refresh) {
                return "hx.closeDialog(null,null,null);setTimeout(&quot;window.location.reload(true);&quot;, 100);";
            }
            return "hx.closeDialog(null,null,null);";
        }
    }

    protected class Download
    extends Dialog.Submit {
        public Download() {
            super((Dialog)DownloadDialog.this, "submit", LexiconText.make((String)"hx", (String)"ok"));
        }

        public String getInvokeCode(HxOp op) {
            if (DownloadDialog.this.refresh) {
                return "window.top.location=&quot;" + op.toUri(DownloadDialog.this.wrapper.getNavOrd()) + "&quot;;setTimeout(&quot;window.location.reload(true);&quot;, 100);";
            }
            return "window.top.location=&quot;" + op.toUri(DownloadDialog.this.wrapper.getNavOrd()) + "&quot;;hx.closeDialog(null,null,null);";
        }
    }
}

