/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.Context;
import javax.baja.util.LexiconModule;

public abstract class SaveCommand
extends SmartCommand {
    private SaveConfirmDialog dlg = new SaveConfirmDialog("Confirm Save", this);

    public SaveCommand(BHxView view) {
        super(view, LexiconModule.make(SmartCommand.class));
    }

    @Override
    public String getInvokeCode(HxOp op) {
        StringBuilder b = new StringBuilder();
        b.append("if(this.className.indexOf(\"-disabled\") == -1)");
        b.append("{save.pending();");
        b.append("hx.fireEvent(\"").append(op.getPath());
        b.append("\",\"");
        b.append(this.getId());
        b.append("\");");
        b.append("}");
        return b.toString();
    }

    @Override
    public void addOnload(HxOp op) throws Exception {
        String quote = HxUtil.getInnerQuote((HxOp)op);
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/save.js"));
        if (this.registerOnInputs(op)) {
            op.addOnload("save.attachSave(" + this.getRegistrationElement(op) + ", " + quote + op.getPath() + quote + ", " + quote + this.getId() + quote + ");");
        }
        op.addOnload("save.warningMessage=" + quote + this.lexModule.getHtmlSafe("save.warningMessage", (Context)op) + quote + ";");
    }

    public String getHtmlElementName(HxOp op) {
        return "smartTableSave";
    }

    @Override
    public String getName(HxOp op) {
        return "save";
    }

    @Override
    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean registerOnInputs(HxOp op) {
        return false;
    }

    public String getRegistrationElement(HxOp op) {
        return "document.body";
    }

    @Override
    public boolean startsEnabled(HxOp op) {
        return false;
    }

    public static void exemptInputFromSaveRegistration(HtmlWriter out) {
        out.attr(" noSave", "true");
    }

    public static void setModified(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"try{ save.modified();}catch(err){}");
    }

    public String getConfirmMessage(HxOp op) throws Exception {
        return null;
    }

    public final void handle(HxOp op) throws Exception {
        String formConfirm = op.getFormValue("saveConfirmed");
        if (formConfirm == null || formConfirm.equals("false")) {
            try {
                String confirm = this.getConfirmMessage(op);
                if (!this.dlg.isSubmit(op) && confirm != null) {
                    this.dlg.open(confirm, op);
                    return;
                }
            }
            catch (Exception e) {
                new ErrorDialog("Cannot Save", (Command)this, (Throwable)e).open(op);
                return;
            }
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"save.saved();");
        this.onHandle(op);
    }

    public abstract void onHandle(HxOp var1) throws Exception;

    public class SaveConfirmDialog
    extends ConfirmDialog {
        public SaveConfirmDialog(String title, Command handler) {
            super(title, handler);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            super.writeContent(op);
            SmartCommand.setFormValueOnLoad(op.scope("saveConfirmed"), "true", op);
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this), new ConfirmCancel()};
        }

        protected class ConfirmCancel
        extends Dialog.Cancel {
            public ConfirmCancel() {
                super((Dialog)SaveConfirmDialog.this);
            }

            public String getInvokeCode(HxOp op) {
                try {
                    String quote = HxUtil.getOuterQuote((HxOp)op);
                    return super.getInvokeCode(op) + SmartCommand.getInvokeCodeForSetFormValue(op.scope("saveConfirmed"), "false", quote, true, op);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.getInvokeCode(op);
                }
            }
        }
    }
}

