/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.FinishTableThread;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.util.Lexicon;

public class FinishTableCommand
extends Command {
    private static String SNOOP_PROTECTION = "/*>*/";

    public FinishTableCommand(BHxView view) {
        super(view);
    }

    public String getLoadInvokeCode(HxOp op) {
        String quote = HxUtil.getInnerQuote((HxOp)op);
        StringBuilder buf = new StringBuilder();
        buf.append("if(smartTable.checkLoading(hx.$(").append(quote).append(op.scope("loading"));
        buf.append(quote).append("), hx.$(").append(quote).append(op.scope("records"));
        buf.append(quote).append("))){");
        buf.append(this.getInvokeCode(op));
        buf.append("}");
        return buf.toString();
    }

    public String getInvokeCode(HxOp op) {
        return this.getInvokeCode(op, HxUtil.getInnerQuote((HxOp)op));
    }

    String getInvokeCode(HxOp op, String quote) {
        StringBuilder buf = new StringBuilder();
        buf.append("smartTable.startLoading(hx.$(").append(quote).append(op.scope("loading"));
        buf.append(quote).append("));");
        buf.append("hx.fireEvent(");
        buf.append(quote).append(op.getPath()).append(quote);
        buf.append(",");
        buf.append(quote).append(this.getId()).append(quote);
        buf.append(");");
        return buf.toString();
    }

    public void handle(HxOp op) throws Exception {
        String retry;
        BHxSmartTableView sView = null;
        BHxView view = this.getView();
        if (view instanceof BHxSmartTableView && !(sView = (BHxSmartTableView)view).isEnabled(op)) {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var loading = hx.$('").w((Object)op.scope("loading")).w((Object)"'); if(loading != null) loading.innerHTML='&nbsp;';");
            return;
        }
        FinishTableThread finishTableThread = null;
        if (sView != null && sView.supportsPagination(op) && !sView.supportsPaginatedQuery(op)) {
            finishTableThread = FinishTableThread.get(op, FinishTableThread.CACHE_ENTRY_MAX_SIZE);
        } else {
            FinishTableThread.remove(op);
        }
        TableContents contents = null;
        if (finishTableThread == null && sView != null) {
            try {
                finishTableThread = new FinishTableThread(sView, sView.supportsAutoRefresh(op) || sView.supportsPagination(op) && !sView.supportsPaginatedQuery(op));
                finishTableThread.startAndWait(op, this);
            }
            catch (Throwable e) {
                e.printStackTrace();
                op.getRequest().getSession().setAttribute(op.scope("finishTableException"), (Object)e);
                this.handleException(op);
                return;
            }
        }
        if ((retry = op.getFormValue("retry")) != null) {
            this.refresh(op);
            return;
        }
        if (finishTableThread != null || contents != null) {
            if (finishTableThread != null && finishTableThread.cachePage) {
                FinishTableThread.add(finishTableThread, op, true);
            }
            if (finishTableThread != null && finishTableThread.running) {
                if (!finishTableThread.started) {
                    finishTableThread.startAndWait(op, this);
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append("setTimeout('hx.fireEvent(\"");
                    buf.append(op.getPath());
                    buf.append("\",\"");
                    buf.append(this.getId());
                    buf.append("\");', 750);");
                    op.getHtmlWriter().w((Object)buf.toString());
                    return;
                }
            }
            if (finishTableThread != null) {
                contents = finishTableThread.contents;
            }
            if (contents != null) {
                TableContents data = contents;
                int fullContentSize = data.tr.size();
                if (sView != null) {
                    if (sView.supportsPagination(op)) {
                        int pageSize = sView.getPageSize(op);
                        sView.setPageCount(op, contents.getPageCount(pageSize));
                        sView.setRecordCount(op, contents.getRecordCount());
                        int page = sView.getPage(op);
                        if (sView.supportsPaginatedQuery(op)) {
                            page = 1;
                        }
                        data = data.getPage(page - 1, pageSize);
                    }
                    if (sView.supportsAutoRefresh(op)) {
                        int newHash = data.hashCode();
                        op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("tableContentHash", op), (Object)newHash);
                    }
                }
                this.writeContents(data, fullContentSize, op);
            } else {
                this.handleException(op);
            }
        }
    }

    public void handleException(HxOp op) throws Exception {
        Throwable e = (Throwable)op.getRequest().getSession().getAttribute(op.scope("finishTableException"));
        if (e != null) {
            String msg;
            boolean dialog = true;
            if (e instanceof OutOfMemoryError && (msg = e.getMessage()) != null && msg.startsWith("Query too large")) {
                e = new LocalizableRuntimeException("smartTableHx", "error.resultTooLarge", e);
                dialog = false;
            }
            if (e instanceof ServiceNotFoundException) {
                e = new LocalizableRuntimeException("smartTableHx", "error.serviceNotFound", new Object[]{e.getMessage()}, e);
                dialog = false;
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"function deleteTable(){");
            out.w((Object)"var table=document.getElementById('").w((Object)op.scope("records")).w((Object)"');");
            out.w((Object)"var tableLength = table.rows.length;");
            out.w((Object)"for(var i=1; i<tableLength; i++) ").w((Object)SNOOP_PROTECTION);
            out.w((Object)"  table.deleteRow(-1);");
            out.w((Object)"}deleteTable();");
            ErrorDialog errorDialog = new ErrorDialog("Error", (Command)this, e);
            if (dialog) {
                op.getRequest().getSession().removeAttribute(op.scope("finishTableException"));
                errorDialog.open(op);
            } else {
                out.w((Object)"smartTable.loadingException(hx.$('").w((Object)op.scope("loading")).w((Object)("'),\"" + HxTabUtil.safe(errorDialog.getMessage(op)) + "\");"));
            }
        }
    }

    public void writeContents(TableContents contents, int fullContentSize, HxOp op) throws Exception {
        if (this.getView() instanceof BHxSmartTableView) {
            contents = ((BHxSmartTableView)this.getView()).updateContents(contents, op);
        }
        boolean anySelected = false;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"function finishTable(){");
        out.w((Object)"var table=document.getElementById('").w((Object)op.scope("records")).w((Object)"');");
        out.w((Object)"if(table == null) return;");
        out.w((Object)"var loading=hx.$('").w((Object)op.scope("loading")).w((Object)"');");
        int maxResultSize = BHxSmartTableView.MAX_RESULT_SIZE;
        if (this.getView() instanceof BHxSmartTableView) {
            maxResultSize = ((BHxSmartTableView)this.getView()).getMaxResultSize((Context)op);
        }
        if (fullContentSize == maxResultSize || contents.warning != null) {
            String text = Lexicon.make(FinishTableCommand.class).getText("onlyTopWarning", new Object[]{BInteger.make((int)maxResultSize)});
            if (contents.warning != null) {
                text = contents.warning;
            }
            out.w((Object)"smartTable.warning(loading, '").w((Object)text).w((Object)"');");
        } else {
            out.w((Object)"loading.innerHTML='&nbsp;';");
            out.w((Object)"loading.className='';");
        }
        out.w((Object)"var unloaded = table.className.indexOf('loaded') == -1;");
        out.w((Object)"var tableBody = table.getElementsByTagName('tbody')[0];");
        out.w((Object)"var tableLength = table.rows.length;");
        out.w((Object)"for(var i=1; i<tableLength; i++) ").w((Object)SNOOP_PROTECTION);
        out.w((Object)"  table.deleteRow(-1);");
        out.w((Object)"var row;");
        out.w((Object)"var cell;");
        String className = "";
        if (contents.className != null) {
            className = contents.className;
        }
        out.w((Object)"table.className='smartTable-table ux-table ").w((Object)className).w((Object)" loaded';");
        String quote = HxUtil.getInnerQuote((HxOp)op);
        out.w((Object)("smartTable.unselectScope(" + quote + op.getPath() + quote + ");"));
        out.w((Object)"if(unloaded){smartTable.addClick(table); }");
        for (int i = 0; i < contents.tr.size(); ++i) {
            String cls = "ux-table-row";
            out.w((Object)"row=tableBody.appendChild(document.createElement('tr'));");
            TableContents.Tr tr = contents.tr.get(i);
            boolean selected = false;
            if (tr.className != null) {
                cls = cls + ' ' + tr.className;
                if (tr.className.contains("selected")) {
                    selected = true;
                }
            }
            out.w((Object)"row.id=\"").safe((Object)tr.id).w((Object)"\";");
            if (tr.hidden) {
                out.w((Object)"row.style.display='none';");
            }
            out.w((Object)("row.className='" + cls + "';"));
            int j = 0;
            while (j < tr.td.size()) {
                TableContents.Td td = tr.td.get(j);
                out.w((Object)"cell=row.insertCell(row.cells.length);");
                if (td.className != null) {
                    out.w((Object)"cell.className='");
                    out.w((Object)td.className);
                    if (td.additionalClassName != null) {
                        out.w((Object)" ").w((Object)td.additionalClassName);
                    }
                    out.w((Object)"';");
                    if (td.className.indexOf("selected") > -1) {
                        selected = true;
                    }
                } else {
                    out.w((Object)"cell.className='");
                    if (td.additionalClassName != null) {
                        out.w((Object)" ").w((Object)td.additionalClassName);
                    }
                    out.w((Object)"';");
                }
                int col = j++;
                TableContents sContents = contents;
                out.w((Object)"cell.innerHTML=\"");
                out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> {
                    HtmlWriter sOut = sOp.getHtmlWriter();
                    if (col == 0 && tr.icons != null) {
                        for (int k = 0; k < tr.icons.length; ++k) {
                            if (tr.icons[k] != null) {
                                if (sContents.iconHeight == -1) {
                                    HxUtil.makeImageJS((BImage)tr.icons[k], null, null, null, (HxOp)sOp);
                                } else {
                                    HxUtil.makeImageJS((BImage)tr.icons[k], (String)("height='" + sContents.iconHeight + "'"), null, null, (HxOp)sOp);
                                }
                            }
                            sOut.w((Object)"&nbsp;");
                        }
                    }
                    if (sContents.writeSafe) {
                        sOut.safe((Object)td.text);
                    } else {
                        sOut.w((Object)td.text);
                    }
                    if (td.text.length() == 0) {
                        sOut.w((Object)"&nbsp;");
                    }
                }, (HxOp)op)));
                out.w((Object)" \";");
            }
            if (!selected) continue;
            anySelected = true;
            out.w((Object)"smartTable.add(document.getElementById(\"").safe((Object)tr.id).w((Object)"\"));");
        }
        if (anySelected) {
            out.w((Object)"smartTable.setForm(smartTable.scope(table));");
        }
        out.w((Object)"hx.resizeCurrentDialog();");
        out.w((Object)contents.getOnload());
        out.w((Object)"}");
        out.w((Object)"finishTable();");
        HxUtil.addJavascriptOnload((HxOp)op);
    }
}

