/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import java.util.ArrayList;
import java.util.List;
import javax.baja.sys.BValue;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;

public class CommandBindings {
    private Support support = new Support(){

        @Override
        public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
            command.setEnabled(bindingBasedState);
        }
    };
    List<CommandPolicy> commands = new ArrayList<CommandPolicy>();
    Command doubleClickCommand = null;

    public void addCommand(Command command, BCommandEnablePolicy policy) {
        this.commands.add(new CommandPolicy(command, policy));
        command.setEnabled(policy == BCommandEnablePolicy.always);
    }

    public void setDoubleClickCommand(Command command) {
        this.doubleClickCommand = command;
    }

    public void setSupport(Support value) {
        this.support = value;
    }

    public Support getSupport() {
        return this.support;
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public Command[] getCommands() {
        Command[] result = new Command[this.getCommandCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getCommand(i);
        }
        return result;
    }

    public Command getCommand(int idx) {
        CommandPolicy cp = this.commands.get(idx);
        return cp.command;
    }

    public BCommandEnablePolicy getPolicy(int idx) {
        CommandPolicy cp = this.commands.get(idx);
        return cp.policy;
    }

    public void doubleClick() {
        if (this.doubleClickCommand != null && this.doubleClickCommand.isEnabled()) {
            this.doubleClickCommand.invoke();
        }
    }

    public void addMenuCommands(BMenu menu) {
        Command[] commands = this.getCommands();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].isEnabled()) continue;
            menu.add(null, (BValue)new BActionMenuItem(commands[i]), null);
        }
    }

    public void commandPopup(BWidget owner, double x, double y) {
        BMenu menu = new BMenu();
        boolean openMenu = false;
        Command[] commands = this.getCommands();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].isEnabled()) continue;
            menu.add(null, (BValue)new BActionMenuItem(commands[i]), null);
            openMenu = true;
        }
        if (openMenu) {
            menu.open(owner, x, y);
        }
    }

    public static class TreeTableController
    extends javax.baja.ui.treetable.TreeTableController {
        private CommandBindings bindings;

        public TreeTableController() {
            this.bindings = new CommandBindings();
        }

        public TreeTableController(CommandBindings pBindings) {
            this.bindings = pBindings;
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.bindings.doubleClick();
        }

        public CommandBindings getCommandBindings() {
            return this.bindings;
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            this.commandPopup(event.getX(), event.getY());
        }

        protected void backgroundPopup(BMouseEvent event) {
            this.commandPopup(event.getX(), event.getY());
        }

        protected void commandPopup(double x, double y) {
            this.bindings.commandPopup((BWidget)this.getTable(), x, y);
        }
    }

    public static class TreeTableSelection
    extends javax.baja.ui.treetable.TreeTableSelection {
        private CommandBindings bindings;

        public TreeTableSelection() {
            this.bindings = new CommandBindings();
        }

        public TreeTableSelection(CommandBindings pBindings) {
            this.bindings = pBindings;
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.setCommandEnabledStates();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.setCommandEnabledStates();
        }

        public void select(int[] rows) {
            super.select(rows);
            this.setCommandEnabledStates();
        }

        public void deselect(int row) {
            super.deselect(row);
            this.setCommandEnabledStates();
        }

        public void deselectAll() {
            super.deselectAll();
            this.setCommandEnabledStates();
        }

        public CommandBindings getCommandBindings() {
            return this.bindings;
        }

        public void setCommandEnabledStates() {
            int numRows = this.getRows().length;
            Command[] commands = this.bindings.getCommands();
            block8: for (int i = 0; i < commands.length; ++i) {
                switch (this.bindings.getPolicy(i).getOrdinal()) {
                    case 1: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numRows == 1);
                        continue block8;
                    }
                    case 2: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numRows == 2);
                        continue block8;
                    }
                    case 3: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numRows > 1);
                        continue block8;
                    }
                    case 4: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numRows > 0);
                        continue block8;
                    }
                    case 5: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], true);
                        continue block8;
                    }
                    case 0: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numRows == 0);
                        continue block8;
                    }
                    default: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], false);
                    }
                }
            }
        }
    }

    public static class TableController
    extends javax.baja.ui.table.TableController {
        private CommandBindings bindings;

        public TableController() {
            this.bindings = new CommandBindings();
        }

        public TableController(CommandBindings pBindings) {
            this.bindings = pBindings;
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.bindings.doubleClick();
        }

        public CommandBindings getCommandBindings() {
            return this.bindings;
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            this.commandPopup(event.getX(), event.getY());
        }

        protected void backgroundPopup(BMouseEvent event) {
            this.commandPopup(event.getX(), event.getY());
        }

        protected void commandPopup(double x, double y) {
            this.bindings.commandPopup((BWidget)this.getTable(), x, y);
        }
    }

    public static class TableSelection
    extends javax.baja.ui.table.TableSelection {
        private CommandBindings bindings;

        public TableSelection() {
            this.bindings = new CommandBindings();
        }

        public TableSelection(CommandBindings pBindings) {
            this.bindings = pBindings;
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.setCommandEnabledStates();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.setCommandEnabledStates();
        }

        public void select(int[] rows) {
            super.select(rows);
            this.setCommandEnabledStates();
        }

        public void deselect(int row) {
            super.deselect(row);
            this.setCommandEnabledStates();
        }

        public void deselectAll() {
            super.deselectAll();
            this.setCommandEnabledStates();
        }

        public CommandBindings getCommandBindings() {
            return this.bindings;
        }

        public void setCommandEnabledStates() {
            int[] rows = this.getRows();
            int numRows = rows != null ? rows.length : 0;
            Command[] commands = this.bindings.getCommands();
            for (int i = 0; i < commands.length; ++i) {
                this.setEnabled(commands[i], numRows, this.bindings.getPolicy(i));
            }
        }

        protected void setEnabled(Command command, int numRows, BCommandEnablePolicy policy) {
            switch (policy.getOrdinal()) {
                case 1: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, numRows == 1);
                    break;
                }
                case 2: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, numRows == 2);
                    break;
                }
                case 3: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, numRows > 1);
                    break;
                }
                case 4: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, numRows > 0);
                    break;
                }
                case 5: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, true);
                    break;
                }
                case 0: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, numRows == 0);
                    break;
                }
                default: {
                    this.bindings.getSupport().setBoundCommandEnabled(command, false);
                }
            }
        }
    }

    public static class ListSelection
    extends javax.baja.ui.list.ListSelection {
        private CommandBindings bindings;

        public ListSelection() {
            this.bindings = new CommandBindings();
        }

        public ListSelection(CommandBindings pBindings) {
            this.bindings = pBindings;
        }

        public CommandBindings getCommandBindings() {
            return this.bindings;
        }

        public void setCommandEnabledStates() {
            int numItems = this.getItems().length;
            Command[] commands = this.bindings.getCommands();
            block8: for (int i = 0; i < commands.length; ++i) {
                switch (this.bindings.getPolicy(i).getOrdinal()) {
                    case 1: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numItems == 1);
                        continue block8;
                    }
                    case 2: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numItems == 2);
                        continue block8;
                    }
                    case 3: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numItems > 1);
                        continue block8;
                    }
                    case 4: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numItems > 0);
                        continue block8;
                    }
                    case 5: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], true);
                        continue block8;
                    }
                    case 0: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], numItems == 0);
                        continue block8;
                    }
                    default: {
                        this.bindings.getSupport().setBoundCommandEnabled(commands[i], false);
                    }
                }
            }
        }

        public void select(int index, boolean clear) {
            super.select(index, clear);
            this.setCommandEnabledStates();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.setCommandEnabledStates();
        }

        public void select(int[] indices) {
            super.select(indices);
            this.setCommandEnabledStates();
        }

        public void deselect(int index) {
            super.deselect(index);
            this.setCommandEnabledStates();
        }

        public void deselectAll() {
            super.deselectAll();
            this.setCommandEnabledStates();
        }
    }

    public static class ListController
    extends javax.baja.ui.list.ListController {
        private CommandBindings bindings;

        public ListController(CommandBindings bindings) {
            this.bindings = bindings;
        }

        protected void itemDoubleClicked(BMouseEvent event, int index) {
            this.bindings.doubleClick();
        }

        protected void itemPopup(BMouseEvent event, int index) {
            this.bindings.commandPopup((BWidget)this.getList(), event.getX(), event.getY());
        }

        protected void backgroundPopup(BMouseEvent event) {
            this.bindings.commandPopup((BWidget)this.getList(), event.getX(), event.getY());
        }
    }

    private class CommandPolicy {
        public Command command;
        public BCommandEnablePolicy policy;

        public CommandPolicy(Command pCommand, BCommandEnablePolicy pPolicy) {
            this.command = pCommand;
            this.policy = pPolicy;
        }
    }

    public static interface Support {
        public void setBoundCommandEnabled(Command var1, boolean var2);
    }
}

