/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.hx.util.HxUtils;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.FinishTableCommand;
import com.tridium.smartTableHx.FinishTableThread;
import com.tridium.smartTableHx.IFinishableTable;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.export.ExportCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

@NiagaraType
public abstract class BHxSmartTableView
extends BHxView
implements IFinishableTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSmartTableView.class);
    static int DEFAULT_PAGE_START = 1;
    static int DEFAULT_PAGE_COUNT = 1;
    public static final String FINISH_LATER = "finishLater";
    public static final String HEIGHT = "height";
    public static final String FIX_COMMAND_EVENT = "fixCommandEvent";
    @Deprecated
    public static final String MANY = SmartCommand.smartTableHxLex.getText("many");
    public static final String EXPORT_TABLE = "exportTable";
    public static final LexiconModule LEX = LexiconModule.make(BHxSmartTableView.class);
    public static final BFacets finishLater = BFacets.make((String)"finishLater", (boolean)true);
    public static final BFacets exportTableFacets = BFacets.make((String)"exportTable", (boolean)true);
    protected FinishTableCommand finishTableCommand = new FinishTableCommand(this);
    protected StopTableCommand stopTableCommand;
    AutoRefreshCommand autoRefreshCommand;
    protected SmartCommand pageCommand;
    protected SmartCommand nextPageCommand;
    protected SmartCommand prevPageCommand;
    protected ExportCommand exportCommand;
    protected SmartCommand pageCountCommand;
    public static final int MAX_RESULT_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.query.maxResultSize", 5000));
    public static final int MAX_PAGE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.query.maxPageSize", 5000));
    public static final int MAX_EXPORT_RESULT_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.query.maxExportResultSize", Nre.getHostModel().equals("Workstation") ? 25000 : 5000));

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSmartTableView() {
        this.registerEvent((Event)this.finishTableCommand);
        this.autoRefreshCommand = new AutoRefreshCommand(this);
        this.registerEvent((Event)this.autoRefreshCommand);
        this.pageCommand = new PageCommand(this);
        this.registerEvent((Event)this.pageCommand);
        this.nextPageCommand = new NextPageCommand(this);
        this.registerEvent((Event)this.nextPageCommand);
        this.prevPageCommand = new PrevPageCommand(this);
        this.registerEvent((Event)this.prevPageCommand);
        this.exportCommand = new ExportCommand(this);
        this.registerEvent((Event)this.exportCommand);
        this.stopTableCommand = new StopTableCommand(this);
        this.registerEvent((Event)this.stopTableCommand);
        this.pageCountCommand = new PageCountCommand(this);
        this.registerEvent((Event)this.pageCountCommand);
    }

    public void writeResources(HxOp op) {
        op.jQuery();
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        String themeName = (String)op.getRequest().getSession().getAttribute("themeName");
        if (themeName != null) {
            op.addStyleSheet(BOrd.make((String)("module://theme" + themeName + "/ux/theme.css")));
        }
    }

    public void write(HxOp op) throws Exception {
        if (op.getFacets().get(HEIGHT) != null) {
            this.dialogWrite(op);
            return;
        }
        if (this.supportsAutoRefresh(op) || this.supportsPagination(op)) {
            op.setDynamic();
        }
        HtmlWriter out = op.getHtmlWriter();
        this.writeResources(op);
        this.writeCommands(op);
        out.w((Object)"<table ");
        out.attr("id", op.scope("records"));
        out.attr(" name", op.scope("records"));
        out.attr(" class", "smartTable-table ux-table");
        out.w((Object)">");
        out.w((Object)"<thead class='ux-table-head'>");
        out.w((Object)"<tr>");
        this.writeTableHeader(op);
        out.w((Object)"</tr>");
        out.w((Object)"</thead>");
        out.w((Object)"<tbody></tbody>");
        out.w((Object)"</table>");
        this.loadTable(op);
    }

    public boolean isEnabled(HxOp op) {
        return true;
    }

    public boolean requiresFinishing(HxOp op) {
        boolean finishLater = op.getFacets().getb(FINISH_LATER, false);
        return finishLater;
    }

    public boolean supportsPagination(HxOp op) {
        return false;
    }

    public boolean supportsPaginatedQuery(HxOp op) {
        return false;
    }

    public int minimumPageSize(HxOp op) {
        return 20;
    }

    public int defaultPageSize(HxOp op) {
        return 20;
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return false;
    }

    public boolean defaultAutoRefresh(HxOp op) {
        return false;
    }

    public boolean getAutoRefresh(HxOp op) {
        Boolean lastSelection = (Boolean)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("lastAutoRefreshState", op));
        if (lastSelection != null) {
            return lastSelection;
        }
        return this.defaultAutoRefresh(op);
    }

    public void dialogWrite(HxOp op) throws Exception {
        if (this.supportsAutoRefresh(op) || this.supportsPagination(op)) {
            op.setDynamic();
        }
        HtmlWriter out = op.getHtmlWriter();
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        this.writeCommands(op);
        int height = op.getFacets().geti(HEIGHT, 365);
        out.w((Object)"<div style='overflow: auto; height: ").w(height).w((Object)"px;'>");
        out.w((Object)"<table ");
        out.attr("id", op.scope("records"));
        out.attr(" name", op.scope("records"));
        out.attr(" class", "smartTable-table ux-table");
        out.w((Object)">");
        out.w((Object)"<thead class = 'ux-table-head'>");
        this.writeTableHeader(op);
        out.w((Object)"</thead>");
        out.w((Object)"<tbody></tbody>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        this.loadTable(op);
    }

    public void loadTable(HxOp op) throws Exception {
        FinishTableThread finishTableThread = this.makeTableThread(false, op);
        if (finishTableThread == null) {
            return;
        }
        op.addOnload(this.finishTableCommand.getInvokeCode(op));
    }

    public String getFinishInvokeCode(HxOp op) {
        return this.finishTableCommand.getLoadInvokeCode(op);
    }

    public void reloadTable(HxOp op) throws Exception {
        this.killThread(op);
        if (this.supportsPaginatedQuery(op)) {
            this.resetPageCountForQuery(op);
        }
        op.getRequest().getSession().removeAttribute(SmartCommand.scopeWithOrd("tableContentPage", op));
        SmartCommand.setFormValue(op.scope("smartTablePage"), "1", op);
        FinishTableThread finishTableThread = this.makeTableThread(true, op);
        if (finishTableThread == null) {
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)this.finishTableCommand.getInvokeCode(op));
    }

    public FinishTableThread makeTableThread(boolean reloading, HxOp op) {
        op.getRequest().getSession().removeAttribute(SmartCommand.scopeWithOrd("paused", op));
        if (!reloading) {
            this.killThread(op);
        }
        if (!this.isEnabled(op)) {
            return null;
        }
        if (!reloading && this.requiresFinishing(op)) {
            FinishTableThread.remove(op);
            return null;
        }
        FinishTableThread finishTableThread = new FinishTableThread(this, this.supportsAutoRefresh(op) || this.supportsPagination(op) && !this.supportsPaginatedQuery(op));
        FinishTableThread.add(finishTableThread, op);
        return finishTableThread;
    }

    public static void writeFormValue(String name, String value, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("style", "display: none");
        out.attr(" type", "text");
        out.attr(" id", op.scope(name));
        out.attr(" name", op.scope(name));
        out.attr(" value", value);
        out.w((Object)"/>");
    }

    public static void writeUnscopedFormValue(String name, String value, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("style", "display: none");
        out.attr(" type", "text");
        out.attr(" id", name);
        out.attr(" name", name);
        out.attr(" value", value);
        out.w((Object)"/>");
    }

    public static void writePagination(BHxSmartTableView view, HxOp op, SmartCommand pageCmd, SmartCommand nextCmd, SmartCommand prevCmd, SmartCommand pageSizeCmd) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Lexicon lex = op.getLexicon(Sys.getModuleForClass(BHxSmartTableView.class).getModuleName());
        out.w((Object)"<table><tr>");
        out.w((Object)"<td>");
        HxTabUtil.writeCommand(prevCmd, false, op);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        HxTabUtil.writeCommand(nextCmd, false, op);
        out.w((Object)"</td>");
        out.w((Object)"<td ");
        out.w((Object)" style='cursor: n-resize'");
        out.w((Object)" onmouseover ='smartTable.registerMouseWheel(this, &quot;").w((Object)op.getPath()).w((Object)"&quot;);'");
        out.w((Object)">");
        out.safe((Object)lex.getText("pagination.page.label"));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        view.writePageInput(op, pageCmd);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        out.safe((Object)lex.getText("pagination.of"));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        view.writePageCountInput(op);
        out.w((Object)"</td>");
        out.w((Object)"<td>&nbsp;&nbsp;&nbsp;&nbsp;").w((Object)"</td>");
        out.w((Object)"<td>");
        out.safe((Object)lex.getText("pagination.pageSize"));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        view.writePageSizeInput(op, pageSizeCmd);
        out.w((Object)"</td>");
        out.w((Object)"</tr></table>");
    }

    public void writeCommands(HxOp op) throws Exception {
        String pageTitle = this.getPageTitle(op);
        SmartCommand[] commands = this.getButtonCommands(op);
        BHxSmartTableView.writeCommands(pageTitle, commands, !this.requiresFinishing(op) && this.isEnabled(op), op, this, this.supportsAutoRefresh(op), this.autoRefreshCommand, this.supportsPagination(op), this.pageCommand, this.nextPageCommand, this.prevPageCommand, this.pageCommand, this.stopTableCommand);
    }

    public static void writeCommands(SmartCommand[] commands, HxOp op) throws Exception {
        BHxSmartTableView.writeCommands(null, commands, false, op, null, false, null, false, null, null, null, null, null);
    }

    public static void writeCommands(String title, SmartCommand[] commands, boolean enabled, HxOp op) throws Exception {
        BHxSmartTableView.writeCommands(title, commands, enabled, op, null, false, null, false, null, null, null, null, null);
    }

    public static void writeCommands(String title, SmartCommand[] commands, boolean enabled, HxOp op, BHxSmartTableView view, boolean supportsAutoRefresh, SmartCommand autoRefreshCommand, boolean supportsPagination, SmartCommand pageCmd, SmartCommand nextPageCmd, SmartCommand prevPageCmd, SmartCommand pageSizeCmd, SmartCommand stopTableCommand) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String spacerWidth = "222px";
        if (!(title != null && title.length() != 0 || commands.length != 0 || supportsPagination || supportsAutoRefresh)) {
            out.w((Object)"<table ");
            if (!BHxTabbedView.hasTitle(op)) {
                out.attr("style", "display: none;");
            }
            out.w((Object)"><tr>");
            out.w((Object)("<td style='width: " + spacerWidth + "'>"));
            out.w((Object)"<span ");
            out.attr(" id", op.scope("loading"));
            out.attr(" name", op.scope("loading"));
            if (stopTableCommand != null) {
                out.attr(" class", "smartTable-loading");
                out.w((Object)" onmousedown='").w((Object)stopTableCommand.getEnabledInvokeCode(op)).w((Object)"'");
            }
            out.w((Object)">");
            if (enabled) {
                out.w((Object)"Loading.");
            }
            out.w((Object)"</span>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            BHxSmartTableView.writeFormValue("selectionCount", "0", op);
            BHxSmartTableView.writeFormValue("selectionList", "", op);
            BHxSmartTableView.writeFormValue("working", "", op);
            return;
        }
        out.w((Object)"<div ");
        out.attr("class", "smartTable-setup-panel").w((Object)">");
        out.w((Object)"<table ");
        out.w((Object)"style='");
        if (!BHxTabbedView.hasTitle(op)) {
            out.w((Object)"display: none;");
        }
        out.w((Object)"'><tr>");
        if (title != null) {
            out.w((Object)"<td style='white-space: nowrap'>");
            if (op.getPath().equals("")) {
                HxTabUtil.writeTitle(title, op);
            } else {
                HxTabUtil.writeHeader(title, op);
            }
            out.w((Object)"</td>");
        }
        ArrayList<SmartCommand> tableCommands = new ArrayList<SmartCommand>();
        ArrayList<SmartCommand> recordCommands = new ArrayList<SmartCommand>();
        if (supportsAutoRefresh) {
            tableCommands.add(autoRefreshCommand);
        }
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].isTableCommand(op)) {
                tableCommands.add(commands[i]);
                continue;
            }
            recordCommands.add(commands[i]);
        }
        out.w((Object)"</tr></table>");
        BHxSmartTableView.writeFormValue("selectionCount", "0", op);
        BHxSmartTableView.writeFormValue("selectionList", "", op);
        BHxSmartTableView.writeFormValue("working", "", op);
        out.w((Object)"<table class='smartTable-command-table'><tr><td class='smartTable-command-td'>");
        HxTabUtil.writeCommands(recordCommands.toArray(new SmartCommand[0]), false, op);
        out.w((Object)"</td><td class='smartTable-tableCommands-td'>");
        HxTabUtil.writeCommands(tableCommands.toArray(new SmartCommand[0]), false, op);
        out.w((Object)"</td>");
        out.w((Object)("<td style='width: " + spacerWidth + "'>"));
        out.w((Object)"<span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>");
        out.w((Object)"<span ");
        out.attr(" id", op.scope("loading"));
        out.attr(" name", op.scope("loading"));
        if (stopTableCommand != null) {
            out.attr(" class", "smartTable-loading");
            out.w((Object)" onmousedown='").w((Object)stopTableCommand.getEnabledInvokeCode(op)).w((Object)"'");
        }
        out.w((Object)">");
        if (enabled) {
            out.w((Object)"Loading.");
        }
        out.w((Object)"</span>");
        out.w((Object)"</td>");
        out.w((Object)"<td class='smartTable-command-pagination'>");
        if (supportsPagination) {
            out.w((Object)"<div align='left' class='smartTable-command-pagination-div' style='display: none;'");
            out.attr(" id", op.scope("paginationBar"));
            out.attr(" name", op.scope("paginationBar"));
            out.w((Object)">");
            BHxSmartTableView.writePagination(view, op, pageCmd, nextPageCmd, prevPageCmd, pageSizeCmd);
            out.w((Object)"</div>");
        }
        out.w((Object)"</td>");
        out.w((Object)"</tr></table>");
        out.w((Object)"</div>");
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[0];
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        SmartCommand[] commands = this.getButtonCommands(op);
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].process(op)) continue;
            return true;
        }
        return false;
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        SmartCommand[] commands = this.getButtonCommands(op);
        for (int i = 0; i < commands.length; ++i) {
            commands[i].update(op);
        }
        if (op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("paused", op)) != null) {
            return;
        }
        if (!this.getAutoRefresh(op)) {
            if (this.supportsPagination(op)) {
                FinishTableThread.get(op);
            }
            return;
        }
        FinishTableThread finishTableThread = FinishTableThread.get(op);
        if (finishTableThread == null) {
            finishTableThread = this.makeTableThread(true, op);
            if (finishTableThread != null) {
                finishTableThread.startAndWait(op, this.finishTableCommand);
            }
        } else {
            if (finishTableThread.paused) {
                return;
            }
            if (!finishTableThread.running) {
                TableContents contents = finishTableThread.contents;
                if (contents != null) {
                    TableContents data = contents;
                    if (this.supportsPagination(op)) {
                        int pageSize = this.getPageSize(op);
                        this.setPageCount(op, contents.getPageCount(pageSize));
                        this.setRecordCount(op, contents.getRecordCount());
                        int page = this.getPage(op);
                        data = data.getPage(page - 1, pageSize);
                    }
                    Integer hash = (Integer)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("tableContentHash", op));
                    int newHash = data.hashCode();
                    if (hash == null || hash != newHash) {
                        HtmlWriter out = op.getHtmlWriter();
                        out.w((Object)this.finishTableCommand.getInvokeCode(op));
                        return;
                    }
                }
                if ((finishTableThread = this.makeTableThread(true, op)) != null) {
                    finishTableThread.startAndWait(op, this.finishTableCommand);
                }
            }
        }
    }

    public abstract void writeTableHeader(HxOp var1) throws Exception;

    @Override
    public abstract TableContents writeContents(HxOp var1) throws Exception;

    public TableContents updateContents(TableContents contents, HxOp op) throws Exception {
        return contents;
    }

    public boolean scopeRowIds(HxOp op) {
        return false;
    }

    public static String scopeId(String id, HxOp op) {
        return op.getPath() + "~" + id;
    }

    public static String unscopeId(String id) {
        String[] split = TextUtil.split((String)id, (char)'~');
        return split[split.length - 1];
    }

    public String unscopeId(String id, HxOp op) {
        if (this.scopeRowIds(op)) {
            return BHxSmartTableView.unscopeId(id);
        }
        return id;
    }

    public TableContents writeRows(BITable<?> table, HxOp op) {
        TableContents contents = new TableContents(op.scope("records"));
        TableCursor c = table.cursor();
        Column[] columns = table.getColumns().list();
        for (int j = 0; j < columns.length; ++j) {
            contents.columns.td.add(new TableContents.Td(columns[j].getDisplayName((Context)op)));
        }
        int i = 0;
        while (c.next()) {
            TableContents.Tr tr = new TableContents.Tr();
            Object o = c.get();
            if (o instanceof BIProtected && !((BIProtected)o).getPermissions((Context)op).has(BPermissions.operatorRead)) continue;
            tr.id = this.scopeRowIds(op) ? BHxSmartTableView.scopeId("" + i, op) : "" + i;
            for (int k = 0; k < columns.length; ++k) {
                tr.td.add(new TableContents.Td(c.cell(columns[k]).toString()));
            }
            contents.tr.add(tr);
            ++i;
        }
        return contents;
    }

    public String getPageTitle(HxOp op) throws Exception {
        if (op.getPath().equals("")) {
            return super.getPageTitle(op);
        }
        return "";
    }

    public static BFacets makeHeightFacets(int height) {
        return BFacets.make((String)HEIGHT, (int)height);
    }

    public void killThread(HxOp op) {
        FinishTableThread thread = FinishTableThread.get(op);
        if (thread != null && thread.started && thread.running) {
            thread.kill();
        }
    }

    public String calculatePageCountForQuery(HxOp op) throws Exception {
        return BHxSmartTableView.getManyText(op);
    }

    public String getPageCountForQuery(HxOp op) throws Exception {
        String sessionValue = (String)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("smartTablePageCount", op));
        if (sessionValue == null) {
            return BHxSmartTableView.getManyText(op);
        }
        return sessionValue;
    }

    public void resetPageCountForQuery(HxOp op) throws Exception {
        op.getRequest().getSession().removeAttribute(SmartCommand.scopeWithOrd("smartTablePageCount", op));
    }

    public boolean knownPageCount(HxOp op) throws Exception {
        return !this.supportsPaginatedQuery(op) || !this.getPageCountForQuery(op).equals(BHxSmartTableView.getManyText(op));
    }

    public void writePageInput(HxOp op, Command pageCmd) throws Exception {
        op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("tableContentPage", op), (Object)DEFAULT_PAGE_START);
        HtmlWriter out = op.getHtmlWriter();
        String key = op.scope("smartTablePage");
        out.w((Object)"<input type='text' size='6' width='6' noSave='true' style='text-align: right'");
        out.w((Object)" name='").safe((Object)key).w((Object)"'");
        out.w((Object)" id='").safe((Object)key).w((Object)"'");
        String invokeCode = pageCmd.getInvokeCode(op);
        out.w((Object)" onchange='").w((Object)invokeCode).w((Object)"'");
        out.w((Object)" onKeyPress='if(smartTable.onEnter(event) == true){").w((Object)invokeCode).w((Object)"}'");
        out.w((Object)" value='").safe((Object)Integer.toString(this.getPage(op))).w((Object)"'/>");
        op.addGlobal("hx.addFormElementToPoll('" + key + "');");
    }

    public int getPage(HxOp op) {
        Integer pVal = (Integer)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("tableContentPage", op));
        if (pVal != null) {
            return pVal;
        }
        return DEFAULT_PAGE_START;
    }

    public void setPage(HxOp op, int page) throws Exception {
        if (page < DEFAULT_PAGE_START) {
            page = DEFAULT_PAGE_START;
        }
        op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("tableContentPage", op), (Object)page);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("smartTablePage")).w((Object)"');");
        out.w((Object)"if(elem != null){");
        out.w((Object)"elem.value = '");
        out.w((Object)Integer.toString(page));
        out.w((Object)"';}");
        out.w((Object)"elem = document.getElementById('").w((Object)op.scope("pagination.prevPage")).w((Object)"');");
        out.w((Object)"if(elem != null){");
        out.w((Object)"elem.className = '");
        if (page <= DEFAULT_PAGE_START) {
            out.w((Object)"ux-btn-tb ux-disabled'; elem.setAttribute('disabled', 'disabled');};");
        } else {
            out.w((Object)"ux-btn-tb';elem.removeAttribute('disabled');};");
        }
        out.w((Object)"elem = document.getElementById('").safe((Object)op.scope("pagination.nextPage")).w((Object)"');");
        out.w((Object)"if(elem != null){");
        out.w((Object)"elem.className = '");
        if (page >= this.getPageCount(op) && !this.supportsPaginatedQuery(op)) {
            out.w((Object)"ux-btn-tb ux-disabled'; elem.setAttribute('disabled', 'disabled');};");
        } else {
            out.w((Object)"ux-btn-tb';elem.removeAttribute('disabled');};");
        }
    }

    public void writePageSizeInput(HxOp op, Command pageSizeCmd) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String key = op.scope("smartTablePageSize");
        out.w((Object)"<input type='text' size='2' width='2' noSave='true' style='text-align: right'");
        out.w((Object)" name='").w((Object)key).w((Object)"'");
        out.w((Object)" id='").w((Object)key).w((Object)"'");
        String invokeCode = pageSizeCmd.getInvokeCode(op);
        out.w((Object)" onchange='").w((Object)invokeCode).w((Object)"'");
        out.w((Object)" onKeyPress='if(smartTable.onEnter(event) == true){").w((Object)invokeCode).w((Object)"}'");
        out.w((Object)" value='").w((Object)Integer.toString(this.getPageSize(op))).w((Object)"'/>");
    }

    public int getPageSize(HxOp op) {
        Integer pVal = (Integer)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("tableContentPageSize", op));
        if (pVal != null) {
            return pVal;
        }
        return this.defaultPageSize(op);
    }

    public void setPageSize(HxOp op, int pageSize) throws Exception {
        if (pageSize < 1) {
            pageSize = 1;
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("smartTablePageSize")).w((Object)"');");
            out.w((Object)"elem.value = '");
            out.w((Object)Integer.toString(pageSize));
            out.w((Object)"';");
        }
        if (pageSize > this.getMaxPageSize((Context)op)) {
            throw new IllegalStateException("Page Limit is too high: " + pageSize + " > " + this.getMaxPageSize((Context)op));
        }
        op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("tableContentPageSize", op), (Object)pageSize);
    }

    public void writePageCountInput(HxOp op) throws Exception {
        if (this.supportsPaginatedQuery(op)) {
            this.resetPageCountForQuery(op);
        }
        HtmlWriter out = op.getHtmlWriter();
        String key = op.scope("smartTablePageCount");
        out.w((Object)"<input type='text' size='6' width='6' style='border-style:none; background-color:transparent; -moz-user-select:none;'");
        out.attr(" class", "smartTable-pageCount");
        out.w((Object)" name='").w((Object)key).w((Object)"' ");
        out.w((Object)" id='").w((Object)key).w((Object)"' ");
        out.attr("readonly", "readonly");
        if (this.supportsPaginatedQuery(op)) {
            out.w((Object)" value='").safe((Object)BHxSmartTableView.getManyText(op)).w((Object)"'");
            String quote = HxUtil.getOuterQuote((HxOp)op);
            out.w((Object)(" onClick='this.className=" + quote + "smartTable-pageCount-disabled" + quote + ";")).w((Object)this.pageCountCommand.getEnabledInvokeCode(op)).w((Object)"'");
            out.w((Object)" onmousedown='return smartTable.disableSelection(event);'");
            out.w((Object)"/>");
        } else {
            out.w((Object)" value='").w((Object)Integer.toString(DEFAULT_PAGE_COUNT)).w((Object)"'/>");
        }
        op.addGlobal("hx.addFormElementToPoll('" + key + "');");
    }

    public int getPageCount(HxOp op) {
        Integer pVal = (Integer)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("tableContentPageCount", op));
        if (this.supportsPaginatedQuery(op)) {
            try {
                String sessionText = this.getPageCountForQuery(op);
                if (!sessionText.equals(BHxSmartTableView.getManyText(op))) {
                    return Integer.parseInt(sessionText);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pVal != null) {
            return pVal;
        }
        return DEFAULT_PAGE_COUNT;
    }

    public void setPageCount(HxOp op, int pageCount) throws Exception {
        boolean knownPageCount = this.knownPageCount(op);
        if (this.supportsPaginatedQuery(op) && knownPageCount) {
            pageCount = this.getPageCount(op);
        }
        if (pageCount < DEFAULT_PAGE_COUNT && knownPageCount) {
            pageCount = DEFAULT_PAGE_COUNT;
        }
        op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("tableContentPageCount", op), (Object)pageCount);
        HtmlWriter out = op.getHtmlWriter();
        int page = this.getPage(op);
        if (pageCount < page && knownPageCount) {
            this.setPage(op, pageCount);
        } else if (knownPageCount) {
            out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("pagination.prevPage")).w((Object)"');");
            out.w((Object)"if(elem != null){");
            out.w((Object)"elem.className = '");
            if (page <= DEFAULT_PAGE_START) {
                out.w((Object)"ux-btn-tb ux-disabled'; elem.setAttribute('disabled', 'disabled');};");
            } else {
                out.w((Object)"ux-btn-tb';elem.removeAttribute('disabled');};");
            }
            out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("pagination.nextPage")).w((Object)"');");
            out.w((Object)"if(elem != null){");
            out.w((Object)"elem.className = '");
            if (page >= pageCount && !this.supportsPaginatedQuery(op)) {
                out.w((Object)"ux-btn-tb ux-disabled'; elem.setAttribute('disabled', 'disabled');};");
            } else {
                out.w((Object)"ux-btn-tb';elem.removeAttribute('disabled');};");
            }
        }
        out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("smartTablePageCount")).w((Object)"');");
        out.w((Object)"if(elem != null){");
        out.w((Object)"elem.value = '");
        if (this.supportsPaginatedQuery(op)) {
            out.w((Object)this.getPageCountForQuery(op));
        } else {
            out.w((Object)Integer.toString(pageCount));
        }
        out.w((Object)"';}");
    }

    public int getRecordCount(HxOp op) {
        Integer pVal = (Integer)op.getRequest().getSession().getAttribute(SmartCommand.scopeWithOrd("tableContentRecCount", op));
        if (pVal != null) {
            return pVal;
        }
        return 0;
    }

    public void setRecordCount(HxOp op, int recCount) throws Exception {
        if (recCount < 0) {
            recCount = 0;
        }
        op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("tableContentRecCount", op), (Object)recCount);
        int threshold = Math.min(this.minimumPageSize(op), this.getPageSize(op));
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("paginationBar")).w((Object)"');");
        out.w((Object)"if(elem != null){");
        out.w((Object)"elem.style.display='");
        boolean display = recCount >= threshold && this.isEnabled(op) || this.getPage(op) > 1;
        out.safe((Object)(display ? "" : "none")).w((Object)"';}");
    }

    public static String getManyText(HxOp op) {
        return SmartCommand.smartTableHxLexModule.getHtmlSafeText("many", (Context)op);
    }

    public int getMaxResultSize(Context cx) {
        if (cx.getFacets().getb(EXPORT_TABLE, false)) {
            return MAX_EXPORT_RESULT_SIZE;
        }
        return MAX_RESULT_SIZE;
    }

    public int getMaxPageSize(Context cx) {
        if (cx.getFacets().getb(EXPORT_TABLE, false)) {
            return MAX_EXPORT_RESULT_SIZE;
        }
        return MAX_PAGE_SIZE;
    }

    public class PageCountCommand
    extends SmartCommand {
        public PageCountCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "pageCountCommand";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            String key = op.scope("smartTablePageCount");
            HtmlWriter out = op.getHtmlWriter();
            String calculatedCount = BHxSmartTableView.this.calculatePageCountForQuery(op);
            op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("smartTablePageCount", op), (Object)calculatedCount);
            out.w((Object)"var elem=smartTable.$$('").w((Object)key).w((Object)"'); elem.value='").w((Object)calculatedCount).w((Object)"';");
            out.w((Object)"elem.className='smartTable-pageCount';");
        }
    }

    static class PrevPageCommand
    extends SmartCommand {
        public PrevPageCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "pagination.prevPage";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        @Override
        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            BHxSmartTableView sView = (BHxSmartTableView)this.getView();
            int page = sView.getPage(op) - 1;
            sView.setPage(op, page);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)sView.finishTableCommand.getInvokeCode(op));
        }
    }

    static class NextPageCommand
    extends SmartCommand {
        public NextPageCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "pagination.nextPage";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public boolean isDefaultAction() {
            return false;
        }

        @Override
        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BHxSmartTableView sView = (BHxSmartTableView)this.getView();
            int page = sView.getPage(op) + 1;
            int pageCount = sView.getPageCount(op);
            if (sView.knownPageCount(op) && page > pageCount) {
                page = pageCount;
            }
            sView.setPage(op, page);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)sView.finishTableCommand.getInvokeCode(op));
        }
    }

    static class PageCommand
    extends SmartCommand {
        public PageCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "pagination.page";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            BHxSmartTableView sView = (BHxSmartTableView)this.getView();
            int pageSize = sView.defaultPageSize(op);
            try {
                pageSize = Integer.parseInt(op.getFormValue("smartTablePageSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int sessionPageSize = sView.getPageSize(op);
            boolean supportsPaginatedQuery = sView.supportsPaginatedQuery(op);
            boolean resetPageNumber = false;
            if (sessionPageSize != pageSize) {
                if (supportsPaginatedQuery) {
                    sView.resetPageCountForQuery(op);
                }
                resetPageNumber = true;
            }
            sView.setPageSize(op, pageSize);
            int page = 1;
            try {
                page = Integer.parseInt(op.getFormValue("smartTablePage"));
                int pageCount = sView.getPageCount(op);
                if (page > pageCount && (!supportsPaginatedQuery || sView.knownPageCount(op))) {
                    page = pageCount;
                }
            }
            catch (Exception pageCount) {
                // empty catch block
            }
            if (resetPageNumber) {
                page = 1;
            }
            sView.setPage(op, page);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)sView.finishTableCommand.getInvokeCode(op));
        }
    }

    public class StopTableCommand
    extends SmartCommand {
        public StopTableCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "stopTable";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            FinishTableThread thread = FinishTableThread.get(op);
            if (thread != null && (thread.started || thread.killed) && thread.running) {
                op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("paused", op), (Object)"paused");
                thread.pause();
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"smartTable.pause(smartTable.$$('").w((Object)op.scope("loading")).w((Object)"'));");
                return;
            }
            BHxSmartTableView.this.reloadTable(op);
        }
    }

    public class AutoRefreshCommand
    extends ToggleCommand {
        public AutoRefreshCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "autoRefresh";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        @Override
        public boolean isTableCommand(HxOp op) {
            return true;
        }

        @Override
        public boolean isSelected(HxOp op) {
            return BHxSmartTableView.this.getAutoRefresh(op);
        }

        @Override
        public boolean handle(boolean selected, HxOp op) throws Exception {
            selected = !selected;
            op.getRequest().getSession().setAttribute(SmartCommand.scopeWithOrd("lastAutoRefreshState", op), (Object)selected);
            if (selected) {
                HxUtils.forceUpdate((HxOp)op);
            }
            return selected;
        }
    }
}

