/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.http;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.nre.util.ByteArrayUtil;

public class NHttpMessage
extends NMessage {
    private final Map<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    byte[] buf = null;
    private static final List<String> HEADERS_TO_REDACT = Collections.unmodifiableList(Arrays.asList("authorization", "cookie", "proxy-authorization"));

    public NHttpMessage(BIpAddress address) {
        super(address);
    }

    public void addHeader(String name, String value) {
        this.addHeader(name, value, true);
    }

    public void addHeader(String name, String value, boolean replace) {
        List values = this.headerMap.computeIfAbsent(name, key -> new ArrayList());
        if (replace) {
            values.clear();
        }
        values.add(value);
    }

    public Map<String, List<String>> getHeaderMap() {
        TreeMap<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<String>> entry : this.headerMap.entrySet()) {
            headerMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(headerMap);
    }

    public NVPair[] getHeaders() {
        NVPair[] headers = new NVPair[this.headerMap.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> entry : this.headerMap.entrySet()) {
            List<String> headerValues = entry.getValue();
            headers[i] = new NVPair(entry.getKey(), headerValues.get(headerValues.size() - 1));
            ++i;
        }
        return headers;
    }

    public List<String> getValues(String name) {
        List<String> values = this.headerMap.get(name);
        if (values == null) {
            return null;
        }
        return Collections.unmodifiableList(this.headerMap.get(name));
    }

    public String getValue(String name) {
        List<String> headerValues = this.headerMap.get(name);
        if (headerValues != null) {
            return headerValues.get(headerValues.size() - 1);
        }
        return null;
    }

    public byte[] getData() {
        return this.buf;
    }

    @Override
    public String toTraceString() {
        StringWriter sw = new StringWriter();
        StringBuffer sb = sw.getBuffer();
        for (Map.Entry<String, List<String>> entry : this.headerMap.entrySet()) {
            String name = entry.getKey();
            List<String> headerValues = entry.getValue();
            if (HEADERS_TO_REDACT.contains(name.toLowerCase(Locale.ENGLISH))) {
                sb.append(name).append(": ********").append('\n');
                continue;
            }
            for (String header : headerValues) {
                sb.append(name).append(": ").append(header).append('\n');
            }
        }
        if (this.buf != null && this.buf.length > 0) {
            ByteArrayUtil.hexDump((PrintWriter)new PrintWriter(sw), (byte[])this.buf, (int)0, (int)this.buf.length);
        }
        return sw.toString();
    }

    public static class NVPair {
        public String name;
        public String value;

        public NVPair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

