/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.driver.util.DrByteArrayUtil;
import java.io.IOException;
import java.io.InputStream;

public class DebugStream
extends InputStream {
    byte[] dat;
    int cnt = 0;
    InputStream in;
    private static final int MINIMUM_BUFFER_SIZE = 1024;

    public DebugStream(int maxLen) {
        if (maxLen < 1024) {
            maxLen = 1024;
        }
        this.dat = new byte[maxLen];
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n >= 0 && this.cnt < this.dat.length) {
            this.dat[this.cnt++] = (byte)n;
        }
        return n;
    }

    public InputStream reset(InputStream in) {
        this.in = in;
        this.cnt = 0;
        return this;
    }

    public boolean hasDebug() {
        return this.cnt > 0;
    }

    public String debugString() {
        return DrByteArrayUtil.toString((byte[])this.dat, (int)this.cnt);
    }
}

