/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.msg;

import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.IAddMessageData;
import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class NiagaraRemoteSendRolesHandler
implements IMessageBuilder,
IAddMessageData<List<String>> {
    private List<String> roles;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final String deviceUuid;
    private final String server;
    private static final Logger log = Logger.getLogger("cloudLink.channel.heartbeat.niagaraRemote");
    private static final String API_PATH = "/api/v1/remote/station-roles/";
    private static final String ROLES = "roles";

    public NiagaraRemoteSendRolesHandler(BChannelConfig channelConfig) {
        BFederatedIdentityAuthenticator authenticator = (BFederatedIdentityAuthenticator)channelConfig.getAuthenticator("niagaraRemoteSendHeartbeat");
        this.server = authenticator.getRegistrationHost();
        this.deviceUuid = authenticator.getSystemId();
        HashMap encoderProps = new HashMap();
        AccessController.doPrivileged(() -> {
            authenticator.addMessageHandlerProperties(null, null, encoderProps);
            return null;
        });
        this.certAliasAndPass = (BCertificateAliasAndPassword)encoderProps.get("certAliasAndPassword");
    }

    public int add(List<String> value) {
        this.roles = value;
        return this.roles.isEmpty() ? 0 : 1;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(ROLES).array();
        this.roles.forEach(arg_0 -> ((JSONWriter)jsonSerializer).value(arg_0));
        jsonSerializer.endArray();
        jsonSerializer.endObject();
        stringWriter.flush();
        try {
            url = new URL("https://" + this.server + API_PATH + this.deviceUuid);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Forge bootstrap device authentication", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Niagara Remote roles message with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.PUT, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").body(stringWriter.getBuffer().toString()).certificateAliasAndPassword(this.certAliasAndPass).build();
    }
}

