/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.msg;

import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.ncs.remote.NiagaraRemoteConnection;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class NiagaraRemoteSendHeartbeatResult
implements SendHeartbeatResult {
    private final boolean success;
    private final List<NiagaraRemoteConnection> result;
    private String etag = null;
    private static final String ETAG_HEADER = "ETag";

    public NiagaraRemoteSendHeartbeatResult(HttpResponseMessage responseMessage) {
        if (responseMessage == null) {
            this.success = true;
            this.result = null;
            return;
        }
        if (responseMessage.getStatusCode() != 200) {
            this.success = false;
            this.result = null;
            return;
        }
        this.success = true;
        List etagHeaders = (List)responseMessage.getHeaders().get(ETAG_HEADER);
        if (etagHeaders != null) {
            this.etag = (String)etagHeaders.get(0);
        }
        this.result = new ArrayList<NiagaraRemoteConnection>();
        JSONObject response = new JSONObject(responseMessage.getBodyAsString());
        JSONArray connections = response.getJSONArray("connections");
        for (int i = 0; i < connections.length(); ++i) {
            JSONObject connection = connections.getJSONObject(i);
            String connectionType = connection.getString("connectionType");
            String toDeviceId = connection.getString("toDeviceId");
            this.result.add(new NiagaraRemoteConnection(connectionType, toDeviceId));
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Object getResult() {
        return this.result;
    }

    public List<NiagaraRemoteConnection> getConnections() {
        return this.result;
    }

    public String getEtag() {
        return this.etag;
    }
}

