/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.msg;

import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.ncs.msg.NiagaraRemoteSendHeartbeatResult;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.HttpStatusException;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class NiagaraRemoteSendHeartbeatHandler
implements ISendHeartbeatHandler {
    private final String deviceId;
    private final String host;
    private Map<String, Object> payloadProperties;
    private BCertificateAliasAndPassword certAliasAndPass;
    private static final Logger log = Logger.getLogger("cloudLink.channel.heartbeat");

    public NiagaraRemoteSendHeartbeatHandler(BChannelConfig channelConfig) {
        BFederatedIdentityAuthenticator authenticator = (BFederatedIdentityAuthenticator)channelConfig.getAuthenticator("niagaraRemoteSendHeartbeat");
        this.host = authenticator.getRegistrationHost();
        this.deviceId = authenticator.getSystemId();
    }

    public int add(Map<String, Object> value) {
        this.certAliasAndPass = (BCertificateAliasAndPassword)value.remove("certAliasAndPassword");
        this.payloadProperties = value;
        return 0;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url = null;
        try {
            url = new URI("https://" + this.host + "/api/v1/remote/device-connection" + '/' + "foxwss" + '/' + this.deviceId + '/' + "outbound").toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.log(Level.INFO, "Unable to build URL for Niagara Remote connection configuration request", log.isLoggable(Level.FINE) ? ex : null);
        }
        HttpRequestMessage msg = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.GET, url, this.payloadProperties).mimeType("application/json").certificateAliasAndPassword(this.certAliasAndPass).build();
        return msg;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<SendHeartbeatResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> reqFuture = new CompletableFuture<IMessageResponse>();
        reqFuture.whenComplete((resp, err) -> {
            if (err == null || NiagaraRemoteSendHeartbeatHandler.isNotModified(err)) {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    NiagaraRemoteSendHeartbeatResult result = new NiagaraRemoteSendHeartbeatResult(response);
                    channelFuture.complete(result);
                }
                catch (Exception exc) {
                    channelFuture.completeExceptionally(exc);
                }
            } else {
                channelFuture.completeExceptionally((Throwable)err);
            }
        });
        return reqFuture;
    }

    private static boolean isNotModified(Throwable error) {
        return error instanceof HttpStatusException && ((HttpStatusException)error).getStatusCode() == 304;
    }
}

