/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.heartbeat;

import com.tridium.authn.BAuthenticationService;
import com.tridium.clUtils.niagaranetwork.BINiagaraNetworkHelper;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.heartbeat.BHeartbeatPolicy;
import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.ncs.msg.NiagaraRemoteSendHeartbeatResult;
import com.tridium.cloudLink.ncs.msg.NiagaraRemoteSendRolesHandler;
import com.tridium.cloudLink.ncs.remote.NiagaraRemoteConnection;
import com.tridium.cloudLink.security.BCloudAuthenticationScheme;
import com.tridium.cloudLink.security.BCloudTrustManager;
import com.tridium.cloudLink.security.BJwksTrustMapping;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.role.BAbstractRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(5)))", override=true), @NiagaraProperty(name="deviceConnectionEtag", type="String", defaultValue="", flags=5)})
public class BNiagaraRemoteHeartbeatPolicy
extends BHeartbeatPolicy {
    @Generated
    public static final Property executionTime = BNiagaraRemoteHeartbeatPolicy.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    @Generated
    public static final Property deviceConnectionEtag = BNiagaraRemoteHeartbeatPolicy.newProperty((int)5, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraRemoteHeartbeatPolicy.class);
    private static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    private final Logger log = Logger.getLogger("cloudLink.channel.heartbeat.niagaraRemote");
    private List<BINiagaraNetworkHelper> niagaraNetworkHelpers;
    private Subscriber subscriber;
    private ScheduledExecutorService executor;

    @Generated
    public String getDeviceConnectionEtag() {
        return this.getString(deviceConnectionEtag);
    }

    @Generated
    public void setDeviceConnectionEtag(String v) {
        this.setString(deviceConnectionEtag, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"NRHeartbeatRetry", (long)2L, (TimeUnit)TimeUnit.MINUTES);
        CloudLinkUtils.ensureAuthenticationInfrastructure();
        this.getContainer().getChannel().getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            BFederatedIdentityAuthenticator authenticator = (BFederatedIdentityAuthenticator)ccs.getAuthenticator("FederatedIdentity");
            if (authenticator != null) {
                BNiagaraRemoteHeartbeatPolicy.ensureTrustMapping(authenticator);
            }
            this.updateRoles();
            BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
            this.subscriber = Subscriber.make(event -> {
                if (event.getSourceComponent() instanceof BRoleService && (event.getId() == 1 || event.getId() == 2 || event.getId() == 3)) {
                    if (event.getId() == 1 && event.getValue() instanceof BAbstractRole) {
                        this.subscriber.subscribe((BComponent)((BAbstractRole)event.getValue()));
                    } else if (event.getId() == 2 && event.getValue() instanceof BAbstractRole) {
                        this.subscriber.unsubscribe((BComponent)((BAbstractRole)event.getValue()));
                    }
                    this.updateRoles();
                } else if (event.getSourceComponent() instanceof BAbstractRole && event.getId() == 0 && "enabled".equals(event.getSlotName())) {
                    this.updateRoles();
                }
            });
            this.subscriber.subscribe((BComponent)roleService, 1);
        }));
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public String getOperationId() {
        return "niagaraRemoteSendHeartbeat";
    }

    public void handleResults(SendHeartbeatResult result) {
        NiagaraRemoteSendHeartbeatResult remoteResult = (NiagaraRemoteSendHeartbeatResult)result;
        List<NiagaraRemoteConnection> connections = remoteResult.getConnections();
        if (connections != null) {
            this.configureNiagaraNetwork(connections);
            String etag = remoteResult.getEtag();
            if (etag != null) {
                this.setDeviceConnectionEtag(etag);
            }
        }
    }

    public Map<String, Object> getPayloadProperties() {
        HashMap<String, Object> payloadProperties = new HashMap<String, Object>();
        String etag = this.getDeviceConnectionEtag();
        if (etag != null && !etag.isEmpty()) {
            payloadProperties.put(IF_NONE_MATCH_HEADER, etag);
        }
        BChannelConfig config = this.getContainer().getChannel().getChannelConfig();
        BAbstractTransport transport = config.getTransport("niagaraRemoteSendHeartbeat");
        BAbstractClientAuthenticator authenticator = config.getAuthenticator("niagaraRemoteSendHeartbeat");
        if (transport != null && authenticator != null) {
            AccessController.doPrivileged(() -> {
                authenticator.addMessageHandlerProperties(transport, null, payloadProperties);
                return null;
            });
        }
        String correlationId = UUID.randomUUID().toString();
        this.log.fine(() -> "CorrelationId: " + correlationId);
        payloadProperties.put("X-Correlation-Id", correlationId);
        return payloadProperties;
    }

    protected Logger getLogger() {
        return this.log;
    }

    private void configureNiagaraNetwork(List<NiagaraRemoteConnection> connections) {
        List<BINiagaraNetworkHelper> niagaraNetworkHelpers = this.getNiagaraNetworkHelpers();
        if (niagaraNetworkHelpers == null) {
            return;
        }
        BChannelConfig config = this.getContainer().getChannel().getChannelConfig();
        BFederatedIdentityAuthenticator authenticator = (BFederatedIdentityAuthenticator)config.getAuthenticator("niagaraRemoteSendHeartbeat");
        BAbstractTransport transport = config.getTransport("niagaraRemoteSendHeartbeat");
        String host = authenticator.getRegistrationHost();
        HashMap props = new HashMap();
        AccessController.doPrivileged(() -> {
            authenticator.addMessageHandlerProperties(transport, null, props);
            return null;
        });
        BCertificateAliasAndPassword certAliasAndPass = (BCertificateAliasAndPassword)props.get("certAliasAndPassword");
        String systemId = authenticator.getSystemId();
        connections = connections.stream().filter(c -> "foxwss".equals(c.getConnectionType())).collect(Collectors.toList());
        List deviceIds = connections.stream().map(NiagaraRemoteConnection::getToDeviceId).collect(Collectors.toList());
        BCertificateAliasCredential credential = new BCertificateAliasCredential();
        credential.setUsername(systemId);
        credential.setCertificateAlias(certAliasAndPass.getAlias().toLowerCase(Locale.ROOT));
        credential.setCertificatePassword(certAliasAndPass.getPassword());
        for (BINiagaraNetworkHelper helper : niagaraNetworkHelpers) {
            helper.configureNiagaraNetwork(deviceIds, host, credential);
        }
    }

    private List<BINiagaraNetworkHelper> getNiagaraNetworkHelpers() {
        if (this.niagaraNetworkHelpers != null) {
            return this.niagaraNetworkHelpers;
        }
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BINiagaraNetworkHelper.TYPE.getTypeInfo());
        if (types.length == 0) {
            String message = "No concrete type found for BINiagaraNetworkHelper. Ensure necessary utility module is installed.";
            this.log.warning(message);
            this.executeFail(message);
            return null;
        }
        this.niagaraNetworkHelpers = new ArrayList<BINiagaraNetworkHelper>();
        for (TypeInfo type : types) {
            this.niagaraNetworkHelpers.add((BINiagaraNetworkHelper)type.getInstance().as(BINiagaraNetworkHelper.class));
        }
        return this.niagaraNetworkHelpers;
    }

    private void updateRoles() {
        BChannelConfig config = this.getContainer().getChannel().getChannelConfig();
        NiagaraRemoteSendRolesHandler handler = new NiagaraRemoteSendRolesHandler(config);
        handler.add(this.getRoles());
        BAbstractTransport transport = config.getTransport("niagaraRemoteSendHeartbeat");
        CompletableFuture responseFuture = new CompletableFuture();
        MessageWrapper wrapper = new MessageWrapper(handler.toMessage(true), responseFuture, transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(this.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        responseFuture.whenComplete((resp, err) -> {
            if (err != null) {
                this.log.log(Level.INFO, "Error sending roles information: " + err.getMessage(), this.log.isLoggable(Level.FINE) ? err : null);
                this.executor.schedule(this::updateRoles, 5L, TimeUnit.MINUTES);
            } else {
                this.log.fine("roles information sent successfully");
            }
        });
    }

    private List<String> getRoles() {
        BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
        ArrayList<String> roles = new ArrayList<String>();
        for (BAbstractRole role : (BAbstractRole[])roleService.getChildren(BAbstractRole.class)) {
            if (!role.getEnabled()) continue;
            roles.add(role.getName());
        }
        return roles;
    }

    private static void ensureTrustMapping(BFederatedIdentityAuthenticator authenticator) {
        BAuthenticationService authenticationService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        BCloudAuthenticationScheme[] cloudSchemes = (BCloudAuthenticationScheme[])authenticationService.getAuthenticationSchemes().getChildren(BCloudAuthenticationScheme.class);
        BCloudAuthenticationScheme cloudAuthenticationScheme = cloudSchemes[0];
        BCloudTrustManager manager = cloudAuthenticationScheme.getTrustManager();
        if (manager.getKeyResolver("NCS-NNoNR") == null) {
            BJwksTrustMapping jwksTrustMapping = new BJwksTrustMapping();
            String issuer = "https://" + authenticator.getRegistrationHost() + "/api/v1/accesstoken";
            jwksTrustMapping.setExpectedJwtIssuer(issuer);
            jwksTrustMapping.setJwksEndpoint(issuer + "/publicKey");
            jwksTrustMapping.setExpectedJwtAudience(authenticator.getSystemId());
            jwksTrustMapping.setAppId("NCS-NNoNR");
            manager.add(SlotPath.escape((String)"NCS-NNoNR".toLowerCase()), (BValue)jwksTrustMapping);
        }
    }
}

