/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.forge.msg.ForgeAmqpAckAlarmCommandHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpCommandResponseHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpGetLastTimestampsHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpMultiPointReadCommandHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpMultiPointWriteCommandHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpPointReadCommandHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpPointWriteCommandHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpRegisterCommandsHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendAlarmHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendBatchAlarmHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendEventHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendHeartbeatHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendHistoriesHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendPointValuesHandler;
import com.tridium.cloudLink.forge.msg.IForgeAckAlarmCommandHandler;
import com.tridium.cloudLink.forge.msg.IForgeCommandResponseHandler;
import com.tridium.cloudLink.forge.msg.IForgeMultiPointReadCommandHandler;
import com.tridium.cloudLink.forge.msg.IForgeMultiPointWriteCommandHandler;
import com.tridium.cloudLink.forge.msg.IForgePointReadCommandHandler;
import com.tridium.cloudLink.forge.msg.IForgePointWriteCommandHandler;
import com.tridium.cloudLink.forge.util.ForgeUtils;
import com.tridium.cloudLink.msg.IGetLastTimestampsHandler;
import com.tridium.cloudLink.msg.IRegisterCommandsHandler;
import com.tridium.cloudLink.msg.ISendAlarmHandler;
import com.tridium.cloudLink.msg.ISendBatchAlarmHandler;
import com.tridium.cloudLink.msg.ISendEventHandler;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.msg.ISendHistoriesHandler;
import com.tridium.cloudLink.msg.ISendPointValuesHandler;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.IGetMessageKey;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNcsAmqpHandlerFactory
extends BAbstractCloudLinkHandlerFactory {
    @Generated
    public static final Type TYPE = Sys.loadType(BNcsAmqpHandlerFactory.class);
    protected static final Logger log = Logger.getLogger("cloudLink.ncs.msg");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getPlatformType() {
        return "NCS";
    }

    public String getTransportType() {
        return "AMQP";
    }

    public IGetMessageKey<? extends IMessage> getMessageKeyHandler() {
        return new IGetMessageKey<AmqpMessage>(){

            public String getKey(AmqpMessage message) {
                return message.getMetadata().get("ObjectType").toString() + '.' + message.getMetadata().get("ObjectVersion").toString();
            }
        };
    }

    public IGetMessageKey<? extends IMessage> getMessageCorrelationIdHandler() {
        return new IGetMessageKey<AmqpMessage>(){

            public String getKey(AmqpMessage message) {
                Object correlationId = message.getMessage().getCorrelationId();
                return correlationId == null ? null : correlationId.toString();
            }
        };
    }

    public Consumer<IMessage> getMessageLogger() {
        return message -> {
            if (!log.isLoggable(Level.FINEST)) {
                return;
            }
            try {
                JSONObject platformHeaders;
                JSONObject data;
                Map headers = message.getMetadata();
                String payloadString = new String(message.getPayload(), StandardCharsets.UTF_8);
                if (headers.containsKey("ObjectType") && "SystemCommand".equals(headers.get("ObjectType")) && (data = new JSONObject(payloadString)).has("CommandParameters") && data.getJSONObject("CommandParameters").has("CloudPlatformHeaders") && (platformHeaders = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CloudPlatformHeaders"))).has("Auth")) {
                    String auth = JSONUtil.getString((JSONObject)platformHeaders, (String)"Auth");
                    auth = auth.length() > 40 ? auth.substring(0, 10) + "..." + auth.substring(auth.length() - 10) : (auth.length() > 5 ? auth.charAt(0) + "..." + auth.charAt(auth.length() - 1) : "REDACTED");
                    platformHeaders.put("Auth", (Object)auth);
                    data.getJSONObject("CommandParameters").put("CloudPlatformHeaders", (Object)platformHeaders);
                    payloadString = data.toString();
                }
                String payload = payloadString;
                log.finest(() -> String.format("Received AMQP message, headers: %spayload [%s]", ForgeUtils.makeHeaderString((Map)headers), payload));
            }
            catch (JSONException ex) {
                log.log(Level.WARNING, "Error deserializing incoming AMQP message", log.isLoggable(Level.FINE) ? ex : null);
            }
        };
    }

    protected void registerHandlers() {
        this.messageHandlerTypes.put(IForgeAckAlarmCommandHandler.class, ForgeAmqpAckAlarmCommandHandler.class);
        this.messageHandlerTypes.put(IForgeCommandResponseHandler.class, ForgeAmqpCommandResponseHandler.class);
        this.messageHandlerTypes.put(IForgeMultiPointReadCommandHandler.class, ForgeAmqpMultiPointReadCommandHandler.class);
        this.messageHandlerTypes.put(IForgeMultiPointWriteCommandHandler.class, ForgeAmqpMultiPointWriteCommandHandler.class);
        this.messageHandlerTypes.put(IForgePointReadCommandHandler.class, ForgeAmqpPointReadCommandHandler.class);
        this.messageHandlerTypes.put(IForgePointWriteCommandHandler.class, ForgeAmqpPointWriteCommandHandler.class);
        this.messageHandlerTypes.put(IGetLastTimestampsHandler.class, ForgeAmqpGetLastTimestampsHandler.class);
        this.messageHandlerTypes.put(IRegisterCommandsHandler.class, ForgeAmqpRegisterCommandsHandler.class);
        this.messageHandlerTypes.put(ISendAlarmHandler.class, ForgeAmqpSendAlarmHandler.class);
        this.messageHandlerTypes.put(ISendBatchAlarmHandler.class, ForgeAmqpSendBatchAlarmHandler.class);
        this.messageHandlerTypes.put(ISendEventHandler.class, ForgeAmqpSendEventHandler.class);
        this.messageHandlerTypes.put(ISendHistoriesHandler.class, ForgeAmqpSendHistoriesHandler.class);
        this.messageHandlerTypes.put(ISendHeartbeatHandler.class, ForgeAmqpSendHeartbeatHandler.class);
        this.messageHandlerTypes.put(ISendPointValuesHandler.class, ForgeAmqpSendPointValuesHandler.class);
    }
}

