/*
 * Decompiled with CFR 0.152.
 */
package test.install;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BCodeSigner;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.CursorUtil;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.sys.Nre;
import java.io.File;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.naming.SlotPath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public class TestInstallableRegistry
implements InstallableRegistry {
    private Map<String, Map<Version, BInstallable>> installables = new TreeMap<String, Map<Version, BInstallable>>();

    public TestInstallableRegistry(BInstallable ... installables) {
        for (BInstallable installable : installables) {
            BPart part = installable.getPart();
            if (part == null) continue;
            Map<Version, BInstallable> byVersion = this.installables.get(part.getPartName());
            if (byVersion == null) {
                byVersion = new TreeMap(Comparator.reverseOrder());
                this.installables.put(part.getPartName(), byVersion);
            }
            byVersion.put(part.getVersion().getVendorVersion(), installable);
        }
    }

    public static BDistribution dist(String installableName, String versionString, Type partType, BDependency ... dependencies) {
        BDistribution result = new BDistribution();
        result.setInstallableName(installableName);
        result.setVersion(new BVersion(versionString));
        if (partType != null) {
            BPart part = (BPart)partType.getInstance();
            part.setPartName(installableName);
            part.setVersion(new BVersion(versionString));
            result.getParts().add(SlotPath.escape((String)part.getPartName()), (BValue)part);
        }
        for (BDependency dependency : dependencies) {
            result.getDependencies().add(null, (BValue)dependency);
        }
        return result;
    }

    public static BModuleInstallable module(String moduleName, String runtimeProfileName, String versionString, String relatedProfileNames, BDependency ... deps) {
        BModuleInstallable result = new BModuleInstallable();
        result.setInstallableName(String.format("%s-%s", moduleName, runtimeProfileName));
        result.setVersion(new BVersion(versionString));
        BModulePart part = new BModulePart();
        part.setPartName(result.getInstallableName());
        part.setModuleName(moduleName);
        part.setRuntimeProfile(RuntimeProfile.valueOf((String)runtimeProfileName));
        part.setVersion(new BVersion(versionString));
        try {
            File file = new File(TestInstallableRegistry.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            List signers = Nre.getJarSignatureRegistry().getCodeSigners(file);
            BVector signersVector = part.getCodeSigners();
            for (CodeSigner signer : signers) {
                signersVector.add(null, (BValue)new BCodeSigner(signer));
            }
            part.setSignersInitialized(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize code signers.", exception);
        }
        result.getParts().add(SlotPath.escape((String)part.getPartName()), (BValue)part);
        if (deps != null) {
            for (BDependency bDependency : deps) {
                part.getDependencies().add(SlotPath.escape((String)bDependency.getPartName()), bDependency.newCopy());
                result.getDependencies().add(SlotPath.escape((String)bDependency.getPartName()), bDependency.newCopy());
            }
        }
        if (relatedProfileNames != null) {
            for (String string : relatedProfileNames.split(",")) {
                if (string.equals("")) continue;
                part.getRelatedModulePartNames().add(SlotPath.escape((String)string), (BValue)BString.make((String)String.format("%s-%s", moduleName, string)));
            }
        }
        return result;
    }

    public BInstallable findInstallable(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        IterableCursor<BInstallable> c = this.getInstallables(depend, listener);
        return c.next() ? (BInstallable)c.get() : null;
    }

    public IterableCursor<BInstallable> getInstallables(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        if (BPart.isWildcardName((String)depend.getPartName())) {
            ArrayList accum = new ArrayList();
            this.installables.entrySet().stream().filter(entry -> BPart.matchesName((String)((String)entry.getKey()), (String)depend.getPartName())).forEach(entry -> ((Map)entry.getValue()).values().forEach(inst -> {
                if (inst.getPart().meets(depend)) {
                    accum.add(inst);
                }
            }));
            return CursorUtil.cursor(accum.iterator());
        }
        return CursorUtil.cursor(this.installables.get(depend.getPartName()).values().stream().filter(inst -> inst.meets(depend, listener)).iterator());
    }

    public IterableCursor<BInstallable> getInstallables(boolean latestOnly, DaemonSessionTaskListener listener) throws Exception {
        if (latestOnly) {
            return CursorUtil.cursor(this.installables.values().stream().map(map -> (BInstallable)map.values().iterator().next()).iterator());
        }
        Stream<Object> stream = StreamSupport.stream(Spliterators.emptySpliterator(), false);
        for (Map<Version, BInstallable> map2 : this.installables.values()) {
            stream = Stream.concat(stream, map2.values().stream());
        }
        return CursorUtil.cursor(stream.iterator());
    }
}

