/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.function.RunnableCanThrowException;
import javax.baja.nre.function.SupplierCanThrowException;
import javax.baja.nre.security.IKeyPurpose;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.security.crypto.X509CertificateFactory;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BNumber;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.web.WebDev;
import javax.baja.web.js.BJsBuild;
import org.testng.Assert;
import sun.misc.Unsafe;

public class TestHelper {
    private static Unsafe unsafe;
    private static int hashCodes;
    protected static final int WAIT_FOR_TRUE_INTERVAL = 10;
    protected static final int WAIT_FOR_TRUE_TIMEOUT = 5000;

    public static void assertWillBeTrue(BooleanSupplier condition, String message) {
        Assert.assertTrue(TestHelper.waitFor(condition, 5000L, 10L), message);
    }

    public static void assertWillBeTrue(BooleanSupplier condition, Supplier<String> message) {
        if (!TestHelper.waitFor(condition, 5000L, 10L)) {
            Assert.fail(message.get());
        }
    }

    public static void assertWillBeTrue(BooleanSupplier condition, long timeout, String message) {
        Assert.assertTrue(TestHelper.waitFor(condition, timeout, 10L), message);
    }

    public static void assertWillBeTrue(BooleanSupplier condition, long timeout, Supplier<String> message) {
        if (!TestHelper.waitFor(condition, timeout, 10L)) {
            Assert.fail(message.get());
        }
    }

    public static boolean waitFor(BooleanSupplier condition) {
        return TestHelper.waitFor(condition, 5000L, 10L);
    }

    public static boolean waitFor(BooleanSupplier condition, long timeout) {
        return TestHelper.waitFor(condition, timeout, 10L);
    }

    public static boolean waitFor(BooleanSupplier condition, long timeout, long interval) {
        long now = Clock.ticks();
        long end = now + timeout;
        while (now < end) {
            if (condition.getAsBoolean()) {
                return true;
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            now = Clock.ticks();
        }
        return condition.getAsBoolean();
    }

    public static void waitForClockChange() {
        BAbsTime start = Clock.time();
        TestHelper.waitFor(() -> Clock.time().getMillis() > start.getMillis());
    }

    public static void fieldEditorSlotFacetsToHaveUxFieldEditorDefined(String expectedFeType, String expectedUxFeType) {
        Assert.assertNotNull(expectedFeType, "expectedFeType argument");
        Assert.assertNotNull(expectedUxFeType, "expectedUxFeType argument");
        Registry registry = Sys.getRegistry();
        for (TypeInfo type : registry.getConcreteTypes(BComplex.TYPE.getTypeInfo())) {
            BComplex instance;
            if (type.isAbstract() || type.isInterface() || type.is(BWidget.TYPE)) continue;
            try {
                instance = type.getInstance().asComplex();
            }
            catch (Throwable ignore) {
                continue;
            }
            for (Property property : instance.getProperties()) {
                BFacets facets = property.getFacets();
                String actualFeType = facets.gets("fieldEditor", null);
                if (!expectedFeType.equals(actualFeType)) continue;
                String actualUxFeType = facets.gets("uxFieldEditor", null);
                String message = "actual UX field editor type for " + type.getModuleName() + ':' + type.getTypeName() + '.' + property.getName();
                Assert.assertNotNull(actualUxFeType, message);
                Assert.assertEquals(actualUxFeType, expectedUxFeType, message);
            }
        }
    }

    public static Object getPrivateField(Object object, String variableName) {
        return TestHelper.actOnField(object, variableName, field -> field.get(object));
    }

    public static void setPrivateField(Object object, String variableName, Object value) {
        TestHelper.setPrivateField(object, variableName, value, VolatileParameter.KEEP_CURRENT);
    }

    public static void setPrivateField(Object object, String variableName, Object value, VolatileParameter volatileParameter) {
        TestHelper.actOnField(object, variableName, field -> {
            TestHelper.setField(object, field, value, volatileParameter);
            return null;
        });
    }

    private static void setField(Object object, Field field, Object value, VolatileParameter volatileParameter) {
        long offset;
        Object objectForPut;
        Object previousValue;
        if (object != null && (previousValue = TestHelper.getPrivateField(object, field.getName())) != null) {
            hashCodes += previousValue.hashCode();
        }
        Unsafe unsafe = TestHelper.getUnsafe();
        boolean isVolatile = Modifier.isVolatile(field.getModifiers());
        if (volatileParameter == VolatileParameter.FORCE_VOLATILE) {
            isVolatile = true;
        } else if (volatileParameter == VolatileParameter.FORCE_NOT_VOLATILE) {
            isVolatile = false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            objectForPut = unsafe.staticFieldBase(field);
            offset = unsafe.staticFieldOffset(field);
        } else {
            offset = unsafe.objectFieldOffset(field);
            objectForPut = object;
        }
        Class<?> type = field.getType();
        if (type == Boolean.TYPE) {
            if (isVolatile) {
                unsafe.putBooleanVolatile(objectForPut, offset, (Boolean)value);
            } else {
                unsafe.putBoolean(objectForPut, offset, (Boolean)value);
            }
        } else if (type == Integer.TYPE) {
            if (isVolatile) {
                unsafe.putIntVolatile(objectForPut, offset, TestHelper.toNumber(value).getInt());
            } else {
                unsafe.putInt(objectForPut, offset, TestHelper.toNumber(value).getInt());
            }
        } else if (type == Long.TYPE) {
            if (isVolatile) {
                unsafe.putLongVolatile(objectForPut, offset, TestHelper.toNumber(value).getLong());
            } else {
                unsafe.putLong(objectForPut, offset, TestHelper.toNumber(value).getLong());
            }
        } else if (type == Double.TYPE) {
            if (isVolatile) {
                unsafe.putDoubleVolatile(objectForPut, offset, TestHelper.toNumber(value).getDouble());
            } else {
                unsafe.putDouble(objectForPut, offset, TestHelper.toNumber(value).getDouble());
            }
        } else if (type == Float.TYPE) {
            if (isVolatile) {
                unsafe.putFloatVolatile(objectForPut, offset, TestHelper.toNumber(value).getFloat());
            } else {
                unsafe.putFloat(objectForPut, offset, TestHelper.toNumber(value).getFloat());
            }
        } else if (type == Short.TYPE) {
            if (isVolatile) {
                unsafe.putShortVolatile(objectForPut, offset, (Short)value);
            } else {
                unsafe.putShort(objectForPut, offset, (Short)value);
            }
        } else if (type == Character.TYPE) {
            if (isVolatile) {
                unsafe.putCharVolatile(objectForPut, offset, ((Character)value).charValue());
            } else {
                unsafe.putChar(objectForPut, offset, ((Character)value).charValue());
            }
        } else if (type == Byte.TYPE) {
            if (isVolatile) {
                unsafe.putByteVolatile(objectForPut, offset, (Byte)value);
            } else {
                unsafe.putByte(objectForPut, offset, (Byte)value);
            }
        } else if (isVolatile) {
            unsafe.putObjectVolatile(objectForPut, offset, value);
        } else {
            unsafe.putObject(objectForPut, offset, value);
        }
    }

    private static BNumber toNumber(Object value) {
        if (value instanceof Double) {
            return BDouble.make((double)((Double)value));
        }
        if (value instanceof Integer) {
            return BInteger.make((int)((Integer)value));
        }
        if (value instanceof Float) {
            return BFloat.make((float)((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return BLong.make((long)((Long)value));
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return BDouble.make((double)number.doubleValue());
        }
        throw new RuntimeException("Currently unsupported conversion type: " + value.getClass().getName());
    }

    private static <T> T actOnField(Object object, String variableName, ExceptionFunction<Field, T, IllegalAccessException> function) {
        Field field = null;
        boolean fieldAccessible = false;
        try {
            Class<?> cls = object instanceof Class ? (Class<?>)object : object.getClass();
            field = TestHelper.getField(cls, variableName);
            fieldAccessible = field.isAccessible();
            field.setAccessible(true);
            T t = function.apply(field);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot manipulate field: " + e.getMessage(), e);
        }
        finally {
            try {
                if (field != null) {
                    field.setAccessible(fieldAccessible);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Field getField(Class<?> declaringClass, String fieldName) throws NoSuchFieldException {
        if (declaringClass == null) {
            throw new RuntimeException("Can't get field on null object/class");
        }
        try {
            Field field = declaringClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> declaringSuperClass = declaringClass.getSuperclass();
            if (declaringSuperClass == null) {
                throw e;
            }
            return TestHelper.getField(declaringSuperClass, fieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void runWithAlternateValue(Object object, String variableName, Object alternateValue, RunnableCanThrowException<E> r) throws E {
        Object originalValue = TestHelper.getPrivateField(object, variableName);
        TestHelper.setPrivateField(object, variableName, alternateValue);
        try {
            r.run();
        }
        finally {
            TestHelper.setPrivateField(object, variableName, originalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T callWithAlternateValue(Object object, String variableName, Object alternateValue, SupplierCanThrowException<T, E> testSupplier) throws E {
        Object originalValue = TestHelper.getPrivateField(object, variableName);
        TestHelper.setPrivateField(object, variableName, alternateValue);
        try {
            Object object2 = testSupplier.get();
            return (T)object2;
        }
        finally {
            TestHelper.setPrivateField(object, variableName, originalValue);
        }
    }

    public static WebDevSnapshot webDevSnapshot() {
        return new WebDevSnapshot();
    }

    public static WebDevScenario withWebDev(String ... webDevIds) {
        return new WebDevScenario(webDevIds);
    }

    public static WebDevScenario withWebDev(BJsBuild ... builds) {
        return new WebDevScenario((String[])Arrays.stream(builds).map(BJsBuild::getId).toArray(String[]::new));
    }

    public static <T> T invokePrivate(Object obj, String methodName, Object ... args) throws Throwable {
        return TestHelper.invokePrivate(obj, obj.getClass(), methodName, args);
    }

    public static <T> T invokePrivate(Object obj, Class<?> declaringClass, String methodName, Object ... args) throws Throwable {
        Method method = null;
        try {
            Class[] argClasses = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            method = declaringClass.getDeclaredMethod(methodName, argClasses);
            method.setAccessible(true);
            Object object = method.invoke(obj, args);
            return (T)object;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            Assert.fail("Failed to invoke " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            if (method != null) {
                method.setAccessible(true);
            }
        }
        return null;
    }

    public static void copyFile(BOrd original, FilePath destination) throws IOException {
        BIFile inFile = (BIFile)original.get();
        BIFile outFile = BFileSystem.INSTANCE.makeFile(destination);
        try (InputStream in = inFile.getInputStream();
             OutputStream out = outFile.getOutputStream();){
            FileUtil.pipe((InputStream)in, (OutputStream)out);
            out.flush();
        }
    }

    public static BIFile unpackModuleFileAsTempFile(String moduleFilePath) throws IOException {
        try {
            BOrd moduleOrd = BOrd.make((String)("module://" + moduleFilePath));
            BIFile moduleFile = (BIFile)moduleOrd.get();
            File tempFile = File.createTempFile(moduleFile.getFileName(), '.' + moduleFile.getExtension());
            tempFile.deleteOnExit();
            TestHelper.copyFile(moduleOrd, BFileSystem.INSTANCE.localFileToPath(tempFile));
            return (BIFile)BFileSystem.INSTANCE.localFileToOrd(tempFile).get().as(BIFile.class);
        }
        catch (Exception e) {
            System.err.println("Failed to unpack file '" + moduleFilePath + "', exception '" + e.getMessage() + '\'');
            e.printStackTrace();
            throw e;
        }
    }

    private static Unsafe getUnsafe() {
        if (unsafe != null) {
            return unsafe;
        }
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            return unsafe;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize sun.misc.Unsafe ", e);
        }
    }

    public static void assertCanRunConcurrently(int threadsPerRunnable, int iterationsPerRunnable, long timeout, Runnable ... runnables) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        AtomicInteger counter = new AtomicInteger(0);
        AtomicReference exception = new AtomicReference();
        int totalThreads = threadsPerRunnable * runnables.length;
        for (Runnable runnable : runnables) {
            for (int i = 0; i < threadsPerRunnable; ++i) {
                threads.add(new Thread(() -> {
                    try {
                        for (int j = 0; j < iterationsPerRunnable; ++j) {
                            runnable.run();
                        }
                    }
                    catch (Exception e) {
                        exception.set(e);
                        throw e;
                    }
                    counter.incrementAndGet();
                }, "assertCanRunConcurrently"));
            }
        }
        for (Thread thread : threads) {
            thread.start();
        }
        TestHelper.assertWillBeTrue(() -> {
            Exception e = (Exception)exception.get();
            if (e != null) {
                throw new RuntimeException("Failure on thread", e);
            }
            return counter.get() == totalThreads;
        }, timeout, "not all threads completed successfully");
    }

    public static IX509CertificateEntry createTestClientCertEntry(String alias, String cn, int days, String passphrase) throws Exception {
        String dn = "CN=" + cn + ",OU=client_testing,O=Tridium,C=US";
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.set(6, cal.get(6) + days);
        Date notAfter = cal.getTime();
        return X509CertificateFactory.getInstance().generateSelfSignedCert(alias, dn, dn, notBefore, notAfter, 2048, IKeyPurpose.CLIENT_CERT, null, null);
    }

    public static IX509CertificateEntry createTestServerCertEntry(String alias, String cn, int days, String passphrase) throws Exception {
        return TestHelper.createTestServerCertEntry(alias, cn, days, null, null);
    }

    public static IX509CertificateEntry createTestServerCertEntry(String alias, String cn, int days, String san, String passphrase) throws Exception {
        String dn = "CN=" + cn + ",OU=server_testing,O=Tridium,C=US";
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.set(6, cal.get(6) + days);
        Date notAfter = cal.getTime();
        return X509CertificateFactory.getInstance().generateSelfSignedCert(alias, dn, dn, notBefore, notAfter, 2048, IKeyPurpose.SERVER_CERT, san, null);
    }

    public static BINavNode loadPaletteItem(BModule module, String ... pathToItem) {
        BINavNode palette = TestHelper.loadPaletteFor(module);
        BINavNode found = null;
        for (String pathEntry : pathToItem) {
            if ((found = found == null ? palette.getNavChild(pathEntry) : found.getNavChild(pathEntry)) != null) continue;
            String path = String.join((CharSequence)"/", pathToItem);
            Assert.fail(String.format("Failed to locate entry [%s] in the palette for module [%s]", path, module.getModuleName()));
        }
        return found;
    }

    public static BINavNode loadPaletteFor(BModule module) {
        return module.getNavChild("module.palette");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void runWithAlternateSystemProperty(String propertyName, String alternateValue, RunnableCanThrowException<E> r) throws E {
        String originalValue = System.getProperty(propertyName);
        try {
            TestHelper.setOrClearSystemProperty(propertyName, alternateValue);
            r.run();
        }
        finally {
            TestHelper.setOrClearSystemProperty(propertyName, originalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception, T> T runWithAlternateSystemProperty(String propertyName, String alternateValue, SupplierCanThrowException<T, E> s) throws E {
        String originalValue = System.getProperty(propertyName);
        try {
            TestHelper.setOrClearSystemProperty(propertyName, alternateValue);
            Object object = s.get();
            return (T)object;
        }
        finally {
            TestHelper.setOrClearSystemProperty(propertyName, originalValue);
        }
    }

    private static void setOrClearSystemProperty(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    static {
        hashCodes = 0;
    }

    public static enum VolatileParameter {
        KEEP_CURRENT,
        FORCE_VOLATILE,
        FORCE_NOT_VOLATILE;

    }

    public static class WebDevScenario {
        private final List<String> webDevIds;

        private WebDevScenario(String ... webDevIds) {
            this.webDevIds = Arrays.asList(webDevIds);
        }

        public <E extends Exception> WebDevScenario on(RunnableCanThrowException<E> runnable) throws E {
            WebDevScenario.withWebDevEnabled(true, runnable, this.webDevIds);
            return this;
        }

        public <E extends Exception> WebDevScenario off(RunnableCanThrowException<E> runnable) throws E {
            WebDevScenario.withWebDevEnabled(false, runnable, this.webDevIds);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <E extends Exception> void withWebDevEnabled(boolean enabled, RunnableCanThrowException<E> runnable, List<String> webDevIds) throws E {
            if (webDevIds.isEmpty()) {
                runnable.run();
                return;
            }
            String webDevId = webDevIds.get(0);
            WebDev webDev = WebDev.get((String)webDevId);
            boolean wasEnabled = webDev.isEnabled();
            List<String> rest = webDevIds.subList(1, webDevIds.size());
            webDev.setEnabled(enabled);
            try {
                WebDevScenario.withWebDevEnabled(enabled, runnable, rest);
            }
            finally {
                webDev.setEnabled(wasEnabled);
            }
        }
    }

    public static class WebDevSnapshot {
        private final Map<String, Boolean> webdevStatuses = new HashMap<String, Boolean>();

        private WebDevSnapshot() {
            Map map = (Map)TestHelper.getPrivateField(WebDev.class, "webDevs");
            map.forEach((name, webDev) -> this.webdevStatuses.put((String)name, webDev.isEnabled()));
        }

        public void restore() {
            this.webdevStatuses.forEach((name, enabled) -> WebDev.get((String)name).setEnabled(enabled.booleanValue()));
        }
    }

    private static interface ExceptionFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    public static class LogRecorderHandler
    extends Handler {
        public List<String> logs = new ArrayList<String>();

        @Override
        public void publish(LogRecord record) {
            this.logs.add(record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public boolean contains(String logEntry) {
            return this.logs.contains(logEntry);
        }

        public void reset() {
            this.logs.clear();
        }

        public static LogRecorderHandler addLogHandler(String logName) {
            LogRecorderHandler logHandler = new LogRecorderHandler();
            Logger.getLogger(logName).addHandler(logHandler);
            return logHandler;
        }

        public void removeLogHandler(String logName) {
            Logger.getLogger(logName).removeHandler(this);
        }
    }

    public static class LatestLogHandler
    extends Handler {
        String latestMessage;
        Level latestLevel;

        public Level getLatestLevel() {
            return this.latestLevel;
        }

        public String getLatestMessage() {
            return this.latestMessage;
        }

        @Override
        public void publish(LogRecord record) {
            this.latestMessage = record.getMessage();
            this.latestLevel = record.getLevel();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public static LatestLogHandler addLogHandler(String logName) {
            LatestLogHandler logHandler = new LatestLogHandler();
            Logger.getLogger(logName).addHandler(logHandler);
            return logHandler;
        }

        public void removeLogHandler(String logName) {
            Logger.getLogger(logName).removeHandler(this);
        }
    }
}

