/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.testng.TestRunnerNg;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.TestException;

@NiagaraType
public abstract class BTest
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BTest.class);
    int verifyCount;
    protected BStation station;
    private static TestStationHandler stationHandler;
    private static final Object testStationMonitor;
    private boolean junit;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setup() throws Exception {
    }

    public void cleanup() throws Exception {
    }

    public Method[] list() throws Exception {
        return (Method[])Arrays.stream(((Object)((Object)this)).getClass().getMethods()).filter(m -> m.getName().startsWith("test")).toArray(Method[]::new);
    }

    public void verify(boolean condition) {
        if (condition) {
            this.pass();
        } else {
            this.fail("verify(false)");
        }
    }

    public void verify(boolean condition, String failureMessage) {
        if (condition) {
            this.pass();
        } else {
            this.fail(failureMessage);
        }
    }

    public void fail() {
        this.fail("fail()");
    }

    public void verifyEq(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                this.pass();
            } else {
                this.fail("null != " + b);
            }
        } else if (a.equals(b)) {
            int hashB;
            int hashA = a.hashCode();
            if (hashA != (hashB = b.hashCode())) {
                this.fail(a + " != " + b + " (hashCodes not equal, " + hashA + " != " + hashB + ')');
            } else {
                this.pass();
            }
        } else {
            this.fail(a + " != " + b);
        }
    }

    public <T> void verifyEq(T a, T b, Comparator<T> comp) {
        if (a == null) {
            if (b == null) {
                this.pass();
            } else {
                this.fail("null != " + b);
            }
        } else if (b != null && comp.compare(a, b) == 0) {
            this.pass();
        } else {
            this.fail(a + " != " + b);
        }
    }

    public void verifyEquivalent(BObject a, BObject b) {
        if (a == null) {
            if (b == null) {
                this.pass();
            } else {
                this.fail("null != " + b);
            }
        } else if (b != null && a.equivalent((Object)b)) {
            this.pass();
        } else {
            this.fail(a + " != " + b);
        }
    }

    public void verifySame(Object a, Object b) {
        if (a == b) {
            this.pass();
        } else {
            this.fail(a + " !== " + b);
        }
    }

    public void verifyValuesEq(Object[] a, Object[] b) {
        if (a == null || b == null) {
            if (a == b) {
                this.pass();
            } else {
                this.fail(BTest.toString(a) + " != " + BTest.toString(b));
            }
        } else {
            boolean same = true;
            if (a.length != b.length) {
                same = false;
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] == null || b[i] == null) {
                        if (a[i] == b[i]) continue;
                        same = false;
                        break;
                    }
                    if (a[i].equals(b[i])) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                this.pass();
            } else {
                this.fail(BTest.toString(a) + " != " + BTest.toString(b));
            }
        }
    }

    public void verifyValuesSame(Object[] a, Object[] b) {
        if (a == null || b == null) {
            if (a == b) {
                this.pass();
            } else {
                this.fail(BTest.toString(a) + " !== " + BTest.toString(b));
            }
        } else {
            boolean same = true;
            if (a.length != b.length) {
                same = false;
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] == b[i]) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                this.pass();
            } else {
                this.fail(BTest.toString(a) + " !== " + BTest.toString(b));
            }
        }
    }

    public void verifyValuesEquivalent(BComplex[] a, BComplex[] b) {
        if (a == null || b == null) {
            if (a == b) {
                this.pass();
            } else {
                this.fail(BTest.toString(a) + " != " + BTest.toString(b));
            }
        } else {
            boolean same = true;
            if (a.length != b.length) {
                same = false;
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] == null || b[i] == null) {
                        if (a[i] == b[i]) continue;
                        same = false;
                        break;
                    }
                    if (a[i].equivalent((Object)b[i])) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                this.pass();
            } else {
                this.fail(BTest.toString(a) + " != " + BTest.toString(b));
            }
        }
    }

    public void verifyValuesSame(int[] a, int[] b) {
        if (a == null || b == null) {
            if (a == b) {
                this.pass();
            } else {
                this.fail(BTest.asString(a) + " !== " + BTest.asString(b));
            }
        } else {
            boolean same = true;
            if (a.length != b.length) {
                same = false;
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] == b[i]) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                this.pass();
            } else {
                this.fail(BTest.asString(a) + " !== " + BTest.asString(b));
            }
        }
    }

    public void verifyEq(boolean a, boolean b) {
        if (a == b) {
            this.pass();
        } else {
            this.fail(a + " != " + b);
        }
    }

    public void verifyEq(int a, int b) {
        if (a == b) {
            this.pass();
        } else {
            this.fail(a + " != " + b);
        }
    }

    public void verifyEq(long a, long b) {
        if (a == b) {
            this.pass();
        } else {
            this.fail(a + "L != " + b + 'L');
        }
    }

    public void verifyEq(float a, float b) {
        if (BFloat.equals((float)a, (float)b)) {
            this.pass();
        } else {
            this.fail(a + "f != " + b + 'f');
        }
    }

    public void verifyEq(double a, double b) {
        if (BDouble.equals((double)a, (double)b)) {
            this.pass();
        } else {
            this.fail(a + " != " + b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestStationHandler createTestStation(String bog) throws Exception {
        Object object = testStationMonitor;
        synchronized (object) {
            while (stationHandler != null) {
                testStationMonitor.wait();
            }
            stationHandler = new TestStationHandler(bog);
        }
        return stationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestStationHandler createTestStation(BOrd ord) throws Exception {
        Object object = testStationMonitor;
        synchronized (object) {
            while (stationHandler != null) {
                testStationMonitor.wait();
            }
            stationHandler = new TestStationHandler(ord);
        }
        return stationHandler;
    }

    public static TestStationHandler createTestStation() throws Exception {
        return BTest.createTestStation("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<bajaObjectGraph version=\"1.0\">\r\n<p h=\"1\" m=\"b=baja\" t=\"b:Station\">\r\n</p>\r\n</bajaObjectGraph>");
    }

    @Deprecated
    public BStation getTestStation() {
        if (this.station != null) {
            return this.station;
        }
        this.station = new BStation();
        this.station.setStationName("test");
        BComponentSpace space = new BComponentSpace("station", null, BOrd.make((String)"station:"));
        BLocalHost.INSTANCE.addNavChild((BINavNode)space);
        space.setRootComponent((BComponent)this.station);
        Station.station = this.station;
        Station.space = space;
        Nre.protectedStationHome = new File(Sys.getNiagaraUserHome() + File.separator + "test" + File.separator + "station");
        Nre.stationHome = new File(Nre.protectedStationHome, "shared");
        return this.station;
    }

    @Deprecated
    public void startTestStation() {
        BStation station = this.getTestStation();
        if (station.isRunning()) {
            return;
        }
        Nre.getServiceManager().startAllServices();
        station.start();
        Station.stationStarted = true;
    }

    @Deprecated
    public void stopTestStation() {
        BStation station = this.getTestStation();
        if (!station.isRunning()) {
            return;
        }
        Nre.getServiceManager().stopAllServices();
        station.stop();
        Station.stationStarted = false;
    }

    @Deprecated
    public void clearTestStation() {
        this.stopTestStation();
        this.privateCleanup();
        this.station = null;
    }

    @Deprecated
    void privateCleanup() {
        if (this.station != null) {
            BLocalHost.INSTANCE.removeNavChild((BINavNode)this.station.getSpace());
            Nre.getServiceManager().clearAllServices();
        }
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        s.append('[');
        for (int i = 0; i < a.length; ++i) {
            if (i > 10) {
                s.append(", ...");
                break;
            }
            if (i > 0) {
                s.append(", ");
            }
            s.append(a[i]);
        }
        return s.append(']').toString();
    }

    public boolean isJunit() {
        return this.junit;
    }

    public void setJunit(boolean value) {
        this.junit = value;
    }

    private void pass() {
        if (this.junit) {
            TestRunnerNg.pass();
        } else {
            ++this.verifyCount;
        }
    }

    private void fail(String msg) {
        if (!this.junit) {
            throw new TestException(msg);
        }
        TestRunnerNg.fail(msg);
    }

    private static String asString(int[] a) {
        if (a == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(a[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        testStationMonitor = new Object();
    }

    public static class TestStationHandler
    implements AutoCloseable {
        private BStation station;

        private TestStationHandler(String bog) throws Exception {
            this(new ValueDocDecoder((InputStream)new ByteArrayInputStream(bog.getBytes(StandardCharsets.UTF_8))));
        }

        private TestStationHandler(BOrd ord) throws Exception {
            this(new ValueDocDecoder(ord));
        }

        private TestStationHandler(ValueDocDecoder d) throws Exception {
            BComponentSpace space = new BComponentSpace("station", null, BOrd.make((String)"station:"));
            BLocalHost.INSTANCE.addNavChild((BINavNode)space);
            try {
                Station.space = space;
                this.station = new BStation();
                this.station.setStationName("test");
                if (d != null) {
                    BComponent graph = (BComponent)d.decodeDocument();
                    if (graph instanceof BStation) {
                        this.station = (BStation)graph;
                    } else {
                        this.station.add("test", (BValue)graph, null);
                    }
                }
                Station.station = this.station;
                space.setRootComponent((BComponent)this.station);
                Nre.protectedStationHome = new File(Sys.getNiagaraUserHome() + File.separator + "test" + File.separator + "station");
                Nre.stationHome = new File(Nre.protectedStationHome, "shared");
            }
            catch (Exception e) {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)space);
                throw e;
            }
        }

        public void startStation() {
            if (this.station.isRunning()) {
                return;
            }
            Nre.clearPlatform();
            Nre.loadPlatform();
            Nre.getServiceManager().startAllServices();
            this.station.start();
            Station.stationStarted = true;
            Station.atSteadyState = true;
        }

        public void stopStation() {
            if (this.station == null || !this.station.isRunning()) {
                return;
            }
            this.station.stop();
            Nre.getServiceManager().stopAllServices();
            Nre.clearPlatform();
            Station.stationStarted = false;
            Station.atSteadyState = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseStation() {
            this.stopStation();
            Object object = testStationMonitor;
            synchronized (object) {
                if (this.station != null) {
                    BLocalHost.INSTANCE.removeNavChild((BINavNode)this.station.getSpace());
                    for (BComponent service : Nre.getServiceManager().getAllServices()) {
                        Nre.getServiceManager().unregister((BComponent)((BIService)service));
                    }
                    Nre.getServiceManager().clearAllServices();
                    Station.stationStarted = false;
                    if (this.station.getSlot("test") != null) {
                        this.station.remove("test");
                    }
                    this.station = null;
                    stationHandler = null;
                }
                if (Nre.protectedStationHome != null) {
                    File[] directoriesToClean;
                    for (File directoryToClean : directoriesToClean = new File[]{new File(Nre.protectedStationHome, "history"), new File(Nre.protectedStationHome, "alarm")}) {
                        try {
                            if (!directoryToClean.exists()) continue;
                            FileUtil.deleteDiligently((File)directoryToClean);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to delete directory in the test station: " + e);
                            e.printStackTrace();
                        }
                    }
                }
                testStationMonitor.notify();
            }
        }

        public BStation getStation() {
            return this.station;
        }

        @Override
        public void close() {
            this.releaseStation();
        }
    }
}

