/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.module.NModule;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.testng.CustomTestNG;
import com.tridium.testng.NiagaraAnnotationTransformer;
import com.tridium.testng.RequiresListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.test.BISystemTest;
import javax.baja.test.BTestNg;
import org.testng.Assert;
import org.testng.IMethodInstance;
import org.testng.IResultMap;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.collections.Lists;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.JUnitReportReporter;
import org.testng.reporters.VerboseReporter;
import org.testng.reporters.XMLReporter;
import org.testng.reporters.jq.Main;

public class TestRunnerNg {
    private CustomTestNG testng = null;
    HashSet<ClassLoader> loaders = null;
    private String testJar = null;
    private String xmlPathInJar = null;
    private int verbosity = 0;
    private String groups = null;
    private String excludeGroups = null;
    private String reportDirectory = null;
    private int loopCount = 1;
    private boolean skipHtmlReport = false;
    private boolean generateJunitReport = false;
    private boolean benchmark = false;
    private static Logger LOGGER = Logger.getLogger("TestNG");
    private static final int logFileSize = 10000;
    private static final int logFileCount = 5;
    public static final Logger UTILS_LOGGER = Logger.getLogger("Utils");
    private long failed = 0L;
    private long passed = 0L;
    private long skipped = 0L;
    private BAbsTime start;
    private HashMap<String, Long> testCounts = new HashMap();
    private HashMap<String, Long> suiteCounts = new HashMap();
    private boolean killThreadsOnExit = true;
    private boolean exitOnFailure = true;
    private static final boolean BEEP_ON_FAIL = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.test.beepOnFailure"));
    private static final boolean SKIP_HTML_REPORT = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.test.skipHtmlReport"));
    private static final boolean GENERATE_JUNIT_REPORT = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.test.generateJunitReport"));

    public void run(Type type) {
        this.runFiltered(type, null);
    }

    public void run(Type type, Method method) {
        Predicate<IMethodInstance> filter = null;
        if (method != null) {
            filter = m -> m.getMethod().getMethodName().equals(method.getName());
        }
        this.runFiltered(type, filter);
    }

    public void run(Type type, Pattern pattern) {
        Predicate<IMethodInstance> filter = null;
        if (pattern != null) {
            filter = m -> pattern.matcher(m.getMethod().getMethodName()).find();
        }
        this.runFiltered(type, filter);
    }

    private void runFiltered(Type type, Predicate<IMethodInstance> filter) {
        this.init();
        this.testng.setTestClasses(new Class[]{type.getTypeClass()});
        this.loaders.add(type.getTypeClass().getClassLoader());
        this.addTestNGClassLoaders();
        if (filter != null) {
            this.testng.setMethodInterceptor((methods, context) -> methods.stream().filter(filter).collect(Collectors.toList()));
        }
        this.loop();
        this.end();
    }

    public void run() {
        this.run((Pattern)null);
    }

    public void run(Pattern pattern) {
        TypeInfo[] types;
        this.init();
        List testClasses = Lists.newArrayList();
        for (TypeInfo t : types = Sys.getRegistry().getConcreteTypes(BTestNg.TYPE.getTypeInfo())) {
            try {
                Class clazz = t.getTypeSpec().getResolvedType().getTypeClass();
                if (!t.is(BISystemTest.TYPE) && this.hasMatchingMethods(clazz, pattern)) {
                    testClasses.add(clazz);
                }
                this.loaders.add(clazz.getClassLoader());
            }
            catch (TypeException e) {
                System.err.println("SEVERE [testrunner] can not resolve type: " + t);
                System.err.println("                    reason: " + e.getCause());
                if (!(e.getCause() instanceof OutOfMemoryError)) continue;
                System.gc();
            }
        }
        this.addTestNGClassLoaders();
        this.testng.setTestClasses(testClasses.toArray(new Class[0]));
        if (pattern != null) {
            this.testng.setMethodInterceptor((methods, context) -> methods.stream().filter(m -> this.matches((IMethodInstance)m, pattern)).collect(Collectors.toList()));
        }
        this.loop();
        this.end();
    }

    public void run(ModuleInfo moduleInfo) {
        this.run(new ModuleInfo[]{moduleInfo});
    }

    public void run(ModuleInfo[] moduleInfos) {
        this.init();
        List testClasses = Lists.newArrayList();
        for (ModuleInfo moduleInfo : moduleInfos) {
            TypeInfo[] types;
            if (moduleInfo instanceof NModuleInfo && !((NModuleInfo)moduleInfo).isAutoload()) {
                try {
                    ((NRegistry)Sys.getRegistry()).loadModule(moduleInfo.getModuleName(), moduleInfo.getRuntimeProfile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((NRegistry)Sys.getRegistry()).syncModules();
                moduleInfo = Sys.getRegistry().getModule(moduleInfo.getModuleName(), moduleInfo.getRuntimeProfile());
            }
            for (TypeInfo t : types = moduleInfo.getTypes()) {
                if (t.isAbstract() || !t.is(BTestNg.TYPE) || t.is(BISystemTest.TYPE)) continue;
                testClasses.add(t.getTypeSpec().getResolvedType().getTypeClass());
                this.loaders.add(t.getTypeSpec().getResolvedType().getTypeClass().getClassLoader());
            }
        }
        this.addTestNGClassLoaders();
        this.testng.setTestClasses(testClasses.toArray(new Class[0]));
        if (!testClasses.isEmpty()) {
            this.loop();
        }
        this.end();
    }

    private void loop() {
        if (this.loopCount > 1) {
            for (int i = 1; i <= this.loopCount; ++i) {
                Instant before = Instant.now();
                this.testng.run();
                long gap = Duration.between(before, Instant.now()).toMillis();
                LOGGER.log(Level.INFO, "  Completed loop count = " + i + ", millis = " + gap);
            }
        } else {
            this.testng.run();
        }
    }

    public void init() {
        try {
            AccessController.doPrivileged(() -> {
                NModule tridiumTest = Nre.getModuleManager().loadModule("tridiumTest", RuntimeProfile.wb);
                Class cls = tridiumTest.loadClass("com.tridium.tridiumtest.util.MockitoUtils");
                Method m = cls.getMethod("loadMockito", new Class[0]);
                m.invoke(null, new Object[0]);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "[testrunner]: Error loading Mockito", e);
        }
        if (this.testng == null) {
            this.testng = new CustomTestNG(false);
        }
        this.loaders = new HashSet();
        this.start = BAbsTime.now();
        this.testng.setOutputDirectory(this.getOutputDirectory());
        if (AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().isEmbedded()).booleanValue()) {
            this.testng.setUseDefaultListeners(false);
            SimpleTestListener tla = new SimpleTestListener();
            this.testng.addListener(tla);
            try {
                File testNgDirectory = new File(Nre.niagaraUserHome.getPath() + File.separatorChar + "reports" + File.separatorChar + "testng");
                if (!testNgDirectory.exists() && !testNgDirectory.mkdirs()) {
                    throw new IOException("Failed to create testNG directory \"" + testNgDirectory.getPath() + "\"");
                }
                FileHandler fh = new FileHandler(testNgDirectory.getPath() + File.separatorChar + "TestNG.%g.log", 10000, 5, true);
                fh.setFormatter(new SimpleFormatter());
                LOGGER.addHandler(fh);
            }
            catch (IOException ioe) {
                System.err.println("SEVERE [testrunner] ***LOGGER INIT FAILED*** : " + ioe);
            }
            catch (SecurityException se) {
                System.err.println("SEVERE [testrunner] ***LOGGER INIT FAILED*** : " + se);
            }
            this.testng.setVerbose(0);
            UTILS_LOGGER.setLevel(Level.OFF);
        } else {
            TestListener tla = new TestListener();
            this.testng.addListener(tla);
            this.testng.addListener(new RequiresListener(OperatingSystemEnum.getOS()));
            this.testng.addListener(new NiagaraAnnotationTransformer());
            this.testng.addListener(new BenchmarkTestListener());
            if (!SKIP_HTML_REPORT && !this.skipHtmlReport) {
                this.testng.addListener(new Main());
                this.testng.addListener(new EmailableReporter());
            }
            if (GENERATE_JUNIT_REPORT || this.generateJunitReport) {
                this.testng.addListener(new JUnitReportReporter());
            }
            this.testng.addListener(new XMLReporter());
            if (this.verbosity > 4) {
                this.testng.addListener(new VerboseReporter("[TestNG] "));
            }
        }
        if (this.verbosity != 0) {
            this.testng.setVerbose(this.verbosity);
        } else {
            UTILS_LOGGER.setLevel(Level.OFF);
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            this.testng.setGroups(this.groups);
        }
        if (this.excludeGroups != null && !this.excludeGroups.isEmpty()) {
            this.testng.setExcludedGroups(this.excludeGroups);
        }
    }

    public void end() {
        System.out.println("===============================================");
        System.out.println("Results of all run tests");
        System.out.println("Total tests run: " + (this.passed + this.failed) + ", Failures: " + this.failed + ", Skips: " + this.skipped);
        System.out.println("===============================================");
        System.out.println();
        if (this.benchmark) {
            BAbsTime end = BAbsTime.now();
            System.out.println("Total Time: " + this.start.delta(end).toString(null));
            System.out.println();
            System.out.println("High impact tests:");
            this.sortAndPrintTestTimes(this.getTestCounts());
            System.out.println();
            System.out.println("High impact suites:");
            this.sortAndPrintTestTimes(this.getSuiteCounts());
            System.out.println();
        }
        if (this.killThreadsOnExit) {
            this.killUserThreads();
        }
        try {
            this.wipeOldTestNGClassLoaders();
        }
        catch (Exception e) {
            System.err.println("SEVERE [testrunner] cannot wipe old TestNg class loaders due to Exception");
            e.printStackTrace();
        }
        this.testng = null;
        this.loaders = null;
        if (this.exitOnFailure && this.failed > 0L) {
            System.exit(-1);
        }
    }

    private void sortAndPrintTestTimes(Map<String, Long> counts) {
        counts.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue).reversed()).limit(50L).forEachOrdered(e -> System.out.println("  " + (String)e.getKey() + ": " + e.getValue() + "ms"));
    }

    private void killUserThreads() {
        ThreadGroup parentGroup;
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while ((parentGroup = rootGroup.getParent()) != null) {
            rootGroup = parentGroup;
        }
        Thread[] threads = new Thread[rootGroup.activeCount()];
        while (rootGroup.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        Predicate<Thread> needsTermination = t -> t != null && t != Thread.currentThread() && !t.isDaemon() && !"DestroyJavaVM".equals(t.getName());
        Arrays.stream(threads).filter(needsTermination).findFirst().ifPresent(t -> {
            System.out.println("INFO [testrunner] found running user threads, sleeping to allow potential cleanup");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        threads = new Thread[rootGroup.activeCount()];
        while (rootGroup.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        Arrays.stream(threads).filter(needsTermination).forEach(t -> {
            block15: {
                if (t.getName().equals("JavaFX Application Thread")) {
                    try {
                        System.err.println("SEVERE [testrunner] forcing user thread " + t.getName() + " to terminate specifically.");
                        Class<?> platformImpl = Class.forName("com.sun.javafx.application.PlatformImpl");
                        platformImpl.getDeclaredMethod("tkExit", new Class[0]).invoke(null, new Object[0]);
                        Class<?> platform = Class.forName("javafx.application.Platform");
                        platform.getDeclaredMethod("exit", new Class[0]).invoke(null, new Object[0]);
                        if (t.isAlive()) {
                            Thread.sleep(3000L);
                        } else {
                            System.out.println("INFO [testrunner] " + t.getName() + " has been terminated successfully.");
                        }
                        if (t.isAlive()) {
                            System.err.println("SEVERE [testrunner] " + t.getName() + " will not shutdown, terminating VM with System.exit(-1)");
                            System.exit(-1);
                            break block15;
                        }
                        System.out.println("INFO [testrunner] " + t.getName() + " has been terminated successfully.");
                    }
                    catch (Exception e) {
                        System.err.println("SEVERE [testrunner] cannot cleanup " + t.getName() + " due to Exception");
                        e.printStackTrace();
                        NreLib.dumpThreads();
                    }
                } else {
                    System.err.println("SEVERE [testrunner] forcing user thread " + t.getName() + " to terminate with Thread.interrupt().");
                    StackTraceElement[] st = Thread.getAllStackTraces().get(t);
                    if (st != null) {
                        StringJoiner joiner = new StringJoiner(System.lineSeparator() + "\t");
                        joiner.add("SEVERE [testrunner] stack trace of " + t.getName() + " :");
                        for (StackTraceElement element : st) {
                            joiner.add(element.toString());
                        }
                        System.err.println(joiner);
                    }
                    try {
                        t.interrupt();
                        Thread.sleep(100L);
                        if (t.isAlive()) {
                            Thread.sleep(2000L);
                            if (t.isAlive()) {
                                System.err.println("SEVERE [testrunner] cannot cleanup " + t.getName() + " with Thread.interrupt");
                                NreLib.dumpThreads();
                                Thread.sleep(2000L);
                                System.err.println("SEVERE [testrunner] user " + t.getName() + " did not terminate. This indicates an underlying issue with thread management and should be addressed.");
                            } else {
                                System.out.println("INFO [testrunner] " + t.getName() + " has been interrupted successfully after a small wait.");
                            }
                        } else {
                            System.out.println("INFO [testrunner] " + t.getName() + " has been interrupted successfully.");
                        }
                    }
                    catch (Exception e) {
                        System.err.println("SEVERE [testrunner] cannot cleanup " + t.getName() + " due to Exception");
                        e.printStackTrace();
                        NreLib.dumpThreads();
                    }
                }
            }
        });
    }

    private void addTestNGClassLoaders() {
        if (this.loaders == null) {
            return;
        }
        this.loaders.forEach(this.testng::addClassLoader);
    }

    private void wipeOldTestNGClassLoaders() throws Exception {
        try {
            Class<?> classHelperClass = Class.forName("org.testng.internal.ClassHelper");
            Field listField = classHelperClass.getDeclaredField("classLoaders");
            listField.setAccessible(true);
            List list = (List)listField.get(classHelperClass);
            list.clear();
            Class<?> methodHelperClass = Class.forName("org.testng.internal.MethodHelper");
            Field nameCacheField = methodHelperClass.getDeclaredField("CANONICAL_NAME_CACHE");
            nameCacheField.setAccessible(true);
            Map map = (Map)nameCacheField.get(methodHelperClass);
            map.clear();
        }
        catch (Exception e) {
            System.err.println("SEVERE [testrunner] unable to read properties fro internal TestNg classes clearing old class loaders.");
            e.printStackTrace();
            throw e;
        }
    }

    private boolean hasMatchingMethods(Class<?> clazz, Pattern pattern) {
        return Arrays.stream(clazz.getMethods()).anyMatch(m -> pattern == null || this.matches(clazz, m.getName(), pattern));
    }

    private boolean matches(IMethodInstance m, Pattern pattern) {
        return this.matches(m.getInstance().getClass(), m.getMethod().getMethodName(), pattern);
    }

    private boolean matches(Class<?> clazz, String methodName, Pattern pattern) {
        return pattern.matcher(clazz.getName() + "#" + methodName).find();
    }

    private void loadTestProperties() {
        File testPropsFile = new File(Nre.niagaraHome, "lib" + File.separator + "testng.properties");
        try (FileInputStream in = new FileInputStream(testPropsFile);){
            Properties testProps = new Properties();
            testProps.load(in);
            for (Object o : testProps.keySet()) {
                String key = (String)o;
                if (AccessController.doPrivileged(() -> System.getProperty(key)) != null) continue;
                AccessController.doPrivileged(() -> System.getProperties().setProperty(key, testProps.getProperty(key).trim()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("WARNING [testrunner] cannot load " + testPropsFile + ": File not found");
        }
        catch (Throwable e) {
            System.err.println("SEVERE [testrunner] cannot load " + testPropsFile + ": " + e);
        }
    }

    public String getOutputDirectory() {
        if (this.reportDirectory != null) {
            File outputLocation = new File(this.reportDirectory);
            if (!outputLocation.exists() && !outputLocation.mkdirs()) {
                System.err.println("SEVERE [testrunner] unable to create output directory for reports");
            }
            return this.reportDirectory;
        }
        File defaultOutputLocation = new File(Nre.niagaraUserHome, "reports" + File.separator + "testng");
        if (!defaultOutputLocation.exists() && !defaultOutputLocation.mkdirs()) {
            System.err.println("SEVERE [testrunner] unable to create output directory for reports");
        }
        return defaultOutputLocation.getAbsolutePath();
    }

    private static void beep() {
        if (BEEP_ON_FAIL) {
            System.out.println("\u0007");
        }
    }

    public static void pass() {
        Assert.assertTrue(true);
    }

    public static void fail(String msg) {
        Assert.fail(msg);
    }

    public String getTestJar() {
        return this.testJar;
    }

    public void setTestJar(String testJar) {
        this.testJar = testJar;
    }

    public String getXmlPathInJar() {
        return this.xmlPathInJar;
    }

    public void setXmlPathInJar(String xmlPathInJar) {
        this.xmlPathInJar = xmlPathInJar;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(String excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public boolean isKillThreadsOnExit() {
        return this.killThreadsOnExit;
    }

    public void setKillThreadsOnExit(boolean killThreadsOnExit) {
        this.killThreadsOnExit = killThreadsOnExit;
    }

    public boolean isExitOnFailure() {
        return this.exitOnFailure;
    }

    public void setExitOnFailure(boolean exitOnFailure) {
        this.exitOnFailure = exitOnFailure;
    }

    public long getFailed() {
        return this.failed;
    }

    public long getPassed() {
        return this.passed;
    }

    public long getSkipped() {
        return this.skipped;
    }

    public void setSkipHtmlReport(boolean skipHtmlReport) {
        this.skipHtmlReport = skipHtmlReport;
    }

    public void setGenerateJunitReport(boolean generateJunitReport) {
        this.generateJunitReport = generateJunitReport;
    }

    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    public Map<String, Long> getTestCounts() {
        return Collections.unmodifiableMap(this.testCounts);
    }

    public Map<String, Long> getSuiteCounts() {
        return Collections.unmodifiableMap(this.suiteCounts);
    }

    private class BenchmarkTestListener
    implements ITestListener {
        long start;
        long end;

        private BenchmarkTestListener() {
        }

        @Override
        public void onTestStart(ITestResult iTestResult) {
            this.start = iTestResult.getStartMillis();
        }

        @Override
        public void onTestSuccess(ITestResult iTestResult) {
            this.endTest(iTestResult);
        }

        @Override
        public void onTestFailure(ITestResult iTestResult) {
            this.endTest(iTestResult);
        }

        @Override
        public void onTestSkipped(ITestResult iTestResult) {
            this.start = iTestResult.getStartMillis();
            this.endTest(iTestResult);
        }

        @Override
        public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
            this.endTest(iTestResult);
        }

        private void endTest(ITestResult result) {
            long time = result.getEndMillis() - this.start;
            TestRunnerNg.this.testCounts.compute(result.getMethod().getQualifiedName(), (k, v) -> v == null ? time : time + v);
        }

        @Override
        public void onStart(ITestContext iTestContext) {
        }

        @Override
        public void onFinish(ITestContext iTestContext) {
            Date end = iTestContext.getEndDate();
            Date start = iTestContext.getStartDate();
            long delta = end.getTime() - start.getTime();
            TestRunnerNg.this.suiteCounts.compute(iTestContext.getSuite().getName(), (k, v) -> v == null ? delta : delta + v);
        }
    }

    public class SimpleTestListener
    extends TestListenerAdapter {
        @Override
        public void onFinish(ITestContext tc) {
            IResultMap failedMap = tc.getFailedTests();
            TestRunnerNg.this.failed = TestRunnerNg.this.failed + (long)failedMap.size();
            TestRunnerNg.this.passed = TestRunnerNg.this.passed + (long)tc.getPassedTests().size();
            if (TestRunnerNg.this.verbosity != 0) {
                LOGGER.log(Level.FINE, "TestNG Summary: passed = " + TestRunnerNg.this.passed + ", failed = " + TestRunnerNg.this.failed);
            }
        }
    }

    public class TestListener
    extends TestListenerAdapter {
        @Override
        public void onTestFailure(ITestResult failure) {
            if (TestRunnerNg.this.verbosity != 0) {
                System.out.println(" TestNG Test Failed: " + failure.getName() + " - " + failure.getThrowable());
            }
        }

        @Override
        public void onTestSkipped(ITestResult skip) {
            if (TestRunnerNg.this.verbosity != 0) {
                System.out.println(" TestNG Test Skipped: " + skip.getName());
            }
        }

        @Override
        public void onTestSuccess(ITestResult success) {
            if (TestRunnerNg.this.verbosity != 0) {
                System.out.println(" TestNG Test Ended: " + success.getName());
            }
        }

        @Override
        public void onFinish(ITestContext tc) {
            IResultMap failedMap = tc.getFailedTests();
            TestRunnerNg.this.failed = TestRunnerNg.this.failed + (long)failedMap.size();
            TestRunnerNg.this.passed = TestRunnerNg.this.passed + (long)tc.getPassedTests().size();
            TestRunnerNg.this.skipped = TestRunnerNg.this.skipped + (long)tc.getSkippedTests().size();
            Set<ITestResult> failures = failedMap.getAllResults();
            if (failures.isEmpty()) {
                return;
            }
            System.out.println("\n*** TestNG Failure Summary ***");
            TestRunnerNg.beep();
            for (ITestResult result : failures) {
                Throwable err = result.getThrowable();
                System.out.print(" TestNG Test Failed: " + result.getName());
                if (err == null) {
                    System.out.println();
                } else {
                    System.out.println(" - " + err);
                }
                if (TestRunnerNg.this.verbosity == 0 || err == null) continue;
                System.out.println(" TestNG Error Stack Trace: ");
                err.printStackTrace();
            }
        }
    }
}

