/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.authn.AuthenticationClient;
import java.util.Optional;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BICredentials;
import javax.baja.security.BIPreconnectCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.sys.BIObject;

public class TestCertAuthenticationClient
implements AuthenticationClient {
    private final String username;
    private final String clientCertAlias;
    private final BPassword certPassword;
    private BIPreconnectCredentials preconnectCredentials;

    public TestCertAuthenticationClient(String username, String clientCertAlias, BPassword certPassword) {
        this.username = username;
        this.clientCertAlias = clientCertAlias;
        this.certPassword = certPassword;
    }

    public BIUserCredentials requestUsername(AuthenticationRealm realm) {
        return new BUsernameCredential(this.username);
    }

    public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
        BCertificateAliasCredential certCred = new BCertificateAliasCredential();
        certCred.setUsername(this.username);
        certCred.setCertificateAlias(this.clientCertAlias);
        certCred.setCertificatePassword(this.certPassword);
        return certCred;
    }

    public void setPreconnectCredentials(BIPreconnectCredentials credentials) {
        this.preconnectCredentials = credentials;
    }

    public Optional<BIPreconnectCredentials> getPreconnectCredentials() {
        if (this.preconnectCredentials == null) {
            BCertificateAliasCredential credential = new BCertificateAliasCredential();
            credential.setUsername(this.username);
            credential.setCertificateAlias(this.clientCertAlias);
            credential.setCertificatePassword(this.certPassword);
            this.preconnectCredentials = credential;
        }
        return Optional.of(this.preconnectCredentials);
    }

    public String toString() {
        String pswd = "UNKNOWN";
        try {
            pswd = this.certPassword.getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.toString() + " [username=" + this.username + ", clientCertAlias=" + this.clientCertAlias + ", certPassword=" + pswd + ']';
    }
}

