/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.fox.sys.BFoxService;
import com.tridium.template.file.BINtplFile;
import java.io.IOException;
import java.util.Objects;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.firewall.BServerPort;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BAes256Pbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebService;

public final class StationBuilder {
    private static final boolean COPY_EXACT = true;
    private String templatePath = null;
    private String stationName = null;
    private String adminUsername = null;
    private String adminPassword = null;
    private String operatorUsername = null;
    private String operatorPassword = null;
    private boolean useHttp = false;
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private boolean useFox = false;
    private int foxPort = 1911;
    private int foxsPort = 4911;

    private StationBuilder() {
    }

    public static StationBuilder builder() {
        return new StationBuilder();
    }

    public BStation build() throws IOException {
        BStation station;
        Objects.requireNonNull(this.templatePath);
        Objects.requireNonNull(this.stationName);
        Objects.requireNonNull(this.adminUsername);
        Objects.requireNonNull(this.adminPassword);
        try (BINtplFile stationTemplate = (BINtplFile)BFileSystem.INSTANCE.findFile(new FilePath(this.templatePath));){
            station = (BStation)stationTemplate.getBaseComponent().newCopy(true);
        }
        station.setCategoryMask(BCategoryMask.make((String)"1"), null);
        station.setStationName(this.stationName);
        BRoleService roleService = ((BRoleService[])station.getServices().getChildren(BRoleService.class))[0];
        BRole role = new BRole();
        role.setPermissions(BPermissionsMap.make((BPermissions[])new BPermissions[]{null, BPermissions.make((String)"rwi")}));
        roleService.add("operator", (BValue)role);
        BUserService userService = ((BUserService[])station.getServices().getChildren(BUserService.class))[0];
        this.addUser(userService, this.adminUsername, this.adminPassword, "admin");
        if (this.operatorUsername != null) {
            this.addUser(userService, this.operatorUsername, this.operatorPassword, "operator");
        }
        userService.getUser("admin").setAuthenticator((BAbstractAuthenticator)new BPasswordAuthenticator(BPassword.make((String)"", (String)BAes256Pbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
        BFoxService foxService = ((BFoxService[])station.getServices().getChildren(BFoxService.class))[0];
        foxService.setFoxEnabled(this.useFox);
        foxService.setFoxPort(new BServerPort(this.foxPort));
        foxService.setFoxsPort(new BServerPort(this.foxsPort));
        BWebService webService = ((BWebService[])station.getServices().getChildren(BWebService.class))[0];
        webService.setHttpEnabled(this.useHttp);
        webService.setHttpPort(new BServerPort(this.httpPort));
        webService.setHttpsPort(new BServerPort(this.httpsPort));
        return station;
    }

    private void addUser(BUserService userService, String username, String password, String roles) {
        BUser user = userService.getUser(username);
        if (user == null) {
            user = new BUser();
            userService.add(username, (BValue)user);
        }
        user.setAuthenticator((BAbstractAuthenticator)new BPasswordAuthenticator(BPassword.make((String)password, (String)BAes256Pbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
        user.setRoles(roles);
    }

    public StationBuilder withTemplateFile(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public StationBuilder withStationName(String stationName) {
        this.stationName = stationName;
        return this;
    }

    public StationBuilder withAdminCredentials(String adminUsername, String adminPassword) {
        this.adminUsername = adminUsername;
        this.adminPassword = adminPassword;
        return this;
    }

    public StationBuilder withOperatorCredentials(String operatorUsername, String operatorPassword) {
        this.operatorUsername = operatorUsername;
        this.operatorPassword = operatorPassword;
        return this;
    }

    public StationBuilder withHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public StationBuilder withHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public StationBuilder useHttp() {
        this.useHttp = true;
        return this;
    }

    public StationBuilder withFoxPort(int foxPort) {
        this.foxPort = foxPort;
        return this;
    }

    public StationBuilder withFoxsPort(int foxsPort) {
        this.foxsPort = foxsPort;
        return this;
    }

    public StationBuilder useFox() {
        this.useFox = true;
        return this;
    }
}

