/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart.binding;

import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="valueType", type="BTypeSpec", defaultValue="BTypeSpec.NULL"), @NiagaraProperty(name="min", type="BAxisBound", defaultValue="BAxisBound.makeAuto()"), @NiagaraProperty(name="max", type="BAxisBound", defaultValue="BAxisBound.makeAuto()")})
public class BAxisSpec
extends BStruct {
    @Generated
    public static final Property valueType = BAxisSpec.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property min = BAxisSpec.newProperty((int)0, (BValue)BAxisBound.makeAuto(), null);
    @Generated
    public static final Property max = BAxisSpec.newProperty((int)0, (BValue)BAxisBound.makeAuto(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAxisSpec.class);

    @Generated
    public BTypeSpec getValueType() {
        return (BTypeSpec)this.get(valueType);
    }

    @Generated
    public void setValueType(BTypeSpec v) {
        this.set(valueType, (BValue)v, null);
    }

    @Generated
    public BAxisBound getMin() {
        return (BAxisBound)this.get(min);
    }

    @Generated
    public void setMin(BAxisBound v) {
        this.set(min, (BValue)v, null);
    }

    @Generated
    public BAxisBound getMax() {
        return (BAxisBound)this.get(max);
    }

    @Generated
    public void setMax(BAxisBound v) {
        this.set(max, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAxisSpec() {
    }

    public BAxisSpec(BTypeSpec valueType) {
        this.setValueType(valueType);
    }

    public BAxisSpec(BTypeSpec valueType, BSimple min, BSimple max) {
        Type resType = valueType.getResolvedType();
        if (!min.getType().is(resType)) {
            throw new IllegalArgumentException("Type mismatch: min type (" + min.getType().getTypeSpec() + ") != " + resType.getTypeSpec());
        }
        if (!max.getType().is(resType)) {
            throw new IllegalArgumentException("Type mismatch: max type (" + max.getType().getTypeSpec() + ") != " + resType.getTypeSpec());
        }
        this.setValueType(valueType);
        this.setMin(BAxisBound.make((BSimple)min));
        this.setMax(BAxisBound.make((BSimple)max));
    }

    public BAxisSpec(BTypeSpec valueType, BAxisBound min, BAxisBound max) {
        Type resType = valueType.getResolvedType();
        if (!min.isAuto() && !min.getValue().getType().equals(resType)) {
            throw new IllegalArgumentException("Type mismatch: min type (" + min.getValue().getType().getTypeSpec() + ") != " + resType.getTypeSpec());
        }
        if (!max.isAuto() && !max.getValue().getType().equals(resType)) {
            throw new IllegalArgumentException("Type mismatch: max type (" + max.getValue().getType().getTypeSpec() + ") != " + resType.getTypeSpec());
        }
        this.setValueType(valueType);
        this.setMin(min);
        this.setMax(max);
    }

    public static BAxisSpec makeNull() {
        return new BAxisSpec();
    }

    public boolean isNull() {
        return this.getValueType().isNull();
    }

    public BAxis toAxis(Series series, int column, BAxisDimension dim) {
        AgentList agents;
        AgentList axes;
        BTypeSpec valueTypeSpec = this.getValueType();
        Type columnType = series.getColumnType(column);
        BAxis axis = null;
        if (valueTypeSpec.isNull()) {
            valueTypeSpec = columnType.getTypeSpec();
        }
        if ((axis = (axes = (agents = Sys.getRegistry().getAgents(valueTypeSpec.getTypeInfo())).filter(AgentFilter.is((Type)BAxis.TYPE))).size() == 0 ? new BDiscreteAxis() : (BAxis)axes.getDefault().getInstance()) instanceof BDiscreteAxis) {
            ((BDiscreteAxis)axis).setRange(BDiscreteAxis.extractRange(series, column));
        } else {
            BAxisBound min = this.getMin();
            BAxisBound max = this.getMax();
            axis.setMinAuto(min.isAuto());
            if (!min.isAuto()) {
                axis.setAxisMin(min.getValue());
            }
            axis.setMaxAuto(max.isAuto());
            if (!max.isAuto()) {
                axis.setAxisMax(max.getValue());
            }
        }
        BFacets columnFacets = series.getColumnFacets(column);
        if (null == columnFacets) {
            columnFacets = BFacets.DEFAULT;
        }
        axis.updateFacets(columnFacets);
        axis.setDimension(dim);
        return axis;
    }

    public String toString(Context cx) {
        BTypeSpec type = this.getValueType();
        if (type.isNull()) {
            return "null";
        }
        StringBuilder s = new StringBuilder(64);
        s.append(type.toString(cx));
        s.append("   ");
        s.append("min=" + this.getMin().toString(cx));
        s.append("   max=" + this.getMax().toString(cx));
        return s.toString();
    }
}

