/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.baja.chart.BContinuousAxis;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"baja:INumeric"})})
public class BNumericAxis
extends BContinuousAxis {
    @Generated
    public static final Type TYPE = Sys.loadType(BNumericAxis.class);
    public static final Lexicon lex = Lexicon.make(BNumericAxis.class);
    private static final String ERR_PARSE_FORMAT = "chart.axis.numeric.error.parse";
    private static final double LOG10E = 0.4342944819018;
    private static final BDouble ZERO = BDouble.make((double)0.0);
    private double min = 0.0;
    private double max = 0.0;
    private boolean initMin = true;
    private boolean initMax = true;
    private double tickIncrement;
    private BINumeric[] tickValues;
    private DecimalFormat format;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNumericAxis() {
        this.format = new DecimalFormat("###,###,###,##0.00");
    }

    public BNumericAxis(Object min, Object max) {
        this();
        this.min = ((BINumeric)min).getNumeric();
        this.max = ((BINumeric)max).getNumeric();
    }

    public BNumericAxis(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public Type getValueType() {
        return BINumeric.TYPE;
    }

    @Override
    public Object getAxisMin() {
        if (this.min == this.max) {
            this.expandRangeForConstant();
        }
        return BDouble.make((double)this.min);
    }

    @Override
    public void setAxisMin(Object newMin) {
        double v = ((BINumeric)newMin).getNumeric();
        Double d = v;
        if (d.isNaN()) {
            return;
        }
        this.min = v;
    }

    @Override
    public void updateAutoMin(Object newMin) {
        double v = ((BINumeric)newMin).getNumeric();
        Double d = v;
        if (d.isNaN()) {
            return;
        }
        if (this.initMin) {
            this.min = v;
            this.initMin = false;
        } else {
            this.min = Math.min(this.min, v);
        }
    }

    @Override
    public Object getAxisMax() {
        if (this.min == this.max) {
            this.expandRangeForConstant();
        }
        return BDouble.make((double)this.max);
    }

    @Override
    public void setAxisMax(Object newMax) {
        double v = ((BINumeric)newMax).getNumeric();
        Double d = v;
        if (d.isNaN()) {
            return;
        }
        this.max = v;
    }

    @Override
    public void updateAutoMax(Object newMax) {
        double v = ((BINumeric)newMax).getNumeric();
        Double d = v;
        if (d.isNaN()) {
            return;
        }
        if (this.initMax) {
            this.max = v;
            this.initMax = false;
        } else {
            this.max = Math.max(this.max, v);
        }
    }

    private void expandRangeForConstant() {
        if (this.min != this.max) {
            return;
        }
        double mid = this.min;
        if (this.isMinAuto()) {
            this.min = mid - 10.0;
        }
        if (this.isMaxAuto()) {
            this.max = mid + 10.0;
        }
    }

    private void expandRangeForTicks() {
        double maxTick;
        if (this.tickValues == null || this.tickValues.length > 3) {
            return;
        }
        double minTick = this.tickValues[0].getNumeric();
        if (this.min > minTick) {
            this.min = minTick;
        }
        if (this.max < (maxTick = this.tickValues[this.tickValues.length - 1].getNumeric())) {
            this.max = maxTick;
        }
    }

    @Override
    public void reset() {
        if (this.isMinAuto()) {
            this.initMin = true;
            this.min = 0.0;
        }
        if (this.isMaxAuto()) {
            this.initMax = true;
            this.max = 100.0;
        }
    }

    @Override
    public double toPercentOfRange(Object value) {
        return (((BINumeric)value).getNumeric() - this.min) / (this.max - this.min);
    }

    @Override
    public Object fromPercentOfRange(double percent) {
        double result = this.min + (this.max - this.min) * percent;
        return BDouble.make((double)result);
    }

    @Override
    public Object getZero() {
        return ZERO;
    }

    @Override
    public void doLayout() {
        double delta = this.max - this.min;
        double log10 = Math.log(delta) * 0.4342944819018;
        this.tickIncrement = Math.max((float)Math.pow(10.0, Math.round(log10) - 2L), Float.MIN_VALUE);
        if (delta > 10.0 && this.tickIncrement < 5.0) {
            this.tickIncrement = 5.0;
        }
        try {
            this.tickIncrement = this.format.parse(this.format.format(this.tickIncrement)).doubleValue();
            double precision = Math.pow(10.0, -this.getFacets().geti("precision", 2));
            if (this.tickIncrement < precision) {
                this.tickIncrement = precision;
            }
        }
        catch (ParseException e) {
            log.severe(lex.getText(ERR_PARSE_FORMAT, new Object[]{this.tickIncrement}));
        }
        int tickCount = (int)(delta / this.tickIncrement) + 1;
        while (tickCount > 20) {
            this.tickIncrement = this.tickIncrement == 1.0 ? (this.tickIncrement *= 10.0) : (this.tickIncrement *= 2.0);
            tickCount = (int)(delta / this.tickIncrement);
        }
        double minTick = this.min;
        if ((minTick = (double)Math.round(minTick)) > this.min) {
            try {
                minTick -= this.tickIncrement;
                if (minTick > this.min) {
                    minTick = this.min - this.tickIncrement;
                }
                minTick = this.format.parse(this.format.format(minTick)).doubleValue();
            }
            catch (ParseException e) {
                log.severe(lex.getText(ERR_PARSE_FORMAT, new Object[]{this.tickIncrement}));
            }
        }
        double maxTick = this.max;
        if ((maxTick = (double)Math.round(maxTick)) < this.max) {
            maxTick = minTick + this.tickIncrement * ((this.max - minTick) / this.tickIncrement + 1.0);
        }
        tickCount = (int)((maxTick - minTick) / this.tickIncrement) + 1;
        this.tickValues = new BINumeric[tickCount];
        double tickVal = minTick;
        for (int i = 0; i < tickCount; ++i) {
            this.tickValues[i] = BDouble.make((double)tickVal);
            tickVal += this.tickIncrement;
        }
        if (tickCount <= 3) {
            this.expandRangeForTicks();
        }
    }

    @Override
    public Object[] getTickValues() {
        return this.tickValues;
    }

    @Override
    public String valueToString(Object value) {
        return this.format.format(((BINumeric)value).getNumeric());
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public boolean validateZoom(Object zoomMin, Object zoomMax) {
        double zmin = ((BINumeric)zoomMin).getNumeric();
        double zmax = ((BINumeric)zoomMax).getNumeric();
        if (zmax - zmin < 0.01) {
            return false;
        }
        return super.validateZoom(zoomMin, zoomMax);
    }

    @Override
    public BFacets updateFacets(BFacets newFacets) {
        if (null == newFacets) {
            newFacets = BFacets.DEFAULT;
        }
        int prec = newFacets.geti("precision", 2);
        StringBuilder s = new StringBuilder("###,###,###,##0");
        for (int i = 0; i < prec; ++i) {
            if (i == 0) {
                s.append(".");
            }
            s.append("0");
        }
        this.format = BNumericAxis.getLocalizedDecimalFormat(s);
        return super.updateFacets(newFacets);
    }

    private static DecimalFormat getLocalizedDecimalFormat(StringBuilder formatString) {
        BUser user = BUser.getCurrentAuthenticatedUser();
        if (null != user) {
            Locale locale = new Locale(user.getLanguage());
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
            return new DecimalFormat(formatString.toString(), dfs);
        }
        return new DecimalFormat(formatString.toString());
    }
}

