/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.TableSeries;
import javax.baja.chart.TrendFlags;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BLineChart
extends BChart {
    @Generated
    public static final Type TYPE = Sys.loadType(BLineChart.class);
    private BPen defaultPen = BPen.make((double)1.0);
    private static final double[] DASHED = new double[]{1.0, 2.0};
    private BPen dashedPen = BPen.make((double)1.0, (double[])DASHED);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLineChart() {
    }

    public BLineChart(ChartModel model) {
        super(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doPaint(Graphics g) {
        int xcol = 0;
        int ycol = 1;
        g.push();
        try {
            ChartModel model = this.getModel();
            int specCount = model.getSpecCount();
            for (int i = 0; i < specCount; ++i) {
                ChartSpec spec = model.getSpec(i);
                BAxis xaxis = spec.getXAxis();
                BAxis yaxis = spec.getYAxis();
                Series series = spec.getSeries();
                g.setBrush(series.getBrush());
                boolean interpolateTail = BLineChart.interpolateTail(series);
                boolean isTime = xaxis.getValueType().is(BAbsTime.TYPE);
                double nextX = Double.NaN;
                double nextY = Double.NaN;
                double lastX = Double.NaN;
                double lastY = Double.NaN;
                BPen pen = series.getPen();
                if (pen == null) {
                    pen = this.defaultPen;
                }
                g.setPen(pen);
                int rowCount = series.getRowCount();
                boolean lastHidden = false;
                boolean count = false;
                for (int row = 0; row < rowCount; ++row) {
                    double y;
                    double x;
                    int trendFlags = series.getTrendFlags(row);
                    if (TrendFlags.isHidden((int)trendFlags)) {
                        lastHidden = true;
                        continue;
                    }
                    if (Double.isNaN(nextX) || Double.isNaN(nextY)) {
                        Object xval = series.getValue(row, xcol);
                        Object yval = series.getValue(row, ycol);
                        if (xval == null || yval == null) continue;
                        x = xaxis.toDisplaySpace(xval);
                        y = yaxis.toDisplaySpace(yval);
                    } else {
                        x = nextX;
                        y = nextY;
                        nextX = Double.NaN;
                        nextY = Double.NaN;
                    }
                    if (!(lastHidden || row <= 0 || Double.isNaN(lastY) || Double.isNaN(lastX) || TrendFlags.isStart((int)trendFlags))) {
                        int nexttrendFlags;
                        for (int nextRow = row + 1; nextRow < rowCount && !TrendFlags.isHidden((int)(nexttrendFlags = series.getTrendFlags(nextRow))) && !TrendFlags.isStart((int)nexttrendFlags); ++nextRow) {
                            Object nextxval = series.getValue(nextRow, xcol);
                            Object nextyval = series.getValue(nextRow, ycol);
                            if (nextxval == null || nextyval == null) break;
                            nextX = xaxis.toDisplaySpace(nextxval);
                            nextY = yaxis.toDisplaySpace(nextyval);
                            if (!(x - lastX != 0.0 && y - lastY != 0.0 && Math.abs((y - lastY) / (x - lastX) * (nextX - x) + y - nextY) < 2.0 && Math.abs((x - lastX) / (y - lastY) * (nextY - y) + x - nextX) < 2.0 || (int)(x - lastX) == 0 && (int)(lastX - nextX) == 0 && this.signum(y - lastY) == this.signum(nextY - y) || (int)(y - lastY) == 0 && (int)(lastY - nextY) == 0 && this.signum(x - lastX) == this.signum(nextX - x)) && ((int)(x - lastX) != 0 || (int)(y - lastY) != 0)) break;
                            x = nextX;
                            y = nextY;
                            nextX = Double.NaN;
                            nextY = Double.NaN;
                            ++row;
                        }
                    }
                    if (row != 0 && !lastHidden && !TrendFlags.isStart((int)trendFlags)) {
                        g.strokeLine(lastX, lastY, x, y);
                    }
                    lastHidden = false;
                    lastX = x;
                    lastY = y;
                }
                if (!interpolateTail || !isTime || Double.isNaN(lastX) || Double.isNaN(lastY)) continue;
                BPen save = g.getPen();
                g.setPen(this.dashedPen);
                double nowX = xaxis.toDisplaySpace(BAbsTime.now());
                double fullX = xaxis.getFullLength();
                if (nowX > fullX) {
                    nowX = fullX;
                }
                g.strokeLine(lastX, lastY, nowX, lastY);
                g.setPen(save);
            }
        }
        finally {
            g.pop();
        }
    }

    protected static boolean interpolateTail(Series series) {
        if (series instanceof TableSeries) {
            return ((TableSeries)series).shouldInterpolateTail();
        }
        return false;
    }

    protected static Context getContext(Series series) {
        if (series instanceof TableSeries) {
            return ((TableSeries)series).getContext();
        }
        return null;
    }

    private int signum(double value) {
        if (value < 0.0) {
            return -1;
        }
        if (value > 0.0) {
            return 1;
        }
        return 0;
    }
}

