/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="title", type="String", defaultValue=""), @NiagaraProperty(name="titleFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="subtitle", type="String", defaultValue=""), @NiagaraProperty(name="subtitleFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="brush", type="BBrush", defaultValue="BColor.black.toBrush()")})
public class BChartHeader
extends BWidget {
    @Generated
    public static final Property title = BChartHeader.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property titleFont = BChartHeader.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property subtitle = BChartHeader.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property subtitleFont = BChartHeader.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property brush = BChartHeader.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BChartHeader.class);
    private static Lexicon lex = Lexicon.make((String)"chart");
    private static BFont defTitleFont = BFont.make((String)lex.getText("chart.header.title.font"));
    private static BFont defSubtitleFont = BFont.make((String)lex.getText("chart.header.subtitle.font"));

    @Generated
    public String getTitle() {
        return this.getString(title);
    }

    @Generated
    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    @Generated
    public BFont getTitleFont() {
        return (BFont)this.get(titleFont);
    }

    @Generated
    public void setTitleFont(BFont v) {
        this.set(titleFont, (BValue)v, null);
    }

    @Generated
    public String getSubtitle() {
        return this.getString(subtitle);
    }

    @Generated
    public void setSubtitle(String v) {
        this.setString(subtitle, v, null);
    }

    @Generated
    public BFont getSubtitleFont() {
        return (BFont)this.get(subtitleFont);
    }

    @Generated
    public void setSubtitleFont(BFont v) {
        this.set(subtitleFont, (BValue)v, null);
    }

    @Generated
    public BBrush getBrush() {
        return (BBrush)this.get(brush);
    }

    @Generated
    public void setBrush(BBrush v) {
        this.set(brush, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BChartHeader() {
    }

    public BChartHeader(String title, String subtitle) {
        this.setTitle(title);
        this.setSubtitle(subtitle);
    }

    public void computePreferredSize() {
        String sub;
        double w = 0.0;
        double h = 0.0;
        String title = this.getTitle();
        if (title.length() != 0) {
            BFont tf = this.getTitleFont();
            if (tf.isNull()) {
                tf = defTitleFont;
            }
            w = tf.width(title) + 8.0;
            h = tf.getHeight() + 4.0;
        }
        if ((sub = this.getSubtitle()).length() != 0) {
            BFont sf = this.getSubtitleFont();
            if (sf.isNull()) {
                sf = defSubtitleFont;
            }
            w = Math.max(w, sf.width(sub) + 8.0);
            h += sf.getHeight() + 4.0;
        }
        h = h != 0.0 ? (h += 4.0) : (h += 10.0);
        this.setPreferredSize(w, h);
    }

    public void paint(Graphics g) {
        double y = 0.0;
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(this.getBrush());
        String title = this.getTitle();
        if (title.length() != 0) {
            BFont tf = this.getTitleFont();
            if (tf.isNull()) {
                tf = defTitleFont;
            }
            y = tf.getHeight();
            double x = (w - tf.width(title)) / 2.0;
            g.setFont(tf);
            g.drawString(title, x, y);
            y += 4.0;
        }
        String sub = this.getSubtitle();
        if (title.length() != 0) {
            BFont sf = this.getSubtitleFont();
            if (sf.isNull()) {
                sf = defSubtitleFont;
            }
            double x = (w - sf.width(sub)) / 2.0;
            g.setFont(sf);
            g.drawString(sub, x, y += sf.getHeight());
            y += 4.0;
        }
    }

    public boolean receiveInputEvents() {
        return false;
    }
}

