/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.util;

import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class ClientSideNativeLibraryLoader {
    public static final Logger log = Logger.getLogger(ClientSideNativeLibraryLoader.class.getName());
    protected static String niagaraHomeBinStr;
    protected static File niagaraHomeBin;

    protected static void findNiagaraHomeBinDir() {
        niagaraHomeBinStr = Nre.getNiagaraHome().getAbsolutePath() + File.separator + "bin";
        niagaraHomeBin = new File(niagaraHomeBinStr);
    }

    protected static void loadLibraryFromThisModule(String libName) {
        AccessController.doPrivileged(() -> {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Extracting:> " + libName);
            }
            ClientSideNativeLibraryLoader.extractLibraryFromThisModule(libName);
            try {
                if (libName.contains(".dll")) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("JNI Loading:> " + libName);
                    }
                    System.loadLibrary(libName.substring(0, libName.indexOf(".dll")));
                }
            }
            catch (Throwable throwable) {
                log.log(Level.SEVERE, "Could not load the third party library '" + libName + "'", throwable);
            }
            return null;
        });
    }

    protected static void extractLibraryFromThisModule(String libName) {
        File libraryDest;
        BModule xprotectMod = Sys.loadModule((String)"xprotect");
        FilePath resourceFilePath = new FilePath("nativeLib/" + libName);
        BIFile resourceFile = xprotectMod.resolveFile(resourceFilePath);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "niagaraHomeBin = '" + niagaraHomeBin + "'");
        }
        if ((libraryDest = new File(niagaraHomeBin, libName)).exists()) {
            try {
                FileUtil.delete((File)libraryDest);
            }
            catch (IOException ioException) {
                log.log(Level.SEVERE, "Exception occurred while deleting the existing file '" + libName + "'", ioException);
            }
        }
        try (FileOutputStream libraryDestOut = new FileOutputStream(libraryDest);
             InputStream libraryBytesInJar = resourceFile.getInputStream();){
            int n;
            byte[] buf = new byte[40960];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Using 40K buffer for module read");
            }
            while ((n = libraryBytesInJar.read(buf)) != -1) {
                libraryDestOut.write(buf, 0, n);
            }
        }
        catch (IOException ioException) {
            log.log(Level.SEVERE, "IOException occurred while extracting '" + libName + "'", ioException);
        }
    }

    static {
        ClientSideNativeLibraryLoader.findNiagaraHomeBinDir();
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Platform.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Platform.SDK.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("Microsoft.ApplicationInsights.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Common.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Common.EnvironmentServices.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Common.Login.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Common.State.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.IdentityServer.Common.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Platform.Common.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Telemetry.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Utilities.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("Autofac.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("XProtectBridgeService.exe");
    }
}

