/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.camera;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.web.rpc.BChangeUserPasswordRpc;
import com.tridium.xprotect.BMilestoneXProtectNetwork;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import com.tridium.xprotect.camera.BXProtectCameraInfo;
import com.tridium.xprotect.camera.BXProtectStopRecordingModeEnum;
import com.tridium.xprotect.camera.XProtectMjpegVideoDecoder;
import com.tridium.xprotect.event.BXProtectEventCameraExt;
import com.tridium.xprotect.event.BXProtectVideoEventRecall;
import com.tridium.xprotect.messages.XProtectCameraInitiateRecordingReq;
import com.tridium.xprotect.messages.XProtectCameraPingReq;
import com.tridium.xprotect.messages.XProtectCameraPingRsp;
import com.tridium.xprotect.messages.XProtectMoveToPresetReq;
import com.tridium.xprotect.messages.XProtectPanTiltReq;
import com.tridium.xprotect.messages.XProtectVideoStreamReq;
import com.tridium.xprotect.messages.XProtectZoomReq;
import com.tridium.xprotect.server.management.BXProtectManagementConnection;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.server.recording.BXProtectRecordingServer;
import com.tridium.xprotect.soap.IMIPService;
import com.tridium.xprotect.util.WebProcessUtil;
import com.tridium.xprotect.util.XProtectVideoStreamUtil;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="videoDeviceId", type="BVideoDeviceId", defaultValue="new BXProtectCameraDeviceId()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}, override=true), @NiagaraProperty(name="ptzSupport", type="BVideoCameraInfo", defaultValue="new BXProtectCameraInfo()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN)")}, override=true), @NiagaraProperty(name="fastSpeed", type="int", defaultValue="10", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN, sf)")}), @NiagaraProperty(name="events", type="BPointDeviceExt", defaultValue="new BXProtectEventCameraExt()"), @NiagaraProperty(name="eventRecaller", type="BVideoEventRecall", defaultValue="new BXProtectVideoEventRecall()", flags=6), @NiagaraProperty(name="presetText", type="BEnumRange", defaultValue="BEnumRange.DEFAULT", flags=1), @NiagaraProperty(name="stopRecordingMode", type="BXProtectStopRecordingModeEnum", defaultValue="BXProtectStopRecordingModeEnum.onTimer", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN)")})})
@NiagaraActions(value={@NiagaraAction(name="getPresetList"), @NiagaraAction(name="moveToPreset", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.make(0, (BEnumRange)presetText.getDefaultValue())", flags=20, override=true), @NiagaraAction(name="storePreset", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.make(0, (BEnumRange)presetText.getDefaultValue())", flags=20, override=true)})
public class BXProtectCamera
extends BVideoCamera
implements BIVideoAlarmRecorder,
BIVideoEventProvider {
    private static BFacets sf = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)15));
    @Generated
    public static final Property videoDeviceId = BXProtectCamera.newProperty((int)0, (BValue)new BXProtectCameraDeviceId(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property ptzSupport = BXProtectCamera.newProperty((int)0, (BValue)new BXProtectCameraInfo(), (BFacets)SfUtil.incl((String)"ed.un"));
    @Generated
    public static final Property fastSpeed = BXProtectCamera.newProperty((int)0, (int)10, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)sf));
    @Generated
    public static final Property events = BXProtectCamera.newProperty((int)0, (BValue)new BXProtectEventCameraExt(), null);
    @Generated
    public static final Property eventRecaller = BXProtectCamera.newProperty((int)6, (BValue)new BXProtectVideoEventRecall(), null);
    @Generated
    public static final Property presetText = BXProtectCamera.newProperty((int)1, (BValue)BEnumRange.DEFAULT, null);
    @Generated
    public static final Property stopRecordingMode = BXProtectCamera.newProperty((int)0, (BValue)BXProtectStopRecordingModeEnum.onTimer, (BFacets)SfUtil.incl((String)"ed.un"));
    @Generated
    public static final Action getPresetList = BXProtectCamera.newAction((int)0, null);
    @Generated
    public static final Action moveToPreset = BXProtectCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    @Generated
    public static final Action storePreset = BXProtectCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BXProtectCamera.class);
    static final int SESSION_INIT = 0;
    static final int SESSION_STARTING = 1;
    static final int SESSION_ACTIVE = 2;
    static final int SESSION_FAULT = 4;
    static final int SESSION_STOPPED = 5;
    private MilestoneTcpSession cameraTcpIsSession;
    protected static int videoRequestId = 1;
    public static final Lexicon LEX = Lexicon.make(BXProtectCamera.class);

    @Generated
    public int getFastSpeed() {
        return this.getInt(fastSpeed);
    }

    @Generated
    public void setFastSpeed(int v) {
        this.setInt(fastSpeed, v, null);
    }

    @Generated
    public BPointDeviceExt getEvents() {
        return (BPointDeviceExt)this.get(events);
    }

    @Generated
    public void setEvents(BPointDeviceExt v) {
        this.set(events, (BValue)v, null);
    }

    @Generated
    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    @Generated
    public void setEventRecaller(BVideoEventRecall v) {
        this.set(eventRecaller, (BValue)v, null);
    }

    @Generated
    public BEnumRange getPresetText() {
        return (BEnumRange)this.get(presetText);
    }

    @Generated
    public void setPresetText(BEnumRange v) {
        this.set(presetText, (BValue)v, null);
    }

    @Generated
    public BXProtectStopRecordingModeEnum getStopRecordingMode() {
        return (BXProtectStopRecordingModeEnum)this.get(stopRecordingMode);
    }

    @Generated
    public void setStopRecordingMode(BXProtectStopRecordingModeEnum v) {
        this.set(stopRecordingMode, (BValue)v, null);
    }

    @Generated
    public void getPresetList() {
        this.invoke(getPresetList, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void videoCameraStarted() throws Exception {
        this.getPtzSupport().setSupportsStorePreset(false);
        this.getPtzSupport().setSupportsIris(false);
        this.getPtzSupport().setSupportsFocus(false);
        super.videoCameraStarted();
        this.postAsync(new Runnable(){

            @Override
            public void run() {
                BXProtectCamera.this.startCameraTcpIsSession();
            }
        });
    }

    public void stopped() throws Exception {
        super.stopped();
        this.cameraTcpIsSession.stop();
    }

    public void descendantsStarted() throws Exception {
        BVideoSourcePreferences prefs = (BVideoSourcePreferences)this.get("videoPreferences");
        if (prefs != null) {
            prefs.setPreferredFrameRate(BVideoFrameRateEnum.high);
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(moveToPreset) || action.equals(storePreset)) {
            BEnumRange presetText = this.getPresetText();
            int[] presetOrdinals = presetText.getOrdinals();
            int defaultOrdinal = presetOrdinals == null || presetOrdinals.length == 0 ? 0 : presetOrdinals[0];
            return BDynamicEnum.make((int)defaultOrdinal, (BEnumRange)presetText);
        }
        return super.getActionParameterDefault(action);
    }

    public void doPing() {
        if (this.getXprotectDvr().getConnection().isConnecting()) {
            this.pingFail(LEX.getText("xprotectServerConnecting"));
            return;
        }
        if (!this.getXprotectDvr().getConnection().isConnected()) {
            this.pingFail(LEX.getText("xprotectServerDisconnected"));
            return;
        }
        BXProtectCameraDeviceId cameraId = (BXProtectCameraDeviceId)this.get(videoDeviceId);
        XProtectCameraPingReq req = new XProtectCameraPingReq(cameraId.getCameraId(), this.getXprotectDvr().getConnection().getAuthAttributes().getToken(), true);
        req.setAddress((BAddress)new BIpAddress(cameraId.getServerId().getHostname(), cameraId.getServerId().getPort()));
        boolean pingSuccess = false;
        try {
            XProtectCameraPingRsp rsp = (XProtectCameraPingRsp)this.getCameraTcpIsSession().sendRequest(req);
            rsp.fromInputStream(rsp.in);
            pingSuccess = true;
            this.doGetPresetList();
            this.pingOk();
        }
        catch (Exception e) {
            if (pingSuccess) {
                this.pingFail("Connected to camera. Unable to get camera presets. " + e.getLocalizedMessage());
            }
            this.pingFail(e.getLocalizedMessage());
        }
    }

    public void pingOk() {
        super.pingOk();
    }

    public void pingFail(String cause) {
        super.pingFail(cause);
    }

    public void doGetPresetList() {
        boolean useTls = ((BMilestoneXProtectNetwork)this.getXprotectDvr().getNetwork()).getHttpConfig().getUseTls();
        IMIPService service = WebProcessUtil.getService(useTls);
        String strPresetList = AccessController.doPrivileged(() -> service.getPresets(((BXProtectCameraDeviceId)this.get(videoDeviceId)).getCameraId()));
        if (!strPresetList.equals("")) {
            String[] strPresets = strPresetList.trim().split(";");
            for (int i = 0; i < strPresets.length; ++i) {
                strPresets[i] = EscUtil.slot.escape(strPresets[i]);
            }
            this.setPresetText(BEnumRange.make((String[])strPresets));
        } else {
            this.setPresetText(BEnumRange.DEFAULT);
        }
    }

    public Type getNetworkType() {
        return BMilestoneXProtectNetwork.TYPE;
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    public Action getStorePresetAction() {
        return storePreset;
    }

    public BAbsTime getCameraTime() {
        try {
            return BAbsTime.now();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void onMove(BVideoPanTiltEnum panTiltAction) {
        if (panTiltAction != BVideoPanTiltEnum.none) {
            try {
                this.getCameraTcpIsSession().sendMessage(new XProtectPanTiltReq(panTiltAction));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onZoom(BVideoZoomEnum zoomAction) {
        if (zoomAction != BVideoZoomEnum.none) {
            try {
                this.getCameraTcpIsSession().sendMessage(new XProtectZoomReq(zoomAction));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onFocusControl(BVideoFocusEnum focusEnum) {
    }

    public void onIrisControl(BVideoIrisEnum irisEnum) {
    }

    public void doMoveToPreset(BDynamicEnum presetPosition) {
        try {
            this.getCameraTcpIsSession().sendMessage(new XProtectMoveToPresetReq(presetPosition));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doStorePreset(BDynamicEnum presetPosition) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecordingAlarm(BAlarmRecord alarmRecord) {
        if (alarmRecord.getSourceState() == BSourceState.normal) {
            BXProtectStopRecordingModeEnum stopRecordingMode = this.getStopRecordingMode();
            if (stopRecordingMode == BXProtectStopRecordingModeEnum.onTimer) return;
            if (stopRecordingMode != BXProtectStopRecordingModeEnum.onAlarmToNormal) throw new IllegalStateException("Unrecognized BXProtectStopRecordingModeEnum: " + (Object)((Object)stopRecordingMode));
            this.doForceStopRecording();
            return;
        } else {
            this.doForceStartRecording();
        }
    }

    public void doForceStartRecording() {
        XProtectCameraInitiateRecordingReq initiateRecordingReq = new XProtectCameraInitiateRecordingReq(this);
        initiateRecordingReq.setStartRecording(true);
        try {
            SlotCursor cursor = this.getXprotectDvr().getRecordingServers().getSlots();
            BXProtectRecordingServer recordingServer = null;
            if (cursor.next(BXProtectRecordingServer.class)) {
                recordingServer = (BXProtectRecordingServer)cursor.get();
                String hostName = recordingServer.getId().getHostname();
                int port = recordingServer.getId().getPort();
                initiateRecordingReq.setAddress((BAddress)new BIpAddress(hostName, port));
                this.getCameraTcpIsSession().sendMessage(initiateRecordingReq);
            } else {
                this.getLogger().log(Level.SEVERE, "No recording Server in Initiating Recording Req");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error in Initiating Recording Req");
        }
    }

    public void doForceStopRecording() {
        XProtectCameraInitiateRecordingReq initiateRecordingReq = new XProtectCameraInitiateRecordingReq(this);
        initiateRecordingReq.setStartRecording(false);
        try {
            SlotCursor cursor = this.getXprotectDvr().getRecordingServers().getSlots();
            BXProtectRecordingServer recordingServer = null;
            if (cursor.next(BXProtectRecordingServer.class)) {
                recordingServer = (BXProtectRecordingServer)cursor.get();
                String hostName = recordingServer.getId().getHostname();
                int port = recordingServer.getId().getPort();
                initiateRecordingReq.setAddress((BAddress)new BIpAddress(hostName, port));
                this.getCameraTcpIsSession().sendMessage(initiateRecordingReq);
            } else {
                this.getLogger().log(Level.SEVERE, "No recording Server in Initiating Recording Req");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error in Initiating Recording Req");
        }
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams) {
        return new XProtectMjpegVideoDecoder();
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        XProtectVideoStreamReq videoReq = new XProtectVideoStreamReq();
        videoReq.setVideoSource((BIVideoSource)this);
        videoReq.setVideoDestination(videoDestination);
        videoReq.setPlaybackParams(playbackParams);
        XProtectVideoStreamUtil.sendStreamRequest(videoReq, this);
        IVideoStream ivs = videoReq.makeVideoStream();
        if (ivs != null) {
            videoDestination.receiveVideoStream(ivs);
        }
    }

    public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession) {
    }

    public BXProtectManagementServer getXprotectDvr() {
        return (BXProtectManagementServer)DrUtil.getParent((BComplex)this, (Type)BXProtectManagementServer.TYPE);
    }

    public static synchronized int getNextVideoRequestId() {
        return videoRequestId++;
    }

    public void startCameraTcpIsSession() {
        try {
            BXProtectCameraDeviceId camId = (BXProtectCameraDeviceId)this.get(videoDeviceId);
            this.cameraTcpIsSession = new MilestoneTcpSession(new BIpAddress(camId.getServerId().getHostname(), camId.getServerId().getPort()));
            this.cameraTcpIsSession.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TcpLinkLayer link() {
        return (TcpLinkLayer)this.getXProtectNetwork().tcpComm().getLinkLayer();
    }

    public void socketTerminated(BIpAddress addr, boolean server) {
        int sid = addr.getSessionId();
        if (sid < 0) {
            return;
        }
        if (this.cameraTcpIsSession.getLinkSessionId() == sid) {
            this.cameraTcpIsSession.sessionTerminated();
        }
    }

    public MilestoneTcpSession getCameraTcpIsSession() throws Exception {
        if (this.cameraTcpIsSession == null) {
            this.startCameraTcpIsSession();
        }
        if (!this.cameraTcpIsSession.isActive()) {
            this.cameraTcpIsSession.start();
        }
        return this.cameraTcpIsSession;
    }

    private static boolean isAllowedToWirePasswords(Context cx) {
        return cx.getFacets().getb("isSecure", false) || BXProtectCamera.canChangeInsecurely();
    }

    private static boolean canChangeInsecurely() {
        BWebService webService;
        try {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            return true;
        }
        return !webService.getRequireHttpsForPasswords();
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box)})
    public Map<String, Object> getServerConnectionParamsWithRpc(Context cx) throws BChangeUserPasswordRpc.JSONParseableException {
        if (!BXProtectCamera.isAllowedToWirePasswords(cx)) {
            throw new BChangeUserPasswordRpc.JSONParseableException("Insecure webservice configuration");
        }
        BXProtectManagementConnection serverConnection = this.getXprotectDvr().getConnection();
        HashMap<String, Object> usernamePasswordMap = new HashMap<String, Object>();
        usernamePasswordMap.put("username", serverConnection.getAuth().getUsername());
        usernamePasswordMap.put("password", AccessController.doPrivileged(() -> ((BPassword)serverConnection.getAuth().getPassword()).getValue()));
        usernamePasswordMap.put("authType", serverConnection.getAuth().getAuthType().getTag());
        String uri = !cx.getFacets().getb("isSecure", false) ? "http://" + serverConnection.getHostName() + ":" + serverConnection.getWebClientHttpPort() + "/" : "https://" + serverConnection.getHostName() + ":" + serverConnection.getWebClientHttpsPort() + "/";
        usernamePasswordMap.put("uri", uri);
        return usernamePasswordMap;
    }

    public NComm tcpcomm() {
        return this.getXProtectNetwork().tcpComm();
    }

    public BMilestoneXProtectNetwork getXProtectNetwork() {
        return (BMilestoneXProtectNetwork)DrUtil.getParent((BComplex)this, (Type)BMilestoneXProtectNetwork.TYPE);
    }

    public class MilestoneTcpSession {
        BIpAddress adr;
        int state = 0;
        String status = "";

        public MilestoneTcpSession(BIpAddress address) {
            this.adr = address;
        }

        synchronized void init() throws Exception {
            this.adr.setSessionId(BXProtectCamera.this.link().createSession(this.adr));
        }

        synchronized void sessionTerminated() {
            if (this.state == 2) {
                try {
                    this.start();
                }
                catch (Exception exception) {}
            } else {
                this.adr = null;
                this.state = 5;
            }
        }

        synchronized void stop() throws Exception {
            if (this.adr == null) {
                return;
            }
            BXProtectCamera.this.link().closeSession(this.adr.getSessionId());
            this.adr = null;
            this.state = 5;
        }

        public synchronized void sendMessage(NMessage req) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            req.setAddress((BAddress)this.adr);
            BXProtectCamera.this.getXProtectNetwork().tcpComm().sendMessage(req);
        }

        public synchronized NMessage sendRequest(NMessage req) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            req.setAddress((BAddress)this.adr);
            return BXProtectCamera.this.getXProtectNetwork().tcpComm().sendRequest(req);
        }

        public void restart() throws Exception {
            if (this.adr != null) {
                this.stop();
            }
            this.start();
        }

        public boolean isActive() {
            return this.state == 2;
        }

        synchronized void start() throws Exception {
            try {
                this.state = 1;
                this.init();
                this.state = 2;
            }
            catch (Exception e) {
                this.state = 4;
                throw e;
            }
        }

        synchronized int getLinkSessionId() {
            if (this.adr == null) {
                return -1;
            }
            return this.adr.getSessionId();
        }
    }
}

