/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.transport;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.signing.BSigningService;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.transport.BLocalSigningTransport;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;

@NiagaraType
@NiagaraProperty(name="localOnboardingProfile", type="String", defaultValue="BString.DEFAULT", flags=69)
@NiagaraAction(name="onboard", parameterType="BString", defaultValue="BString.make(\"\")", flags=16, facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(name="BFacets.FIELD_EDITOR", value="\"signingService:ProfilePickerFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"signingService:ProfilePicker\"")}, override=true)
public final class BLocalSigningRequester
extends BAbstractSigningRequester
implements IPropertyValidator {
    @Generated
    public static final Property localOnboardingProfile = BLocalSigningRequester.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action onboard = BLocalSigningRequester.newAction((int)16, (BValue)BString.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"signingService:ProfilePickerFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"signingService:ProfilePicker")));
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalSigningRequester.class);

    @Generated
    public String getLocalOnboardingProfile() {
        return this.getString(localOnboardingProfile);
    }

    @Generated
    public void setLocalOnboardingProfile(String v) {
        this.setString(localOnboardingProfile, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.generateRequesterId(false);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(onboard)) {
            return this.getSession() instanceof BFoxSession ? this : BString.DEFAULT;
        }
        return super.getActionParameterDefault(action);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        if (Arrays.asList(validatable.getModifiedProperties()).contains(localOnboardingProfile)) {
            BLocalSigningRequester.doValidateReadonlyPropertySet(context);
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (localOnboardingProfile.equals(property)) {
            BLocalSigningRequester.doValidateReadonlyPropertySet(context);
        }
    }

    private static void doValidateReadonlyPropertySet(Context context) {
        if (context != null && context.getUser() != null) {
            throw new LocalizableRuntimeException("signingService", "signing.service.illegalManualPropertyChange");
        }
    }

    public void initiateOnboarding(String profileName, Context cx) throws IOException {
        try {
            BLocalSigningRequester.getTransport().onboard(this.getRequesterId(), this.getRequesterComponent(), profileName, cx);
            this.setLocalOnboardingProfile(profileName);
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    public boolean supportsApprovalCheck() {
        return false;
    }

    public BApprovalState checkOnboardingApproval() throws IOException {
        return BApprovalState.unapproved;
    }

    public BCertificateParameter[] getCertificateParameterTemplates() throws IOException {
        try {
            return BLocalSigningRequester.getTransport().getCertificateParameterTemplates(this.getRequesterId(), this.getLocalOnboardingProfile());
        }
        catch (SigningServiceException e) {
            this.setLocalOnboardingProfile("");
            throw new IOException((Throwable)((Object)e));
        }
        catch (IOException | RuntimeException e) {
            this.setLocalOnboardingProfile("");
            throw e;
        }
    }

    public void submitCertificateSigningRequest(NPKCS10CertificationRequest csr, boolean renewal, Context cx) throws IOException {
        try {
            String localProfile = renewal ? null : this.getLocalOnboardingProfile();
            BLocalSigningRequester.getTransport().submitCertificateSigningRequest(this.getRequesterId(), localProfile, this.getRequesterComponent(), csr, renewal, cx);
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
        finally {
            this.setLocalOnboardingProfile("");
        }
    }

    public X509Certificate[] getCertificateSigningResult(boolean renewal) throws IOException {
        try {
            return BLocalSigningRequester.getTransport().getCertificateSigningResult(this.getRequesterId());
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    private static BLocalSigningTransport getTransport() throws IOException {
        try {
            BSigningService signingService = BLocalSigningRequester.getSigningService();
            BLocalSigningTransport[] transports = (BLocalSigningTransport[])signingService.getTransports().getChildren(BLocalSigningTransport.class);
            return Arrays.stream(transports).findFirst().orElseThrow(() -> new IOException((Throwable)((Object)new SigningServiceException("signingService", "requester.local.no.transport"))));
        }
        catch (ServiceNotFoundException e) {
            throw new IOException((Throwable)((Object)new SigningServiceException("signingService", "requester.local.no.transport")));
        }
    }

    private static BSigningService getSigningService() {
        return (BSigningService)Sys.getService((Type)BSigningService.TYPE).as(BSigningService.class);
    }
}

