/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.profile;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.cert.ext.NBasicConstraints;
import com.tridium.crypto.core.cert.ext.NExtendedKeyUsage;
import com.tridium.crypto.core.cert.ext.NKeyUsage;
import com.tridium.crypto.core.io.CertificateStatusEnum;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.CertificateParameterType;
import com.tridium.security.BCertificateStatusEnum;
import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BAbstractSigningProfile;
import com.tridium.signing.profile.BKeyPurpose;
import com.tridium.signing.profile.BSigningRecordStore;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.security.IX509Extension;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.asn1.x509.KeyPurposeId;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="caStatus", type="BCertificateStatusEnum", defaultValue="BCertificateStatusEnum.ok", flags=67), @NiagaraProperty(name="caAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="expirationPeriod", type="BRelTime", defaultValue="BRelTime.makeDays(365)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeHours(1))"), @Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.FALSE, \"showDay\", BBoolean.TRUE)"), @Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="keyPurpose", type="BKeyPurpose", defaultValue="BKeyPurpose.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="enforceKeyPurpose", type="boolean", defaultValue="true", flags=4, facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="certificateStore", type="BSigningRecordStore", defaultValue="new BSigningRecordStore()")})
public class BSimpleSigningProfile
extends BAbstractSigningProfile {
    @Generated
    public static final Property caStatus = BSimpleSigningProfile.newProperty((int)67, (BValue)BCertificateStatusEnum.ok, null);
    @Generated
    public static final Property caAliasAndPassword = BSimpleSigningProfile.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property expirationPeriod = BSimpleSigningProfile.newProperty((int)0, (BValue)BRelTime.makeDays((int)365), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeHours((int)1)), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"showDay", (BIDataValue)BBoolean.TRUE)), (BFacets)BFacets.make((String)"security", (boolean)true)));
    @Generated
    public static final Property keyPurpose = BSimpleSigningProfile.newProperty((int)0, (BValue)BKeyPurpose.DEFAULT, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property enforceKeyPurpose = BSimpleSigningProfile.newProperty((int)4, (boolean)true, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property certificateStore = BSimpleSigningProfile.newProperty((int)0, (BValue)new BSigningRecordStore(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSimpleSigningProfile.class);

    @Generated
    public BCertificateStatusEnum getCaStatus() {
        return (BCertificateStatusEnum)this.get(caStatus);
    }

    @Generated
    public void setCaStatus(BCertificateStatusEnum v) {
        this.set(caStatus, (BValue)v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCaAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(caAliasAndPassword);
    }

    @Generated
    public void setCaAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(caAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public BRelTime getExpirationPeriod() {
        return (BRelTime)this.get(expirationPeriod);
    }

    @Generated
    public void setExpirationPeriod(BRelTime v) {
        this.set(expirationPeriod, (BValue)v, null);
    }

    @Generated
    public BKeyPurpose getKeyPurpose() {
        return (BKeyPurpose)this.get(keyPurpose);
    }

    @Generated
    public void setKeyPurpose(BKeyPurpose v) {
        this.set(keyPurpose, (BValue)v, null);
    }

    @Generated
    public boolean getEnforceKeyPurpose() {
        return this.getBoolean(enforceKeyPurpose);
    }

    @Generated
    public void setEnforceKeyPurpose(boolean v) {
        this.setBoolean(enforceKeyPurpose, v, null);
    }

    @Generated
    public BSigningRecordStore getCertificateStore() {
        return (BSigningRecordStore)this.get(certificateStore);
    }

    @Generated
    public void setCertificateStore(BSigningRecordStore v) {
        this.set(certificateStore, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.getCaAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.CA_CERT.name()));
            this.updateCaStatus();
        } else if (x == 2 && this.isRunning() && caAliasAndPassword.equals(a)) {
            this.updateCaStatus();
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    protected final BCertificateSigningRecord doRegisterRequester(String requesterId, boolean renewal) throws SigningServiceException {
        BCertificateSigningRecord record;
        Optional<BCertificateSigningRecord> optRec = this.getRecord(requesterId);
        if (optRec.isPresent()) {
            record = optRec.get();
            if (!renewal) {
                BCertificateSigningRecord.resetRecord(record);
            }
        } else {
            record = BCertificateSigningRecord.make(requesterId);
        }
        this.getCertificateStore().store(requesterId, record);
        return record;
    }

    @Override
    protected void doValidateCsr(NPKCS10CertificationRequest csr) throws SigningServiceException {
        BCertificateParameter[] csrParameters = (BCertificateParameter[])this.getChildren(BCertificateParameter.class);
        SigningServiceUtils.validateKeyType(csr, csrParameters);
        SigningServiceUtils.validateKeySize(csr, csrParameters);
        if (this.getEnforceKeyPurpose()) {
            SigningServiceUtils.checkKeyPurpose(csr, this.getKeyPurpose());
        }
        SigningServiceUtils.validateDn(csr, csrParameters);
        SigningServiceUtils.validateCommonNameTemplate(csr, csrParameters);
    }

    @Override
    protected final X509Certificate doSignCertificate(NPKCS10CertificationRequest csr, String requesterId) throws SigningServiceException {
        if (this.getCaAlias().isEmpty()) {
            throw new SigningServiceException("signingService", "signing.service.ca.alias.notFound");
        }
        if ("default".equals(this.getCaAlias())) {
            throw new SigningServiceException("signingService", "signing.service.ca.alias.factory");
        }
        NX509CertificateEntry caCert = this.retrieveCaCertificate();
        try {
            NSigningParameters parameters = this.getSigningParameters(csr);
            return CertUtils.signCertificate((NPKCS10CertificationRequest)csr, (IX509CertificateEntry)caCert, (NSigningParameters)parameters, (boolean)true).getCertificate();
        }
        catch (Exception e) {
            String messageLexKey = "signing.service.signing.failed";
            SigningServiceUtils.LOG.log(Level.SEVERE, SigningServiceUtils.LEX.getText(messageLexKey) + e.getMessage(), e);
            throw new SigningServiceException("signingService", messageLexKey, (Throwable)e, e.getMessage());
        }
    }

    private NSigningParameters getSigningParameters(NPKCS10CertificationRequest csr) throws Exception {
        Date notBefore = new Date();
        KeyPurpose keyPurpose = this.getEnforceKeyPurpose() ? this.getKeyPurpose().toKeyPurpose() : null;
        NSigningParameters signingParameters = NSigningParameters.make((Date)notBefore, (Date)new Date(notBefore.getTime() + this.getExpirationPeriod().getMillis()), (KeyPurpose)keyPurpose);
        for (IX509Extension extension : csr.getExtensions()) {
            if (extension instanceof NKeyUsage) {
                if (!this.isKeyUsageExtensionValid((NKeyUsage)extension)) continue;
                signingParameters.addExtension(extension);
                continue;
            }
            if (extension instanceof NExtendedKeyUsage) {
                if (!this.isExtendedKeyUsageExtensionValid((NExtendedKeyUsage)extension)) continue;
                signingParameters.addExtension(extension);
                continue;
            }
            if (extension instanceof NBasicConstraints) {
                if (!this.isBasicConstraintsExtensionValid((NBasicConstraints)extension)) continue;
                signingParameters.addExtension(extension);
                continue;
            }
            signingParameters.addExtension(extension);
        }
        return signingParameters;
    }

    private boolean isKeyUsageExtensionValid(NKeyUsage keyUsageExtension) {
        switch (this.getKeyPurpose().toKeyPurpose()) {
            case SERVER_CERT: {
                return CertUtils.checkKeyUsageExtension((NKeyUsage)keyUsageExtension, (int[])new int[]{128, 32});
            }
            case CLIENT_CERT: 
            case CODE_SIGNING_CERT: {
                return CertUtils.checkKeyUsageExtension((NKeyUsage)keyUsageExtension, (int[])new int[]{128});
            }
            case CA_CERT: {
                return CertUtils.checkKeyUsageExtension((NKeyUsage)keyUsageExtension, (int[])new int[]{4, 2});
            }
        }
        return true;
    }

    private boolean isExtendedKeyUsageExtensionValid(NExtendedKeyUsage extendedKeyUsageExtension) {
        switch (this.getKeyPurpose().toKeyPurpose()) {
            case CLIENT_CERT: {
                return CertUtils.checkExtendedKeyUsageExtension((NExtendedKeyUsage)extendedKeyUsageExtension, (KeyPurposeId[])new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth});
            }
            case SERVER_CERT: {
                return CertUtils.checkExtendedKeyUsageExtension((NExtendedKeyUsage)extendedKeyUsageExtension, (KeyPurposeId[])new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth});
            }
            case CODE_SIGNING_CERT: {
                return CertUtils.checkExtendedKeyUsageExtension((NExtendedKeyUsage)extendedKeyUsageExtension, (KeyPurposeId[])new KeyPurposeId[]{KeyPurposeId.id_kp_codeSigning});
            }
        }
        return true;
    }

    private boolean isBasicConstraintsExtensionValid(NBasicConstraints basicConstraintsExtension) {
        if (this.getKeyPurpose().toKeyPurpose() == KeyPurpose.CA_CERT) {
            return CertUtils.checkBasicConstraintsExtension((NBasicConstraints)basicConstraintsExtension);
        }
        return true;
    }

    private NX509CertificateEntry retrieveCaCertificate() throws SigningServiceException {
        try {
            String caAlias = this.getCaAlias();
            ICryptoManager cryptoManager = CertManagerFactory.getInstance();
            X509Certificate cert = cryptoManager.getKeyStore().getCertificate(caAlias);
            if (cert == null) {
                throw new SigningServiceException("signingService", "signing.service.ca.notFound", caAlias);
            }
            BPassword caPassword = this.getCaAliasAndPassword().getPassword();
            if (caPassword.equals((Object)BPassword.DEFAULT)) {
                throw new SigningServiceException("signingService", "signing.service.ca.pw.notFound");
            }
            String password = caPassword.getValue();
            PrivateKey key = (PrivateKey)cryptoManager.getKeyStore().getKey(caAlias, password.toCharArray());
            return NX509CertificateEntry.make((String)caAlias, (X509Certificate[])new X509Certificate[]{cert}, (PrivateKey)key);
        }
        catch (UnrecoverableKeyException e) {
            throw new SigningServiceException("signingService", "signing.service.ca.retrieve.failed", (Throwable)e, SigningServiceUtils.LEX.getText("signing.service.ca.pw.incorrect"));
        }
        catch (Exception e) {
            throw new SigningServiceException("signingService", "signing.service.ca.retrieve.failed", e.getMessage(), e);
        }
    }

    @Override
    protected Map<String, BValue> doGetCsrParameters(Context cx) throws SigningServiceException {
        HashMap<String, BValue> params = new HashMap<String, BValue>();
        if (this.getEnforceKeyPurpose()) {
            params.put(CertificateParameterType.KEY_PURPOSE.name(), (BValue)BCertificateParameter.make((CertificateParameterType)CertificateParameterType.KEY_PURPOSE, (BValue)BInteger.make((int)this.getKeyPurpose().getOrdinal())));
        }
        BCertificateParameter[] childParameters = (BCertificateParameter[])this.getChildren(BCertificateParameter.class);
        Arrays.stream(childParameters).filter(childParam -> !CertificateParameterType.KEY_PURPOSE.name().equals(childParam.getParameterType())).forEach(childParam -> {
            BValue cfr_ignored_0 = (BValue)params.put(childParam.getName(), (BValue)childParam.getNewInstanceForCsrGeneration(cx));
        });
        return params;
    }

    @Override
    protected final Optional<BCertificateSigningRecord> doGetRecord(String requesterId) throws SigningServiceException {
        return this.getCertificateStore().getRecord(requesterId);
    }

    @Override
    protected final Iterator<BCertificateSigningRecord> doGetAllRecords() throws SigningServiceException {
        return this.getCertificateStore().getAllRecords();
    }

    @Override
    protected final void updateRecord(BCertificateSigningRecord record) throws SigningServiceException {
        this.getCertificateStore().store(record.getRequesterId(), record);
    }

    @Override
    public X509Certificate[] getCaCertificateChain(String requesterId) throws SigningServiceException {
        try {
            String caAlias = this.getCaAlias();
            ICryptoManager cryptoManager = CertManagerFactory.getInstance();
            X509Certificate[] caCertificateChain = cryptoManager.getKeyStore().getCertificateChain(caAlias);
            if (caCertificateChain == null) {
                throw new SigningServiceException("signingService", "signing.service.ca.notFound", caAlias);
            }
            return caCertificateChain;
        }
        catch (SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SigningServiceException("signingService", "signing.service.ca.retrieve.failed", e.getMessage(), e);
        }
    }

    @Override
    public String getCaFingerprint() throws SigningServiceException {
        try {
            String caAlias = this.getCaAlias();
            ICryptoManager cryptoManager = CertManagerFactory.getInstance();
            X509Certificate caCertificate = cryptoManager.getKeyStore().getCertificate(caAlias);
            if (caCertificate == null) {
                throw new SigningServiceException("signingService", "signing.service.ca.notFound", caAlias);
            }
            return NX509Certificate.make((X509Certificate)caCertificate).getFingerprint("SHA256");
        }
        catch (SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SigningServiceException("signingService", "signing.service.ca.retrieve.failed", e.getMessage(), e);
        }
    }

    private String getCaAlias() {
        return this.getCaAliasAndPassword().getAlias();
    }

    private void updateCaStatus() {
        CertificateStatusEnum certStatus;
        block4: {
            BCertificateAliasAndPassword aliasAndPassword = this.getCaAliasAndPassword();
            String caAlias = aliasAndPassword.getAlias();
            if (SigningServiceUtils.isDefaultOrEmptyAlias(caAlias)) {
                this.setCaStatus(BCertificateStatusEnum.badKey);
                return;
            }
            BPassword caPassword = aliasAndPassword.getPassword();
            if (BPassword.DEFAULT.equals((Object)caPassword)) {
                this.setCaStatus(BCertificateStatusEnum.badPassword);
                return;
            }
            certStatus = CertificateStatusEnum.BAD_KEY;
            try {
                CoreCryptoManager ccm = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
                certStatus = CertificateStatusEnum.BAD_PASSWORD;
                SecretChars certPasswordChars = AccessController.doPrivileged(() -> ((BPassword)caPassword).getSecretChars());
                certStatus = ccm.checkCACertificateStatus(caAlias, certPasswordChars);
            }
            catch (Exception e) {
                if (!SigningServiceUtils.LOG.isLoggable(Level.FINE)) break block4;
                SigningServiceUtils.LOG.log(Level.FINE, "CA Cert validation check failed for profile '" + this.toPathString() + "'. Setting CA Cert Status to " + certStatus, e);
            }
        }
        this.setCaStatus(BCertificateStatusEnum.make((CertificateStatusEnum)certStatus));
    }
}

