/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.fox;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.LocalizableServerException;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.fox.BSigningChannel;
import java.io.IOException;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="signingServiceStation", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:RemoteStationFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"niagaraDriver:RemoteStationEditor\"))")}), @NiagaraProperty(name="temporaryCode", type="BPassword", defaultValue="BPassword.DEFAULT", flags=69), @NiagaraProperty(name="accessToken", type="BPassword", defaultValue="BPassword.DEFAULT", flags=69)})
public final class BFoxSigningRequester
extends BAbstractSigningRequester
implements BFoxClientConnection.Interest {
    @Generated
    public static final Property signingServiceStation = BFoxSigningRequester.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:RemoteStationFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"niagaraDriver:RemoteStationEditor")));
    @Generated
    public static final Property temporaryCode = BFoxSigningRequester.newProperty((int)69, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property accessToken = BFoxSigningRequester.newProperty((int)69, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxSigningRequester.class);

    @Generated
    public String getSigningServiceStation() {
        return this.getString(signingServiceStation);
    }

    @Generated
    public void setSigningServiceStation(String v) {
        this.setString(signingServiceStation, v, null);
    }

    @Generated
    public BPassword getTemporaryCode() {
        return (BPassword)this.get(temporaryCode);
    }

    @Generated
    public void setTemporaryCode(BPassword v) {
        this.set(temporaryCode, (BValue)v, null);
    }

    @Generated
    public BPassword getAccessToken() {
        return (BPassword)this.get(accessToken);
    }

    @Generated
    public void setAccessToken(BPassword v) {
        this.set(accessToken, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && enabled.equals(property)) {
            if (this.getEnabled()) {
                BSigningChannel.addSigningChannelUser();
            } else {
                BSigningChannel.removeSigningChannelUser();
            }
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.getEnabled()) {
            BSigningChannel.addSigningChannelUser();
        }
        this.generateRequesterId(false);
    }

    public void stopped() throws Exception {
        if (this.getEnabled()) {
            BSigningChannel.removeSigningChannelUser();
        }
        super.stopped();
    }

    public void initiateOnboarding(String comment, Context cx) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("comment", comment);
        try {
            BPassword code = this.performSigningTask(signingChannel -> signingChannel.onboard(this.getRequesterId(), metadata, this.getTemporaryCode()));
            if (code != null) {
                this.setTemporaryCode(code);
            }
        }
        catch (LocalizableServerException | SecurityException lre) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Unrecoverable onboarding failure for current Requester ID on " + this.toPathString() + ". Generating a new Requester ID and trying again.", lre);
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Unrecoverable onboarding failure for current Requester ID on " + this.toPathString() + ". Generating a new Requester ID and trying again.");
            }
            this.generateRequesterId(true);
            this.setTemporaryCode(BPassword.DEFAULT);
            try {
                BPassword code = this.performSigningTask(signingChannel -> signingChannel.onboard(this.getRequesterId(), metadata, this.getTemporaryCode()));
                if (code != null) {
                    this.setTemporaryCode(code);
                }
            }
            catch (SigningServiceException e) {
                throw new IOException((Throwable)((Object)e));
            }
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
        this.logFine("Submitted onboarding request");
    }

    public BApprovalState checkOnboardingApproval() throws IOException {
        if (this.getTemporaryCode().isDefault()) {
            throw new IOException((Throwable)((Object)new SigningServiceException("signingService", "requester.code.notfound")));
        }
        BApprovalState result = null;
        try {
            this.setAccessToken(BPassword.DEFAULT);
            BPassword token = this.performSigningTask(signingChannel -> signingChannel.getToken(this.getRequesterId(), this.getTemporaryCode()));
            if (token != null) {
                this.setAccessToken(token);
            }
        }
        catch (SigningServiceException e) {
            if ("channel.exception.onboardRequestRejected".equals(e.getLexiconKey())) {
                result = BApprovalState.rejected;
            }
            if ("channel.exception.onboardRequestExpired".equals(e.getLexiconKey())) {
                result = BApprovalState.expired;
            }
            LOG.log(Level.SEVERE, "Failed to check approval status", (Throwable)((Object)e));
        }
        if (result == null) {
            if (!this.getAccessToken().isDefault()) {
                result = BApprovalState.approved;
                this.logFine("Retrieved access token");
            } else {
                result = BApprovalState.unapproved;
            }
        }
        return result;
    }

    public BCertificateParameter[] getCertificateParameterTemplates() throws IOException {
        this.checkTokenExists();
        try {
            Map params = this.performSigningTask(signingChannel -> signingChannel.getParams(this.getRequesterId(), this.getAccessToken()));
            List<BCertificateParameter> certparams = params.values().stream().filter(value -> value instanceof BCertificateParameter).map(value -> (BCertificateParameter)value).collect(Collectors.toList());
            this.logFine("Retrieved " + certparams.size() + " certificate parameters");
            return certparams.toArray(new BCertificateParameter[0]);
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    public void submitCertificateSigningRequest(NPKCS10CertificationRequest csr, boolean renewal, Context cx) throws IOException {
        BPassword password = this.getRequesterPassword();
        try {
            if (renewal) {
                this.performSigningTask(signingChannel -> {
                    signingChannel.renewCertificate(this.getRequesterId(), this.getRequesterComponent().getCertAlias(), password, csr);
                    return null;
                });
            } else {
                this.checkTokenExists();
                this.performSigningTask(signingChannel -> {
                    signingChannel.signCertificate(this.getRequesterId(), this.getAccessToken(), csr);
                    return null;
                });
            }
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
        this.logFine("Submitted certificate request");
    }

    public X509Certificate[] getCertificateSigningResult(boolean renewal) throws IOException {
        Optional chain;
        try {
            if (renewal) {
                BPassword password = this.getRequesterPassword();
                chain = this.performSigningTask(signingChannel -> signingChannel.getCertificate(this.getRequesterId(), this.getRequesterComponent().getCertAlias(), password, true));
            } else {
                this.checkTokenExists();
                chain = this.performSigningTask(signingChannel -> signingChannel.getCertificate(this.getRequesterId(), this.getAccessToken()));
            }
        }
        catch (SigningServiceException e) {
            throw new IOException((Throwable)((Object)e));
        }
        return chain.orElse(null);
    }

    private <R> R performSigningTask(ThrowingConsumer<BSigningChannel, R> signingChannelConsumer) throws SigningServiceException {
        return this.performSigningTask(this.getSigningServiceStation(), signingChannelConsumer);
    }

    private <R> R performSigningTask(String stationName, ThrowingConsumer<BSigningChannel, R> signingChannelConsumer) throws SigningServiceException {
        if (stationName == null || stationName.isEmpty()) {
            throw new SigningServiceException("signingService", "requester.station.not.selected");
        }
        BNiagaraNetwork niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)niagaraNetwork.getNiagaraStation(stationName);
        if (station == null) {
            throw new SigningServiceException("signingService", "requester.station.not.exist", stationName);
        }
        if (station.isDisabled()) {
            throw new SigningServiceException("signingService", "requester.station.not.operational", station.getStationName());
        }
        BFoxClientConnection connection = station.getClientConnection();
        try {
            connection.engageNoRetry((BFoxClientConnection.Interest)this);
            BSigningChannel signingChannel = (BSigningChannel)connection.getChannels().get("signing", BSigningChannel.TYPE);
            R r = signingChannelConsumer.accept(signingChannel);
            return r;
        }
        catch (SigningServiceException | ClassCastException | SecurityException | LocalizableRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Cannot connect to Signing Service station: " + stationName, e);
            } else {
                LOG.log(Level.WARNING, "Cannot connect to Signing Service station: " + stationName);
            }
            throw new SigningServiceException("signingService", "requester.station.cannotConnect", (Throwable)e, stationName);
        }
        finally {
            connection.disengage((BFoxClientConnection.Interest)this);
        }
    }

    private void checkTokenExists() throws IOException {
        if (this.getAccessToken().isDefault()) {
            throw new IOException((Throwable)((Object)new SigningServiceException("signingService", "requester.token.notfound")));
        }
    }

    private BPassword getRequesterPassword() {
        return AccessController.doPrivileged(() -> this.getRequesterComponent().getCertificatePassword()).orElse(null);
    }

    private void logFine(String message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("%s: [%s]", message, this.getRequesterId()));
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, R> {
        public R accept(T var1) throws SigningServiceException;
    }
}

