/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.signing.BSigningService;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BAbstractSigningProfile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public final class BSigningServiceRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningServiceRpc.class);
    public static final String SIGNING_PROFILE_MAP = "getSigningProfileMap";

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static Map<String, String> getSigningProfileMap(Context cx) {
        try {
            BUser contextUser;
            BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE).as(BSigningService.class);
            BUser bUser = contextUser = cx != null ? cx.getUser() : null;
            if (contextUser == null || !contextUser.getPermissionsFor((BIProtected)signingService).hasAdminRead()) {
                SigningServiceUtils.LOG.warning("User does not have read permissions on the Signing Service");
                return Collections.emptyMap();
            }
            return Arrays.stream(signingService.getProfiles().getChildren(BAbstractSigningProfile.class)).filter(profile -> contextUser.getPermissionsFor((BIProtected)profile).hasAdminRead()).collect(Collectors.toMap(profile -> profile.getDisplayName(cx), profile -> SlotPath.unescape((String)profile.getName())));
        }
        catch (ServiceNotFoundException e) {
            throw new IllegalArgumentException("No SigningService found on station", e);
        }
    }
}

