/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BAlarmConsoleUIChannel;
import com.tridium.alarm.ui.BAlarmDialog;
import com.tridium.alarm.ui.BTrayIcon;
import com.tridium.alarm.ui.TrayIconListener;
import com.tridium.alarm.ui.portal.BAlarmPortalOptions;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.alarm.ui.portal.BConsoleRecordList;
import com.tridium.alarm.ui.portal.BPortalConsoleRecipient;
import com.tridium.alarm.ui.portal.IllegalFoxwssConsoleRecordException;
import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.GenericReportableAuthenticationException;
import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BFoxStationSpace;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.WbAuthenticationClient;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.security.ChangeUserAuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BUuid;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.tool.BWbService;

@NiagaraType
@NiagaraProperty(name="alarmPortalConsoleRecipient", type="BConsoleRecipient", defaultValue="new BConsoleRecipient()", flags=4)
@NiagaraActions(value={@NiagaraAction(name="connect", parameterType="BWidget", defaultValue="new BWidget()", flags=4), @NiagaraAction(name="routeAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", flags=4), @NiagaraAction(name="updateConnectionStatus", flags=4), @NiagaraAction(name="scanForReconnect", flags=4)})
@NiagaraTopic(name="newUnackedAlarm", eventType="BAlarmRecord")
public class BAlarmPortalTool
extends BWbService
implements TrayIconListener,
NavListener,
BFoxClientConnection.Interest {
    @Generated
    public static final Property alarmPortalConsoleRecipient = BAlarmPortalTool.newProperty((int)4, (BValue)new BConsoleRecipient(), null);
    @Generated
    public static final Action connect = BAlarmPortalTool.newAction((int)4, (BValue)new BWidget(), null);
    @Generated
    public static final Action routeAlarm = BAlarmPortalTool.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action updateConnectionStatus = BAlarmPortalTool.newAction((int)4, null);
    @Generated
    public static final Action scanForReconnect = BAlarmPortalTool.newAction((int)4, null);
    @Generated
    public static final Topic newUnackedAlarm = BAlarmPortalTool.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmPortalTool.class);
    private static final int UPDATE_INTERVAL_SEC = 30;
    Hashtable<String, BConsoleRecipient> recipients = new Hashtable();
    Hashtable<String, Boolean> consoleUsesFoxwss = new Hashtable();
    Hashtable<BConsoleRecipient, BConsoleRecord> recipToRecord = new Hashtable();
    Array<BOrd> stations = new Array(BOrd.class);
    BWidget view;
    Clock.Ticket reconnectTicket;
    BTrayIcon trayIcon = new BTrayIcon();
    protected int acked = 0;
    protected int unacked = 0;
    int activeViewCount = 0;
    long unackedTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.YELLOW_ICON);
    long inactiveTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.GRAY_ICON);
    long activeTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.RED_ICON);
    long normalTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.GREEN_ICON);
    long clearedTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.WHITE_ICON);
    protected BAlarmPortalOptions options;
    static BAlarmDialog alarmDialog;
    private static final Object ALARM_DIALOG_LOCK;
    Hashtable<BUuid, BAckState> alarms = new Hashtable();
    Hashtable<BOrdList, BSourceState> sourceStates = new Hashtable();
    boolean sourcesInAlarm = false;
    Clock.Ticket updateTicket;
    private boolean running = false;
    static BImage alarmImg;
    public static final UiLexicon lexicon;
    private static final BIcon icon;
    private static final Logger LOGGER;

    @Generated
    public BConsoleRecipient getAlarmPortalConsoleRecipient() {
        return (BConsoleRecipient)this.get(alarmPortalConsoleRecipient);
    }

    @Generated
    public void setAlarmPortalConsoleRecipient(BConsoleRecipient v) {
        this.set(alarmPortalConsoleRecipient, (BValue)v, null);
    }

    @Generated
    public void connect(BWidget parameter) {
        this.invoke(connect, (BValue)parameter, null);
    }

    @Generated
    public void routeAlarm(BAlarmRecord parameter) {
        this.invoke(routeAlarm, (BValue)parameter, null);
    }

    @Generated
    public void updateConnectionStatus() {
        this.invoke(updateConnectionStatus, null, null);
    }

    @Generated
    public void scanForReconnect() {
        this.invoke(scanForReconnect, null, null);
    }

    @Generated
    public void fireNewUnackedAlarm(BAlarmRecord event) {
        this.fire(newUnackedAlarm, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmPortalTool() {
        this.options = BAlarmPortalOptions.getDefault();
        this.setAlarmPortalConsoleRecipient(new BPortalConsoleRecipient(this));
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        this.start();
    }

    private void doConnect() {
        this.doConnect(null);
    }

    public void doConnect(BWidget view) {
        BLink[] links;
        this.view = view;
        this.acked = 0;
        this.unacked = 0;
        this.sourcesInAlarm = false;
        for (BLink link : links = this.getLinks()) {
            this.remove(link.getName());
        }
        this.recipients = new Hashtable();
        BConsoleRecordList list = this.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            BConsoleRecord entry = list.get(i);
            try {
                BConsoleRecipient recip = this.connectToServer(view, entry);
                int[] iac = this.getInitialAlarmCounts(recip);
                this.acked += iac[0];
                this.unacked += iac[1];
                continue;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Could not connect to " + BAlarmPortalTool.computeOrdStringFromRecord(entry));
            }
        }
        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
        this.cancelReconnectTicket();
        this.scheduleReconnectTicket();
    }

    public void doRouteAlarm(BAlarmRecord alarm) {
        this.getAlarmPortalConsoleRecipient().doRouteAlarm(alarm);
    }

    public void doUpdateConnectionStatus() {
        this.cancelUpdateTicket();
        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        boolean fullyConnected = this.fullyConnected();
        if (alarmDialog != null) {
            alarmDialog.setFullyConnected(fullyConnected);
        }
        if (!fullyConnected) {
            if ((this.running || this.activeViewCount > 0) && this.options.getAlarmPopupEnabled() && alarmDialog == null) {
                this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
            }
        } else {
            this.cancelUpdateTicket();
            this.scheduleUpdateTicket();
        }
    }

    public synchronized BConsoleRecipient connectToServer(BWidget view, BConsoleRecord entry) throws Exception {
        boolean illegalFoxwssDuplicateDirectAndFallthrough;
        block16: {
            BOrd hostOrd = entry.getHostOrd();
            FoxConnectionTypeEnum foxConnectionType = entry.getUseFoxs() ? FoxConnectionTypeEnum.FOXS_OR_FOXWSS : FoxConnectionTypeEnum.FOX_OR_FOXWSS;
            int websocketPort = -1;
            if ("foxwss".equals(entry.getSessionScheme())) {
                foxConnectionType = FoxConnectionTypeEnum.FOXWSS;
                websocketPort = entry.getPort();
            }
            BFoxSession foxSession = BFoxSession.make(null, (BHost)((BHost)hostOrd.get()), (int)entry.getPort(), (FoxConnectionTypeEnum)foxConnectionType, (int)websocketPort);
            BOrd consoleOrd = entry.getConsoleOrd();
            BICredentials cred = AuthUtil.getCredentials((String)("[alarmPortal]" + foxSession.getAuthenticationRealmName()));
            if (cred != null) {
                foxSession.setCredentials(cred);
            }
            AlarmPortalToolAuthenticationClient client = new AlarmPortalToolAuthenticationClient((BWidget)this.getToolWbShell());
            foxSession.getConnection().setAuthenticationClient((AuthenticationClient)client);
            while (true) {
                try {
                    block19: {
                        BConsoleRecipient recip;
                        block18: {
                            String key;
                            boolean fallthroughToFoxwss;
                            block17: {
                                String sessionScheme = entry.getSessionScheme();
                                foxSession = BFoxSession.connect((BFoxSession)foxSession);
                                boolean bl = fallthroughToFoxwss = (foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS || foxConnectionType == FoxConnectionTypeEnum.FOXS_OR_FOXWSS) && foxSession.getFoxConnectionType() == FoxConnectionTypeEnum.FOXWSS;
                                if (!fallthroughToFoxwss) {
                                    entry.setPort(foxSession.getPort());
                                    entry.setUseFoxs(foxSession.getUseFoxs());
                                    String string = sessionScheme = foxSession.getUseFoxs() ? "foxs" : "fox";
                                    if (foxSession.getFoxConnectionType() == FoxConnectionTypeEnum.FOXWSS) {
                                        sessionScheme = "foxwss";
                                    }
                                    entry.setSessionScheme(sessionScheme);
                                }
                                BOrd stationOrd = BOrd.make((String)"station:");
                                BObject o = stationOrd.get((BObject)foxSession);
                                BFoxStationSpace c = (BFoxStationSpace)o;
                                BOrd tmp = BOrd.make((String)("station:|" + consoleOrd.toString()));
                                recip = (BConsoleRecipient)tmp.get((BObject)c.getRootComponent());
                                key = BAlarmPortalTool.computeOrdStringFromRecord(entry);
                                if (this.recipients.contains(recip) || this.duplicateFoxwssRecipientExists(hostOrd, consoleOrd, sessionScheme)) break block17;
                                if (!this.stations.contains((Object)entry.getHostOrd())) {
                                    this.stations.add((Object)entry.getHostOrd());
                                }
                                this.recipients.put(key, recip);
                                this.consoleUsesFoxwss.put(key, fallthroughToFoxwss || foxSession.getFoxConnectionType() == FoxConnectionTypeEnum.FOXWSS);
                                this.recipToRecord.put(recip, entry);
                                break block18;
                            }
                            if (!this.recipients.containsKey(key)) break block19;
                            this.consoleUsesFoxwss.put(key, fallthroughToFoxwss || foxSession.getFoxConnectionType() == FoxConnectionTypeEnum.FOXWSS);
                        }
                        this.fullyConnected();
                        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
                        this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
                        return recip;
                    }
                    illegalFoxwssDuplicateDirectAndFallthrough = true;
                    break block16;
                }
                catch (ChangeUserAuthenticationException e) {
                    AuthUtil.removeSavedUser((String)("[alarmPortal]" + foxSession.getAuthenticationRealmName()));
                    continue;
                }
                catch (CancelledAuthenticationException e) {
                }
                catch (AuthenticationException e) {
                    LoginFailureCause loginFailureCause = e.getLoginFailureCause();
                    if (loginFailureCause != null && loginFailureCause == LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED) {
                        client.setException(new AuthenticationException(e.getAuthenticationRealm(), (Throwable)new GenericReportableAuthenticationException(LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED)));
                        AuthUtil.removeSavedUser((String)("[alarmPortal]" + foxSession.getAuthenticationRealmName()));
                        continue;
                    }
                    client.setException(e);
                    continue;
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.log(Level.FINE, "Exception encountered connecting to alarm console recipient: " + (Object)((Object)entry), e);
                }
                break;
            }
            return null;
        }
        if (illegalFoxwssDuplicateDirectAndFallthrough) {
            throw new IllegalFoxwssConsoleRecordException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BAlarmConsoleUIChannel channel(BConsoleRecipient recipient) {
        if (recipient == null) {
            return null;
        }
        try {
            BFoxSession session = (BFoxSession)recipient.getSession();
            if (session != null) {
                Object object = BAlarmConsoleChannel.CHANNEL_MUTEX;
                synchronized (object) {
                    return BAlarmConsole.getAlarmUiChannel((BFoxConnection)session.getConnection());
                }
            }
        }
        catch (Exception e) {
            BAlarmPortalTool.logThrowable("Exception getting the alarmui channel for recipient " + recipient.getName(), e);
        }
        return null;
    }

    protected int[] getInitialAlarmCounts(BConsoleRecipient recip) {
        if (recip == null) {
            return new int[]{0, 0};
        }
        try {
            String queryStr = BAlarmPortalTool.channel(recip).getInitialAlarmQuery(this, recip);
            BOrd queryOrd = BOrd.make((String)queryStr);
            BITable collection = (BITable)queryOrd.get((BObject)recip);
            int acked = 0;
            int unacked = 0;
            try (TableCursor cur = collection.cursor();){
                while (cur.next()) {
                    BAlarmRecord rec = (BAlarmRecord)cur.get();
                    if (!this.accept(rec)) continue;
                    if (this.alarms == null) {
                        this.alarms = new Hashtable();
                    }
                    this.alarms.put(rec.getUuid(), rec.getAckState());
                    if (this.sourceStates == null) {
                        this.sourceStates = new Hashtable();
                    }
                    this.sourceStates.put(rec.getSource(), rec.getSourceState());
                    if (rec.isAcknowledged()) {
                        ++acked;
                    } else {
                        ++unacked;
                    }
                    if (rec.isNormal()) continue;
                    this.sourcesInAlarm = true;
                }
            }
            return new int[]{acked, unacked};
        }
        catch (Exception e) {
            BAlarmPortalTool.logThrowable("Exception getting initial alarm counts for recipient " + recip.getName(), e);
            return new int[]{0, 0};
        }
    }

    protected BConsoleRecord getConsoleRecordForStation(BOrd station) {
        BConsoleRecordList list = this.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            BConsoleRecord entry = list.get(i);
            String foxScheme = '|' + BAlarmPortalTool.computeAdjustedSessionScheme(entry.getUseFoxs(), entry.getSessionScheme()) + ':';
            String entryStr = entry.getHostOrd() + foxScheme + entry.getPort();
            if (!entryStr.equals(station.toString())) continue;
            return list.get(i);
        }
        return null;
    }

    public BConsoleRecipient getRecipientForRecord(BConsoleRecord entry) {
        if (entry == null) {
            return null;
        }
        return this.recipients.get(BAlarmPortalTool.computeOrdStringFromRecord(entry));
    }

    protected BConsoleRecord getRecordForRecipient(BConsoleRecipient recip) {
        return this.recipToRecord.get(recip);
    }

    protected BConsoleRecord getConsoleRecordFor(BOrd consoleOrd) {
        String consoleOrdStr;
        String consoleOrdSSLStr = consoleOrdStr = consoleOrd.toString();
        String consoleOrdWebsocketStr = consoleOrdStr;
        if (!(consoleOrdStr.contains("|fox:") || consoleOrdStr.contains("|foxs:") || consoleOrdStr.contains("|foxwss:"))) {
            StringBuilder tmp = new StringBuilder();
            StringBuilder tmpSSL = new StringBuilder();
            StringBuilder tmpWebsocket = new StringBuilder();
            int index = consoleOrdStr.indexOf("|station");
            String prefix = consoleOrdStr.substring(0, index);
            tmp.append(prefix);
            tmpSSL.append(prefix);
            tmpWebsocket.append(prefix);
            tmp.append("|fox:1911");
            tmpSSL.append("|foxs:4911");
            tmpWebsocket.append("|foxwss:443");
            String postfix = consoleOrdStr.substring(index);
            tmp.append(postfix);
            tmpSSL.append(postfix);
            tmpWebsocket.append(postfix);
            consoleOrdStr = tmp.toString();
            consoleOrdSSLStr = tmpSSL.toString();
            consoleOrdWebsocketStr = tmpWebsocket.toString();
        }
        BConsoleRecordList list = this.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            BConsoleRecord record = list.get(i);
            String recordString = record.getHostOrd() + "|fox:" + record.getPort() + "|station:|" + record.getConsoleOrd();
            if (recordString.equals(consoleOrdStr)) {
                return record;
            }
            recordString = record.getHostOrd() + "|foxs:" + record.getPort() + "|station:|" + record.getConsoleOrd();
            if (recordString.equals(consoleOrdSSLStr)) {
                return record;
            }
            recordString = record.getHostOrd() + "|foxwss:" + record.getPort() + "|station:|" + record.getConsoleOrd();
            if (!recordString.equals(consoleOrdWebsocketStr)) continue;
            return record;
        }
        return null;
    }

    protected BConsoleRecipient[] getRecipientsFor(BOrd consoleOrd) {
        Array arr = new Array(BConsoleRecipient.class);
        Enumeration<String> en = this.recipients.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!key.equals(consoleOrd.toString())) continue;
            arr.add((Object)this.recipients.get(key));
        }
        return (BConsoleRecipient[])arr.array();
    }

    public final void handleAlarm(BAlarmRecord alarmRecord) {
        this.getAlarmPortalConsoleRecipient().fireNewUnackedAlarm(alarmRecord);
    }

    public void processAlarm(BAlarmRecord alarmRecord) {
        if (this.running && this.accept(alarmRecord)) {
            BAckState oldAckState = this.alarms.get(alarmRecord.getUuid());
            BSourceState oldSourceState = this.sourceStates.get(alarmRecord.getSource());
            if (oldAckState == null) {
                ++this.unacked;
            } else if (oldAckState != BAckState.acked && alarmRecord.isAcknowledged()) {
                ++this.acked;
                --this.unacked;
            }
            if (oldSourceState == null) {
                this.sourcesInAlarm = true;
            } else if (oldSourceState != BSourceState.normal && alarmRecord.isNormal()) {
                this.sourcesInAlarm = false;
            } else if (oldSourceState == BSourceState.normal && !alarmRecord.isNormal()) {
                this.sourcesInAlarm = false;
                for (BSourceState sourceState : this.sourceStates.values()) {
                    if (sourceState == BSourceState.normal) continue;
                    this.sourcesInAlarm = true;
                    break;
                }
            }
            this.alarms.put(alarmRecord.getUuid(), alarmRecord.getAckState());
            this.sourceStates.put(alarmRecord.getSource(), alarmRecord.getSourceState());
            this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, alarmRecord);
            this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        }
    }

    public boolean accept(BAlarmRecord rec) {
        for (BConsoleRecipient recip : this.recipients.values()) {
            if (!recip.accept(rec)) continue;
            return true;
        }
        return false;
    }

    public void navEvent(NavEvent event) {
    }

    public boolean fullyConnected() {
        if (this.options.getConsoleList().size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.options.getConsoleList().size(); ++i) {
            BConsoleRecipient recip = this.getRecipientForRecord(this.options.getConsoleList().get(i));
            if (recip != null && recip.isMounted() && recip.getSession() != null && recip.getSession().isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean partiallyConnected() {
        if (this.options.getConsoleList().size() <= 0) {
            return false;
        }
        if (this.fullyConnected()) {
            return false;
        }
        Enumeration<String> keys = this.recipients.keys();
        while (keys.hasMoreElements()) {
            BConsoleRecipient recip = this.recipients.get(keys.nextElement());
            if (!recip.isMounted()) continue;
            return true;
        }
        return false;
    }

    public boolean serviceRunning() {
        return BAlarmPortalTool.getManager().isRunning(this.getType().getTypeInfo());
    }

    protected BWbShell getToolWbShell() {
        int i;
        BWidgetShell[] shells = BWidget.getApplication().getShells();
        if (shells.length <= 0) {
            return null;
        }
        for (i = 0; i < shells.length && !(shells[i] instanceof BWbShell); ++i) {
        }
        try {
            return (BWbShell)shells[i];
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void updateTrayIcon(int acked, int unacked, boolean srcInAlarm) {
        if (this.running || this.activeViewCount > 0) {
            if (this.options.getTrayIconEnabled()) {
                if (this.trayIcon == null) {
                    this.trayIcon = new BTrayIcon();
                }
                long icon = this.activeTrayIconImg;
                if (!this.fullyConnected()) {
                    icon = this.inactiveTrayIconImg;
                } else if (acked == 0 && unacked == 0) {
                    icon = this.clearedTrayIconImg;
                } else if (acked > 0 && unacked == 0) {
                    icon = this.unackedTrayIconImg;
                } else if (!srcInAlarm) {
                    icon = this.normalTrayIconImg;
                }
                this.trayIcon.updateTrayIcon(icon, lexicon.getText("AlarmPortalTool.displayName") + ": " + acked + ' ' + lexicon.getText("trayIcon.acked") + " / " + unacked + ' ' + lexicon.getText("trayIcon.unackedAlarms"));
                if (!this.trayIcon.isShowing()) {
                    this.trayIcon.show();
                }
                if (icon != this.inactiveTrayIconImg) {
                    this.cancelUpdateTicket();
                    this.scheduleUpdateTicket();
                }
            } else if (this.trayIcon != null && this.trayIcon.isShowing()) {
                this.trayIcon.hide();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showAlarmDialog(int acked, int unacked, boolean srcInAlarm, BAlarmRecord lastAlarm) {
        if ((this.running || this.activeViewCount > 0) && this.options.getAlarmPopupEnabled()) {
            Object object = ALARM_DIALOG_LOCK;
            synchronized (object) {
                if (alarmDialog == null) {
                    alarmDialog = new BAlarmDialog(this, lexicon.getText("AlarmPortalTool.displayName"), alarmImg, lastAlarm, acked, unacked, this.options.getAlarmPopupAlwaysOnTop(), this.options.getAlarmPopupUncloseable());
                    alarmDialog.open();
                } else {
                    alarmDialog.setVisible(true);
                }
            }
            alarmDialog.setFullyConnected(this.fullyConnected());
            alarmDialog.updateAlarmCounts(acked, unacked, srcInAlarm);
            alarmDialog.updateLastAlarm(lastAlarm);
            alarmDialog.setFullyConnected(this.fullyConnected());
            if (this.fullyConnected()) {
                this.cancelUpdateTicket();
                this.scheduleUpdateTicket();
            }
        }
    }

    protected void updateLastAlarm(BAlarmRecord rec) {
        if (alarmDialog != null) {
            alarmDialog.updateLastAlarm(rec);
            if (!alarmDialog.isVisible()) {
                alarmDialog.setVisible(true);
                alarmDialog.open();
            }
        }
    }

    public void closeAlarmDialog() {
        if (alarmDialog != null) {
            alarmDialog = null;
        }
    }

    protected void viewActivated() {
        ++this.activeViewCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewDeactivated() {
        if (alarmDialog != null) {
            this.options.setPopupPosition(BPoint.make((double)alarmDialog.getScreenBounds().x(), (double)alarmDialog.getScreenBounds().y()));
            this.options.save();
        }
        --this.activeViewCount;
        if (this.activeViewCount == 0) {
            Object object = ALARM_DIALOG_LOCK;
            synchronized (object) {
                if (alarmDialog != null) {
                    alarmDialog.close();
                }
            }
            if (this.trayIcon != null) {
                this.trayIcon.removeTrayIconListener(this);
                if (this.trayIcon.isShowing()) {
                    this.trayIcon.hide();
                }
            }
            if (!this.serviceRunning()) {
                try {
                    this.serviceStopped();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void serviceStarted() throws Exception {
        this.running = true;
        this.alarms = new Hashtable();
        try {
            this.doConnect();
        }
        catch (Exception e) {
            BAlarmPortalTool.logThrowable("Exception while calling doConnect during service started", e);
        }
        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
        if (this.trayIcon != null) {
            this.trayIcon.addTrayIconListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStopped() throws Exception {
        this.running = false;
        this.alarms = null;
        this.sourceStates = null;
        BConsoleRecordList list = this.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                BConsoleRecord entry = list.get(i);
                BAlarmPortalTool.channel(this.getRecipientForRecord(entry)).unregister((BAlarmConsole)null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.activeViewCount == 0) {
            if (this.trayIcon != null) {
                this.trayIcon.removeTrayIconListener(this);
            }
            if (this.trayIcon.isShowing()) {
                this.trayIcon.hide();
            }
            this.options.save();
            Object object = ALARM_DIALOG_LOCK;
            synchronized (object) {
                alarmDialog.close();
                alarmDialog = null;
            }
            this.trayIcon = null;
        }
        this.cancelReconnectTicket();
    }

    @Override
    public void onTrayIconClicked(BTrayIcon source) {
    }

    @Override
    public void onTrayIconDoubleClicked(BTrayIcon source) {
        try {
            this.getToolWbShell().hyperlink(this.getNavOrd());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onAlarmDialogHyperlink(BAlarmDialog source, BOrd ord) {
        try {
            this.getToolWbShell().hyperlink(new HyperlinkInfo(ord, BHyperlinkMode.newTab));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onAlarmDialogClosed(BAlarmDialog source) {
        this.options.setPopupPosition(BPoint.make((double)source.getScreenBounds().x(), (double)source.getScreenBounds().y()));
        alarmDialog = null;
    }

    public void doScanForReconnect() throws Exception {
        if (this.options.getConsoleList().size() <= 0) {
            return;
        }
        if (this.recipients.isEmpty()) {
            return;
        }
        this.cancelReconnectTicket();
        Enumeration<String> keys = this.recipients.keys();
        while (keys.hasMoreElements()) {
            try {
                BConsoleRecipient recipient = this.recipients.get(keys.nextElement());
                if (recipient.isMounted()) continue;
                this.connectToServer(this.view, this.getRecordForRecipient(recipient));
            }
            catch (Exception e) {
                BAlarmPortalTool.logThrowable("Exception re-connecting unmounted recipient", e);
            }
        }
        this.scheduleReconnectTicket();
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("alarm:AlarmConsole");
        list.remove("alarm:PortalAlarmConsole");
        return list;
    }

    private void cancelUpdateTicket() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
    }

    private void scheduleUpdateTicket() {
        this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)updateConnectionStatus, null);
    }

    private void cancelReconnectTicket() {
        if (this.reconnectTicket != null) {
            this.reconnectTicket.cancel();
        }
    }

    private void scheduleReconnectTicket() {
        this.reconnectTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.options.getReconnectInterval(), (Action)scanForReconnect, null);
    }

    private static void logThrowable(String message, Throwable thrown) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, message, thrown);
        } else {
            LOGGER.warning(message);
        }
    }

    boolean duplicateFoxwssRecipientExists(BOrd hostOrd, BOrd consoleOrd, String sessionScheme) {
        String postFix = "|station:|" + consoleOrd;
        String[] incompatibleKeyPrefixesToCheck = "foxwss".equals(sessionScheme) ? new String[]{hostOrd + "|" + "fox" + ':', hostOrd + "|" + "foxs" + ':'} : ("fox".equals(sessionScheme) ? new String[]{hostOrd + "|" + "foxwss" + ':', hostOrd + "|" + "foxs" + ':'} : new String[]{hostOrd + "|" + "foxwss" + ':', hostOrd + "|" + "fox" + ':'});
        return this.recipients.keySet().stream().anyMatch(k -> {
            if (k.endsWith(postFix)) {
                for (String incompatibleKeyPrefixToCheck : incompatibleKeyPrefixesToCheck) {
                    if (!k.startsWith(incompatibleKeyPrefixToCheck) || !this.consoleUsesFoxwss.get(k).booleanValue()) continue;
                    return true;
                }
            }
            return false;
        });
    }

    static String getFoxSessionScheme(boolean useFoxs, FoxConnectionTypeEnum foxConnectionType) {
        String sessionScheme;
        String string = sessionScheme = useFoxs ? "foxs" : "fox";
        if (foxConnectionType == FoxConnectionTypeEnum.FOXWSS) {
            sessionScheme = "foxwss";
        }
        return sessionScheme;
    }

    static String computeOrdStringFromRecord(BConsoleRecord rec) {
        return BAlarmPortalTool.computeOrdStringFromRecordParts(rec.getHostOrd(), rec.getPort(), rec.getUseFoxs(), rec.getSessionScheme(), rec.getConsoleOrd());
    }

    static String computeOrdStringFromRecordParts(BOrd hostOrd, int port, boolean useFoxs, String scheme, BOrd consoleOrd) {
        String sessionScheme = BAlarmPortalTool.computeAdjustedSessionScheme(useFoxs, scheme);
        return hostOrd + "|" + sessionScheme + ':' + port + "|station:|" + consoleOrd;
    }

    static String computeAdjustedSessionScheme(boolean useFoxs, String scheme) {
        String sessionScheme;
        String string = sessionScheme = useFoxs ? "foxs" : "fox";
        if ("foxwss".equals(scheme)) {
            sessionScheme = scheme;
        }
        return sessionScheme;
    }

    static BOrd computeOrdFromRecord(BConsoleRecord rec) {
        return BOrd.make((String)BAlarmPortalTool.computeOrdStringFromRecord(rec));
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        ALARM_DIALOG_LOCK = new Object();
        alarmImg = BImage.make((String)"module://icons/x16/alarm.png");
        lexicon = UiLexicon.makeUiLexicon(BAlarmPortalTool.class);
        icon = BIcon.std((String)"alarm.png");
        LOGGER = Logger.getLogger("alarm");
    }

    private static class AlarmPortalToolAuthenticationClient
    extends WbAuthenticationClient {
        public AlarmPortalToolAuthenticationClient(BWidget owner) {
            super(owner);
        }

        public String getRealmPrefix() {
            return "[alarmPortal]";
        }
    }
}

