/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsoleUIChannel;
import com.tridium.alarm.ui.portal.AddConsoleWizard;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.alarm.ui.portal.BConsoleRecordList;
import com.tridium.alarm.ui.portal.BPortalAlarmConsole;
import com.tridium.alarm.ui.portal.IllegalFoxwssConsoleRecordException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.fox.BFoxProxySession;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmPortalTool"})})
public class BAlarmPortal
extends BWbView
implements BFoxProxySession.NotifyListener,
BWbShell.ActivityListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmPortal.class);
    private ConsoleRecipientSubscriber subscriber;
    BGridPane controlPane;
    ToggleCommand trayIconEnabled;
    ToggleCommand alarmPopupEnabled;
    ToggleCommand alarmPopupAlwaysOnTop;
    ToggleCommand alarmPopupUncloseable;
    Command addCommand;
    BButton startButton;
    BButton stopButton;
    BCheckBox autoStart;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAlarmPortal.class);
    public static final Logger log = Logger.getLogger("alarm");
    BAlarmPortalTool tool;
    BPortalAlarmConsole console;
    BTable acMonitor = new BTable();
    public static final String REALM_PREFIX = "[alarmPortal]";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmPortal() throws Exception {
        this.acMonitor.setController((TableController)new MonitorController());
        this.acMonitor.setModel((TableModel)new MonitorModel());
        this.acMonitor.setCellRenderer((TableCellRenderer)new MonitorCellRenderer());
        this.acMonitor.setSelection(new TableSelection(){

            public void select(int row, boolean clear) {
                super.select(row, true);
            }

            public void select(int anchor, int lead, boolean clear) {
                super.select(lead, true);
            }

            public void select(int[] rows) {
                super.select(rows[0], true);
            }
        });
        BSplitPane splitPane = new BSplitPane(BOrientation.vertical, 20.0);
        splitPane.setWidget1((BWidget)BTitlePane.makePane((String)lexicon.getText("portal.alarmConsoleMonitor"), (BTable)this.acMonitor, (String)"Consoles"));
        this.console = new BPortalAlarmConsole();
        splitPane.setWidget2((BWidget)this.console);
        BEdgePane contentPane = new BEdgePane();
        contentPane.setCenter((BWidget)splitPane);
        this.setContent((BWidget)contentPane);
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        this.tool = (BAlarmPortalTool)value;
        this.trayIconEnabled = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.trayIconEnabled"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setTrayIconEnabled(this.isSelected());
                BAlarmPortal.this.tool.updateTrayIcon(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm());
                return null;
            }
        };
        this.trayIconEnabled.setSelected(this.tool.options.getTrayIconEnabled());
        this.alarmPopupEnabled = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.alarmPopupEnabled"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setAlarmPopupEnabled(this.isSelected());
                BAlarmPortal.this.alarmPopupAlwaysOnTop.setEnabled(this.isSelected());
                BAlarmPortal.this.alarmPopupUncloseable.setEnabled(this.isSelected());
                if (this.isSelected()) {
                    BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), BAlarmPortal.this.console.getMostRecentRecord());
                } else {
                    BAlarmPortal.this.tool.closeAlarmDialog();
                }
                return null;
            }
        };
        this.alarmPopupEnabled.setSelected(this.tool.options.getAlarmPopupEnabled());
        this.alarmPopupAlwaysOnTop = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.alarmPopupAlwaysOnTop"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setAlarmPopupAlwaysOnTop(this.isSelected());
                if (BAlarmPortalTool.alarmDialog != null) {
                    BAlarmPortalTool.alarmDialog.setAlwaysOnTop(this.isSelected());
                }
                BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
                return null;
            }
        };
        this.alarmPopupAlwaysOnTop.setEnabled(this.alarmPopupEnabled.isSelected());
        this.alarmPopupAlwaysOnTop.setSelected(this.tool.options.getAlarmPopupAlwaysOnTop());
        this.alarmPopupUncloseable = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.alarmPopupUncloseable"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setAlarmPopupUncloseable(this.isSelected());
                if (BAlarmPortalTool.alarmDialog != null) {
                    BAlarmPortalTool.alarmDialog.setUncloseable(this.isSelected());
                }
                BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
                return null;
            }
        };
        this.alarmPopupUncloseable.setEnabled(this.alarmPopupEnabled.isSelected());
        this.alarmPopupUncloseable.setSelected(this.tool.options.getAlarmPopupUncloseable());
        this.addCommand = new Command((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.add"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.addConsoleRecipient();
                return null;
            }
        };
        BConsoleRecordList list = this.tool.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            BConsoleRecord rec = list.get(i);
            ((MonitorModel)this.acMonitor.getModel()).addConsoleRecord(rec);
        }
        this.tool.viewActivated();
        new LoadThread().start();
    }

    public boolean onNotify(BFoxProxySession session) {
        return this.getWbShell().notifyTimeout((BWidget)this, (BISession)session);
    }

    public void activity() {
        if (!this.isVisible()) {
            return;
        }
        BConsoleRecordList list = this.tool.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            BConsoleRecord rec = list.get(i);
            BConsoleRecipient recip = this.tool.getRecipientForRecord(rec);
            if (recip == null || !(recip.getSession() instanceof BFoxProxySession)) continue;
            ((BFoxProxySession)recip.getSession()).userActivity();
        }
    }

    public void activated() {
        this.getWbShell().addActivityListener((BWbShell.ActivityListener)this);
    }

    public void deactivated() {
        this.getWbShell().removeActivityListener((BWbShell.ActivityListener)this);
        BConsoleRecordList list = this.tool.options.getConsoleList();
        for (int i = 0; i < list.size(); ++i) {
            BConsoleRecord rec = list.get(i);
            BConsoleRecipient recip = this.tool.getRecipientForRecord(rec);
            if (recip == null || !(recip.getSession() instanceof BFoxProxySession)) continue;
            ((BFoxProxySession)recip.getSession()).removeNotifyListener((BFoxProxySession.NotifyListener)this);
        }
        this.tool.viewDeactivated();
        super.deactivated();
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
        }
    }

    public BIMenu[] getViewMenus() {
        BMenu[] menus = this.console.getViewMenus();
        menus[0].add("portalSep", (BValue)new BSeparator());
        menus[0].add("addConsole", this.addCommand);
        menus[0].add("portalSep2", (BValue)new BSeparator());
        menus[0].add("trayIconEnabled", (Command)this.trayIconEnabled);
        menus[0].add("alarmPopupEnabled", (Command)this.alarmPopupEnabled);
        menus[0].add("alarmPopupAlwaysOnTop", (Command)this.alarmPopupAlwaysOnTop);
        menus[0].add("alarmPopupUncloseable", (Command)this.alarmPopupUncloseable);
        return menus;
    }

    public BToolBar getViewToolBar() {
        BToolBar toolBar = new BToolBar();
        toolBar.addButton("addConsole", this.addCommand);
        return toolBar;
    }

    private void addConsoleRecipient() {
        BConsoleRecordList list = this.tool.options.getConsoleList();
        int sizeBefore = list.size();
        AddConsoleWizard wizard = new AddConsoleWizard(list);
        BWizard.open((BWidget)this.getWbShell(), (WizardModel)wizard);
        list = wizard.getConsoleRecordList();
        int addedRows = list.size() - sizeBefore;
        if (addedRows > 0) {
            this.tool.options.setConsoleList(list);
            this.tool.options.save();
            for (int i = addedRows; i > 0; --i) {
                BConsoleRecord rec = list.get(list.size() - i);
                ((MonitorModel)this.acMonitor.getModel()).addConsoleRecord(rec);
                this.connect(rec, list.size() - i);
            }
            this.acMonitor.sizeColumnsToFit();
            this.acMonitor.getModel().updateTable();
        }
    }

    void connect(BConsoleRecord rec, int currentRow) {
        BAbsTime sinceTime = (BAbsTime)this.acMonitor.getModel().getValueAt(currentRow, 6);
        ConnectThread th = new ConnectThread(rec, currentRow, sinceTime);
        th.start();
    }

    class MonitorCellRenderer
    extends TableCellRenderer {
        int i = -1;

        MonitorCellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            boolean connected;
            BOrd hostOrd = (BOrd)this.getTable().getModel().getValueAt(cell.row, 0);
            Integer port = (Integer)this.getTable().getModel().getValueAt(cell.row, 1);
            BBoolean useFoxs = (BBoolean)this.getTable().getModel().getValueAt(cell.row, 2);
            String scheme = (String)this.getTable().getModel().getValueAt(cell.row, 3);
            BOrd consoleOrd = (BOrd)this.getTable().getModel().getValueAt(cell.row, 4);
            BConsoleRecipient recip = BAlarmPortal.this.tool.recipients.get(BAlarmPortalTool.computeOrdStringFromRecordParts(hostOrd, port, useFoxs.getBoolean(), scheme, consoleOrd));
            boolean bl = connected = recip != null && recip.isMounted();
            if (!connected) {
                if (BAlarmPortal.this.console != null && BAlarmPortal.this.tool != null) {
                    BAlarmPortal.this.tool.updateTrayIcon(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm());
                    BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
                }
                return BBrush.makeSolid((BColor)((BColor)BStatus.downBg));
            }
            return null;
        }
    }

    class MonitorController
    extends TableController {
        MonitorController() {
        }

        public void cellPopup(BMouseEvent event, int row, int col) {
            Command connectCommand = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.connect"){

                public CommandArtifact doInvoke() {
                    MonitorController.this.connectConsole();
                    return null;
                }
            };
            Command connectNewCommand = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.connectNewUser"){

                public CommandArtifact doInvoke() {
                    int currentRow = MonitorController.this.getTable().getSelection().getRow();
                    BConsoleRecord rec = ((MonitorModel)MonitorController.this.getTable().getModel()).getConsoleEntry(currentRow);
                    BConsoleRecipient recip = BAlarmPortal.this.tool.recipients.get(BAlarmPortalTool.computeOrdStringFromRecord(rec));
                    BFoxSession foxSession = null;
                    if (recip != null && recip.getSession() instanceof BFoxSession) {
                        foxSession = (BFoxSession)recip.getSession();
                    }
                    if (foxSession == null) {
                        BOrd hostOrd = rec.getHostOrd();
                        FoxConnectionTypeEnum foxConnType = rec.getUseFoxs() ? FoxConnectionTypeEnum.FOXS_OR_FOXWSS : FoxConnectionTypeEnum.FOX_OR_FOXWSS;
                        int websocketPort = -1;
                        if ("foxwss".equals(rec.getSessionScheme())) {
                            foxConnType = FoxConnectionTypeEnum.FOXWSS;
                            websocketPort = rec.getPort();
                        }
                        foxSession = BFoxSession.make(null, (BHost)((BHost)hostOrd.get()), (int)rec.getPort(), (FoxConnectionTypeEnum)foxConnType, (int)websocketPort);
                    }
                    AuthUtil.removeSavedUser((String)(BAlarmPortal.REALM_PREFIX + foxSession.getAuthenticationRealmName()));
                    AuthUtil.removeCredentials((String)(BAlarmPortal.REALM_PREFIX + foxSession.getAuthenticationRealmName()));
                    if (foxSession.isConnected()) {
                        foxSession.disconnect();
                    }
                    MonitorController.this.connectConsole();
                    return null;
                }
            };
            Command disconnectCommand = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.disconnect"){

                public CommandArtifact doInvoke() {
                    try {
                        int currentRow = MonitorController.this.getTable().getSelection().getRow();
                        BConsoleRecord entry = ((MonitorModel)MonitorController.this.getTable().getModel()).getConsoleEntry(currentRow);
                        BConsoleRecipient recip = BAlarmPortal.this.tool.recipients.get(BAlarmPortalTool.computeOrdStringFromRecord(entry));
                        if (recip != null && recip.getSession() != null) {
                            recip.getSession().disconnect();
                        }
                        ((MonitorModel)MonitorController.this.getTable().getModel()).set(currentRow, 6, BAbsTime.now());
                    }
                    catch (Exception e) {
                        log.severe("Cannot disconnect: " + e);
                    }
                    return null;
                }
            };
            Command removeCommand = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.remove"){

                public CommandArtifact doInvoke() {
                    MonitorController.this.deleteConsoleRecipient();
                    return null;
                }
            };
            Command conCmd = null;
            String statusVal = this.getTable().getModel().getValueAt(row, 5).toString();
            conCmd = statusVal.equals(lexicon.getText("portal.connected")) || statusVal.equals(lexicon.getText("portal.connected.foxwssRedirect")) ? disconnectCommand : connectCommand;
            BMenu menu = new BMenu();
            menu.add("connect", conCmd);
            menu.add("connectNew", connectNewCommand);
            menu.add("sep", (BValue)new BSeparator());
            menu.add("remove", removeCommand);
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }

        protected void backgroundPopup(BMouseEvent event) {
            BMenu menu = new BMenu();
            menu.add("add", BAlarmPortal.this.addCommand);
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }

        private void deleteConsoleRecipient() {
            int[] rows = this.getTable().getSelection().getRows();
            rows = this.sort(rows);
            BConsoleRecord[] recs = new BConsoleRecord[rows.length];
            for (int i = rows.length - 1; i >= 0; --i) {
                recs[i] = ((MonitorModel)this.getTable().getModel()).getConsoleEntry(rows[i]);
                String key = BAlarmPortalTool.computeOrdStringFromRecord(recs[i]);
                BConsoleRecipient recip = BAlarmPortal.this.tool.recipients.remove(key);
                BAlarmPortal.this.tool.consoleUsesFoxwss.remove(key);
                if (recip != null) {
                    BAlarmPortal.this.tool.recipToRecord.remove(recip);
                }
                if (recip != null && recip.getSession() != null) {
                    if (recip.getSession() instanceof BFoxProxySession) {
                        ((BFoxProxySession)recip.getSession()).removeNotifyListener((BFoxProxySession.NotifyListener)BAlarmPortal.this);
                    }
                    recip.getSession().disconnect();
                }
                BAlarmPortal.this.console.removeAlarmsFrom(recs[i]);
            }
            BConsoleRecordList list = BAlarmPortal.this.tool.options.getConsoleList();
            for (int i = rows.length - 1; i >= 0; --i) {
                list = BConsoleRecordList.remove(list, rows[i]);
                ((MonitorModel)this.getTable().getModel()).removeConsoleRecordAt(rows[i]);
            }
            BAlarmPortal.this.tool.options.setConsoleList(list);
            BAlarmPortal.this.tool.options.save();
            this.getTable().getModel().updateTable();
            this.getTable().sizeColumnsToFit();
            BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
        }

        private void connectConsole() {
            int currentRow = this.getTable().getSelection().getRow();
            BAbsTime sinceTime = (BAbsTime)this.getTable().getModel().getValueAt(currentRow, 6);
            BConsoleRecord rec = ((MonitorModel)this.getTable().getModel()).getConsoleEntry(currentRow);
            try {
                if (null == BAlarmPortal.this.tool.connectToServer((BWidget)BAlarmPortal.this, rec)) {
                    String unableToConnectToHostMessage = "Unable to establish a connection to host: " + rec.getHostOrd().toString();
                    if (log.isLoggable(Level.SEVERE)) {
                        log.severe(unableToConnectToHostMessage);
                    }
                    throw new BajaRuntimeException(unableToConnectToHostMessage);
                }
                BConsoleRecipient recip = BAlarmPortal.this.tool.getRecipientForRecord(rec);
                if (recip == null) {
                    String unableToGetConsoleRecip = "Unable to get Console Recipient for record: " + rec.getConsoleOrd().toString();
                    if (log.isLoggable(Level.SEVERE)) {
                        log.severe(unableToGetConsoleRecip);
                    }
                    throw new BajaRuntimeException(unableToGetConsoleRecip);
                }
                BOrd newOrd = BAlarmPortalTool.computeOrdFromRecord(rec);
                BAlarmConsoleUIChannel alarmConsoleChannel = BAlarmPortal.this.console.channel(recip);
                if (alarmConsoleChannel == null) {
                    String unableToGetAlarmConsoleUiChannel = "Unable to get Alarm Console UI Channel for given recipient: " + recip;
                    if (log.isLoggable(Level.SEVERE)) {
                        log.severe(unableToGetAlarmConsoleUiChannel);
                    }
                    throw new BajaRuntimeException(unableToGetAlarmConsoleUiChannel);
                }
                String queryOrdStr = alarmConsoleChannel.getInitialAlarmQuery(BAlarmPortal.this.console, recip, newOrd);
                BOrd queryOrd = BOrd.make((String)(queryOrdStr + " and timestamp >= AbsTime '" + sinceTime.encodeToString() + "'"));
                BITable collection = (BITable)queryOrd.get((BObject)recip);
                ((MonitorModel)this.getTable().getModel()).set(currentRow, 6, BAbsTime.now());
                try (TableCursor cur = collection.cursor();){
                    BPortalAlarmConsole.SourceModCursor recs = new BPortalAlarmConsole.SourceModCursor(newOrd, (Cursor<BAlarmRecord>)cur);
                    while (recs.next()) {
                        BAlarmRecord alarm = (BAlarmRecord)recs.get();
                        BAlarmPortal.this.console.processAlarm(alarm);
                    }
                }
            }
            catch (CancelledAuthenticationException recip) {
            }
            catch (IllegalFoxwssConsoleRecordException ex) {
                BDialog.error((BWidget)BAlarmPortal.this, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)lexicon.getText("portal.illegalDuplicateFoxwssConnection"));
            }
            catch (Exception e) {
                BDialog.error((BWidget)BAlarmPortal.this, (String)lexicon.getText("portal.connectFailed"), (Object)lexicon.getText("messages.connectionError", new Object[]{rec.getHostOrd()}), (Throwable)e);
            }
        }

        private int[] sort(int[] rows) {
            for (int i = rows.length - 1; i >= 0; --i) {
                for (int j = 1; j <= i; ++j) {
                    if (rows[j - 1] <= rows[j]) continue;
                    int temp = rows[j - 1];
                    rows[j - 1] = rows[j];
                    rows[j] = temp;
                }
            }
            return rows;
        }
    }

    class MonitorModel
    extends DefaultTableModel {
        ArrayList<BConsoleRecord> entries;
        Hashtable<BConsoleRecipient, Boolean> wasConnectedList;

        public MonitorModel() {
            super(new String[]{lexicon.getText("portal.station"), lexicon.getText("portal.port"), lexicon.getText("auth.foxs"), lexicon.getText("portal.scheme"), lexicon.getText("portal.consoleOrd"), lexicon.getText("portal.status"), lexicon.getText("portal.lastConnectTime"), lexicon.getText("portal.lastDisconnectTime")});
            this.wasConnectedList = new Hashtable();
            this.entries = new ArrayList();
        }

        public void addConsoleRecord(BConsoleRecord cr) {
            this.entries.add(cr);
            Object[] args = new Object[]{cr.getHostOrd(), cr.getPort(), BBoolean.make((boolean)cr.getUseFoxs()), cr.getSessionScheme(), cr.getConsoleOrd(), lexicon.getText("portal.notConnected"), BAbsTime.NULL, BAbsTime.NULL};
            this.addRow(null, args);
        }

        public void removeConsoleRecordAt(int row) {
            BConsoleRecipient recip;
            this.removeRow(row);
            BConsoleRecord rec = this.entries.remove(row);
            if (rec != null && (recip = BAlarmPortal.this.tool.recipients.get(BAlarmPortalTool.computeOrdStringFromRecord(rec))) != null && BAlarmPortal.this.subscriber != null) {
                BAlarmPortal.this.subscriber.unsubscribe((BComponent)recip);
            }
        }

        public BConsoleRecord getConsoleEntry(int row) {
            return this.entries.get(row);
        }

        public Object getValueAt(int row, int col) {
            BConsoleRecord entry;
            if (row < this.entries.size() && (entry = this.entries.get(row)) != null) {
                switch (col) {
                    case 0: {
                        return entry.getHostOrd();
                    }
                    case 1: {
                        return entry.getPort();
                    }
                    case 2: {
                        return BBoolean.make((boolean)entry.getUseFoxs());
                    }
                    case 3: {
                        return entry.getSessionScheme();
                    }
                    case 4: {
                        return entry.getConsoleOrd();
                    }
                }
            }
            if (col == 5) {
                boolean connected;
                BOrd hostOrd = (BOrd)this.getTable().getModel().getValueAt(row, 0);
                Integer port = (Integer)this.getTable().getModel().getValueAt(row, 1);
                BBoolean useFoxs = (BBoolean)this.getTable().getModel().getValueAt(row, 2);
                String scheme = (String)this.getTable().getModel().getValueAt(row, 3);
                BOrd consoleOrd = (BOrd)this.getTable().getModel().getValueAt(row, 4);
                String key = BAlarmPortalTool.computeOrdStringFromRecordParts(hostOrd, port, useFoxs.getBoolean(), scheme, consoleOrd);
                BConsoleRecipient recip = BAlarmPortal.this.tool.recipients.get(key);
                if (recip == null) {
                    if (BAlarmPortal.this.tool.duplicateFoxwssRecipientExists(hostOrd, consoleOrd, BAlarmPortalTool.computeAdjustedSessionScheme(useFoxs.getBoolean(), scheme))) {
                        return lexicon.getText("portal.notConnected.duplicateFoxwss");
                    }
                    if (Boolean.TRUE.equals(BAlarmPortal.this.tool.consoleUsesFoxwss.get(key)) && !"foxwss".equals(scheme)) {
                        return lexicon.getText("portal.notConnected.foxwssRedirect");
                    }
                    return lexicon.getText("portal.notConnected");
                }
                Boolean wc = this.wasConnectedList.get(recip);
                boolean wasConnected = wc != null ? wc : false;
                boolean bl = connected = recip != null && recip.isMounted();
                if (wasConnected && !connected) {
                    this.set(row, 7, BAbsTime.now());
                } else if (!wasConnected && connected) {
                    BConsoleRecord rec = ((MonitorModel)this.getTable().getModel()).getConsoleEntry(row);
                    BAlarmPortal.this.connect(rec, row);
                    this.set(row, 6, BAbsTime.now());
                }
                this.wasConnectedList.put(recip, connected);
                if (connected) {
                    BFoxSession foxSession;
                    if (recip.getSession() instanceof BFoxSession && (foxSession = (BFoxSession)recip.getSession()).getFoxConnectionType() == FoxConnectionTypeEnum.FOXWSS && !"foxwss".equals(BAlarmPortalTool.computeAdjustedSessionScheme(useFoxs.getBoolean(), scheme))) {
                        return lexicon.getText("portal.connected.foxwssRedirect");
                    }
                    return lexicon.getText("portal.connected");
                }
                if (Boolean.TRUE.equals(BAlarmPortal.this.tool.consoleUsesFoxwss.get(key)) && !"foxwss".equals(scheme)) {
                    return lexicon.getText("portal.notConnected.foxwssRedirect");
                }
                return lexicon.getText("portal.notConnected");
            }
            return super.getValueAt(row, col);
        }
    }

    private class ConsoleRecipientSubscriber
    extends Subscriber {
        private ConsoleRecipientSubscriber() {
        }

        public void event(BComponentEvent event) {
        }
    }

    class ConnectThread
    extends Thread {
        BConsoleRecord rec;
        int currentRow;
        BAbsTime sinceTime;

        ConnectThread(BConsoleRecord rec, int currentRow, BAbsTime sinceTime) {
            super("alarm: Portal Reconnect");
            this.rec = rec;
            this.currentRow = currentRow;
            this.sinceTime = sinceTime;
        }

        @Override
        public void run() {
            try {
                BAlarmPortal.this.tool.connectToServer((BWidget)BAlarmPortal.this, this.rec);
                BConsoleRecipient recip = BAlarmPortal.this.tool.getRecipientForRecord(this.rec);
                if (BAlarmPortal.this.subscriber == null) {
                    BAlarmPortal.this.subscriber = new ConsoleRecipientSubscriber();
                }
                BAlarmPortal.this.subscriber.subscribe((BComponent)recip);
                BOrd newOrd = BAlarmPortalTool.computeOrdFromRecord(this.rec);
                String queryOrdStr = BAlarmPortal.this.console.channel(recip).getInitialAlarmQuery(BAlarmPortal.this.console, recip, newOrd).toString();
                boolean firstConnect = this.sinceTime.isNull();
                BOrd queryOrd = firstConnect ? BOrd.make((String)queryOrdStr) : BOrd.make((String)(queryOrdStr + " and timestamp >= AbsTime '" + this.sinceTime.encodeToString() + "'"));
                BITable collection = (BITable)queryOrd.get((BObject)recip);
                ((MonitorModel)BAlarmPortal.this.acMonitor.getModel()).set(this.currentRow, 6, BAbsTime.now());
                TableCursor cur = collection.cursor();
                BPortalAlarmConsole.SourceModCursor recs = new BPortalAlarmConsole.SourceModCursor(newOrd, (Cursor<BAlarmRecord>)cur);
                int i = 0;
                while (recs.next()) {
                    BAlarmRecord alarm = (BAlarmRecord)recs.get();
                    BAlarmPortal.this.console.doProcessAlarm(alarm);
                    ++i;
                }
                this.rec.setInitialLoadComplete(true);
                BAlarmPortal.this.console.init();
                if (recip != null && recip.getSession() instanceof BFoxProxySession) {
                    ((BFoxProxySession)recip.getSession()).addNotifyListener((BFoxProxySession.NotifyListener)BAlarmPortal.this);
                }
            }
            catch (IllegalFoxwssConsoleRecordException ex) {
                BDialog.error((BWidget)BAlarmPortal.this, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)lexicon.getText("portal.illegalDuplicateFoxwssConnection"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot connect to: " + BAlarmPortalTool.computeOrdStringFromRecord(this.rec) + " : ", e);
            }
        }
    }

    class LoadThread
    extends Thread {
        LoadThread() {
        }

        @Override
        public void run() {
            BAlarmPortal.this.console.loadValue((BObject)BAlarmPortal.this.tool);
            BAlarmPortal.this.tool.connect((BWidget)BAlarmPortal.this);
            try {
                BNiagaraWbShell shell = (BNiagaraWbShell)BAlarmPortal.this.getWbShell();
                shell.pane.update(shell.tab());
            }
            catch (Exception shell) {
                // empty catch block
            }
            int acked = BAlarmPortal.this.console.getAckedAlarmCount();
            int unacked = BAlarmPortal.this.console.getUnackedAlarmCount();
            BAlarmPortal.this.tool.showAlarmDialog(acked, unacked, BAlarmPortal.this.console.sourcesInAlarm(), null);
        }
    }
}

