/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.alarm.ui.portal.BConsoleRecordList;
import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.GenericReportableAuthenticationException;
import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BFoxStationSpace;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BCnxConfigPane;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.auth.BHostCnxHandler;
import com.tridium.workbench.auth.BStationCnxType;
import com.tridium.workbench.auth.BWbLoginPane;
import com.tridium.workbench.auth.WbAuthenticationClient;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BITable;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.gx.Size;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.security.ChangeUserAuthenticationException;
import javax.baja.security.ReportCauseAuthenticationException;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.workbench.authn.BCredInputPane;

public class AddConsoleWizard
extends WizardModel
implements BFoxClientConnection.Interest {
    static UiLexicon lex = UiLexicon.makeUiLexicon(AddConsoleWizard.class);
    boolean edit = false;
    boolean online = true;
    private static final int STEP_HOST = 0;
    private static final int STEP_USERNAME = 1;
    private static final int STEP_CREDS = 2;
    private static final int STEP_CONSOLE = 3;
    private static final int STEP_TLS_APPROVAL = 4;
    private static final int STEP_CONNECTING = 5;
    int currentStep = 0;
    AuthenticationRealm realm = null;
    BOrd hostOrd;
    int port;
    boolean useFoxs;
    FoxConnectionTypeEnum foxConnectionType;
    BFoxSession foxSession;
    boolean requestReceived;
    int responseState;
    private static final int WAITING_FOR_RESPONSE = 0;
    private static final int RESPONSE_ACQUIRED = 1;
    private static final int RESPONSE_FAILED = 2;
    int connectionState;
    private static final int CONNECTING = 0;
    private static final int CONNECTED = 1;
    private static final int CONNECTION_FAILED = 2;
    private static final int CONNECTION_N4AX_INCOMPATIBILITY = 3;
    boolean tlsThreadRunning = false;
    boolean cancelled = false;
    String connectionFailureCause = null;
    BWidget hostPane;
    BWidget consolePane;
    BEdgePane tlsWaitPane;
    BCnxConfigPane openPane;
    BTable acTable;
    CollectionTableModel acTableModel;
    BTextField offlineOrdField;
    BConsoleRecordList list;

    public AddConsoleWizard(BConsoleRecordList list) {
        this.list = list;
        this.buildStepHost();
    }

    private void buildStepHost() {
        BCnxHandler[] handlers = BCnxHandler.getHandlersOnType((TypeInfo)BStationCnxType.TYPE.getTypeInfo(), null);
        this.openPane = new BCnxConfigPane(handlers);
        this.hostPane = this.openPane;
    }

    private void buildStepConsole() {
        try {
            if (this.connectionFailed()) {
                throw new Exception("Authentication failed.");
            }
            BOrd stationOrd = BOrd.make((String)"station:");
            BObject o = stationOrd.get((BObject)this.foxSession);
            BFoxStationSpace c = (BFoxStationSpace)o;
            BOrd queryOrd = BOrd.make((String)"station:|slot:/|bql:select slotPathOrd from alarm:ConsoleRecipient");
            BITable alarmConsoles = (BITable)queryOrd.get((BObject)c.getRootComponent());
            this.acTable = new BTable();
            this.acTable.setController((TableController)new Controller());
            this.acTableModel = new CollectionTableModel(alarmConsoles, null);
            this.acTable.setModel((TableModel)this.acTableModel);
            this.acTable.setSelection(new TableSelection(){

                public void select(int row, boolean clear) {
                    super.select(row, true);
                }

                public void select(int anchor, int lead, boolean clear) {
                    super.select(lead, true);
                }

                public void select(int[] rows) {
                    super.select(rows[0], true);
                }
            });
            BEdgePane edge = new BEdgePane();
            edge.setCenter((BWidget)this.acTable);
            this.consolePane = edge;
            this.online = true;
            if (this.acTableModel.getRowCount() == 1) {
                TableSelection sel = this.acTable.getSelection();
                sel.selectAll();
                this.acTable.setSelection(sel);
                this.update(5);
            }
        }
        catch (Exception e) {
            this.online = false;
            BLabel error = new BLabel(lex.getText("messages.connectionError", new Object[]{this.hostOrd}));
            BLabel error2 = new BLabel(e.toString());
            BLabel instructions = new BLabel(lex.getText("portal.wizard.alarmConsoleOrd"));
            this.offlineOrdField = new BTextField("slot:/", 40);
            BGridPane pane = new BGridPane(1);
            pane.add(null, (BValue)error);
            pane.add(null, (BValue)error2);
            pane.add(null, (BValue)new BLabel(""));
            pane.add(null, (BValue)instructions);
            pane.add(null, (BValue)this.offlineOrdField);
            this.consolePane = pane;
        }
    }

    public String getTitle() {
        if (this.edit) {
            return lex.getText("portal.wizard.editTitle");
        }
        return lex.getText("portal.wizard.addTitle");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(360.0, 250.0);
    }

    public void init() {
        this.updateTo(0);
    }

    public void back() {
        switch (this.currentStep) {
            case 1: {
                this.abortConnection();
                this.updateTo(0);
                break;
            }
            case 2: {
                AuthUtil.removeSavedUser((String)("[alarmPortal]" + this.realm.getAuthenticationRealmName()));
                this.abortConnection();
                this.getWizard().enterBusy();
                this.startConnectionAttempt();
                if (this.useFoxs || this.foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS) {
                    new TlsCheckThread().start();
                    this.waitForTlsThreadStart();
                    if (this.useFoxs) {
                        this.updateTo(4);
                        break;
                    }
                    this.updateTo(5);
                    break;
                }
                this.waitForRequest();
                this.getWizard().exitBusy();
                this.updateTo(1);
                break;
            }
            case 3: {
                AuthUtil.removeSavedUser((String)("[alarmPortal]" + this.realm.getAuthenticationRealmName()));
                this.getWizard().enterBusy();
                this.foxSession.disconnect();
                this.startConnectionAttempt();
                this.getWizard().exitBusy();
                if (!this.useFoxs && this.foxConnectionType != FoxConnectionTypeEnum.FOX_OR_FOXWSS) break;
                new TlsCheckThread().start();
                this.waitForTlsThreadStart();
                if (this.useFoxs) {
                    this.updateTo(4);
                    break;
                }
                this.updateTo(5);
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                this.processHostPane();
                this.getWizard().enterBusy();
                BHost host = (BHost)this.hostOrd.get();
                this.foxSession = BFoxSession.make(null, (BHost)host, (int)this.port, (FoxConnectionTypeEnum)this.foxConnectionType, (int)-1);
                if (this.foxSession.isConnected()) {
                    this.getWizard().exitBusy();
                    this.realm = this.foxSession;
                    this.updateTo(3);
                    break;
                }
                this.startConnectionAttempt();
                if (this.useFoxs || this.foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS) {
                    if (this.useFoxs) {
                        this.updateTo(4);
                    } else {
                        this.updateTo(5);
                    }
                    new TlsCheckThread().start();
                    this.waitForTlsThreadStart();
                    break;
                }
                this.waitForRequest();
                this.getWizard().exitBusy();
                if (!this.connectionFailed()) break;
                String errorMessage = this.connectionState == 3 ? lex.get("portal.wizard.connectionIncompatible") : lex.get("portal.wizard.connectFailed");
                BDialog.error((BWidget)this.getWizard(), (String)UiLexicon.bajaui().getText("dialog.error"), (Object)errorMessage);
                this.getWizard().close();
                return;
            }
            case 1: 
            case 2: {
                this.getWizard().enterBusy();
                this.responseState = 1;
                this.waitForConnectionOrRequest();
                this.getWizard().exitBusy();
            }
        }
    }

    private BICredentials processCredentialsPane(BWbLoginPane pane) {
        try {
            this.updateToCreds(pane);
            this.waitForResponse();
            return pane.getCredInputPane().extractCredentials();
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            BDialog.error((BWidget)this.getWizard(), (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            this.responseState = 2;
            return null;
        }
    }

    public boolean finish() {
        try {
            if (!this.online) {
                this.doit();
            } else if (this.acTable.getSelection() != null) {
                this.doit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean cancel() {
        this.failResponse();
        this.cancelled = true;
        return true;
    }

    private void updateTo(int step) {
        this.currentStep = step;
        switch (step) {
            case 0: {
                this.updateToHost();
                break;
            }
            case 4: {
                this.updateToTls();
                break;
            }
            case 5: {
                this.updateToConnecting();
                break;
            }
            case 1: {
                this.updateToUsername();
                break;
            }
            case 2: {
                this.updateToCreds();
                break;
            }
            case 3: {
                this.updateToConsole();
            }
        }
    }

    private void updateToHost() {
        this.update(this.hostPane, 2);
        this.getWizard().setNextAsDefault();
    }

    private void updateToTls() {
        this.tlsWaitPane = new BEdgePane();
        this.tlsWaitPane.setCenter((BWidget)new BLabel(lex.get("portal.wizard.tlsWait")));
        this.update((BWidget)this.tlsWaitPane, 0);
    }

    private void updateToConnecting() {
        this.tlsWaitPane = new BEdgePane();
        this.tlsWaitPane.setCenter((BWidget)new BLabel(lex.get("portal.connecting")));
        this.update((BWidget)this.tlsWaitPane, 0);
    }

    private void updateToUsername() {
    }

    private void updateToCreds() {
    }

    private void updateToCreds(BWbLoginPane pane) {
        if (this.connectionFailed()) {
            BDialog.error((BWidget)this.getWizard(), (String)UiLexicon.bajaui().getText("dialog.error"), (Object)(this.connectionFailureCause != null ? this.connectionFailureCause : lex.get("portal.wizard.connectFailed")));
            this.getWizard().close();
            return;
        }
        this.update((BWidget)pane, 3);
    }

    private void updateToConsole() {
        this.buildStepConsole();
        int mask = 1;
        if (this.acTable != null && this.acTable.getSelection().getRowCount() == 1) {
            mask |= 4;
        }
        if (this.consolePane != null) {
            this.update(this.consolePane, mask);
        }
        if (!this.online) {
            this.update(5);
        }
    }

    private void processHostPane() {
        this.port = 1911;
        this.useFoxs = false;
        this.foxConnectionType = FoxConnectionTypeEnum.FOX_OR_FOXWSS;
        try {
            BCnxHandler handler = this.openPane.saveCnxHandler();
            handler.saveCnx();
            handler.toHyperlink();
            this.port = ((BHostCnxHandler)handler).getPort();
            this.useFoxs = handler.isSecure();
            String sessionScheme = ((BHostCnxHandler)handler).getSessionScheme();
            this.foxConnectionType = sessionScheme.equals("foxwss") ? FoxConnectionTypeEnum.FOXWSS : (this.useFoxs ? FoxConnectionTypeEnum.FOXS_OR_FOXWSS : FoxConnectionTypeEnum.FOX_OR_FOXWSS);
            this.hostOrd = ((BHostCnxHandler)handler).getHostOrd();
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            BDialog.error((BWidget)this.getWizard(), (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
        }
    }

    private void startConnectionAttempt() {
        this.connectionState = 0;
        new ConnectThread(new AddConsoleAuthenticationClient((BWidget)this.getWizard())).start();
    }

    private boolean connectionFailed() {
        return this.connectionState == 2 || this.connectionState == 3;
    }

    private void waitForRequest() {
        this.requestReceived = false;
        try {
            while (!this.requestReceived && !this.connectionFailed() && this.connectionState != 1) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void failResponse() {
        this.responseState = 2;
    }

    private void waitForResponse() {
        try {
            while (this.responseState == 0 && !this.connectionFailed()) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitForConnection() {
        try {
            while (this.connectionState == 0) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitForConnectionOrRequest() {
        this.requestReceived = false;
        try {
            while (this.connectionState == 0 && !this.requestReceived) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void abortConnection() {
        this.failResponse();
        this.waitForConnection();
    }

    private void waitForTlsThreadStop(AuthenticationRealm realm) {
        if (this.useFoxs || this.foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS) {
            if (realm instanceof BFoxSession) {
                this.foxSession = (BFoxSession)realm;
            }
            while (this.tlsThreadRunning && !this.connectionFailed()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void waitForTlsThreadStart() {
        if (this.useFoxs || this.foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS) {
            while (!this.tlsThreadRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void doit() throws Exception {
        if (this.online) {
            int[] selRow = this.acTableModel.getSelection().getRows();
            for (int i = 0; i < selRow.length; ++i) {
                String consoleOrdStr = (String)this.acTableModel.getValueAt(selRow[i], 0);
                BConsoleRecord record = new BConsoleRecord();
                record.setHostOrd(this.hostOrd);
                record.setPort(this.port);
                record.setUseFoxs(this.useFoxs);
                record.setSessionScheme(BAlarmPortalTool.getFoxSessionScheme(this.useFoxs, this.foxConnectionType));
                record.setConsoleOrd(BOrd.make((String)consoleOrdStr));
                this.list = BConsoleRecordList.add(this.list, record);
            }
        } else {
            BConsoleRecord record = new BConsoleRecord();
            record.setHostOrd(this.hostOrd);
            record.setPort(this.port);
            record.setUseFoxs(this.useFoxs);
            record.setSessionScheme(BAlarmPortalTool.getFoxSessionScheme(this.useFoxs, this.foxConnectionType));
            record.setConsoleOrd(BOrd.make((String)this.offlineOrdField.getText()));
            this.list = BConsoleRecordList.add(this.list, record);
        }
    }

    public BConsoleRecordList getConsoleRecordList() {
        return this.list;
    }

    class Model
    extends CollectionTableModel {
        public Model(BITable<? extends BIObject> coll) {
            super(coll, null);
        }

        public Object getValueAt(int r, int c) {
            String s = super.getValueAt(r, c).toString();
            return SlotPath.unescape((String)s);
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            this.updateFinish();
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            this.updateFinish();
        }

        private void updateFinish() {
            if (AddConsoleWizard.this.acTable.getSelection().getRowCount() == 1) {
                AddConsoleWizard.this.update(5);
            } else {
                AddConsoleWizard.this.update(1);
            }
        }
    }

    class TlsCheckThread
    extends Thread {
        TlsCheckThread() {
        }

        @Override
        public void run() {
            AddConsoleWizard.this.tlsThreadRunning = true;
            try {
                while (!AddConsoleWizard.this.cancelled && !AddConsoleWizard.this.foxSession.getConnection().isSslHandshakeComplete() && AddConsoleWizard.this.connectionState == 0) {
                    Thread.sleep(300L);
                }
                if (AddConsoleWizard.this.connectionFailed()) {
                    AddConsoleWizard.this.tlsThreadRunning = false;
                    String errorMessage = AddConsoleWizard.this.connectionState == 3 ? lex.get("portal.wizard.connectionIncompatible") : lex.get("portal.wizard.connectFailed");
                    BDialog.error((BWidget)AddConsoleWizard.this.getWizard(), (String)UiLexicon.bajaui().getText("dialog.error"), (Object)errorMessage);
                    AddConsoleWizard.this.getWizard().close();
                    return;
                }
                if (AddConsoleWizard.this.cancelled) {
                    AddConsoleWizard.this.tlsThreadRunning = false;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            AddConsoleWizard.this.tlsThreadRunning = false;
            AddConsoleWizard.this.getWizard().exitBusy();
        }
    }

    class ConnectThread
    extends Thread {
        WbAuthenticationClient client;

        ConnectThread(WbAuthenticationClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            boolean tlsFinished = false;
            AddConsoleWizard.this.connectionFailureCause = null;
            BHost host = (BHost)AddConsoleWizard.this.hostOrd.get();
            AddConsoleWizard.this.foxSession = BFoxSession.make(null, (BHost)host, (int)AddConsoleWizard.this.port, (FoxConnectionTypeEnum)AddConsoleWizard.this.foxConnectionType, (int)-1);
            AddConsoleWizard.this.foxSession.getConnection().setAuthenticationClient((AuthenticationClient)this.client);
            while (AddConsoleWizard.this.connectionState == 0) {
                try {
                    if (AddConsoleWizard.this.foxSession.isConnected()) {
                        AddConsoleWizard.this.foxSession.disconnect();
                    }
                    if ((AddConsoleWizard.this.useFoxs || AddConsoleWizard.this.foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS) && !tlsFinished) {
                        AddConsoleWizard.this.waitForTlsThreadStart();
                    }
                    tlsFinished = true;
                    AddConsoleWizard.this.foxSession = BFoxSession.connect((BFoxSession)AddConsoleWizard.this.foxSession);
                    if (AddConsoleWizard.this.foxConnectionType != FoxConnectionTypeEnum.FOX_OR_FOXWSS && AddConsoleWizard.this.foxConnectionType != FoxConnectionTypeEnum.FOXS_OR_FOXWSS || AddConsoleWizard.this.foxSession.getFoxConnectionType() != FoxConnectionTypeEnum.FOXWSS) {
                        AddConsoleWizard.this.port = AddConsoleWizard.this.foxSession.getPort();
                        AddConsoleWizard.this.useFoxs = AddConsoleWizard.this.foxSession.getUseFoxs();
                        AddConsoleWizard.this.foxConnectionType = AddConsoleWizard.this.foxSession.getFoxConnectionType();
                    }
                    AddConsoleWizard.this.connectionState = 1;
                    AddConsoleWizard.this.getWizard().exitBusy();
                    AddConsoleWizard.this.updateTo(3);
                }
                catch (IncompatibleVersionException e) {
                    AddConsoleWizard.this.connectionState = 3;
                }
                catch (CancelledAuthenticationException | ChangeUserAuthenticationException e) {
                    AddConsoleWizard.this.connectionState = 2;
                }
                catch (AuthenticationException e) {
                    LoginFailureCause loginFailureCause = e.getLoginFailureCause();
                    if (loginFailureCause != null) {
                        AddConsoleWizard.this.connectionFailureCause = loginFailureCause.getDefaultFailureMessage();
                        if (loginFailureCause != LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED) continue;
                        this.client.setException(new AuthenticationException(e.getAuthenticationRealm(), (Throwable)new GenericReportableAuthenticationException(LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED)));
                        AuthUtil.removeSavedUser((String)("[alarmPortal]" + AddConsoleWizard.this.realm.getAuthenticationRealmName()));
                        continue;
                    }
                    this.client.setException(e);
                }
                catch (Exception e) {
                    AddConsoleWizard.this.connectionState = 2;
                }
            }
        }
    }

    private class AddConsoleAuthenticationClient
    extends WbAuthenticationClient {
        public AddConsoleAuthenticationClient(BWidget owner) {
            super(owner);
        }

        public BIUserCredentials requestUsername(AuthenticationRealm realm) {
            if (AddConsoleWizard.this.useFoxs || AddConsoleWizard.this.foxConnectionType == FoxConnectionTypeEnum.FOX_OR_FOXWSS) {
                AddConsoleWizard.this.waitForTlsThreadStop(realm);
            }
            AddConsoleWizard.this.updateTo(1);
            return super.requestUsername(realm);
        }

        public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
            AddConsoleWizard.this.updateTo(2);
            return super.requestInformation(realm, schemeName, step, seedInfo);
        }

        protected BICredentials acquireUserCredentials(AuthenticationRealm realm, BCredInputPane pane) {
            try {
                if (AddConsoleWizard.this.cancelled) {
                    throw new FoxAuthenticationException("Cancelled", null, null, null);
                }
                boolean showError = this.exception != null;
                boolean showCause = showError && this.exception.getCause() != null && this.exception.getCause() instanceof ReportCauseAuthenticationException;
                String message = showCause ? ((ReportCauseAuthenticationException)this.exception.getCause()).getCauseMessage() : null;
                this.exception = null;
                BWbLoginPane credWbPane = new BWbLoginPane(realm, pane, showError, message);
                AddConsoleWizard.this.realm = realm;
                AddConsoleWizard.this.responseState = 0;
                AddConsoleWizard.this.requestReceived = true;
                BICredentials creds = AddConsoleWizard.this.processCredentialsPane(credWbPane);
                if (AddConsoleWizard.this.cancelled) {
                    AddConsoleWizard.this.waitForTlsThreadStop(realm);
                    throw new FoxAuthenticationException("Cancelled", null, null, null);
                }
                if (AddConsoleWizard.this.responseState == 2) {
                    return null;
                }
                return creds;
            }
            catch (AuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                BDialog.error((BWidget)AddConsoleWizard.this.getWizard().getOwner(), (String)"", (Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public String getRealmPrefix() {
            return "[alarmPortal]";
        }
    }
}

