/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.data.BDataRow;
import com.tridium.data.BDataTable;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BFormat;

public abstract class ConsoleTableModel
extends TableModel {
    private static BImage alarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    private static BImage redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    private static BImage greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
    private static BImage whiteAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");
    public BAlarmConsoleOptions options = BAlarmConsoleOptions.getDefault();
    private ConsoleColumns columns;
    private int sortCol = 5;
    private boolean sortAsc = false;
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);

    public ConsoleTableModel(ConsoleColumns columns) {
        this.columns = columns;
        columns.addModel(this);
    }

    public void init(BIAlarmServiceView alarmServiceView, Context cx) {
        this.columns.init(alarmServiceView, cx);
    }

    public abstract BAlarmRecord getRecord(int var1);

    public BAlarmRecord getRecord(BOrdList src, int row) {
        return this.getRecord(row);
    }

    public abstract int getAlarmCount();

    public int getAlarmCount(BOrdList src) {
        return this.getAlarmCount();
    }

    public abstract int getSourceCount();

    public ConsoleColumns getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.getColumnCount();
    }

    public String getColumnName(int col) {
        return this.columns.getColumn(col).getName();
    }

    public void addDataColumn(String name, String key) {
        this.columns.addDataColumn(name, key);
    }

    public void removeDataColumn(String key) {
        this.columns.removeDataColumn(key);
    }

    public void columnsModified() {
        this.updateTable();
    }

    public Object getSubject(int row) {
        return this.getRecord(row);
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        BAlarmRecord rec;
        ConsoleColumns.Column col = this.columns.getColumn(colIndex);
        Object value = col.getValue(rec = this.getRecord(rowIndex));
        if (value instanceof BAbsTime) {
            if (this.options.getTimeZoneDisplay() == BTimeZoneDisplay.source) {
                return ((BAbsTime)value).toString((Context)BFacets.make((BFacets)rec.getAlarmData(), (BFacets)TIME_FACETS));
            }
            return ((BAbsTime)value).toString((Context)BFacets.make((BFacets)TIME_FACETS, (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
        }
        if (value instanceof BString || value instanceof String) {
            return TextUtil.replace((String)value.toString(), (String)"\\n", (String)" ");
        }
        if (value instanceof BFacets) {
            return BFormat.make((String)value.toString()).format((Object)rec).replace('\n', ' ');
        }
        if (value instanceof String) {
            return TextUtil.replace((String)value.toString(), (String)"\\n", (String)" ");
        }
        return value;
    }

    public BImage getRowIcon(int row) {
        BAlarmRecord alarm = this.getRecord(row);
        BImage img = alarmImg;
        BSourceState sourceState = alarm.getSourceState();
        BAckState ackState = alarm.getAckState();
        if (sourceState == BSourceState.alert && ackState != BAckState.acked) {
            img = orangeAlarmImg;
        } else if (sourceState == BSourceState.alert && ackState == BAckState.acked) {
            img = whiteAlarmImg;
        } else if (ackState == BAckState.acked && sourceState != BSourceState.normal) {
            img = alarmImg;
        } else if (sourceState == BSourceState.normal && ackState != BAckState.acked) {
            img = greenAlarmImg;
        } else if (ackState != BAckState.acked && sourceState != BSourceState.normal) {
            img = redAlarmImg;
        } else if (ackState == BAckState.acked && sourceState == BSourceState.normal) {
            img = whiteAlarmImg;
        }
        if (alarm.getAlarmData().get("notes") != null) {
            return BImage.make((BIcon)BIcon.make((BIcon)BIcon.make((BOrdList)img.getOrdList()), (BIcon)BIcon.std((String)"badges/note.png")));
        }
        return img;
    }

    public void close() {
        this.columns.removeModel(this);
    }

    public BITable<BDataRow> export() {
        int colCount = this.getTable().getModel().getColumnCount();
        int rowCount = this.getTable().getModel().getRowCount();
        BDataTable t = new BDataTable();
        for (int c = 0; c < colCount; ++c) {
            String displayName = this.getTable().getModel().getColumnName(c);
            String name = SlotPath.escape((String)displayName);
            Type type = BIDataValue.TYPE;
            t.addColumn(name, displayName, type, 0, BFacets.NULL);
        }
        t.startRows();
        for (int r = 0; r < rowCount; ++r) {
            t.startRow();
            for (int c = 0; c < colCount; ++c) {
                int col = c;
                if (this.getTable().getModel() instanceof DynamicTableModel) {
                    col = ((DynamicTableModel)this.getTable().getModel()).toRootColumnIndex(c);
                }
                t.set(this.export(r, col).toDataValue(), BFacets.NULL);
            }
            t.endRow();
        }
        t.endRows();
        return t;
    }

    public BObject export(int row, int col) {
        ConsoleColumns.Column column = this.getColumns().getColumn(col);
        if (column instanceof ConsoleColumns.DataColumn) {
            return BString.make((String)SlotPath.unescape((String)this.hexCorrection(this.getValueAt(row, col).toString())));
        }
        return super.export(row, col);
    }

    private String hexCorrection(String input) {
        int atLength = input.split("at ").length;
        int javaLength = input.split(".java:").length;
        input = input.replaceAll("\n", " ").trim();
        if (atLength == javaLength && input.matches(".*java:[0-9]+\\)$")) {
            input = input.replaceAll("\\$", "\\$24");
        }
        return input;
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    public void setInitialSort(int col, boolean ascending) {
        this.sortCol = col;
        this.sortAsc = ascending;
    }

    public int getLastSortColumn() {
        return this.sortCol;
    }

    public boolean getLastSortAscending() {
        return this.sortAsc;
    }
}

