/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BAlarmExtStatusJob;
import com.tridium.alarm.ui.BAlarmClassFE;
import com.tridium.alarm.ui.BInstructionsFE;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.Map;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataTable;
import javax.baja.data.DataTypes;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmService"})})
@NiagaraAction(name="updateCommands", flags=4)
public class BAlarmExtManager
extends BWbComponentView {
    @Generated
    public static final Action updateCommands = BAlarmExtManager.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmExtManager.class);
    private static final String[] ATTRS = new String[]{"parent.toPathString", "toPathString", "name", "alarmState", "alarmEnable.isToOffnormal", "alarmEnable.isToFault", "alarmState.ordinal", "alarmClass", "alarmInstructions", "status"};
    private static final int[] DISPLAY = new int[]{0, 2, 3, 4, 5, 7, 8};
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private BAlarmService alarmService;
    private BTable table;
    private BIRandomAccessTable<? extends BIObject> itable;
    private CollectionTableModel collectionModel;
    private ToggleCommand enableToOffnormal;
    private ToggleCommand enableToFault;
    private Command editAlarmClass;
    private Command editInstructions;
    private IntHashMap nameMap;
    private BBorderPane topPane;
    private BJobBar jobBar;
    private BJob job;
    private boolean jobComplete;
    private Map<String, String> alarmClassDisplayNameMap;

    @Generated
    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmExtManager() {
        BEdgePane content = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.topPane = new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        content.setTop((BWidget)this.topPane);
        this.topPane.setVisible(false);
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        content.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("alarm.alarmSourceExts"), (BTable)this.table, (String)lex.getText("alarm.exts")));
        this.setContent((BWidget)content);
        this.enableToOffnormal = new EnableToOffnormal();
        this.enableToFault = new EnableToFault();
        this.editAlarmClass = new EditAlarmClass();
        this.editInstructions = new EditInstructions();
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"alarm.point");
        this.nameMap.put(2, (Object)"alarm.extension");
        this.nameMap.put(3, (Object)"alarm.alarmState");
        this.nameMap.put(4, (Object)"alarm.toOffnormalEnabled.label");
        this.nameMap.put(5, (Object)"alarm.toFaultEnabled.label");
        this.nameMap.put(7, (Object)"alarm.alarmClass");
        this.nameMap.put(8, (Object)"alarm.instructions");
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.alarmService = (BAlarmService)value;
        this.alarmClassDisplayNameMap = this.alarmService.getAlarmClassDisplayNameMap(context);
        this.updateTable();
        this.table.fireTableModified(null);
    }

    private void updateTable() {
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bqlOrd = BOrd.make((BOrd)authority, (String)this.query()).normalize();
        this.itable = Tables.slurp((BITable)((BITable)bqlOrd.resolve().get()));
        boolean prevSorted = false;
        int sortCol = -1;
        boolean sortAsc = true;
        if (this.table.getModel() instanceof AlarmExtTableModel) {
            prevSorted = true;
            sortCol = ((AlarmExtTableModel)this.table.getModel()).sortCol;
            sortAsc = ((AlarmExtTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel renameModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        AlarmExtTableModel hideModel = new AlarmExtTableModel((TableModel)renameModel, DISPLAY);
        hideModel.setColumnShowable(1, false);
        hideModel.setColumnShowable(6, false);
        if (prevSorted && sortCol != -1) {
            hideModel.sortByColumn(sortCol, sortAsc);
        }
        this.table.setModel((TableModel)hideModel);
        this.table.relayout();
    }

    private String query() {
        StringBuilder s = new StringBuilder(128);
        s.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ATTRS[i]);
        }
        s.append(" from alarm:AlarmSourceExt");
        return s.toString();
    }

    public void doUpdateCommands() {
    }

    public BOrd[] getSelectedOrds() {
        int[] selectedRows = this.table.getSelection().getRows();
        int rowCount = selectedRows.length;
        BOrd[] ords = new BOrd[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            String path = this.itable.get(selectedRows[i]).cell(this.itable.getColumns().get("toPathString")).toString();
            ords[i] = BOrd.make((String)("station:|slot:" + path)).normalize();
        }
        return ords;
    }

    public BAlarmSourceExt getExtensionForRow(int rowIndex) {
        String path = this.collectionModel.getValueAt(rowIndex, 1).toString();
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
        return (BAlarmSourceExt)targetOrd.resolve().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableToOffnormal() {
        BWidgetShell shell;
        BOrd[] selections = this.getSelectedOrds();
        if (selections.length == 0) {
            return;
        }
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd jobServiceOrd = BOrd.make((BOrd)authority, (String)"service:baja:JobService");
        BJobService jobService = (BJobService)jobServiceOrd.resolve().get();
        jobService.lease();
        BAlarmExtStatusJob[] jobs = (BAlarmExtStatusJob[])jobService.getChildren(BAlarmExtStatusJob.class);
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                if (jobs[i] == null) continue;
                jobs[i].lease();
                if (!jobs[i].isAlive()) continue;
                BDialog.error((BWidget)this, (String)lex.getText("alarmExtManager.commandFail"), (Object)lex.getText("alarmExtManager.statusJobExists"));
                return;
            }
        }
        if (!this.topPane.isVisible()) {
            this.topPane.setVisible(true);
            this.topPane.getParentWidget().relayout();
        }
        if ((shell = this.getShell()) != null) {
            shell.enterBusy();
        }
        try {
            BOrd serviceOrd = BOrd.make((BOrd)authority, (String)"service:alarm:AlarmService");
            BAlarmService service = (BAlarmService)serviceOrd.resolve().get();
            BVector extOrds = new BVector();
            for (int j = 0; j < selections.length; ++j) {
                extOrds.add("o" + j, (BValue)selections[j]);
            }
            if (this.enableToOffnormal.isSelected()) {
                this.setJob(service.enableToOffnormal(extOrds), service);
            } else {
                this.setJob(service.disableToOffnormal(extOrds), service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableToFault() {
        BWidgetShell shell;
        BOrd[] selections = this.getSelectedOrds();
        if (selections.length == 0) {
            return;
        }
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd jobServiceOrd = BOrd.make((BOrd)authority, (String)"service:baja:JobService");
        BJobService jobService = (BJobService)jobServiceOrd.resolve().get();
        jobService.lease();
        BAlarmExtStatusJob[] jobs = (BAlarmExtStatusJob[])jobService.getChildren(BAlarmExtStatusJob.class);
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                if (jobs[i] == null) continue;
                jobs[i].lease();
                if (!jobs[i].isAlive()) continue;
                BDialog.error((BWidget)this, (String)lex.getText("alarmExtManager.commandFail"), (Object)lex.getText("alarmExtManager.statusJobExists"));
                return;
            }
        }
        if (!this.topPane.isVisible()) {
            this.topPane.setVisible(true);
            this.topPane.getParentWidget().relayout();
        }
        if ((shell = this.getShell()) != null) {
            shell.enterBusy();
        }
        try {
            BOrd serviceOrd = BOrd.make((BOrd)authority, (String)"service:alarm:AlarmService");
            BAlarmService service = (BAlarmService)serviceOrd.resolve().get();
            BVector extOrds = new BVector();
            for (int j = 0; j < selections.length; ++j) {
                extOrds.add("o" + j, (BValue)selections[j]);
            }
            if (this.enableToOffnormal.isSelected()) {
                this.setJob(service.enableToFault(extOrds), service);
            } else {
                this.setJob(service.disableToFault(extOrds), service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    private BJob getJob() {
        return this.job;
    }

    private void setJob(BJob job) {
        this.job = job;
        this.jobComplete = false;
        this.registerForComponentEvents((BComponent)job);
        this.jobBar.load(job);
        if (job != null && job.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(job);
        }
    }

    private void setJob(BOrd jobOrd, BAlarmService service) throws Exception {
        service.getComponentSpace().sync();
        BJob job = (BJob)jobOrd.get((BObject)service);
        this.setJob(job);
    }

    private void jobComplete(BJob job) {
        this.updateTable();
    }

    public class AlarmExtTableModel
    extends DynamicTableModel {
        public int sortCol;
        public boolean sortAsc;

        public AlarmExtTableModel(TableModel root, int[] showColumns) {
            super(root, showColumns);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public AlarmExtTableModel(TableModel root) {
            super(root);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.sortCol = col;
            this.sortAsc = ascending;
            super.sortByColumn(col, ascending);
        }

        public Object getValueAt(int row, int col) {
            Object value = super.getValueAt(row, col);
            if (this.toRootColumnIndex(col) == 7) {
                try {
                    String alarmClassName = value.toString();
                    String alarmClassDisplayName = (String)BAlarmExtManager.this.alarmClassDisplayNameMap.get(alarmClassName);
                    if (alarmClassDisplayName == null) {
                        alarmClassDisplayName = BAlarmExtManager.this.alarmService.getAlarmClassDisplayName((Object)BString.make((String)alarmClassName), null).toString();
                        BAlarmExtManager.this.alarmClassDisplayNameMap.put(alarmClassName, alarmClassDisplayName);
                    }
                    return alarmClassDisplayName;
                }
                catch (Exception e) {
                    return value.toString();
                }
            }
            if (value instanceof String) {
                value = SlotPath.unescape((String)((String)value));
            }
            return value;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int row, BITable<? extends BIObject> itable) {
            super("alarmExtManager.goto.point", row, itable);
        }

        @Override
        public BOrd getTargetOrd() {
            return BOrd.make((String)("slot:" + BAlarmExtManager.this.collectionModel.getValueAt(this.row, 0)));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable<? extends BIObject> itable;

        public Goto(String key, int row, BITable<? extends BIObject> itable) {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass(BAlarmExtManager.class), key);
            this.row = row;
            this.itable = itable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BAlarmExtManager.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        BIDataTable<? extends BIObject> lastTable = null;
        int stateOrdCol = -1;

        private CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            int stateOrd = Integer.parseInt(((WrapperTableModel)BAlarmExtManager.this.table.getModel()).getRootModel().getValueAt(cell.row, this.stateOrdCol).toString());
            return stateOrd == BAlarmState.normal.getOrdinal() ? super.getForeground(cell) : BColor.white.toBrush();
        }

        protected void paintCellBackground(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.selected) {
                super.paintCellBackground(g, cell);
                return;
            }
            try {
                ColumnList columns = BAlarmExtManager.this.itable.getColumns();
                if (BAlarmExtManager.this.itable != this.lastTable || this.stateOrdCol == -1) {
                    this.stateOrdCol = columns.indexOf("alarmState.ordinal");
                }
                BColor bg = null;
                BColor fg = null;
                TableModel tModel = BAlarmExtManager.this.table.getModel();
                if (!(tModel instanceof WrapperTableModel)) {
                    super.paintCellBackground(g, cell);
                    return;
                }
                int stateOrd = Integer.parseInt(((WrapperTableModel)tModel).getRootModel().getValueAt(cell.row, this.stateOrdCol).toString());
                if (stateOrd != BAlarmState.normal.getOrdinal()) {
                    if (stateOrd == BAlarmState.fault.getOrdinal()) {
                        bg = (BColor)BStatus.faultBg;
                        fg = (BColor)BStatus.faultFg;
                    } else {
                        bg = (BColor)BStatus.alarmBg;
                        fg = (BColor)BStatus.alarmFg;
                    }
                }
                if (bg != null) {
                    g.setBrush(bg);
                    g.fillRect(0.0, 0.0, cell.width, cell.height);
                    g.setBrush(fg);
                } else {
                    g.setBrush(Theme.table().getTextBrush());
                }
                g.setFont(Theme.table().getCellFont());
            }
            catch (ClassCastException | NullPointerException e) {
                super.paintCellBackground(g, cell);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            ColumnList columns = BAlarmExtManager.this.itable.getColumns();
            BOrd targetOrd = null;
            String path = BAlarmExtManager.this.collectionModel.getValueAt(row, 1).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            if (targetOrd != null) {
                ((BWbShell)this.getShell()).hyperlink(targetOrd);
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            ColumnList columns = BAlarmExtManager.this.itable.getColumns();
            String path = BAlarmExtManager.this.collectionModel.getValueAt(row, 1).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            BComponent target = (BComponent)targetOrd.get();
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeViewsMenu((BWidget)this.getTable(), (BObject)target)));
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)target)));
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new GotoPoint(row, (BITable<? extends BIObject>)BAlarmExtManager.this.itable));
            menu.add(null, (BValue)new BSeparator());
            if (BAlarmExtManager.this.table.getModel().getSelection().getRows().length == 1) {
                BAlarmExtManager.this.enableToOffnormal.setSelected(DataTypes.otob((BIObject)BAlarmExtManager.this.itable.get(row).cell(columns.get("alarmEnable.isToOffnormal"))));
                BAlarmExtManager.this.enableToFault.setSelected(DataTypes.otob((BIObject)BAlarmExtManager.this.itable.get(row).cell(columns.get("alarmEnable.isToFault"))));
            }
            menu.add("toOffnormal", (Command)BAlarmExtManager.this.enableToOffnormal);
            menu.add("toFault", (Command)BAlarmExtManager.this.enableToFault);
            menu.add("editAlarmClass", BAlarmExtManager.this.editAlarmClass);
            menu.add("editInstructions", BAlarmExtManager.this.editInstructions);
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }

    public class EditInstructions
    extends Command {
        public EditInstructions() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass(BAlarmExtManager.class), "alarm.editInstructions");
        }

        public CommandArtifact doInvoke() {
            int[] selectedRows = BAlarmExtManager.this.table.getSelection().getRows();
            BAlarmInstructions inst = BAlarmInstructions.NULL;
            if (selectedRows.length == 1) {
                BAlarmSourceExt extension = BAlarmExtManager.this.getExtensionForRow(selectedRows[0]);
                extension.lease();
                inst = extension.getAlarmInstructions();
            }
            BInstructionsFE iFE = new BInstructionsFE();
            BAlarmExtManager.this.add("temp", (BValue)iFE);
            iFE.loadValue((BObject)inst, null);
            BAlarmExtManager.this.remove("temp");
            int retVal = BDialog.open((BWidget)BAlarmExtManager.this, (String)lex.get("alarm.editAlarmClass.label"), (Object)((Object)iFE), (int)3, null);
            if (retVal == 1) {
                try {
                    inst = (BAlarmInstructions)iFE.saveValue((BObject)inst, null);
                    for (int i = 0; i < selectedRows.length; ++i) {
                        BAlarmSourceExt extension = BAlarmExtManager.this.getExtensionForRow(selectedRows[i]);
                        extension.lease();
                        extension.setAlarmInstructions(inst);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BAlarmExtManager.this.updateTable();
            }
            return null;
        }
    }

    public class EditAlarmClass
    extends Command {
        public EditAlarmClass() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass(BAlarmExtManager.class), "alarm.editAlarmClass");
        }

        public CommandArtifact doInvoke() {
            int[] selectedRows = BAlarmExtManager.this.table.getSelection().getRows();
            String acName = "";
            if (selectedRows.length == 1) {
                BAlarmSourceExt extension = BAlarmExtManager.this.getExtensionForRow(selectedRows[0]);
                extension.lease();
                acName = extension.getAlarmClass();
            }
            BAlarmClassFE acFE = new BAlarmClassFE();
            BAlarmExtManager.this.add("temp", (BValue)acFE);
            acFE.loadValue((BObject)BString.make((String)acName), null);
            BAlarmExtManager.this.remove("temp");
            int retVal = BDialog.open((BWidget)BAlarmExtManager.this, (String)lex.get("alarm.editAlarmClass.label"), (Object)((Object)acFE), (int)3, null);
            if (retVal == 1) {
                try {
                    acName = acFE.saveValue((BObject)BString.make((String)acName), null).toString();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        BAlarmSourceExt extension = BAlarmExtManager.this.getExtensionForRow(selectedRows[i]);
                        extension.lease();
                        extension.setAlarmClass(acName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BAlarmExtManager.this.updateTable();
            }
            return null;
        }
    }

    public class EnableToFault
    extends ToggleCommand {
        public EnableToFault() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass(BAlarmExtManager.class), "alarm.toFaultEnabled");
        }

        public CommandArtifact doInvoke() {
            BAlarmExtManager.this.enableToFault();
            return null;
        }
    }

    public class EnableToOffnormal
    extends ToggleCommand {
        public EnableToOffnormal() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass(BAlarmExtManager.class), "alarm.toOffnormalEnabled");
        }

        public CommandArtifact doInvoke() {
            BAlarmExtManager.this.enableToOffnormal();
            return null;
        }
    }
}

