/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmDbView;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableController;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmService", "alarm:AlarmDatabase", "alarm:ArchiveAlarmProvider"}, requiredPermissions="w")})
public class BAlarmDbMaintenance
extends BAlarmDbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDbMaintenance.class);
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private ToggleCommand clearRecordsBeforeSelected;
    private ToggleCommand clearAllRecords;
    private ToggleCommand clearOldRecords;
    private BWbEditor dateEditor;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        BWidget alarmView = this.getContent();
        BEdgePane pane = new BEdgePane();
        this.setContent((BWidget)new BLabel(""));
        BIProtected loadedComponent = (BIProtected)value;
        BPermissions currentPermissions = loadedComponent.getPermissions(cx);
        if (currentPermissions.hasAdminInvoke()) {
            BGridPane options = new BGridPane(2);
            options.setHalign(BHalign.left);
            options.setValign(BValign.top);
            OptionGroup optionGroup = new OptionGroup();
            this.clearOldRecords = new ClearOldRecords();
            optionGroup.add(this.clearOldRecords);
            options.add("clearOld", (BValue)new BRadioButton(this.clearOldRecords));
            this.dateEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
            BAbsTime now = Clock.time();
            BAbsTime beforeTime = BAbsTime.make((int)(now.getYear() - 5), (BMonth)now.getMonth(), (int)now.getDay());
            this.dateEditor.loadValue((BObject)beforeTime);
            BFlowPane datePane = new BFlowPane();
            datePane.add("before", (BValue)new BLabel(lex.getText("before")));
            datePane.add("dateEditor", (BValue)this.dateEditor);
            options.add("date", (BValue)new BBorderPane((BWidget)datePane, 0.0, 0.0, 0.0, 10.0));
            this.clearRecordsBeforeSelected = new ClearRecordsBeforeSelected();
            optionGroup.add(this.clearRecordsBeforeSelected);
            options.add("clearBeforeSelected", (BValue)new BRadioButton(this.clearRecordsBeforeSelected));
            options.add(null, (BValue)new BLabel(""));
            this.clearAllRecords = new ClearAllRecords();
            optionGroup.add(this.clearAllRecords);
            options.add("clearAll", (BValue)new BRadioButton(this.clearAllRecords));
            options.add(null, (BValue)new BLabel(""));
            BGridPane actions = new BGridPane(1);
            actions.add("run", (BValue)new BButton((Command)new RunMaintenance()));
            BEdgePane maintenancePane = new BEdgePane();
            maintenancePane.setCenter((BWidget)new BBorderPane((BWidget)options));
            maintenancePane.setBottom((BWidget)actions);
            pane.setCenter(alarmView);
            pane.setBottom((BWidget)maintenancePane);
        } else {
            pane.setCenter(alarmView);
        }
        this.setContent((BWidget)pane);
        this.query();
    }

    private void runMaintenance() {
        try {
            if (this.clearAllRecords.isSelected()) {
                String msg;
                String title = lex.getText("confirmClear.title");
                if (BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirmClear"))) != 4) {
                    return;
                }
            } else if (this.clearRecordsBeforeSelected.isSelected()) {
                int row = this.table.getSelection().getRow();
                if (row == -1) {
                    BDialog.error((BWidget)this, (String)lex.getText("confirmClear.title"), (Object)lex.getText("alarm.noRecordSelected"));
                } else {
                    String msg;
                    String title = lex.getText("confirmClear.title");
                    if (BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirmClear"))) != 4) {
                        return;
                    }
                }
            } else if (this.clearOldRecords.isSelected()) {
                BAbsTime before = (BAbsTime)this.dateEditor.saveValue();
                String title = lex.getText("confirmClear.title");
                String msg = lex.getText("confirmClear.before", new Object[]{before.toString()});
                if (BDialog.confirm((BWidget)this, (String)title, (Object)msg) != 4) {
                    return;
                }
            }
            this.query();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new MaintenanceThread().start();
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                BAlarmDbMaintenance.this.showDetailsDialog(BAlarmDbMaintenance.this.model.getRecord(row));
            }
        }
    }

    private class RunMaintenance
    extends Command {
        RunMaintenance() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass(BAlarmDbMaintenance.class), "command.runMaintenance");
        }

        public CommandArtifact doInvoke() {
            BAlarmDbMaintenance.this.runMaintenance();
            return null;
        }
    }

    private class ClearOldRecords
    extends ToggleCommand {
        ClearOldRecords() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass(BAlarmDbMaintenance.class), "command.clearOldRecords");
        }
    }

    private class ClearRecordsBeforeSelected
    extends ToggleCommand {
        ClearRecordsBeforeSelected() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass(BAlarmDbMaintenance.class), "command.clearRecordsBeforeSelected");
        }
    }

    private class ClearAllRecords
    extends ToggleCommand {
        ClearAllRecords() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass(BAlarmDbMaintenance.class), "command.clearAllRecords");
        }
    }

    private class OptionGroup<T extends ToggleCommand>
    extends ToggleCommandGroup<T> {
        private OptionGroup() {
        }

        public void selected(ToggleCommand cmd) {
            if (BAlarmDbMaintenance.this.dateEditor != null) {
                BAlarmDbMaintenance.this.dateEditor.setReadonly(cmd != BAlarmDbMaintenance.this.clearOldRecords);
            }
        }
    }

    private class MaintenanceThread
    extends Thread {
        MaintenanceThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BAlarmDbMaintenance.this.enterBusy();
            try {
                if (BAlarmDbMaintenance.this.clearAllRecords.isSelected()) {
                    try (AlarmDbConnection conn = BAlarmDbMaintenance.this.alarmDb.getDbConnection(null);){
                        conn.clearAllRecords(BAlarmDbMaintenance.this.context);
                    }
                }
                if (BAlarmDbMaintenance.this.clearRecordsBeforeSelected.isSelected()) {
                    int row = BAlarmDbMaintenance.this.table.getSelection().getRow();
                    BAbsTime before = BAlarmDbMaintenance.this.model.getRecord(row).getTimestamp();
                    try (AlarmDbConnection conn = BAlarmDbMaintenance.this.alarmDb.getDbConnection(null);){
                        conn.clearOldRecords(before, BAlarmDbMaintenance.this.context);
                    }
                    BAlarmDbMaintenance.this.model.getSelection().deselectAll();
                } else if (BAlarmDbMaintenance.this.clearOldRecords.isSelected()) {
                    BAbsTime before = (BAbsTime)BAlarmDbMaintenance.this.dateEditor.saveValue();
                    try (AlarmDbConnection conn = BAlarmDbMaintenance.this.alarmDb.getDbConnection(null);){
                        conn.clearOldRecords(before, BAlarmDbMaintenance.this.context);
                    }
                }
                BAlarmDbMaintenance.this.query();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                BAlarmDbMaintenance.this.exitBusy();
            }
        }
    }
}

