/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.AlarmActionEnum;
import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.alarm.BAlarmFilterSet;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.AlarmTableModel;
import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmClassMappingFE;
import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BAlarmConsoleUIChannel;
import com.tridium.alarm.ui.BAlarmDetailsDialog;
import com.tridium.alarm.ui.BAlarmReportDialog;
import com.tridium.alarm.ui.BAlarmTitlePane;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.BNotesDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.IAudioPlayer;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.fieldeditors.gx.BColorFE;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"alarm:ConsoleRecipient"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="title", type="String", defaultValue="(UiLexicon.makeUiLexicon(BAlarmConsole.class)).getText(\"alarm.openAlarmSources\")"), @NiagaraProperty(name="showTitle", type="boolean", defaultValue="BBoolean.TRUE")})
@NiagaraActions(value={@NiagaraAction(name="processAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()"), @NiagaraAction(name="timeRangeModified")})
public class BAlarmConsole
extends BWbComponentView
implements IAudioPlayer.MediaPlayerListener,
BIExportableTableView,
BIAlarmServiceView {
    @Generated
    public static final Property title = BAlarmConsole.newProperty((int)0, (String)UiLexicon.makeUiLexicon(BAlarmConsole.class).getText("alarm.openAlarmSources"), null);
    @Generated
    public static final Property showTitle = BAlarmConsole.newProperty((int)0, (BValue)BBoolean.TRUE, null);
    @Generated
    public static final Action processAlarm = BAlarmConsole.newAction((int)0, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action timeRangeModified = BAlarmConsole.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmConsole.class);
    protected BTable sourceTable;
    protected SourceTableModel sourceModel;
    protected BTable alarmTable;
    protected BList instructions;
    protected BSplitPane contentPane;
    protected BButton filterBtn;
    protected BConsoleRecipient recipient;
    protected BAlarmService alarmService;
    private final ConsoleColumns columns;
    BAlarmTitlePane alarmTitlePane;
    protected BDynamicTimeRangeFE timeRangeEd;
    protected BDynamicTimeRange timeRange;
    protected BAlarmDetailsDialog detailsDlg;
    protected BAlarmReportDialog alarmReport;
    protected Context ctx;
    private static final boolean AWT_ENV = UiEnv.get() != null;
    private static IAudioPlayer soundPlayer;
    public static final Logger logger;
    Map<BOrd, BAbstractFile> sounds = new HashMap<BOrd, BAbstractFile>();
    protected Command ackCommand;
    protected Command ackRecentCommand;
    private final Command silenceCommand;
    private final Command urlCommand;
    protected Command notesCommand;
    private final Command showVideoCmd;
    private final ToggleCommand soundOnCommand;
    private final ToggleCommand continuousAlarmCommand;
    private final Command filterCmd;
    private final Command alarmClassMappingCommand;
    private final Command priorityColorsCommand;
    protected Command addColumnCommand;
    protected Command removeColumnCommand;
    protected Command detailsCommand;
    protected Command forceClear;
    private ToggleCommand sourceTimeCommand;
    private ToggleCommand consoleTimeCommand;
    public BAlarmConsoleOptions options;
    public static final UiLexicon lexicon;
    public final BImage lnkImg = BImage.make((String)lexicon.get("commands.hyperlink.icon"));
    Object dataMutex = new Object();

    @Generated
    public String getTitle() {
        return this.getString(title);
    }

    @Generated
    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    @Generated
    public boolean getShowTitle() {
        return this.getBoolean(showTitle);
    }

    @Generated
    public void setShowTitle(boolean v) {
        this.setBoolean(showTitle, v, null);
    }

    @Generated
    public void processAlarm(BAlarmRecord parameter) {
        this.invoke(processAlarm, (BValue)parameter, null);
    }

    @Generated
    public void timeRangeModified() {
        this.invoke(timeRangeModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmConsole() {
        BString[] dataCols;
        this.sourceTable = new BTable();
        this.sourceTable.setController((TableController)this.getController());
        this.sourceTable.setCellRenderer((TableCellRenderer)new AlarmTableCellRenderer());
        this.options = this.getDefaultOptions();
        BGridPane instructionsPane = new BGridPane(1);
        instructionsPane.setStretchRow(0);
        instructionsPane.setStretchColumn(0);
        instructionsPane.setHalign(BHalign.fill);
        instructionsPane.setColumnAlign(BHalign.fill);
        instructionsPane.setValign(BValign.fill);
        instructionsPane.setRowAlign(BValign.fill);
        this.instructions = new BList();
        instructionsPane.add(null, (BValue)new BTitlePane(lexicon.getText("alarm.instructions"), (BWidget)this.instructions));
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.ackCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.acknowledge"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.acknowledgeAlarms(BAlarmConsole.this.getSelectedAlarmsDeep(BAlarmConsole.this.sourceTable));
                return null;
            }
        };
        this.ackCommand.setEnabled(false);
        this.ackRecentCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.acknowledgeRecent"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.acknowledgeAlarms(BAlarmConsole.this.getSelectedAlarms(BAlarmConsole.this.sourceTable));
                return null;
            }
        };
        this.ackRecentCommand.setEnabled(false);
        this.silenceCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.silence"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.alarmSilenceSelected();
                return null;
            }
        };
        this.silenceCommand.setEnabled(false);
        this.urlCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.hyperlink"){

            public CommandArtifact doInvoke() {
                int row = BAlarmConsole.this.sourceTable.getSelection().getRow();
                if (row != -1) {
                    BAlarmConsole.this.hyperlink(BAlarmConsole.this.sourceModel.getRecord(row));
                }
                return null;
            }
        };
        this.urlCommand.setEnabled(false);
        this.notesCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.notes"){

            public CommandArtifact doInvoke() {
                BAlarmRecord[] records = BAlarmConsole.this.getSelectedAlarmsDeep(BAlarmConsole.this.sourceTable);
                BAlarmConsole.this.showNotes((BWidget)BAlarmConsole.this, records);
                return null;
            }
        };
        this.notesCommand.setEnabled(false);
        this.detailsCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.details"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.showDetailsDialog(BAlarmConsole.this.sourceTable, BAlarmConsole.this.sourceTable.getSelection().getRow());
                return null;
            }
        };
        this.detailsCommand.setEnabled(false);
        this.filterCmd = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.filter"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.configFilters();
                return null;
            }
        };
        this.showVideoCmd = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.showVideo"){

            public CommandArtifact doInvoke() {
                block5: {
                    try {
                        Class videoAlmConsoleExt = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.ui.alarm.AlarmConsoleExt");
                        if (videoAlmConsoleExt != null) {
                            Method doShowVideoMethod = videoAlmConsoleExt.getMethod("doShowVideo", BAlarmConsole.class, BAlarmRecord.class);
                            if (doShowVideoMethod != null) {
                                int selectedRow = BAlarmConsole.this.sourceTable.getSelection().getRow();
                                ConsoleTableModel model = (ConsoleTableModel)((DynamicTableModel)BAlarmConsole.this.sourceTable.getModel()).getRootModel();
                                BAlarmRecord selectedRecord = model.getRecord(selectedRow);
                                doShowVideoMethod.invoke((Object)videoAlmConsoleExt, BAlarmConsole.this, selectedRecord);
                            } else {
                                System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                            }
                            break block5;
                        }
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException cnfe) {
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)cnfe);
                    }
                }
                return null;
            }
        };
        this.showVideoCmd.setEnabled(false);
        this.soundOnCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.soundOn"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.options.setSoundsEnabled(this.isSelected());
                BAlarmConsole.this.options.save();
                return null;
            }
        };
        this.soundOnCommand.setSelected(this.options.getSoundsEnabled());
        this.continuousAlarmCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.continuousAlarm"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.options.setContinuousAlarm(this.isSelected());
                BAlarmConsole.this.options.save();
                return null;
            }
        };
        this.continuousAlarmCommand.setSelected(this.options.getContinuousAlarm());
        this.continuousAlarmCommand.setEnabled(this.soundOnCommand.isSelected());
        this.alarmClassMappingCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.alarmClassMapping"){

            public CommandArtifact doInvoke() {
                BAlarmClassMapping acMap = BAlarmConsole.this.options.getAlarmClassMapping();
                BAlarmClassMappingFE fe = new BAlarmClassMappingFE();
                BAlarmConsole.this.add("temp", (BValue)fe);
                fe.loadValue((BObject)acMap);
                BOptionDialog dialog = new BOptionDialog((BWidget)BAlarmConsole.this, "AlarmClassMapper", fe.createPopup(), 3, null, null);
                dialog.setBoundsCenteredOnOwner();
                IRectGeom cur = dialog.getScreenBounds();
                dialog.setScreenBounds(cur.x(), cur.y(), 500.0, 400.0);
                dialog.open();
                int retVal = dialog.getResult();
                if (retVal == 1) {
                    try {
                        acMap = (BAlarmClassMapping)fe.doSaveValue((BObject)acMap, null);
                        BAlarmConsole.this.options.setAlarmClassMapping(acMap);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                BAlarmConsole.this.remove((BComplex)fe);
                return null;
            }
        };
        this.priorityColorsCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.priorityColors"){

            public CommandArtifact doInvoke() {
                BColor lowColor = BAlarmConsole.this.options.getLowPriorityColor();
                BColor midColor = BAlarmConsole.this.options.getMidPriorityColor();
                BColor highColor = BAlarmConsole.this.options.getHighPriorityColor();
                BColorFE lowFE = new BColorFE();
                lowFE.loadValue((BObject)lowColor);
                BColorFE midFE = new BColorFE();
                midFE.loadValue((BObject)midColor);
                BColorFE highFE = new BColorFE();
                highFE.loadValue((BObject)highColor);
                BGridPane pane = new BGridPane(2);
                pane.add("l1", (BValue)new BLabel("Low Priority Color"));
                pane.add("f1", (BValue)lowFE);
                pane.add("l2", (BValue)new BLabel("Mid Priority Color"));
                pane.add("f2", (BValue)midFE);
                pane.add("l3", (BValue)new BLabel("High Priority Color"));
                pane.add("f3", (BValue)highFE);
                int retVal = BDialog.open((BWidget)BAlarmConsole.this, (String)lexicon.getText("commands.priorityColors.label"), (Object)pane, (int)3, null);
                if (retVal == 1) {
                    try {
                        lowColor = (BColor)lowFE.saveValue((BObject)lowColor, null);
                        midColor = (BColor)midFE.saveValue((BObject)midColor, null);
                        highColor = (BColor)highFE.saveValue((BObject)highColor, null);
                        BAlarmConsole.this.options.setLowPriorityColor(lowColor);
                        BAlarmConsole.this.options.setMidPriorityColor(midColor);
                        BAlarmConsole.this.options.setHighPriorityColor(highColor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ((AlarmTableCellRenderer)BAlarmConsole.this.sourceTable.getCellRenderer()).resetPriorityColors();
                    BAlarmConsole.this.repaint();
                }
                return null;
            }
        };
        this.addColumnCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.addColumn"){

            public CommandArtifact doInvoke() {
                BGridPane pane = new BGridPane(2);
                pane.add("lbl", (BValue)new BLabel("AlarmData."));
                BTextDropDown dataFacet = new BTextDropDown();
                Field[] alarmFields = BAlarmRecord.class.getDeclaredFields();
                Array facetValues = new Array(String.class);
                for (Field alarmField : alarmFields) {
                    try {
                        if (!(alarmField.get(null) instanceof String)) continue;
                        facetValues.add((Object)((String)alarmField.get(null)));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                Object[] facetValuesStr = (String[])facetValues.trim();
                SortUtil.sort((Object[])facetValuesStr, (Object[])facetValuesStr, (Comparator)new Comparator<Object>(){

                    @Override
                    public int compare(Object arg0, Object arg1) {
                        return arg0.toString().toLowerCase().compareTo(arg1.toString().toLowerCase());
                    }
                });
                for (Object aFacetValuesStr : facetValuesStr) {
                    dataFacet.getList().addItem(aFacetValuesStr);
                }
                pane.add("dataFacet", (BValue)dataFacet);
                int retVal = BDialog.open((BWidget)BAlarmConsole.this, (String)lexicon.getText("commands.addColumn.label"), (Object)pane, (int)3, null);
                if (retVal == 1) {
                    try {
                        String value = dataFacet.getText();
                        BAlarmConsole.this.columns.addDataColumn(null, value);
                        for (int i = 0; i < 2; ++i) {
                            DynamicTableModel model;
                            if (i == 0) {
                                model = (DynamicTableModel)BAlarmConsole.this.sourceTable.getModel();
                            } else {
                                if (BAlarmConsole.this.alarmTable == null) break;
                                model = (DynamicTableModel)BAlarmConsole.this.alarmTable.getModel();
                            }
                            model.setColumnShowable(BAlarmConsole.this.columns.getColumnCount() - 1, true);
                            model.setShowColumn(BAlarmConsole.this.columns.getColumnCount() - 1, true);
                            model.updateTable();
                        }
                        BAlarmConsole.this.options.getAlarmDataCols().add(SlotPath.escape((String)value), (BValue)BString.make((String)value));
                        BAlarmConsole.this.options.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
        this.removeColumnCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.removeColumn"){

            public CommandArtifact doInvoke() {
                BGridPane pane = new BGridPane(2);
                pane.add("lbl", (BValue)new BLabel("AlarmData."));
                BString[] addCols = (BString[])BAlarmConsole.this.options.getAlarmDataCols().getChildren(BString.class);
                BListDropDown tf = new BListDropDown();
                for (BString addCol : addCols) {
                    tf.getList().addItem((Object)addCol.toString());
                }
                pane.add("tf", (BValue)tf);
                int retVal = BDialog.open((BWidget)BAlarmConsole.this, (String)lexicon.getText("commands.removeColumn.label"), (Object)pane, (int)3, null);
                if (retVal == 1) {
                    String removeKey = tf.getSelectedItem().toString();
                    int rootIndex = BAlarmConsole.this.columns.dataColumnIndex(removeKey);
                    if (rootIndex == -1) {
                        return null;
                    }
                    for (int t = 0; t < 2; ++t) {
                        int i;
                        DynamicTableModel model;
                        if (t == 0) {
                            model = (DynamicTableModel)BAlarmConsole.this.sourceTable.getModel();
                        } else {
                            if (BAlarmConsole.this.alarmTable == null) break;
                            model = (DynamicTableModel)BAlarmConsole.this.alarmTable.getModel();
                        }
                        boolean[] showing = new boolean[BAlarmConsole.this.columns.getColumnCount()];
                        for (i = 0; i < showing.length; ++i) {
                            showing[i] = model.showColumn(i);
                        }
                        for (i = rootIndex; i < showing.length - 1; ++i) {
                            showing[i] = showing[i + 1];
                        }
                        showing[showing.length - 1] = false;
                        for (i = 0; i < showing.length; ++i) {
                            model.setShowColumn(i, showing[i]);
                        }
                    }
                    BAlarmConsole.this.columns.removeDataColumn(removeKey);
                    BAlarmConsole.this.options.getAlarmDataCols().remove(SlotPath.escape((String)removeKey));
                    BAlarmConsole.this.options.save();
                    BAlarmConsole.this.sourceModel.updateTable();
                }
                return null;
            }
        };
        this.forceClear = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.forceClear"){

            public CommandArtifact doInvoke() {
                BAlarmRecord[] records = BAlarmConsole.this.getSelectedAlarmsDeep(BAlarmConsole.this.sourceTable);
                for (int i = 0; i < records.length; ++i) {
                    BAlarmRecord rec = (BAlarmRecord)records[i].newCopy();
                    rec.setSourceState(BSourceState.normal);
                    rec.setAckState(BAckState.acked);
                    rec.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)BAlarmConsole.this.getUsername(rec)));
                    if (rec.getAckTime().equals((Object)BAbsTime.NULL)) {
                        rec.setAckTime(BAbsTime.now());
                    }
                    if (rec.getNormalTime().equals((Object)BAbsTime.NULL)) {
                        rec.setNormalTime(BAbsTime.now());
                    }
                    try {
                        BAlarmConsole.this.sendUpdatedAlarm(rec, AlarmActionEnum.FORCE_CLEARED);
                        BAlarmConsole.this.getAlarmService().auditForceClear(rec);
                        BAlarmConsole.this.removeAlarm(rec);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
        this.forceClear.setEnabled(false);
        this.columns = this.getConsoleColumns();
        for (BString dataCol : dataCols = (BString[])this.options.getAlarmDataCols().getChildren(BString.class)) {
            this.columns.addDataColumn(null, dataCol.toString());
        }
        this.sourceModel = this.makeSourceTableModel(this.columns, this.recipient, null);
        this.options.setSortColumn(0);
        this.options.setSortAscending(false);
        this.sourceModel.setInitialSort(this.options.getSortColumn(), this.options.getSortAscending());
        String str = this.options.getDisplayColumns();
        StringTokenizer tok = new StringTokenizer(str, ",");
        Array arr = new Array(Integer.class);
        while (tok.hasMoreTokens()) {
            String st = tok.nextToken();
            arr.add((Object)Integer.valueOf(st));
        }
        int[] cols = new int[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            cols[i] = (Integer)arr.get(i);
        }
        this.sourceTable.setModel((TableModel)new DynamicTableModel((TableModel)this.sourceModel, cols));
        BEdgePane listPane = new BEdgePane();
        listPane.setTop((BWidget)this.timeRangeEd);
        listPane.setBottom((BWidget)new BBorderPane((BWidget)this.makeToolBar()));
        this.alarmTitlePane = BAlarmTitlePane.makePane(this.getTitle(), this.sourceTable);
        listPane.setCenter((BWidget)this.alarmTitlePane);
        BTitlePane listTitlePane = new BTitlePane(this.getTypeDisplayName(this.ctx), (BWidget)listPane);
        if (this.options.getViewInstructions()) {
            double divPos = this.options.getInstructionsDividerPosition();
            this.contentPane = new BSplitPane(BOrientation.vertical, divPos);
            this.contentPane.setWidget1((BWidget)listTitlePane);
            this.contentPane.setWidget2((BWidget)instructionsPane);
            this.setContent((BWidget)this.contentPane);
        } else {
            this.setContent((BWidget)listTitlePane);
        }
    }

    public BTable getExportTable() {
        return this.sourceTable;
    }

    public BToolBar getViewToolBar() {
        BToolBar tb = new BToolBar();
        tb.addButton("filter", this.filterCmd);
        return tb;
    }

    public void changed(Property property, Context context) {
        if (property.equals(title) && this.alarmTitlePane != null) {
            this.alarmTitlePane.setTitle(this.getTitle());
        }
        if (property.equals(showTitle) && this.alarmTitlePane != null) {
            this.alarmTitlePane.setTitleVisible(this.getShowTitle());
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.channel() != null) {
            this.channel().unregister(this.recipient);
            this.channel().unregister(this);
        }
        if (soundPlayer != null) {
            soundPlayer.stop();
            soundPlayer.removeListener(this);
        }
        if (this.contentPane != null) {
            this.options.setInstructionsDividerPosition(this.contentPane.getDividerPosition());
        }
        DynamicTableModel dtm = (DynamicTableModel)this.sourceTable.getModel();
        StringBuilder colStr = new StringBuilder();
        for (int i = 0; i < dtm.getRootColumnCount(); ++i) {
            if (!dtm.showColumn(i)) continue;
            colStr.append(i + ",");
        }
        if (dtm.getRootColumnCount() > 0) {
            this.options.setDisplayColumns(colStr.toString());
        }
        this.options.setSortColumn(this.sourceModel.getLastSortColumn());
        this.options.setSortAscending(this.sourceModel.getLastSortAscending());
        this.options.save();
    }

    public BAlarmConsoleOptions getDefaultOptions() {
        return BAlarmConsoleOptions.getDefault();
    }

    public ConsoleColumns getConsoleColumns() {
        return new ConsoleColumns();
    }

    protected Controller getController() {
        return new Controller();
    }

    protected SourceTableModel makeSourceTableModel(ConsoleColumns columns, BConsoleRecipient recip, Context context) {
        return new SourceTableModel(columns, recip, context);
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        this.recipient = (BConsoleRecipient)value;
        this.ctx = cx;
        this.sourceTable.setMultipleSelection(true);
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            shell = this.getShell();
        }
        this.sourceTimeCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.sourceTimeZone");
        this.consoleTimeCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.consoleTimeZone");
        BTimeZoneDisplay tzDisplay = this.options.getTimeZoneDisplay();
        RadioGroup radioGroup = new RadioGroup();
        radioGroup.add(this.sourceTimeCommand);
        radioGroup.add(this.consoleTimeCommand);
        if (tzDisplay == BTimeZoneDisplay.console) {
            this.consoleTimeCommand.setSelected(true);
        } else {
            this.sourceTimeCommand.setSelected(true);
        }
        this.timeRange = this.recipient.getDefaultTimeRange();
        this.timeRangeEd.loadValue((BObject)this.timeRange);
        BFilterSet filters = this.options.getAlarmFilters();
        BFilterEntry[] entries = (BFilterEntry[])filters.getChildren(BFilterEntry.class);
        boolean filtered = false;
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getActive()) continue;
            filtered = true;
            break;
        }
        if (filtered) {
            this.filterBtn.setImage(BImage.make((String)lexicon.getText("commands.filtered.icon")));
            this.filterBtn.setForeground(BBrush.makeSolid((BColor)BColor.red));
        }
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)timeRangeModified);
        if (shell instanceof BWbShell) {
            new LoadThread().start();
        }
    }

    public BGridPane makeToolBar() {
        int cmdCount = 4;
        if (AWT_ENV) {
            ++cmdCount;
        }
        if (BAlarmConsole.isVideoDriverAvailable()) {
            ++cmdCount;
        }
        BGridPane toolBar = new BGridPane(cmdCount);
        toolBar.setColumnAlign(BHalign.fill);
        toolBar.setUniformColumnWidth(true);
        BButton ackBtn = new BButton(this.ackCommand, true, true);
        toolBar.add("ack", (BValue)ackBtn);
        BButton hypBtn = new BButton(this.urlCommand, true, true);
        toolBar.add("hyp", (BValue)hypBtn);
        BButton notesBtn = new BButton(this.notesCommand, true, true);
        toolBar.add("notes", (BValue)notesBtn);
        if (AWT_ENV) {
            BButton silBtn = new BButton(this.silenceCommand, true, true);
            toolBar.add("sil", (BValue)silBtn);
        }
        this.filterBtn = new BButton(this.filterCmd, true, true);
        toolBar.add("filter", (BValue)this.filterBtn);
        if (BAlarmConsole.isVideoDriverAvailable()) {
            BButton showVideoBtn = new BButton(this.showVideoCmd, true, true);
            toolBar.add("showVideo", (BValue)showVideoBtn);
        }
        return toolBar;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = lexicon.buildMenu("menu.alarm.label");
        menu.add("acknowledge", this.ackCommand);
        menu.add("hyperlink", this.urlCommand);
        menu.add("notes", this.notesCommand);
        menu.add("details", this.detailsCommand);
        if (AWT_ENV) {
            menu.add("silence", this.silenceCommand);
        }
        menu.add("sep0", (BValue)new BSeparator());
        if (this.getRecipientForAlarm(null) == null || this.getRecipientForAlarm(null).getPermissions(this.ctx).hasAdminWrite() || this.getRecipientForAlarm(null).getPermissions(this.ctx).hasAdminInvoke()) {
            menu.add("forceClear", this.forceClear);
            menu.add("sep1", (BValue)new BSeparator());
        }
        menu.add("soundOn", (Command)this.soundOnCommand);
        menu.add("continuousAlarm", (Command)this.continuousAlarmCommand);
        menu.add("acMap", this.alarmClassMappingCommand);
        menu.add("pColors", this.priorityColorsCommand);
        menu.add("sep2", (BValue)new BSeparator());
        menu.add("sourceTime", (Command)this.sourceTimeCommand);
        menu.add("consoleTime", (Command)this.consoleTimeCommand);
        menu.add("sep3", (BValue)new BSeparator());
        menu.add("addCol", this.addColumnCommand);
        menu.add("removeCol", this.removeColumnCommand);
        return new BMenu[]{menu};
    }

    public void doProcessAlarm(BAlarmRecord alarm) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BAlarmConsole.doProcess(): " + this.recipient.getName() + " got alarm: " + alarm.getTimestamp() + " : " + alarm.getSourceState());
        }
        if (!alarm.isOpen()) {
            this.removeAlarm(alarm);
        } else {
            BAbsTime currentTime = BAbsTime.now();
            BAbsTime filterStartTime = this.timeRange.getStartTime(currentTime);
            BAbsTime filterEndTime = this.timeRange.getEndTime(currentTime);
            if (this.options.getAlarmFilters().accept((BComplex)alarm) && (filterStartTime.isNull() || filterStartTime.isBefore(alarm.getTimestamp())) && (filterEndTime.isNull() || this.timeRange.getEndTime(currentTime).isAfter(alarm.getTimestamp()))) {
                this.updateAlarm(alarm, true);
            } else {
                this.removeAlarm(alarm);
            }
        }
        this.options.setSortColumn(this.sourceModel.getLastSortColumn());
        this.options.setSortAscending(this.sourceModel.getLastSortAscending());
        this.sourceModel.sortByColumn(this.sourceModel.getLastSortColumn(), this.sourceModel.getLastSortAscending());
        ((Controller)this.sourceTable.getController()).enableCommands();
    }

    public void doTimeRangeModified() throws Exception {
        this.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            shell = this.getShell();
        }
        if (shell instanceof BWbShell) {
            new LoadThread().start();
        } else {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAlarms(BAlarmRecord[] records) {
        Object object = this.dataMutex;
        synchronized (object) {
            if (this.options.getNotesRequiredOnAck()) {
                BTextDropDown dropDown = new BTextDropDown(false);
                BEdgePane outerPane = new BEdgePane();
                String previousNotes = lexicon.getText("alarm.multipleAlarmNotes");
                if (records.length == 1) {
                    previousNotes = records[0].getAlarmData().get("notes") != null ? records[0].getAlarmData().get("notes").toString() : "";
                }
                BTextEditorPane previousPane = new BTextEditorPane(previousNotes.toString(), 12, 80, false);
                outerPane.setTop((BWidget)previousPane);
                BList genericMsgList = dropDown.getList();
                BVector v = this.options.getAlarmAckResponses();
                BString[] entries = (BString[])v.getChildren(BString.class);
                for (int i = 0; i < entries.length; ++i) {
                    genericMsgList.addItem((Object)BFormat.make((String)entries[i].toString()).format((Object)this));
                }
                BEdgePane pane = new BEdgePane();
                if (genericMsgList.getItemCount() > 0) {
                    pane.setTop((BWidget)dropDown);
                }
                BTextEditorPane text = new BTextEditorPane("", 8, 80, true);
                pane.setCenter((BWidget)text);
                outerPane.setCenter((BWidget)pane);
                text.getEditor().requestFocus();
                int retVal = BDialog.open((BWidget)this, (String)lexicon.getText("commands.notes.label"), (Object)new BBorderPane((BWidget)outerPane), (int)3);
                if (retVal == 2) {
                    return;
                }
                String newNotes = text.getText();
                if (genericMsgList.getItemCount() > 0) {
                    newNotes = dropDown.getText() + '\n' + text.getText();
                }
                for (BAlarmRecord record : records) {
                    String[] keys;
                    BFacets alarmData = record.getAlarmData();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String key : keys = alarmData.list()) {
                        if (key.equals("notes")) continue;
                        BIDataValue value = (BIDataValue)alarmData.get(key);
                        map.put(key, value);
                    }
                    String oldNotes = "";
                    if (alarmData.get("notes") != null) {
                        oldNotes = alarmData.get("notes").toString();
                    }
                    StringBuilder notes = new StringBuilder();
                    notes.append("## " + BAbsTime.now() + " - " + this.getUsername(record) + " ##\n");
                    notes.append(newNotes);
                    notes.append("\n\n");
                    notes.append(oldNotes);
                    map.put("notes", BString.make((String)notes.toString()));
                    BFacets f = BFacets.make(map);
                    record.setAlarmData(f);
                }
            }
            this.ackAlarms(records);
            if (records.length > 1) {
                this.sourceTable.getSelection().deselectAll();
            }
        }
    }

    public void alarmSilenceSelected() {
        if (soundPlayer != null) {
            soundPlayer.stop();
        }
        this.mediaPlayerStopped();
    }

    @Override
    public void mediaPlayerStopped() {
        this.silenceCommand.setEnabled(false);
    }

    public void showError(String message, Throwable t) {
        BDialog.error((BWidget)this, (String)"Error", (Object)message, (Throwable)t);
    }

    public void showNotes(BWidget owner, BAlarmRecord[] records) {
        if (records.length == 0) {
            return;
        }
        String notes = "";
        if (records.length == 1) {
            try {
                notes = ((BString)records[0].getAlarmData().getFacet("notes")).getString();
            }
            catch (Exception exception) {}
        } else {
            notes = lexicon.getText("alarm.multipleAlarmNotes");
        }
        BNotesDialog dlg = new BNotesDialog((BWidget)this, notes, this.getUsername(records[0]), this.canModifySelectedAlarms());
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        String newNotes = dlg.getNewNotes();
        for (int i = 0; i < records.length; ++i) {
            String[] keys;
            if (newNotes == null) continue;
            try {
                notes = newNotes + ((BString)records[i].getAlarmData().getFacet("notes")).getString();
            }
            catch (Exception e) {
                notes = newNotes;
            }
            BFacets alarmData = records[i].getAlarmData();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : keys = alarmData.list()) {
                if (key.equals("notes")) continue;
                BIDataValue value = (BIDataValue)alarmData.get(key);
                map.put(key, value);
            }
            map.put("notes", BString.make((String)notes));
            BFacets f = BFacets.make(map);
            records[i].setAlarmData(f);
            try {
                this.sendUpdatedAlarm(records[i], AlarmActionEnum.NOTES);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String getUsername(BAlarmRecord alarm) {
        BFoxSession session = (BFoxSession)this.getCurrentValueSession();
        BFoxClientConnection conn = session.getConnection();
        return conn.getFoxSession().getUsername();
    }

    protected boolean canModifySelectedAlarms() {
        return this.canModifySelectedAlarms(this.sourceModel.getSelection());
    }

    protected boolean canModifySelectedAlarms(TableSelection sel) {
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        int[] selIndex = sel.getRows();
        SourceTableModel model = (SourceTableModel)((DynamicTableModel)this.sourceModel.getModel()).getRootModel();
        BAlarmService service = this.getAlarmService();
        for (int i = 0; i < selIndex.length; ++i) {
            BAlarmRecord record = model.getRecord(selIndex[i]);
            BAlarmClass alarmClass = service.lookupAlarmClass(record.getAlarmClass());
            if (!(alarmClass == null ? !service.getDefaultAlarmClass().getPermissions(this.ctx).hasOperatorWrite() : !alarmClass.getPermissions(this.ctx).hasOperatorWrite())) continue;
            return false;
        }
        return true;
    }

    protected void loadComplete() {
        this.exitBusy();
        this.exitBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.dataMutex;
        synchronized (object) {
            this.enterBusy();
            try {
                BDynamicTimeRange timeRange;
                StringBuilder ordText = new StringBuilder(this.channel().getInitialAlarmQuery(this, this.recipient).toString());
                BFilterSet filters = this.options.getAlarmFilters();
                StringBuilder predicate = new StringBuilder(64);
                String filterQual = filters.getPredicate();
                if (filterQual != null && !filterQual.isEmpty()) {
                    if (predicate.length() != 0) {
                        predicate.append(" and ");
                    }
                    predicate.append(filterQual);
                }
                if (predicate.length() != 0) {
                    ordText.append(" and ").append((CharSequence)predicate);
                }
                if (!(timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue()).equals((Object)BDynamicTimeRange.DEFAULT)) {
                    BAbsTimeFilter timeFilter = new BAbsTimeFilter();
                    timeFilter.initFromDynamicTimeRange(timeRange);
                    String timeRangePredicate = timeFilter.getPredicate(BAlarmRecord.timestamp.getName());
                    ordText.append(" and ").append(timeRangePredicate);
                }
                String sortColumnName = this.options.getSortColumn() < this.sourceModel.getColumns().getColumnCount() ? this.sourceModel.getColumns().getColumn(this.options.getSortColumn()).getQueryName() : this.sourceModel.getColumns().getColumn(0).getQueryName();
                ordText.append(" order by ");
                if (!"timestamp".equalsIgnoreCase(sortColumnName)) {
                    ordText.append("timestamp desc, " + sortColumnName);
                } else {
                    ordText.append(sortColumnName);
                }
                if (this.options.getSortAscending()) {
                    ordText.append(" asc");
                } else {
                    ordText.append(" desc");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(ordText.toString());
                }
                BOrd ord = BOrd.make((BOrd)this.getCurrentValueSession().getAbsoluteOrd(), (BOrd)BOrd.make((String)ordText.toString()));
                BITable result = (BITable)ord.resolve(this.getCurrentValue()).get();
                try (TableCursor recs = result.cursor();){
                    this.sourceModel.clear();
                    if (recs.next()) {
                        BAlarmRecord alarm = (BAlarmRecord)recs.get();
                        if (alarm.isOpen()) {
                            this.sourceModel.update(alarm);
                            this.sourceTable.sizeColumnsToFit();
                        }
                        while (recs.next()) {
                            alarm = (BAlarmRecord)recs.get();
                            if (alarm.getSourceState() == BSourceState.normal && (alarm.isAcknowledged() || !alarm.getAckRequired())) continue;
                            this.sourceModel.update(alarm, false);
                        }
                        this.sourceModel.sortByColumn(this.sourceModel.getLastSortColumn(), this.sourceModel.getLastSortAscending());
                        this.sourceModel.updateTable();
                        this.sourceTable.sizeColumnsToFit();
                    }
                }
                for (int i = 0; i < this.sourceModel.getRowCount(); ++i) {
                    if (!this.sourceModel.getRecord(i).isAlarm()) continue;
                    this.soundAlarmFor(this.sourceModel.getRecord(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.exitBusy();
                this.loadComplete();
                this.sourceModel.init(this, this.ctx);
                this.sourceTable.sizeColumnsToFit();
                this.sourceModel.getTable().fireTableModified(null);
            }
        }
    }

    public void configFilters() {
        if (this.sourceTable == null) {
            return;
        }
        SlotCursor c = this.options.getAlarmFilters().getProperties();
        if (!c.next(BFilterEntry.class)) {
            this.options.setAlarmFilters(this.buildFilterSet());
        }
        BFilterSetEditor setEditor = new BFilterSetEditor();
        setEditor.loadValue((BObject)this.options.getAlarmFilters());
        BBorderPane borderPane = new BBorderPane((BWidget)setEditor, 10.0, 10.0, 10.0, 10.0);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)borderPane, (int)3) != 2) {
            try {
                BWbShell shell;
                if (setEditor.isModified()) {
                    BFilterSet filters = (BFilterSet)setEditor.saveValue();
                    this.options.setAlarmFilters(filters);
                    BFilterEntry[] entries = (BFilterEntry[])filters.getChildren(BFilterEntry.class);
                    boolean filtered = false;
                    for (int i = 0; i < entries.length; ++i) {
                        if (!entries[i].getActive()) continue;
                        filtered = true;
                        break;
                    }
                    if (filtered) {
                        this.filterBtn.setImage(BImage.make((String)lexicon.getText("commands.filtered.icon")));
                        this.filterBtn.setForeground(BBrush.makeSolid((BColor)BColor.red));
                    } else {
                        this.filterBtn.setImage(BImage.make((String)lexicon.getText("commands.filter.icon")));
                        this.filterBtn.setForeground(BBrush.NULL);
                    }
                }
                if ((shell = this.getWbShell()) == null) {
                    shell = this.getShell();
                }
                if (shell instanceof BWbShell) {
                    new LoadThread().start();
                } else {
                    this.load();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private BFilterSet buildFilterSet() {
        BAlarmRecord rec = new BAlarmRecord(BUuid.DEFAULT);
        BAlarmFilterSet set = new BAlarmFilterSet();
        Property[] props = rec.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue value;
            AgentList agents;
            if (props[i].equals(BAlarmRecord.timestamp) || (agents = (value = rec.get(props[i])).getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() == 0) continue;
            BIBqlFilter filter = (BIBqlFilter)agents.getDefault().getInstance();
            filter.init((BObject)value);
            BFilterEntry entry = new BFilterEntry(false, props[i].getDefaultDisplayName(this.getCurrentContext()), filter);
            set.add(props[i].getName(), (BValue)entry, 0, rec.getSlotFacets((Slot)props[i]), null);
        }
        return set;
    }

    public void updateAlarm(BAlarmRecord alarm, boolean soundAlarm) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BAlarmConsole.alarmCreated(): update alarm: uuid = " + alarm.getUuid() + ", priority = " + alarm.getPriority());
        }
        BAbsTime currentTime = BAbsTime.now();
        BAbsTime filterStartTime = this.timeRange.getStartTime(currentTime);
        BAbsTime filterEndTime = this.timeRange.getEndTime(currentTime);
        if (this.options.getAlarmFilters().accept((BComplex)alarm) && (filterStartTime.isNull() || filterStartTime.isBefore(alarm.getTimestamp())) && (filterEndTime.isNull() || filterEndTime.isAfter(alarm.getTimestamp()))) {
            this.sourceModel.update(alarm);
            this.sourceTable.sizeColumnsToFit();
        }
        if (soundAlarm && alarm.isAlarm()) {
            this.soundAlarmFor(alarm);
        } else if (soundAlarm) {
            this.silenceAlarm(alarm);
        }
    }

    public void removeAlarm(BAlarmRecord alarm) {
        this.sourceModel.remove(alarm);
        this.silenceAlarm(alarm);
        if (this.detailsDlg != null && this.detailsDlg.alarm.getUuid().equals((Object)alarm.getUuid())) {
            this.detailsDlg.alarmCleared();
        }
    }

    protected void viewAll() {
        int row = this.sourceModel.getSelection().getRow();
        if (row == -1) {
            return;
        }
        BAlarmRecord rec = this.sourceModel.getRecord(row);
        BOrdList source = rec.getSource();
        this.alarmTable = new BTable();
        this.alarmTable.setController((TableController)this.getController());
        this.alarmTable.setCellRenderer((TableCellRenderer)new AlarmTableCellRenderer());
        AlarmTableModel model = this.sourceModel.getModelForSource(source);
        DynamicTableModel dynModel = new DynamicTableModel((TableModel)model);
        DynamicTableModel srcDyn = (DynamicTableModel)this.sourceTable.getModel();
        int count = this.columns.getColumnCount();
        for (int i = 0; i < count; ++i) {
            dynModel.setShowColumn(i, srcDyn.showColumn(i));
            dynModel.setColumnShowable(i, srcDyn.isColumnShowable(i));
        }
        this.alarmTable.setModel((TableModel)dynModel);
        this.alarmReport = new BAlarmReportDialog(this, source.toString(), this.alarmTable);
        IRectGeom size = UiEnv.get().getScreenBounds((BWidget)this);
        double x = size.x() + (size.width() - size.width() / 1.3) / 2.0;
        double y = size.y() + (size.height() - size.height() / 2.0) / 2.0;
        this.alarmReport.setPreferredSize(size.width() / 1.3, size.height() / 2.0);
        this.alarmReport.setScreenBounds(x, y, size.width() / 1.3, size.height() / 2.0);
        this.alarmReport.setVisible(true);
        this.alarmReport.open();
        model.close();
        this.alarmTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmRecord[] getSelectedAlarms(BTable table) {
        Object object = this.dataMutex;
        synchronized (object) {
            ConsoleTableModel model = (ConsoleTableModel)((DynamicTableModel)table.getModel()).getRootModel();
            int[] selection = table.getSelection().getRows();
            BAlarmRecord[] alarms = new BAlarmRecord[selection.length];
            ConsoleTableModel consoleTableModel = model;
            synchronized (consoleTableModel) {
                for (int i = 0; i < selection.length; ++i) {
                    alarms[i] = model.getRecord(selection[i]);
                }
            }
            return alarms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmRecord[] getSelectedAlarmsDeep(BTable table) {
        ConsoleTableModel consoleModel = (ConsoleTableModel)((DynamicTableModel)table.getModel()).getRootModel();
        if (!(consoleModel instanceof SourceTableModel)) {
            return this.getSelectedAlarms(table);
        }
        SourceTableModel model = (SourceTableModel)consoleModel;
        int[] selection = table.getSelection().getRows();
        Array alarms = new Array(BAlarmRecord.class);
        SourceTableModel sourceTableModel = model;
        synchronized (sourceTableModel) {
            for (int i = 0; i < selection.length; ++i) {
                int count = model.getRecordCount(selection[i]);
                for (int j = 0; j < count; ++j) {
                    alarms.add((Object)model.getRecordAt(selection[i], j));
                }
            }
        }
        return (BAlarmRecord[])alarms.trim();
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            BOrd authority = this.getCurrentValueSession().getAbsoluteOrd();
            try {
                BOrd serviceOrd = BOrd.make((BOrd)authority, (String)"service:alarm:AlarmService");
                this.alarmService = (BAlarmService)serviceOrd.resolve().get();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to Audit Force Clear: Cannot find alarm Service", e);
            }
        }
        return this.alarmService;
    }

    protected void ackAlarms(BAlarmRecord[] alarms) {
        try {
            Array recs = new Array(BAlarmRecord.class);
            for (BAlarmRecord alarm : alarms) {
                if (alarm.isAcknowledged()) continue;
                BAlarmRecord rec = (BAlarmRecord)alarm.newCopy();
                rec.setUser(this.getUsername(rec));
                rec.setAckTime(BAbsTime.now());
                rec.setAckState(BAckState.ackPending);
                this.sourceModel.update(rec);
                recs.add((Object)rec);
            }
            this.channel().ackAlarms(this.recipient, (BAlarmRecord[])recs.trim());
            this.sourceTable.sizeColumnsToFit();
            this.sourceTable.fireTableModified(null);
            if (this.alarmTable != null) {
                this.alarmTable.fireTableModified(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void soundAlarmFor(BAlarmRecord alarm) {
        if (!this.options.getSoundsEnabled()) {
            return;
        }
        try {
            BOrd sfOrd = BOrd.NULL;
            try {
                if (alarm.getAlarmData().get("soundFile") != null) {
                    sfOrd = BOrd.make((BOrd)BOrd.toSpace((BObject)this.getRecipientForAlarm(alarm)).getNavOrd(), (String)alarm.getAlarmData().get("soundFile").toString());
                }
            }
            catch (NullOrdException nullOrdException) {
                // empty catch block
            }
            if (sfOrd == null || sfOrd.isNull()) {
                BAlarmClassMapping mapping;
                BAlarmClassDef acDef = null;
                if (this.options != null && (mapping = this.options.getAlarmClassMapping()) != null && (acDef = mapping.getAlarmClassDefFor(alarm.getAlarmClass())) != null) {
                    sfOrd = acDef.getAlarmSound();
                }
            }
            if (sfOrd == null || sfOrd.isNull()) {
                this.soundAlarm(alarm);
            } else {
                this.soundAlarm(alarm.getSource(), sfOrd);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Cannot Sound Alarm: ", e);
        }
    }

    public void soundAlarm(BAlarmRecord alarm) throws Exception {
        if (!this.options.getDefaultSoundFile().isNull()) {
            if (this.options.getDefaultSoundFile().relativizeToHost().equals((Object)BLocalHost.INSTANCE.getAbsoluteOrd())) {
                this.soundAlarm(alarm.getSource(), this.options.getDefaultSoundFile());
            } else if (!BOrd.toSpace((BObject)this.getRecipientForAlarm(alarm)).getNavOrd().isNull()) {
                this.soundAlarm(alarm.getSource(), BOrd.make((BOrd)BOrd.toSpace((BObject)this.getRecipientForAlarm(alarm)).getNavOrd(), (String)this.options.getDefaultSoundFile().toString()));
            }
        }
    }

    public void soundAlarm(BOrdList source, BOrd soundFileOrd) {
        block9: {
            try {
                if (!this.options.getSoundsEnabled() || soundFileOrd.isNull()) {
                    return;
                }
                if (!AWT_ENV) break block9;
                BAbstractFile soundFile = this.sounds.get(soundFileOrd);
                if (soundFile == null) {
                    soundFile = (BAbstractFile)soundFileOrd.get();
                    this.sounds.put(soundFileOrd, soundFile);
                }
                if (soundPlayer == null) {
                    try {
                        soundPlayer = UiEnv.get().isMicroEdition() ? (IAudioPlayer)Class.forName("com.tridium.alarm.ui.audio.SoundPlayer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (IAudioPlayer)Class.forName("com.tridium.alarm.ui.audio.MediaPlayer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        soundPlayer.addMediaObject((BValue)source, soundFile);
                        soundPlayer.addListener(this);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        logger.warning("Cannot instantiate AudioPlayer: " + e.getMessage());
                    }
                }
                if (soundPlayer != null) {
                    if (soundPlayer.addMediaObject((BValue)source, soundFile)) {
                        soundPlayer.play(this.options.getContinuousAlarm(), this.options.getContinuousAlarmDelay());
                    }
                    this.silenceCommand.setEnabled(true);
                }
            }
            catch (Exception e) {
                logger.warning("Cannot sound alarm: MediaPlayer exception: " + e);
            }
        }
    }

    public void silenceAlarm(BAlarmRecord alarm) {
        soundPlayer.removeMediaObject((BValue)alarm.getSource());
        if (soundPlayer != null && !soundPlayer.hasMediaObjects()) {
            this.silenceCommand.setEnabled(false);
        }
    }

    public void showDetailsDialog(BTable sourceTable, int row) {
        ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)sourceTable.getModel()).getRootModel();
        this.detailsDlg = new BAlarmDetailsDialog(this, this.options.getTimeZoneDisplay(), tm.getRecord(row), tm, this.ctx);
        this.detailsDlg.setBoundsCenteredOnOwner();
        this.detailsDlg.open();
    }

    protected void hyperlink(BAlarmRecord target) {
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            BOrd hyperlink = BOrd.NULL;
            if (target.getAlarmData().get("hyperlinkOrd") != null) {
                hyperlink = BOrd.make((String)target.getAlarmData().get("hyperlinkOrd").toString());
            }
            if (hyperlink == null || hyperlink.isNull()) {
                BAlarmClassMapping mapping = this.options.getAlarmClassMapping();
                BAlarmClassDef acDef = mapping.getAlarmClassDefFor(target.getAlarmClass());
                hyperlink = acDef.getAlarmUrl();
            }
            if (!hyperlink.isNull()) {
                shell.hyperlink(hyperlink);
                if (this.detailsDlg != null) {
                    this.detailsDlg.close();
                }
                if (this.alarmReport != null) {
                    this.alarmReport.close();
                }
            }
        }
    }

    protected BConsoleRecipient getRecipientForAlarm(BAlarmRecord alarm) {
        return this.recipient;
    }

    @Override
    public BAlarmService getAlarmService(BAlarmRecord rec) {
        return this.getAlarmService();
    }

    protected void sendUpdatedAlarm(BAlarmRecord alarm, AlarmActionEnum alarmAction) throws Exception {
        this.channel().updateAlarm(alarm, alarmAction);
    }

    public BAlarmConsoleUIChannel channel() {
        return this.channel(this.recipient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmConsoleUIChannel channel(BConsoleRecipient recipient) {
        try {
            if (recipient.getComponentSpace() == null) {
                throw new BajaRuntimeException("Console recipient component space is null.");
            }
            BFoxSession session = (BFoxSession)recipient.getSession();
            if (session == null) {
                throw new BajaRuntimeException("Console recipient session is null.");
            }
            BFoxClientConnection connection = session.getConnection();
            if (connection == null) {
                throw new BajaRuntimeException("Console recipient connection is null.");
            }
            Object object = BAlarmConsoleChannel.CHANNEL_MUTEX;
            synchronized (object) {
                return BAlarmConsole.getAlarmUiChannel((BFoxConnection)connection);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception getting the alarmui channel for recipient " + recipient.getName(), e);
            return null;
        }
    }

    public static BAlarmConsoleUIChannel getAlarmUiChannel(BFoxConnection connection) {
        BAlarmConsoleChannel channel = (BAlarmConsoleChannel)connection.getChannels().get("alarmui");
        if (!(channel instanceof BAlarmConsoleUIChannel)) {
            if (channel != null) {
                connection.getChannels().remove("alarmui");
            }
            channel = (BAlarmConsoleChannel)connection.getChannels().get("alarmui", BAlarmConsoleUIChannel.TYPE);
        }
        return (BAlarmConsoleUIChannel)channel;
    }

    static boolean isVideoDriverAvailable() {
        BModule videoDriverModule = null;
        try {
            videoDriverModule = Sys.loadModule((String)"videoDriver");
        }
        catch (ModuleNotFoundException e) {
            videoDriverModule = null;
        }
        catch (ModuleException e) {
            videoDriverModule = null;
        }
        return videoDriverModule != null;
    }

    static {
        logger = Logger.getLogger("alarm");
        if (AWT_ENV) {
            try {
                soundPlayer = UiEnv.get().isMicroEdition() ? (IAudioPlayer)Class.forName("com.tridium.alarm.ui.audio.SoundPlayer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (IAudioPlayer)Class.forName("com.tridium.alarm.ui.audio.MediaPlayer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.warning("Cannot instantiate AudioPlayer: " + e.getMessage());
            }
        }
        lexicon = UiLexicon.makeUiLexicon(BAlarmConsole.class);
    }

    public class AlarmTableCellRenderer
    extends TableCellRenderer {
        IntHashMap priorityColors = new IntHashMap();

        public void resetPriorityColors() {
            this.priorityColors.clear();
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (this.getTable() == null || this.getTable().getModel() == null) {
                return 0.0;
            }
            if (cell.column == 0) {
                return super.getPreferredCellWidth(cell) + 18.0 + 18.0 + 18.0;
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            if (cell.column == 0) {
                BAlarmRecord rec;
                try {
                    ConsoleTableModel am = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                    rec = am.getRecord(cell.row);
                }
                catch (Exception e) {
                    return;
                }
                if (rec == null) {
                    return;
                }
                String alarmClassName = rec.getAlarmClass();
                BAlarmClassMapping mapping = BAlarmConsole.this.options.getAlarmClassMapping();
                BAlarmClassDef acDef = mapping.getAlarmClassDefFor(alarmClassName);
                BImage acIcon = null;
                try {
                    if (rec.getAlarmData().get("icon") != null && BOrd.make((String)rec.getAlarmData().get("icon").toString()) != BOrd.NULL) {
                        acIcon = BImage.make((BOrd)BOrd.make((BOrd)BOrd.toSpace((BObject)BAlarmConsole.this.getRecipientForAlarm(rec)).getNavOrd(), (String)rec.getAlarmData().get("icon").toString()));
                    } else if (acDef != null && acDef.getAlarmIcon() != BOrd.NULL) {
                        acIcon = BImage.make((BOrd)acDef.getAlarmIcon());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (acIcon != null) {
                    y = (cell.height - acIcon.getHeight()) / 2.0;
                    g.drawImage(acIcon, x, y);
                }
                x += 18.0;
                BOrd lnk = BOrd.NULL;
                if (rec.getAlarmData().get("hyperlinkOrd") != null && !BOrd.make((String)rec.getAlarmData().get("hyperlinkOrd").toString()).isNull()) {
                    lnk = BOrd.make((String)rec.getAlarmData().get("hyperlinkOrd").toString());
                } else if (acDef != null) {
                    lnk = acDef.getAlarmUrl();
                }
                if (lnk != null && !lnk.isNull() && BAlarmConsole.this.lnkImg != null) {
                    y = (cell.height - BAlarmConsole.this.lnkImg.getHeight()) / 2.0;
                    g.drawImage(BAlarmConsole.this.lnkImg, x, y);
                }
                x += 18.0;
                String alarmSourceExtCamera = rec.getAlarmData().gets("cameraOrd", null);
                if (alarmSourceExtCamera != null && !BOrd.make((String)alarmSourceExtCamera).isNull()) {
                    String cameraImagePath = lexicon.getText("commands.showVideo.icon");
                    BImage cameraIcon = BImage.make((String)cameraImagePath);
                    y = (cell.height - cameraIcon.getHeight()) / 2.0;
                    g.drawImage(cameraIcon, x, y);
                }
                x += 18.0;
                BImage icon = model.getRowIcon(cell.row);
                if (icon != null) {
                    y = (cell.height - icon.getHeight()) / 2.0;
                    g.drawImage(icon, x, y);
                    x += 18.0;
                }
            }
            String s = this.getCellText(cell);
            BFont font = Theme.table().getCellFont();
            switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    x = cell.width - 2.0 - font.width(s);
                    break;
                }
                case 1: {
                    x = (cell.width - font.width(s)) / 2.0;
                }
            }
            g.setFont(Theme.table().getCellFont());
            g.drawString(s, x, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            try {
                BColor color;
                DynamicTableModel dtm = (DynamicTableModel)this.getTable().getModel();
                BAlarmRecord rec = ((ConsoleTableModel)dtm.getRootModel()).getRecord(cell.row);
                int priority = 0;
                if (rec != null) {
                    priority = rec.getPriority();
                }
                if ((color = (BColor)this.priorityColors.get(priority)) != null) {
                    return BBrush.makeSolid((BColor)color);
                }
                color = this.solveSpectrum(priority, BAlarmConsole.this.options.getLowPriorityColor(), BAlarmConsole.this.options.getMidPriorityColor(), BAlarmConsole.this.options.getHighPriorityColor());
                this.priorityColors.put(priority, (Object)color);
                return BBrush.makeSolid((BColor)color);
            }
            catch (Exception e) {
                return super.getBackground(cell);
            }
        }

        private BColor solveSpectrum(int priority, BColor lowColor, BColor midColor, BColor highColor) {
            int alpha;
            int blue;
            int green;
            int red;
            float mid = 128.0f;
            float value = priority;
            float delta = 128.0f;
            if (value > mid) {
                if (value > mid + delta) {
                    return lowColor;
                }
                float mRed = (float)(lowColor.getRed() - midColor.getRed()) / delta;
                float bRed = (float)midColor.getRed() - mRed * mid;
                red = (int)(mRed * value + bRed);
                float mGreen = (float)(lowColor.getGreen() - midColor.getGreen()) / delta;
                float bGreen = (float)midColor.getGreen() - mGreen * mid;
                green = (int)(mGreen * value + bGreen);
                float mBlue = (float)(lowColor.getBlue() - midColor.getBlue()) / delta;
                float bBlue = (float)midColor.getBlue() - mBlue * mid;
                blue = (int)(mBlue * value + bBlue);
                float mAlpha = (float)(lowColor.getAlpha() - midColor.getAlpha()) / delta;
                float bAlpha = (float)midColor.getAlpha() - mAlpha * mid;
                alpha = (int)(mAlpha * value + bAlpha);
            } else {
                if (value < mid - delta) {
                    return highColor;
                }
                float mRed = (float)(midColor.getRed() - highColor.getRed()) / delta;
                float bRed = (float)midColor.getRed() - mRed * mid;
                red = (int)(mRed * value + bRed);
                float mGreen = (float)(midColor.getGreen() - highColor.getGreen()) / delta;
                float bGreen = (float)midColor.getGreen() - mGreen * mid;
                green = (int)(mGreen * value + bGreen);
                float mBlue = (float)(midColor.getBlue() - highColor.getBlue()) / delta;
                float bBlue = (float)midColor.getBlue() - mBlue * mid;
                blue = (int)(mBlue * value + bBlue);
                float mAlpha = (float)(midColor.getAlpha() - highColor.getAlpha()) / delta;
                float bAlpha = (float)midColor.getAlpha() - mAlpha * mid;
                alpha = (int)(mAlpha * value + bAlpha);
            }
            return BColor.make((int)red, (int)green, (int)blue, (int)alpha);
        }
    }

    protected class Controller
    extends TableController {
        protected Controller() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            this.enableCommands();
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            this.enableCommands();
        }

        void enableCommands() {
            TableSelection sel = this.getTable().getSelection();
            boolean canModifySelectedAlarms = sel.getRows().length > 0 && BAlarmConsole.this.canModifySelectedAlarms(sel);
            BAlarmConsole.this.ackCommand.setEnabled(canModifySelectedAlarms);
            BAlarmConsole.this.ackRecentCommand.setEnabled(canModifySelectedAlarms);
            BAlarmConsole.this.forceClear.setEnabled(canModifySelectedAlarms);
            if (sel.getRows().length == 1) {
                BAlarmInstructions bInstrs;
                ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                BAlarmRecord alarm = tm.getRecord(sel.getRow());
                String alarmSourceExtCamera = alarm.getAlarmData().gets("cameraOrd", null);
                if (alarmSourceExtCamera != null) {
                    BOrd videoCameraOrd = BOrd.make((String)alarmSourceExtCamera);
                    if (!videoCameraOrd.equals((Object)BOrd.NULL)) {
                        BAlarmConsole.this.showVideoCmd.setEnabled(true);
                    } else {
                        BAlarmConsole.this.showVideoCmd.setEnabled(false);
                    }
                } else {
                    BAlarmConsole.this.showVideoCmd.setEnabled(false);
                }
                BString str = (BString)alarm.getAlarmData().get("hyperlinkOrd");
                BOrd hyperlink = BOrd.NULL;
                if (str != null) {
                    hyperlink = BOrd.make((String)str.toString());
                }
                if (hyperlink == null || hyperlink.isNull()) {
                    BAlarmClassMapping mapping = BAlarmConsole.this.options.getAlarmClassMapping();
                    BAlarmClassDef acDef = mapping.getAlarmClassDefFor(alarm.getAlarmClass());
                    hyperlink = acDef.getAlarmUrl();
                }
                if (hyperlink != null && !hyperlink.isNull()) {
                    BAlarmConsole.this.urlCommand.setEnabled(true);
                } else {
                    BAlarmConsole.this.urlCommand.setEnabled(false);
                }
                BAlarmConsole.this.notesCommand.setEnabled(true);
                BAlarmConsole.this.detailsCommand.setEnabled(true);
                BAlarmConsole.this.instructions.removeAllItems();
                if (alarm.getAlarmData().get("instructions") != null && (bInstrs = BAlarmInstructions.make((String)alarm.getAlarmData().get("instructions").toString())) != null) {
                    for (int i = 0; i < bInstrs.size(); ++i) {
                        BAlarmConsole.this.instructions.addItem((Object)(i + 1 + ". " + bInstrs.get(i).format((Object)this)));
                    }
                }
            } else {
                BAlarmConsole.this.urlCommand.setEnabled(false);
                BAlarmConsole.this.notesCommand.setEnabled(false);
                BAlarmConsole.this.showVideoCmd.setEnabled(false);
                BAlarmConsole.this.detailsCommand.setEnabled(false);
                BAlarmConsole.this.instructions.removeAllItems();
            }
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                if (this.getTable() == BAlarmConsole.this.sourceTable) {
                    BAlarmConsole.this.viewAll();
                } else {
                    BAlarmConsole.this.showDetailsDialog(this.getTable(), row);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int x, int y) {
            TableSelection sel = this.getTable().getSelection();
            BAlarmRecord selAlarm = this.getSelectedAlarm(sel);
            BTable sourceTable = this.getTable();
            BMenu menu = new BMenu();
            menu.add("ack", BAlarmConsole.this.ackCommand);
            menu.add("ackAll", BAlarmConsole.this.ackRecentCommand);
            menu.add("url", BAlarmConsole.this.urlCommand);
            menu.add("notes", BAlarmConsole.this.notesCommand);
            menu.add("details", BAlarmConsole.this.detailsCommand);
            if (BAlarmConsole.this.getRecipientForAlarm(selAlarm) == null || BAlarmConsole.this.getRecipientForAlarm(selAlarm).getPermissions(BAlarmConsole.this.ctx).hasAdminInvoke() || BAlarmConsole.this.getRecipientForAlarm(selAlarm).getPermissions(BAlarmConsole.this.ctx).hasAdminWrite()) {
                menu.add("forceClear", BAlarmConsole.this.forceClear);
            }
            menu.open((BWidget)sourceTable, event.getX(), event.getY());
        }

        private BAlarmRecord getSelectedAlarm(TableSelection sel) {
            BAlarmRecord alarm = null;
            if (sel.getRows().length == 1) {
                ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                alarm = tm.getRecord(sel.getRow());
            }
            return alarm;
        }

        protected void cellEntered(BMouseEvent event, int row, int column) {
            ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
            if (tm instanceof SourceTableModel) {
                int count = ((SourceTableModel)tm).getRecordCount(row);
                BWidgetShell shell = BAlarmConsole.this.getShell();
                if (shell != null) {
                    shell.showStatus(count + " Alarm(s)");
                }
            }
        }

        protected void cellExited(BMouseEvent event, int row, int column) {
            BWidgetShell shell = BAlarmConsole.this.getShell();
            if (shell != null) {
                shell.showStatus(null);
            }
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.add("acSep", (BValue)new BSeparator());
            menu.add("addColumn", BAlarmConsole.this.addColumnCommand);
            menu.add("removeColumn", BAlarmConsole.this.removeColumnCommand);
            return menu;
        }
    }

    class RadioGroup
    extends ToggleCommandGroup<ToggleCommand> {
        RadioGroup() {
        }

        protected void selected(ToggleCommand command) {
            super.selected(command);
            if (command == BAlarmConsole.this.sourceTimeCommand) {
                BAlarmConsole.this.options.setTimeZoneDisplay(BTimeZoneDisplay.source);
            } else {
                BAlarmConsole.this.options.setTimeZoneDisplay(BTimeZoneDisplay.console);
            }
            BAlarmConsole.this.sourceTable.fireTableModified(null);
        }
    }

    public class LoadThread
    extends Thread {
        public LoadThread() {
            super("AlarmConsole:LoadThread");
        }

        @Override
        public void run() {
            BAlarmConsole.this.load();
        }
    }
}

