/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassFE;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.portal.BPortalAlarmConsole;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.fieldeditors.BOrdFE;
import com.tridium.workbench.ord.BFileOrdChooser;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BAlarmClassMappingFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmClassMappingFE.class);
    public static final Logger logger = Logger.getLogger("alarm");
    protected BWidget popup;
    protected Context context;
    protected boolean isMicroEdition = false;
    protected Command mapCommand;
    protected Command removeMapCommand;
    protected Command addDefCommand;
    protected Command editDefCommand;
    protected Command delDefCommand;
    protected MappingTableModel mappingTableModel = new MappingTableModel();
    protected DefaultTableModel defTableModel;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAlarmConsole.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmClassMappingFE() {
        if (UiEnv.get().isMicroEdition()) {
            this.defTableModel = new DefaultTableModel(new String[]{lexicon.getText("alarmClassMapper.name"), lexicon.getText("alarmClassMapper.icon"), lexicon.getText("alarmClassMapper.hyperlink")});
            this.isMicroEdition = true;
        } else {
            this.defTableModel = new DefaultTableModel(new String[]{lexicon.getText("alarmClassMapper.name"), lexicon.getText("alarmClassMapper.icon"), lexicon.getText("alarmClassMapper.hyperlink"), lexicon.getText("alarmClassMapper.sound")});
        }
        Command cmd = new Command((BWidget)this, BAlarmClassMappingFE.lexicon.module, "commands.alarmClassMappingFE"){

            public CommandArtifact doInvoke() {
                int retVal;
                if (BAlarmClassMappingFE.this.popup == null) {
                    BAlarmClassMappingFE.this.popup = BAlarmClassMappingFE.this.createPopup();
                }
                if ((retVal = BDialog.open((BWidget)BAlarmClassMappingFE.this, (String)lexicon.getText("alarmClassMapper.title"), (Object)BAlarmClassMappingFE.this.popup, (int)3)) == 1) {
                    BAlarmClassMappingFE.this.setModified();
                }
                return null;
            }
        };
        BButton button = new BButton(cmd, false, true);
        BGridPane pane = new BGridPane(2);
        pane.add("name", (BValue)new BLabel(lexicon.getText("alarmClassMapper.mapping")));
        BToolBar toolBar = new BToolBar();
        toolBar.add("btn", (BValue)button);
        pane.add("button", (BValue)toolBar);
        this.setContent((BWidget)pane);
    }

    public BWidget createPopup() {
        this.addDefCommand = new Command((BWidget)this, BAlarmClassMappingFE.lexicon.module, "commands.addDef"){

            public CommandArtifact doInvoke() {
                BAlarmClassMappingFE.this.addAlarmClassDef();
                return null;
            }
        };
        BButton addDefBtn = new BButton(this.addDefCommand);
        this.editDefCommand = new Command((BWidget)this, BAlarmClassMappingFE.lexicon.module, "commands.editDef"){

            public CommandArtifact doInvoke() {
                BAlarmClassMappingFE.this.editAlarmClassDef();
                return null;
            }
        };
        BButton editDefBtn = new BButton(this.editDefCommand);
        this.editDefCommand.setEnabled(this.defTableModel.getRowCount() > 0);
        this.delDefCommand = new Command((BWidget)this, BAlarmClassMappingFE.lexicon.module, "commands.deleteDef"){

            public CommandArtifact doInvoke() {
                BAlarmClassMappingFE.this.delAlarmClassDef();
                return null;
            }
        };
        BButton delDefBtn = new BButton(this.delDefCommand);
        this.delDefCommand.setEnabled(this.defTableModel.getRowCount() > 0);
        BEdgePane mainPane = new BEdgePane();
        BEdgePane acDefPane = new BEdgePane();
        BGridPane buttonPane = new BGridPane(3);
        buttonPane.add("add", (BValue)addDefBtn);
        buttonPane.add("edit", (BValue)editDefBtn);
        buttonPane.add("del", (BValue)delDefBtn);
        acDefPane.setCenter((BWidget)new BBorderPane((BWidget)new BTable((TableModel)this.defTableModel, (TableController)new Controller())));
        acDefPane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane));
        this.defTableModel.getTable().setMultipleSelection(false);
        mainPane.setCenter((BWidget)new BTitlePane(lexicon.getText("alarmClassMapper.alarmClassDefs"), (BWidget)acDefPane));
        this.mapCommand = new Command((BWidget)this, BAlarmClassMappingFE.lexicon.module, "commands.mapAlarmClass"){

            public CommandArtifact doInvoke() {
                BAlarmClassMappingFE.this.mapAlarmClass();
                return null;
            }
        };
        BButton mapBtn = new BButton(this.mapCommand);
        this.removeMapCommand = new Command((BWidget)this, BAlarmClassMappingFE.lexicon.module, "commands.deleteAlarmClassMap"){

            public CommandArtifact doInvoke() {
                BAlarmClassMappingFE.this.deleteAlarmClassMap();
                return null;
            }
        };
        this.removeMapCommand.setEnabled(false);
        BButton delMapBtn = new BButton(this.removeMapCommand);
        BGridPane mapBtnPane = new BGridPane(3);
        mapBtnPane.add("b1", (BValue)mapBtn);
        mapBtnPane.add("b3", (BValue)delMapBtn);
        BEdgePane mapPane = new BEdgePane();
        BTable mt = new BTable((TableModel)this.mappingTableModel, (TableController)new MappingTableController());
        mt.setPreferredSize(800.0, 800.0);
        mapPane.setCenter((BWidget)new BBorderPane((BWidget)mt));
        mapPane.setBottom((BWidget)new BBorderPane((BWidget)mapBtnPane));
        BSplitPane outerPane = new BSplitPane(BOrientation.vertical, 50.0);
        outerPane.setWidget1((BWidget)mainPane);
        outerPane.setWidget2((BWidget)new BTitlePane(lexicon.getText("alarmClassMapper.alarmClassDefMapping"), (BWidget)mapPane));
        return outerPane;
    }

    protected void doSetReadonly(boolean readonly) {
    }

    protected void doLoadValue(BObject value, Context cx) {
        BAlarmClassMapping acDefList = (BAlarmClassMapping)value;
        this.context = cx;
        BAlarmClassDef[] defs = (BAlarmClassDef[])acDefList.getAlarmClassDefinitions().getChildren(BAlarmClassDef.class);
        for (int i = 0; i < defs.length; ++i) {
            if (this.isMicroEdition) {
                this.defTableModel.addRow(new Object[]{SlotPath.unescape((String)defs[i].getDefName()), defs[i].getAlarmIcon(), defs[i].getAlarmUrl()});
                continue;
            }
            this.defTableModel.addRow(new Object[]{SlotPath.unescape((String)defs[i].getDefName()), defs[i].getAlarmIcon(), defs[i].getAlarmUrl(), defs[i].getAlarmSound()});
        }
        this.defTableModel.updateTable();
        BComponent mapping = acDefList.getAlarmClassDefMapping();
        SlotCursor c = mapping.getProperties();
        while (c.next(BString.class)) {
            Property p = c.property();
            String name = SlotPath.unescape((String)p.getName());
            BString o = (BString)c.get();
            this.mappingTableModel.addRow(new Object[]{name, o});
        }
        this.mappingTableModel.updateTable();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        try {
            BComponent acDefs = new BComponent();
            for (int i = 0; i < this.defTableModel.getRowCount(); ++i) {
                BAlarmClassDef def = new BAlarmClassDef();
                String name = SlotPath.escape((String)((String)this.defTableModel.getValueAt(i, 0)));
                BOrd icon = (BOrd)this.defTableModel.getValueAt(i, 1);
                BOrd url = (BOrd)this.defTableModel.getValueAt(i, 2);
                def.setDefName(name);
                def.setAlarmIcon(icon);
                def.setAlarmUrl(url);
                if (!this.isMicroEdition) {
                    BOrd sound = (BOrd)this.defTableModel.getValueAt(i, 3);
                    def.setAlarmSound(sound);
                }
                acDefs.add(name, (BValue)def);
            }
            BComponent acMap = new BComponent();
            for (int i = 0; i < this.mappingTableModel.getRowCount(); ++i) {
                String acName = SlotPath.escape((String)this.mappingTableModel.getAlarmClassName(i));
                BString defName = (BString)this.mappingTableModel.getValueAt(i, 1);
                acMap.add(acName, (BValue)defName);
            }
            BAlarmClassMapping mapping = (BAlarmClassMapping)((Object)value);
            mapping.setAlarmClassDefinitions(acDefs);
            mapping.setAlarmClassDefMapping(acMap);
            value = mapping;
            return mapping;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected BWidget makeAlarmClassDefPane(String name, BAlarmClassDef def) {
        if (def == null) {
            def = new BAlarmClassDef();
        }
        BGridPane pane = new BGridPane(2);
        pane.add("nameLbl", (BValue)new BLabel(lexicon.getText("alarmClassMapper.name")));
        pane.add("nameField", (BValue)new BTextField(name, 20));
        pane.add("iconLbl", (BValue)new BLabel(lexicon.getText("alarmClassMapper.icon")));
        BOrdFE iconFE = new BOrdFE();
        iconFE.allowLinkButton(false);
        iconFE.loadMenu(new TypeInfo[]{BFileOrdChooser.TYPE.getTypeInfo()});
        iconFE.loadValue((BObject)def.getAlarmIcon());
        pane.add("iconField", (BValue)iconFE);
        pane.add("hyperlinkLbl", (BValue)new BLabel(lexicon.getText("alarmClassMapper.hyperlink")));
        BOrdFE urlFE = new BOrdFE();
        urlFE.allowLinkButton(false);
        urlFE.loadMenu(new TypeInfo[0]);
        urlFE.loadValue((BObject)def.getAlarmUrl());
        pane.add("hyperlinkField", (BValue)urlFE);
        if (!this.isMicroEdition) {
            pane.add("soundLbl", (BValue)new BLabel(lexicon.getText("alarmClassMapper.sound")));
            BOrdFE soundFE = new BOrdFE();
            soundFE.allowLinkButton(false);
            soundFE.loadMenu(new TypeInfo[]{BFileOrdChooser.TYPE.getTypeInfo()});
            soundFE.loadValue((BObject)def.getAlarmSound());
            pane.add("soundField", (BValue)soundFE);
        }
        return pane;
    }

    protected void addAlarmClassDef() {
        BWidget editPane = this.makeAlarmClassDefPane("", null);
        int retVal = BDialog.open((BWidget)this, (String)lexicon.getText("commands.addDef.label"), (Object)editPane, (int)3);
        if (retVal == 2) {
            return;
        }
        try {
            String name = ((BTextField)editPane.get("nameField")).getText();
            BOrd icon = (BOrd)((BOrdFE)editPane.get("iconField")).saveValue();
            BOrd url = (BOrd)((BOrdFE)editPane.get("hyperlinkField")).saveValue();
            if (!this.isMicroEdition) {
                BOrd sound = (BOrd)((BOrdFE)editPane.get("soundField")).saveValue();
                this.defTableModel.addRow(new Object[]{name, icon, url, sound});
            } else {
                this.defTableModel.addRow(new Object[]{name, icon, url});
            }
            this.defTableModel.updateTable();
            this.editDefCommand.setEnabled(true);
            this.delDefCommand.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void editAlarmClassDef() {
        int row = this.defTableModel.getTable().getSelection().getRow();
        if (row < 0) {
            return;
        }
        BAlarmClassDef def = new BAlarmClassDef();
        String name = (String)this.defTableModel.getValueAt(row, 0);
        BOrd icon = (BOrd)this.defTableModel.getValueAt(row, 1);
        BOrd url = (BOrd)this.defTableModel.getValueAt(row, 2);
        def.setDefName(name);
        def.setAlarmIcon(icon);
        def.setAlarmUrl(url);
        if (!this.isMicroEdition) {
            BOrd sound = (BOrd)this.defTableModel.getValueAt(row, 3);
            def.setAlarmSound(sound);
        }
        BWidget editPane = this.makeAlarmClassDefPane(def.getDefName(), def);
        int retVal = BDialog.open((BWidget)this, (String)lexicon.getText("commands.editDef.label"), (Object)editPane, (int)3);
        if (retVal == 2) {
            return;
        }
        try {
            name = ((BTextField)editPane.get("nameField")).getText();
            icon = (BOrd)((BOrdFE)editPane.get("iconField")).saveValue();
            url = (BOrd)((BOrdFE)editPane.get("hyperlinkField")).saveValue();
            this.defTableModel.set(row, 0, (Object)name);
            this.defTableModel.set(row, 1, (Object)icon);
            this.defTableModel.set(row, 2, (Object)url);
            if (!this.isMicroEdition) {
                BOrd sound = (BOrd)((BOrdFE)editPane.get("soundField")).saveValue();
                this.defTableModel.set(row, 3, (Object)sound);
            }
            this.defTableModel.updateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void delAlarmClassDef() {
        int row = this.defTableModel.getTable().getSelection().getRow();
        if (row < 0) {
            return;
        }
        String defName = (String)this.defTableModel.getValueAt(row, 0);
        this.defTableModel.removeRow(row);
        this.defTableModel.updateTable();
        this.delDefCommand.setEnabled(this.defTableModel.getRowCount() > 0);
        this.editDefCommand.setEnabled(this.defTableModel.getRowCount() > 0);
        try {
            int rowCount = this.mappingTableModel.getRowCount();
            for (int i = rowCount - 1; i >= 0; --i) {
                String testName = this.mappingTableModel.getValueAt(i, 1).toString();
                if (!defName.equals(testName)) continue;
                this.mappingTableModel.removeRow(row);
                this.mappingTableModel.updateTable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void mapAlarmClass() {
        BAlarmClassFE alarmClassEditor;
        BGridPane gp = new BGridPane(2);
        gp.setColumnAlign(BHalign.fill);
        BEdgePane ep1 = new BEdgePane();
        ep1.setLeft((BWidget)new BLabel(lexicon.getText("alarm.alarmClass")));
        gp.add("acLbl", (BValue)ep1);
        boolean isAlarmClassTextField = false;
        BComplex parent = this.getParent();
        if (parent != null && parent.getType().is(BPortalAlarmConsole.TYPE)) {
            alarmClassEditor = new BTextField("");
            isAlarmClassTextField = true;
        } else {
            alarmClassEditor = new BAlarmClassFE();
            this.add("fe", (BValue)alarmClassEditor);
            alarmClassEditor.loadValue((BObject)BString.make((String)BAlarmService.defaultAlarmClass.getName()));
            this.remove((BComplex)alarmClassEditor);
        }
        gp.add("ac", (BValue)alarmClassEditor);
        BEdgePane ep2 = new BEdgePane();
        ep2.setLeft((BWidget)new BLabel(lexicon.getText("alarmClassMapper.definition")));
        gp.add("defLbl", (BValue)ep2);
        BTextDropDown defSelect = new BTextDropDown(false);
        for (int i = 0; i < this.defTableModel.getRowCount(); ++i) {
            String defName = (String)this.defTableModel.getValueAt(i, 0);
            defSelect.getList().addItem((Object)defName);
            if (i != 0) continue;
            defSelect.setText(defName);
        }
        gp.add("def", (BValue)defSelect);
        int retVal = BDialog.open((BWidget)this, (String)lexicon.getText("commands.mapAlarmClass"), (Object)gp, (int)3);
        if (retVal == 2) {
            return;
        }
        try {
            String acName = isAlarmClassTextField ? ((BTextField)alarmClassEditor).getText() : alarmClassEditor.saveValue().toString(this.context);
            String defName = defSelect.getText();
            for (int i = 0; i < this.mappingTableModel.getRowCount(); ++i) {
                String ac = (String)this.mappingTableModel.getValueAt(i, 0);
                if (!ac.equals(acName)) continue;
                this.mappingTableModel.removeRow(i);
                this.mappingTableModel.updateTable();
            }
            this.mappingTableModel.addRow(new Object[]{acName, BString.make((String)defName)});
            this.mappingTableModel.updateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deleteAlarmClassMap() {
        try {
            int row = this.mappingTableModel.getTable().getSelection().getRow();
            if (row < 0) {
                return;
            }
            this.mappingTableModel.removeRow(row);
            this.mappingTableModel.updateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MappingTableController
    extends TableController {
        MappingTableController() {
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            if (this.getTable().getSelection().getRowCount() > 0) {
                BAlarmClassMappingFE.this.removeMapCommand.setEnabled(true);
            } else {
                BAlarmClassMappingFE.this.removeMapCommand.setEnabled(false);
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            if (this.getTable().getSelection().getRowCount() > 0) {
                BAlarmClassMappingFE.this.editDefCommand.setEnabled(true);
                BAlarmClassMappingFE.this.delDefCommand.setEnabled(true);
            } else {
                BAlarmClassMappingFE.this.editDefCommand.setEnabled(false);
                BAlarmClassMappingFE.this.delDefCommand.setEnabled(false);
            }
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                BAlarmClassMappingFE.this.editAlarmClassDef();
            }
        }
    }

    class MappingTableModel
    extends DefaultTableModel {
        BAlarmService alarmService;

        public MappingTableModel() {
            super(new String[]{lexicon.getText("alarmClassMapper.alarmClass"), lexicon.getText("alarmClassMapper.definition")});
            this.alarmService = null;
        }

        public synchronized Object getValueAt(int row, int col) {
            BAlarmService alarmService = this.getAlarmService();
            if (col == 0 && alarmService != null) {
                String acName = super.getValueAt(row, col).toString();
                return alarmService.getAlarmClassDisplayName((Object)BString.make((String)acName), null).toString();
            }
            return super.getValueAt(row, col);
        }

        public String getAlarmClassName(int row) {
            return super.getValueAt(row, 0).toString();
        }

        private BAlarmService getAlarmService() {
            block3: {
                if (this.alarmService == null) {
                    try {
                        BWbShell shell = BAlarmClassMappingFE.this.getWbShell();
                        BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:alarm:AlarmService");
                        this.alarmService = (BAlarmService)ord.get();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) break block3;
                        logger.log(Level.FINE, "AlarmService is not available ", e);
                    }
                }
            }
            return this.alarmService;
        }
    }
}

