/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import java.util.Comparator;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Cursor;

public class AlarmDbTableModel
extends ConsoleTableModel {
    private Array<BAlarmRecord> alarmList = new Array(BAlarmRecord.class);

    public AlarmDbTableModel(ConsoleColumns columns) {
        super(columns);
    }

    public synchronized void load(Cursor<BAlarmRecord> cursor) {
        this.clear();
        this.doAdd(cursor);
    }

    @Override
    public int getAlarmCount() {
        return this.alarmList.size();
    }

    @Override
    public int getSourceCount() {
        return -1;
    }

    private synchronized void doAdd(Cursor<BAlarmRecord> cursor) {
        while (cursor.next()) {
            this.add((BAlarmRecord)cursor.get());
        }
        this.updateTable();
    }

    public synchronized void add(BAlarmRecord rec) {
        this.alarmList.add((Object)rec);
    }

    public synchronized void clear() {
        this.alarmList.clear();
        this.updateTable();
    }

    public int getRowCount() {
        return this.alarmList.size();
    }

    @Override
    public BAlarmRecord getRecord(int row) {
        if (row < this.getRowCount()) {
            return (BAlarmRecord)this.alarmList.get(row);
        }
        return null;
    }

    public synchronized void sortByColumn(int col, boolean ascending) {
        if (col < 0 || col >= super.getColumnCount()) {
            return;
        }
        this.setInitialSort(col, ascending);
        ConsoleColumns.Column column = this.getColumns().getColumn(col);
        if (ascending) {
            this.sort(column, SortUtil.ASCENDING);
        } else {
            this.sort(column, SortUtil.DESCENDING);
        }
    }

    private void sort(ConsoleColumns.Column col, Comparator<? super Object> comparator) {
        int n = this.alarmList.size();
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                int j;
                BAlarmRecord tempValue = (BAlarmRecord)this.alarmList.get(i);
                Object tempKey = col.getValue(tempValue);
                for (j = i; j >= incr && comparator.compare(tempKey, col.getValue((BAlarmRecord)this.alarmList.get(j - incr))) < 0; j -= incr) {
                    this.alarmList.set(j, this.alarmList.get(j - incr));
                }
                this.alarmList.set(j, (Object)tempValue);
            }
        }
    }
}

