/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.nmilestone.event.BMilestoneEventPointId;
import com.tridium.nmilestone.messages.MilestoneEventRefreshAroundReq;
import com.tridium.nmilestone.messages.MilestoneRsp;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class MilestoneEventRefreshAroundRsp
extends MilestoneRsp {
    protected BVideoEvent[] videoEvents;
    protected int numEvents;
    InputStream in;

    public MilestoneEventRefreshAroundRsp(InputStream ins) {
        this.in = ins;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fromInputStream(int numEvents) throws Exception {
        int absNumEvents = Math.abs(numEvents);
        Object[] videoEvents = this.getEventsFor(this.in);
        SortUtil.sort((Object[])videoEvents, (Object[])videoEvents, (Comparator)new Comparator<BVideoEvent>(){

            @Override
            public int compare(BVideoEvent o1, BVideoEvent o2) {
                return o1.getTimestamp().compareTo((Object)o2.getTimestamp());
            }
        });
        if (videoEvents.length > absNumEvents) {
            if (numEvents > 0) {
                this.videoEvents = new BVideoEvent[numEvents];
                System.arraycopy(videoEvents, videoEvents.length - numEvents - 1, this.videoEvents, 0, numEvents);
                return;
            } else {
                if (numEvents >= 0) throw new IllegalStateException("Assummed that numEvents would not be = 0. ");
                this.videoEvents = new BVideoEvent[absNumEvents];
                System.arraycopy(videoEvents, 0, this.videoEvents, 0, absNumEvents);
            }
            return;
        } else {
            this.videoEvents = videoEvents;
        }
    }

    @Override
    public Object getTag() {
        return MilestoneEventRefreshAroundReq.EVENT_REFRESH_OBJ;
    }

    public BVideoEvent[] getVideoEvents() {
        return this.videoEvents;
    }

    public BVideoEvent[] getEventsFor(InputStream in) throws Exception {
        in.reset();
        byte[] a = new byte[in.available()];
        ByteArrayInputStream bais = null;
        try {
            in.read(a);
            bais = new ByteArrayInputStream(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XElem methodResponse = MilestoneReqUtil.getMilestoneMethodResponseElem(bais);
        String methodName = MilestoneReqUtil.getText(methodResponse, "methodname");
        if (methodName.length() > 0) {
            if ("alarms".equals(methodName)) {
                XElem alarmsElem = MilestoneReqUtil.getElem(methodResponse, "alarms");
                XElem[] alarmElem = alarmsElem.elems("alarm");
                if (alarmElem == null || alarmElem.length == 0) {
                    return new BVideoEvent[0];
                }
                BVideoEvent[] milestoneEvents = new BVideoEvent[alarmElem.length];
                for (int i = 0; i < alarmElem.length; ++i) {
                    milestoneEvents[i] = BVideoEvent.makeOffNormalEvent();
                    milestoneEvents[i].setDescription(BMilestoneEventPointId.LEX.getText("MilestoneRecording"));
                    milestoneEvents[i].setEventType(BVideoEventTypesEnum.customEvent);
                    try {
                        long startTime = alarmElem[i].getl("startTime");
                        long alarmTime = alarmElem[i].getl("alarmTime");
                        long endTime = alarmElem[i].getl("endTime");
                        milestoneEvents[i].setTimestamp(BAbsTime.make((long)startTime));
                        milestoneEvents[i].setMetaData(BFacets.make((String)"milestoneStartTime", (BIDataValue)BLong.make((long)startTime), (String)"milestoneAlarmTime", (BIDataValue)BLong.make((long)alarmTime), (String)"milestoneEndTime", (BIDataValue)BLong.make((long)endTime)));
                        continue;
                    }
                    catch (XException xe) {
                        xe.printStackTrace();
                    }
                }
                return milestoneEvents;
            }
            throw new Exception("<methodname>...</methodname> text = " + methodName + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }
}

