/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.ui;

import com.lynxspring.control.global.BGlobalMasterExtension;
import com.lynxspring.control.global.BGlobalService;
import com.lynxspring.control.ui.BGlobalMgrTable;
import com.lynxspring.control.util.Util;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BGlobalServiceManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BGlobalServiceManager.class);
    private static final Lexicon bajaLex = Lexicon.make(BObject.class);
    BGlobalService service;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model();
    }

    protected MgrController makeController() {
        return new Controller();
    }

    private String getMasterName(Object obj) {
        BGlobalMasterExtension ext = this.getMasterExt(obj);
        if (ext != null) {
            return ext.getMasterName();
        }
        return "** Invalid Extension";
    }

    private BGlobalMasterExtension getMasterExt(Object obj) {
        if (obj instanceof BGlobalMasterExtension) {
            return (BGlobalMasterExtension)obj;
        }
        Object[] children = ((BComponent)obj).getChildren(BGlobalMasterExtension.class);
        if (children.length > 0) {
            return (BGlobalMasterExtension)children[0];
        }
        return null;
    }

    private class NumberOfSlavesColumn
    extends MgrColumn {
        double iconX;
        private final BImage linkIcon;
        TableCellRenderer renderer;

        public Object get(Object obj) {
            try {
                return "" + BGlobalServiceManager.this.getMasterExt(obj).getSlaveCount();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "0";
            }
        }

        public TableCellRenderer getCellRenderer() {
            return this.renderer;
        }

        boolean cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BWbShell shell;
            BComponent comp = table.getComponentAt(row);
            if (comp == null) {
                return false;
            }
            RectGeom rect = table.getCellBounds(row, col);
            int x = (int)(event.getX() - rect.x);
            if ((double)x > this.iconX && (double)x < this.iconX + 28.0 && (shell = table.getManager().getWbShell()) != null) {
                shell.hyperlink(new HyperlinkInfo(BGlobalServiceManager.this.getMasterExt(comp).getNavOrd(), (BInputEvent)event));
                return true;
            }
            return false;
        }

        protected NumberOfSlavesColumn() {
            super(Util.lex.getText("global.service.slaves"), 4);
            this.linkIcon = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
            this.renderer = new CellRenderer();
        }

        class CellRenderer
        extends ComponentTableCellRenderer {
            CellRenderer() {
            }

            public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
                return super.getPreferredCellWidth(cell) + 28.0;
            }

            public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
                if (this.getTable() == null) {
                    this.setTable();
                }
                super.paintCell(g, cell);
                NumberOfSlavesColumn.this.iconX = super.getPreferredCellWidth(cell);
                g.drawImage(NumberOfSlavesColumn.this.linkIcon, NumberOfSlavesColumn.this.iconX + 4.0, (cell.height - 16.0) / 2.0);
            }

            void setTable() {
                super.setTable((BTable)BGlobalServiceManager.this.getModel().getTable());
            }
        }
    }

    private class SlotPathColumn
    extends MgrColumn {
        public Object get(Object obj) {
            try {
                return BGlobalServiceManager.this.getMasterExt(obj).getSlotPath();
            }
            catch (Exception e) {
                return "** Invalid Extension";
            }
        }

        protected SlotPathColumn() {
            super(Util.lex.getText("Slot Path"), 4);
        }
    }

    private class CurrentValueColumn
    extends MgrColumn {
        public Object get(Object obj) {
            try {
                return BGlobalServiceManager.this.getMasterExt(obj).getIn();
            }
            catch (Exception e) {
                return "** Invalid Extension";
            }
        }

        protected CurrentValueColumn() {
            super(Util.lex.getText("global.service.value"), 4);
        }
    }

    private class DuplicateNameColumn
    extends MgrColumn {
        public Object get(Object obj) {
            BComponent[] comps = ((BGlobalMgrTable)BGlobalServiceManager.this.getModel().getTable()).comps;
            if (comps != null) {
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i].equals(obj) || !BGlobalServiceManager.this.getMasterName(comps[i]).equals(BGlobalServiceManager.this.getMasterName(obj))) continue;
                    return bajaLex.getText("true");
                }
            }
            return bajaLex.getText("false");
        }

        protected DuplicateNameColumn() {
            super(Util.lex.getText("global.service.duplicate"), 6);
        }
    }

    private class MasterNameColumn
    extends MgrColumn {
        public Object get(Object obj) {
            return BGlobalServiceManager.this.getMasterName(obj);
        }

        protected MasterNameColumn() {
            super(Util.lex.getText("global.service.masterName"), 1);
        }

        public BValue load(MgrEditRow row) {
            return BString.make((String)BGlobalServiceManager.this.getMasterName(row.getTarget()));
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BGlobalServiceManager.this.getMasterExt(row.getTarget()).setMasterName(value.toString());
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BString masterName = (BString)rows[0].getCell(colIndex).newCopy();
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)masterName);
            }
            BFacets facets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            editor.loadValue((BObject)masterName, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BString masterName = (BString)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)masterName);
            }
        }
    }

    private class FacetsColumn
    extends MgrColumn {
        private static final String propName = "facets";

        public FacetsColumn() {
            super(Util.lex.getText("global.service.facets"), 3);
        }

        public Object get(Object row) {
            BComponent comp = (BComponent)row;
            return comp.getParent().get(propName);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BComponent comp = (BComponent)row;
            Slot slot = comp.getParent().getSlot(propName);
            if (slot == null) {
                return "";
            }
            BFacets facets = comp.getParent().getSlotFacets(slot);
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return ((BObject)value).toString(cx);
        }

        public BValue load(MgrEditRow row) {
            BValue tmp = row.getTarget().getParent().get(propName);
            if (tmp != null) {
                return tmp.newCopy();
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.getParent().get(propName);
            if (old != null && !old.equivalent((Object)value)) {
                target.set(target.getParent().getProperty(propName), value.newCopy(), cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BValue compFacets = rows[0].getCell(colIndex);
            if (compFacets == null) {
                return null;
            }
            compFacets = compFacets.newCopy();
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)compFacets);
            }
            editor.loadValue((BObject)compFacets, (Context)rows[0].getTarget().getSlotFacets(rows[0].getTarget().getParent().getSlot(propName)));
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BFacets newFacets = (BFacets)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)newFacets);
            }
        }
    }

    class Controller
    extends MgrController {
        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.edit, this.learnMode, this.discover, this.cancel, this.add, this.quickAdd, this.match, this.quickMatch};
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            MgrColumn mgrCol = table.columnIndexToMgrColumn(col);
            if (mgrCol instanceof NumberOfSlavesColumn && ((NumberOfSlavesColumn)mgrCol).cellDoubleClicked(table, event, row, col)) {
                return;
            }
            super.cellDoubleClicked(table, event, row, col);
        }

        public Controller() {
            super((BAbstractManager)BGlobalServiceManager.this);
        }
    }

    class Model
    extends MgrModel {
        public void load(BComponent target) {
            if (!(target instanceof BGlobalService)) {
                return;
            }
            BGlobalServiceManager.this.service = (BGlobalService)target;
            this.getTable().reload();
        }

        public boolean accept(BComponent comp) {
            return ((BGlobalMasterExtension[])comp.getChildren(BGlobalMasterExtension.class)).length > 0;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new SlotPathColumn(), new MgrColumn.Type(), new MasterNameColumn(), new FacetsColumn(), new CurrentValueColumn(), new NumberOfSlavesColumn(), new DuplicateNameColumn()};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BBooleanSchedule.TYPE), MgrTypeInfo.make((Type)BEnumSchedule.TYPE), MgrTypeInfo.make((Type)BNumericSchedule.TYPE), MgrTypeInfo.make((Type)BStringSchedule.TYPE)};
        }

        public BComponent newInstance(MgrTypeInfo info) throws Exception {
            BComponent newComp = info.newInstance();
            newComp.add(null, (BValue)new BGlobalMasterExtension());
            return newComp;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            super.addInstances(rows, cx);
            BComponent container = rows[0].getEdit().getAddContainer();
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i].getTarget() instanceof BControlPoint) continue;
                BComponent comp = container.get(rows[i].getName()).asComponent();
                BGlobalMasterExtension ext = BGlobalServiceManager.this.getMasterExt(comp);
                ext.add(null, (BValue)new BLink(comp.getHandleOrd(), "out", "in", true));
            }
            return null;
        }

        public int getSubscribeDepth() {
            return 1;
        }

        public BMgrTable makeTable() {
            return new BGlobalMgrTable(this);
        }

        protected String makeTableTitle() {
            return Util.lex.getText("Global Master Extensions");
        }

        public Model() {
            super((BAbstractManager)BGlobalServiceManager.this);
        }
    }
}

