/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.ui;

import com.lynxspring.control.global.BGlobalMasterExtension;
import com.lynxspring.control.global.BGlobalSlaveExtension;
import com.lynxspring.control.util.Util;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BGlobalAllExtensionManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BGlobalAllExtensionManager.class);
    BGlobalMasterExtension master;
    private Model model = new Model();
    private BTable table = new BTable((TableModel)new DynamicTableModel((TableModel)this.model), (TableController)new Controller());

    public Type getType() {
        return TYPE;
    }

    private boolean setMasterName(BGlobalSlaveExtension ext) {
        BWbFieldEditor nameEditor = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
        nameEditor.loadValue((BObject)BString.DEFAULT);
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)new BLabel(Util.lex.getText("masterNamePrompt")));
        grid.add(null, (BValue)nameEditor);
        if (1 != BDialog.open((BWidget)this, (String)Util.lex.getText("masterNameTitle"), (Object)grid, (int)3)) {
            return false;
        }
        String name = "";
        try {
            name = ((BString)nameEditor.saveValue()).getString().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name.length() > 0) {
            this.master.setMasterName(name);
            return true;
        }
        BDialog.error((BWidget)this, (String)Util.lex.getText("masterNameInvalidTitle"), (Object)Util.lex.getText("masterNameInvalidText"));
        return this.setMasterName(ext);
    }

    boolean hasSlave(BComplex parent) {
        Object[] objs = parent.asComponent().getChildren(BGlobalSlaveExtension.class);
        boolean validSlave = false;
        for (int i = 0; !validSlave && i < objs.length; ++i) {
            if (((BGlobalSlaveExtension)objs[i]).getMasterName().trim().length() <= 0) continue;
            validSlave = true;
        }
        return validSlave;
    }

    boolean mySlave(BComplex parent) {
        if (this.master.getMasterName().trim().length() == 0) {
            return false;
        }
        BGlobalSlaveExtension[] exts = (BGlobalSlaveExtension[])parent.asComponent().getChildren(BGlobalSlaveExtension.class);
        if (exts.length > 0) {
            return exts[0].getMasterName().equals(this.master.getMasterName());
        }
        return false;
    }

    BComponent getMaster(BComplex parent) {
        BGlobalSlaveExtension[] exts = (BGlobalSlaveExtension[])parent.asComponent().getChildren(BGlobalSlaveExtension.class);
        if (exts.length > 0) {
            if (exts[0].getMasterName().trim().length() == 0) {
                return null;
            }
            try {
                BITable result;
                TableCursor c;
                String tmp = "slot:/|bql:select slotPath from lynxKitControl:GlobalMasterExtension where masterName = '" + exts[0].getMasterName() + "'";
                OrdTarget t = BOrd.make((String)tmp).resolve((BObject)this.master);
                if (t != null && (c = (result = (BITable)t.get()).cursor()).next()) {
                    return BOrd.make((String)c.cell(result.getColumns().get(0)).toString()).get((BObject)this.master).asComponent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context context) throws Exception {
        if (!(obj instanceof BGlobalMasterExtension)) {
            return;
        }
        this.master = (BGlobalMasterExtension)obj;
        this.master.lease(1);
        Type curType = this.master.getParent() instanceof BControlPoint ? ((BControlPoint)this.master.getParent()).getOutStatusValue().getType() : this.master.getIn().getType();
        String tmp = "slot:/|bql:select slotPath from control:ControlPoint where out.type = '" + curType + "' and isWritablePoint = false";
        OrdTarget t = BOrd.make((String)tmp).resolve((BObject)this.master);
        if (t != null) {
            BITable result = (BITable)t.get();
            TableCursor c = result.cursor();
            Object[] comps = new BComponent[]{};
            while (c.next()) {
                BControlPoint newComp = (BControlPoint)BOrd.make((String)c.cell(result.getColumns().get(0)).toString()).get((BObject)this.master).asComponent();
                if (((BGlobalMasterExtension[])newComp.getChildren(BGlobalMasterExtension.class)).length != 0 || newComp.getProxyExt() == null || !newComp.getProxyExt().isNull()) continue;
                comps = (BComponent[])ArrayUtil.addOne((Object[])comps, (Object)newComp);
            }
            if (comps.length > 0) {
                BComponent.lease((BComponent[])comps, (int)1);
            }
            for (int i = 0; i < comps.length; ++i) {
                this.model.addParent(comps[i]);
            }
        }
    }

    public BGlobalAllExtensionManager() {
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setMultipleSelection(false);
        DynamicTableModel model = (DynamicTableModel)this.table.getModel();
        model.setShowColumn(3, false);
        model.setShowColumn(6, false);
        this.setContent((BWidget)new BScrollPane((BWidget)new BTitlePane(Util.lex.getText("global.table.alltitle"), (BWidget)this.table)));
    }

    private class Model
    extends TableModel {
        private BComponent[] linked = new BComponent[0];

        private Model() {
        }

        public int getColumnCount() {
            return 7;
        }

        public boolean isColumnSortable(int col) {
            return col > 1;
        }

        public synchronized void sortByColumn(int i, boolean flag) {
            Object[] cols = this.getColumnValues(i);
            Object[] rows = new BComponent[this.linked.length];
            System.arraycopy(this.linked, 0, rows, 0, cols.length);
            SortUtil.sort((Object[])cols, (Object[])rows, (boolean)flag);
            this.linked = rows;
        }

        public String getColumnName(int col) {
            return Util.lex.getText("global.col" + col);
        }

        public int getRowCount() {
            return this.linked.length;
        }

        public BComplex getObject(int row) {
            if (row > -1) {
                return this.linked[row];
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            boolean hasSlave = BGlobalAllExtensionManager.this.hasSlave((BComplex)this.linked[row]);
            boolean mySlave = BGlobalAllExtensionManager.this.mySlave((BComplex)this.linked[row]);
            BComponent master = BGlobalAllExtensionManager.this.getMaster((BComplex)this.linked[row]);
            switch (col) {
                case 0: {
                    return "" + mySlave;
                }
                case 1: {
                    return "" + (hasSlave && !mySlave);
                }
                case 2: {
                    return this.linked[row].getDisplayName(null);
                }
                case 3: {
                    return this.linked[row].getType().getDisplayName(null);
                }
                case 4: {
                    return this.linked[row].getSlotPath();
                }
                case 5: {
                    return master != null ? master.getSlotPath().toString() : "";
                }
                case 6: {
                    return master != null ? master.getHandleOrd().toString() : "";
                }
            }
            return "";
        }

        void addParent(BComponent parent) {
            this.linked = (BComponent[])ArrayUtil.addOne((Object[])this.linked, (Object)parent);
            this.updateTable();
        }
    }

    private class Renderer
    extends TableCellRenderer {
        private Renderer() {
        }

        public double getCellHeight() {
            return Math.max(Theme.table().getCellFont().getHeight() + 3.0, 18.0);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            boolean mySlave = BGlobalAllExtensionManager.this.mySlave(BGlobalAllExtensionManager.this.model.getObject(cell.row));
            boolean slavedElsewhere = !mySlave && BGlobalAllExtensionManager.this.hasSlave(BGlobalAllExtensionManager.this.model.getObject(cell.row));
            DynamicTableModel model = (DynamicTableModel)BGlobalAllExtensionManager.this.table.getModel();
            switch (cell.column) {
                case 0: {
                    if (model.showColumn(0)) {
                        this.paintBox(g, cell, mySlave, slavedElsewhere);
                        break;
                    }
                }
                case 1: {
                    if (model.showColumn(1)) {
                        this.paintBox(g, cell, slavedElsewhere, !slavedElsewhere);
                        break;
                    }
                }
                default: {
                    BFont font = this.getFont(cell);
                    g.setFont(font);
                    g.drawString(this.getCellText(cell), 2.0, font.getAscent() + 2.0);
                }
            }
        }

        private void paintBox(Graphics g, TableCellRenderer.Cell cell, boolean checked, boolean greyed) {
            double w = 14.0;
            double w2 = w - 2.0;
            double w3 = w - 3.0;
            double x = (cell.width - w) / 2.0;
            g.strokeRect(x, 1.0, w, w);
            g.strokeRect(x + 1.0, 2.0, w2, w2);
            if (checked) {
                g.strokeLine(x + 3.0, 8.0, x + 3.0, w3);
                g.strokeLine(x + 4.0, w - 3.0, x + w3, 4.0);
                g.strokeLine(x + 4.0, w2, x + w3, 5.0);
            } else if (greyed) {
                g.setBrush(BColor.make((int)192, (int)192, (int)192, (int)192));
                g.fillRect(x, 1.0, w + 2.0, 15.0);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        public void mousePressed(BMouseEvent event) {
            int curRow = this.getMouseOverRow();
            if (curRow < 0) {
                return;
            }
            int curCol = this.getMouseOverColumn();
            if (curCol < 2) {
                boolean mySlave = BGlobalAllExtensionManager.this.mySlave(BGlobalAllExtensionManager.this.model.getObject(curRow));
                if (curCol == 0 && mySlave || curCol == 1 && !mySlave && BGlobalAllExtensionManager.this.hasSlave(BGlobalAllExtensionManager.this.model.getObject(curRow))) {
                    if (4 == BDialog.confirm((BWidget)BGlobalAllExtensionManager.this, (String)Util.lex.getText("global.remove.title"), (Object)Util.lex.getText("global.remove.msg", (Object[])new String[]{BGlobalAllExtensionManager.this.model.getObject(curRow).getDisplayName(null)}), (int)12)) {
                        BComponent comp = BGlobalAllExtensionManager.this.model.getObject(curRow).asComponent();
                        Object[] exts = comp.getChildren(BGlobalSlaveExtension.class);
                        for (int i = 0; i < exts.length; ++i) {
                            comp.remove((BComplex)exts[i]);
                        }
                        BGlobalAllExtensionManager.this.model.updateTable();
                    }
                } else if (curCol == 0) {
                    Object[] slaves = BGlobalAllExtensionManager.this.model.getObject(curRow).asComponent().getChildren(BGlobalSlaveExtension.class);
                    BGlobalSlaveExtension ext = null;
                    if (BGlobalAllExtensionManager.this.master.getMasterName().trim().length() == 0 && !BGlobalAllExtensionManager.this.setMasterName(ext)) {
                        return;
                    }
                    ext = slaves.length == 0 ? new BGlobalSlaveExtension() : (BGlobalSlaveExtension)slaves[0];
                    ext.setMasterName(BGlobalAllExtensionManager.this.master.getMasterName());
                    if (slaves.length == 0) {
                        BGlobalAllExtensionManager.this.model.getObject(curRow).asComponent().add(null, (BValue)ext);
                        Property[] props = BGlobalAllExtensionManager.this.model.getObject(curRow).asComponent().getDynamicPropertiesArray();
                        ext = (BGlobalSlaveExtension)BGlobalAllExtensionManager.this.model.getObject(curRow).asComponent().get(props[props.length - 1]).asComponent();
                    }
                    BGlobalAllExtensionManager.this.model.updateTable();
                    ext.lease();
                    if (BGlobalAllExtensionManager.this.master.getParent() instanceof BControlPoint) {
                        ext.setSlave(BGlobalAllExtensionManager.this.master.getParentPoint().getOutStatusValue());
                    } else {
                        ext.setSlave(BGlobalAllExtensionManager.this.master.getIn().getStatusValue());
                    }
                }
            } else {
                super.mousePressed(event);
            }
        }
    }
}

